/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.drawable.ForwardingDrawable;
import javax.annotation.Nullable;

public class MatrixDrawable
extends ForwardingDrawable {
    private Matrix mMatrix;
    @Nullable
    private Matrix mDrawMatrix;
    private int mUnderlyingWidth = 0;
    private int mUnderlyingHeight = 0;

    public MatrixDrawable(Drawable drawable, Matrix matrix) {
        super((Drawable)Preconditions.checkNotNull((Object)drawable));
        this.mMatrix = matrix;
    }

    @Override
    public Drawable setCurrent(@Nullable Drawable newDelegate) {
        Drawable previousDelegate = super.setCurrent(newDelegate);
        this.configureBounds();
        return previousDelegate;
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public void setMatrix(Matrix matrix) {
        this.mMatrix = matrix;
        this.configureBounds();
        this.invalidateSelf();
    }

    @Override
    public void draw(Canvas canvas) {
        this.configureBoundsIfUnderlyingChanged();
        if (this.mDrawMatrix != null) {
            int saveCount = canvas.save();
            canvas.clipRect(this.getBounds());
            canvas.concat(this.mDrawMatrix);
            super.draw(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.draw(canvas);
        }
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.configureBounds();
    }

    private void configureBoundsIfUnderlyingChanged() {
        if (this.mUnderlyingWidth != this.getCurrent().getIntrinsicWidth() || this.mUnderlyingHeight != this.getCurrent().getIntrinsicHeight()) {
            this.configureBounds();
        }
    }

    private void configureBounds() {
        Drawable underlyingDrawable = this.getCurrent();
        Rect bounds = this.getBounds();
        int underlyingWidth = this.mUnderlyingWidth = underlyingDrawable.getIntrinsicWidth();
        int underlyingHeight = this.mUnderlyingHeight = underlyingDrawable.getIntrinsicHeight();
        if (underlyingWidth <= 0 || underlyingHeight <= 0) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
        } else {
            underlyingDrawable.setBounds(0, 0, underlyingWidth, underlyingHeight);
            this.mDrawMatrix = this.mMatrix;
        }
    }

    @Override
    public void getTransform(Matrix transform) {
        super.getTransform(transform);
        if (this.mDrawMatrix != null) {
            transform.preConcat(this.mDrawMatrix);
        }
    }
}

