/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.view.Choreographer;
import androidx.annotation.FloatRange;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.utils.BaseLottieAnimator;
import com.airbnb.lottie.utils.MiscUtils;

public class LottieValueAnimator
extends BaseLottieAnimator
implements Choreographer.FrameCallback {
    private float speed = 1.0f;
    private boolean speedReversedForRepeatMode = false;
    private long lastFrameTimeNs = 0L;
    private float frameRaw = 0.0f;
    private float frame = 0.0f;
    private int repeatCount = 0;
    private float minFrame = -2.1474836E9f;
    private float maxFrame = 2.1474836E9f;
    @Nullable
    private LottieComposition composition;
    @VisibleForTesting
    protected boolean running = false;
    private boolean useCompositionFrameRate = false;

    public Object getAnimatedValue() {
        return Float.valueOf(this.getAnimatedValueAbsolute());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnimatedValueAbsolute() {
        if (this.composition == null) {
            return 0.0f;
        }
        return (this.frame - this.composition.getStartFrame()) / (this.composition.getEndFrame() - this.composition.getStartFrame());
    }

    @FloatRange(from=0.0, to=1.0)
    public float getAnimatedFraction() {
        if (this.composition == null) {
            return 0.0f;
        }
        if (this.isReversed()) {
            return (this.getMaxFrame() - this.frame) / (this.getMaxFrame() - this.getMinFrame());
        }
        return (this.frame - this.getMinFrame()) / (this.getMaxFrame() - this.getMinFrame());
    }

    public long getDuration() {
        return this.composition == null ? 0L : (long)this.composition.getDuration();
    }

    public float getFrame() {
        return this.frame;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setUseCompositionFrameRate(boolean useCompositionFrameRate) {
        this.useCompositionFrameRate = useCompositionFrameRate;
    }

    public void doFrame(long frameTimeNanos) {
        this.postFrameCallback();
        if (this.composition == null || !this.isRunning()) {
            return;
        }
        if (L.isTraceEnabled()) {
            L.beginSection("LottieValueAnimator#doFrame");
        }
        long timeSinceFrame = this.lastFrameTimeNs == 0L ? 0L : frameTimeNanos - this.lastFrameTimeNs;
        float frameDuration = this.getFrameDurationNs();
        float dFrames = (float)timeSinceFrame / frameDuration;
        float newFrameRaw = this.frameRaw + (this.isReversed() ? -dFrames : dFrames);
        boolean ended = !MiscUtils.contains(newFrameRaw, this.getMinFrame(), this.getMaxFrame());
        float previousFrameRaw = this.frameRaw;
        this.frameRaw = MiscUtils.clamp(newFrameRaw, this.getMinFrame(), this.getMaxFrame());
        this.frame = this.useCompositionFrameRate ? (float)Math.floor(this.frameRaw) : this.frameRaw;
        this.lastFrameTimeNs = frameTimeNanos;
        if (!this.useCompositionFrameRate || this.frameRaw != previousFrameRaw) {
            this.notifyUpdate();
        }
        if (ended) {
            if (this.getRepeatCount() != -1 && this.repeatCount >= this.getRepeatCount()) {
                this.frame = this.frameRaw = this.speed < 0.0f ? this.getMinFrame() : this.getMaxFrame();
                this.removeFrameCallback();
                this.notifyEnd(this.isReversed());
            } else {
                this.notifyRepeat();
                ++this.repeatCount;
                if (this.getRepeatMode() == 2) {
                    this.speedReversedForRepeatMode = !this.speedReversedForRepeatMode;
                    this.reverseAnimationSpeed();
                } else {
                    this.frame = this.frameRaw = this.isReversed() ? this.getMaxFrame() : this.getMinFrame();
                }
                this.lastFrameTimeNs = frameTimeNanos;
            }
        }
        this.verifyFrame();
        if (L.isTraceEnabled()) {
            L.endSection("LottieValueAnimator#doFrame");
        }
    }

    private float getFrameDurationNs() {
        if (this.composition == null) {
            return Float.MAX_VALUE;
        }
        return 1.0E9f / this.composition.getFrameRate() / Math.abs(this.speed);
    }

    public void clearComposition() {
        this.composition = null;
        this.minFrame = -2.1474836E9f;
        this.maxFrame = 2.1474836E9f;
    }

    public void setComposition(LottieComposition composition) {
        boolean keepMinAndMaxFrames = this.composition == null;
        this.composition = composition;
        if (keepMinAndMaxFrames) {
            this.setMinAndMaxFrames(Math.max(this.minFrame, composition.getStartFrame()), Math.min(this.maxFrame, composition.getEndFrame()));
        } else {
            this.setMinAndMaxFrames((int)composition.getStartFrame(), (int)composition.getEndFrame());
        }
        float frame = this.frame;
        this.frame = 0.0f;
        this.frameRaw = 0.0f;
        this.setFrame((int)frame);
        this.notifyUpdate();
    }

    public void setFrame(float frame) {
        if (this.frameRaw == frame) {
            return;
        }
        this.frameRaw = MiscUtils.clamp(frame, this.getMinFrame(), this.getMaxFrame());
        this.frame = this.useCompositionFrameRate ? (float)Math.floor(this.frameRaw) : this.frameRaw;
        this.lastFrameTimeNs = 0L;
        this.notifyUpdate();
    }

    public void setMinFrame(int minFrame) {
        this.setMinAndMaxFrames(minFrame, (int)this.maxFrame);
    }

    public void setMaxFrame(float maxFrame) {
        this.setMinAndMaxFrames(this.minFrame, maxFrame);
    }

    public void setMinAndMaxFrames(float minFrame, float maxFrame) {
        if (minFrame > maxFrame) {
            throw new IllegalArgumentException(String.format("minFrame (%s) must be <= maxFrame (%s)", Float.valueOf(minFrame), Float.valueOf(maxFrame)));
        }
        float compositionMinFrame = this.composition == null ? -3.4028235E38f : this.composition.getStartFrame();
        float compositionMaxFrame = this.composition == null ? Float.MAX_VALUE : this.composition.getEndFrame();
        float newMinFrame = MiscUtils.clamp(minFrame, compositionMinFrame, compositionMaxFrame);
        float newMaxFrame = MiscUtils.clamp(maxFrame, compositionMinFrame, compositionMaxFrame);
        if (newMinFrame != this.minFrame || newMaxFrame != this.maxFrame) {
            this.minFrame = newMinFrame;
            this.maxFrame = newMaxFrame;
            this.setFrame((int)MiscUtils.clamp(this.frame, newMinFrame, newMaxFrame));
        }
    }

    public void reverseAnimationSpeed() {
        this.setSpeed(-this.getSpeed());
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setRepeatMode(int value) {
        super.setRepeatMode(value);
        if (value != 2 && this.speedReversedForRepeatMode) {
            this.speedReversedForRepeatMode = false;
            this.reverseAnimationSpeed();
        }
    }

    @MainThread
    public void playAnimation() {
        this.running = true;
        this.notifyStart(this.isReversed());
        this.setFrame((int)(this.isReversed() ? this.getMaxFrame() : this.getMinFrame()));
        this.lastFrameTimeNs = 0L;
        this.repeatCount = 0;
        this.postFrameCallback();
    }

    @MainThread
    public void endAnimation() {
        this.removeFrameCallback();
        this.notifyEnd(this.isReversed());
    }

    @MainThread
    public void pauseAnimation() {
        this.removeFrameCallback();
        this.notifyPause();
    }

    @MainThread
    public void resumeAnimation() {
        this.running = true;
        this.postFrameCallback();
        this.lastFrameTimeNs = 0L;
        if (this.isReversed() && this.getFrame() == this.getMinFrame()) {
            this.setFrame(this.getMaxFrame());
        } else if (!this.isReversed() && this.getFrame() == this.getMaxFrame()) {
            this.setFrame(this.getMinFrame());
        }
        this.notifyResume();
    }

    @MainThread
    public void cancel() {
        this.notifyCancel();
        this.removeFrameCallback();
    }

    private boolean isReversed() {
        return this.getSpeed() < 0.0f;
    }

    public float getMinFrame() {
        if (this.composition == null) {
            return 0.0f;
        }
        return this.minFrame == -2.1474836E9f ? this.composition.getStartFrame() : this.minFrame;
    }

    public float getMaxFrame() {
        if (this.composition == null) {
            return 0.0f;
        }
        return this.maxFrame == 2.1474836E9f ? this.composition.getEndFrame() : this.maxFrame;
    }

    @Override
    void notifyCancel() {
        super.notifyCancel();
        this.notifyEnd(this.isReversed());
    }

    protected void postFrameCallback() {
        if (this.isRunning()) {
            this.removeFrameCallback(false);
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    @MainThread
    protected void removeFrameCallback() {
        this.removeFrameCallback(true);
    }

    @MainThread
    protected void removeFrameCallback(boolean stopRunning) {
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
        if (stopRunning) {
            this.running = false;
        }
    }

    private void verifyFrame() {
        if (this.composition == null) {
            return;
        }
        if (this.frame < this.minFrame || this.frame > this.maxFrame) {
            throw new IllegalStateException(String.format("Frame must be [%f,%f]. It is %f", Float.valueOf(this.minFrame), Float.valueOf(this.maxFrame), Float.valueOf(this.frame)));
        }
    }
}

