/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser.moshi;

import com.airbnb.lottie.parser.moshi.JsonDataException;
import com.airbnb.lottie.parser.moshi.JsonEncodingException;
import com.airbnb.lottie.parser.moshi.JsonScope;
import com.airbnb.lottie.parser.moshi.JsonUtf8Reader;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

public abstract class JsonReader
implements Closeable {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    int stackSize;
    int[] scopes = new int[32];
    String[] pathNames = new String[32];
    int[] pathIndices = new int[32];
    boolean lenient;
    boolean failOnUnknown;

    public static JsonReader of(BufferedSource source) {
        return new JsonUtf8Reader(source);
    }

    JsonReader() {
    }

    final void pushScope(int newTop) {
        if (this.stackSize == this.scopes.length) {
            if (this.stackSize == 256) {
                throw new JsonDataException("Nesting too deep at " + this.getPath());
            }
            this.scopes = Arrays.copyOf(this.scopes, this.scopes.length * 2);
            this.pathNames = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
            this.pathIndices = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
        }
        this.scopes[this.stackSize++] = newTop;
    }

    final JsonEncodingException syntaxError(String message) throws JsonEncodingException {
        throw new JsonEncodingException(message + " at path " + this.getPath());
    }

    public abstract void beginArray() throws IOException;

    public abstract void endArray() throws IOException;

    public abstract void beginObject() throws IOException;

    public abstract void endObject() throws IOException;

    public abstract boolean hasNext() throws IOException;

    public abstract Token peek() throws IOException;

    public abstract String nextName() throws IOException;

    public abstract int selectName(Options var1) throws IOException;

    public abstract void skipName() throws IOException;

    public abstract String nextString() throws IOException;

    public abstract boolean nextBoolean() throws IOException;

    public abstract double nextDouble() throws IOException;

    public abstract int nextInt() throws IOException;

    public abstract void skipValue() throws IOException;

    public final String getPath() {
        return JsonScope.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices);
    }

    private static void string(BufferedSink sink, String value) throws IOException {
        String[] replacements = REPLACEMENT_CHARS;
        sink.writeByte(34);
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                replacement = replacements[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                sink.writeUtf8(value, last, i);
            }
            sink.writeUtf8(replacement);
            last = i + 1;
        }
        if (last < length) {
            sink.writeUtf8(value, last, length);
        }
        sink.writeByte(34);
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonReader.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonReader.REPLACEMENT_CHARS[34] = "\\\"";
        JsonReader.REPLACEMENT_CHARS[92] = "\\\\";
        JsonReader.REPLACEMENT_CHARS[9] = "\\t";
        JsonReader.REPLACEMENT_CHARS[8] = "\\b";
        JsonReader.REPLACEMENT_CHARS[10] = "\\n";
        JsonReader.REPLACEMENT_CHARS[13] = "\\r";
        JsonReader.REPLACEMENT_CHARS[12] = "\\f";
    }

    public static enum Token {
        BEGIN_ARRAY,
        END_ARRAY,
        BEGIN_OBJECT,
        END_OBJECT,
        NAME,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL,
        END_DOCUMENT;

    }

    public static final class Options {
        final String[] strings;
        final okio.Options doubleQuoteSuffix;

        private Options(String[] strings, okio.Options doubleQuoteSuffix) {
            this.strings = strings;
            this.doubleQuoteSuffix = doubleQuoteSuffix;
        }

        public static Options of(String ... strings) {
            try {
                ByteString[] result = new ByteString[strings.length];
                Buffer buffer = new Buffer();
                for (int i = 0; i < strings.length; ++i) {
                    JsonReader.string((BufferedSink)buffer, strings[i]);
                    buffer.readByte();
                    result[i] = buffer.readByteString();
                }
                return new Options((String[])strings.clone(), okio.Options.of((ByteString[])result));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

