/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.toast;

import android.content.Context;
import android.widget.Toast;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.RuntimeInfo;
import tv.athena.util.toast.ToastCompat;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0007J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0007J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0007J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0007J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Ltv/athena/util/toast/ToastUtil;", "", "()V", "sApplication", "Landroid/content/Context;", "getSApplication", "()Landroid/content/Context;", "getDefaultToast", "Landroid/widget/Toast;", "resId", "", "message", "", "showToast", "", "duration", "gravity", "xOffset", "yOffset", "utils_release"})
public final class ToastUtil {
    public static final ToastUtil INSTANCE;

    private final Context getSApplication() {
        return RuntimeInfo.getSAppContext();
    }

    private final Toast getDefaultToast(int resId) {
        String message;
        String string2 = message = this.getSApplication().getString(resId);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
        return this.getDefaultToast(string2);
    }

    private final Toast getDefaultToast(String message) {
        Toast toast = ToastCompat.Companion.makeText(this.getSApplication(), message, 1);
        toast.setGravity(17, 0, 0);
        return toast;
    }

    @JvmStatic
    public static final void showToast(int resId) {
        Toast toast = INSTANCE.getDefaultToast(resId);
        toast.show();
    }

    @JvmStatic
    public static final void showToast(int resId, int duration) {
        Toast toast = INSTANCE.getDefaultToast(resId);
        toast.setDuration(duration);
        toast.show();
    }

    @JvmStatic
    public static final void showToast(int resId, int gravity, int xOffset, int yOffset) {
        Toast toast = ToastCompat.Companion.makeText(INSTANCE.getSApplication(), resId, 1);
        toast.setGravity(gravity, xOffset, yOffset);
        toast.show();
    }

    @JvmStatic
    public static final void showToast(int resId, int gravity, int xOffset, int yOffset, int duration) {
        Toast toast = ToastCompat.Companion.makeText(INSTANCE.getSApplication(), resId, duration);
        toast.setGravity(gravity, xOffset, yOffset);
        toast.show();
    }

    @JvmStatic
    public static final void showToast(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Toast toast = INSTANCE.getDefaultToast(message);
        toast.show();
    }

    @JvmStatic
    public static final void showToast(@NotNull String message, int duration) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Toast toast = INSTANCE.getDefaultToast(message);
        toast.setDuration(duration);
        toast.show();
    }

    @JvmStatic
    public static final void showToast(@NotNull String message, int gravity, int xOffset, int yOffset) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Toast toast = ToastCompat.Companion.makeText(INSTANCE.getSApplication(), message, 1);
        toast.setGravity(gravity, xOffset, yOffset);
        toast.show();
    }

    @JvmStatic
    public static final void showToast(@NotNull String message, int gravity, int xOffset, int yOffset, int duration) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Toast toast = ToastCompat.Companion.makeText(INSTANCE.getSApplication(), message, duration);
        toast.setGravity(gravity, xOffset, yOffset);
        toast.show();
    }

    private ToastUtil() {
    }

    static {
        ToastUtil toastUtil;
        INSTANCE = toastUtil = new ToastUtil();
    }
}

