/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.helper;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.permissions.checker.DoubleChecker;
import tv.athena.util.permissions.checker.PermissionChecker;
import tv.athena.util.permissions.checker.StandardChecker;
import tv.athena.util.permissions.checker.StrictChecker;
import tv.athena.util.permissions.helper.PermissionHelper;
import tv.athena.util.permissions.helper.PermissionsFragment;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\"\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u001fJ-\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\"\u00020\u000f\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J/\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\"\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u001fJ)\u0010*\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\"\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010,R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\b\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Ltv/athena/util/permissions/helper/PermissionHelper;", "", "()V", "DOUBLE_CHECKER", "Ltv/athena/util/permissions/checker/DoubleChecker;", "getDOUBLE_CHECKER", "()Ltv/athena/util/permissions/checker/DoubleChecker;", "DOUBLE_CHECKER$delegate", "Lkotlin/Lazy;", "MAIN_HANDLER", "Landroid/os/Handler;", "getMAIN_HANDLER", "()Landroid/os/Handler;", "MAIN_HANDLER$delegate", "PERMISSION_FRAGMENT_TAG", "", "STANDARD_CHECKER", "Ltv/athena/util/permissions/checker/StandardChecker;", "getSTANDARD_CHECKER", "()Ltv/athena/util/permissions/checker/StandardChecker;", "STRICT_CHECKER", "Ltv/athena/util/permissions/checker/StrictChecker;", "getSTRICT_CHECKER", "()Ltv/athena/util/permissions/checker/StrictChecker;", "STRICT_CHECKER$delegate", "getAlwaysDeniedPermissions", "", "activity", "Landroid/app/Activity;", "deniedPermissions", "", "(Landroid/app/Activity;[Ljava/lang/String;)Ljava/util/List;", "getDeniedPermissions", "context", "Landroid/content/Context;", "permissions", "(Landroid/content/Context;[Ljava/lang/String;)Ljava/util/List;", "getPermissionsFragment", "Ltv/athena/util/permissions/helper/PermissionsFragment;", "fragmentManager", "Landroid/support/v4/app/FragmentManager;", "getRationalePermissions", "hasAlwaysDeniedPermission", "", "(Landroid/app/Activity;[Ljava/lang/String;)Z", "utils_release"})
public final class PermissionHelper {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final Lazy MAIN_HANDLER$delegate;
    @NotNull
    public static final String PERMISSION_FRAGMENT_TAG = "permission_fragment_tag";
    @NotNull
    private static final StandardChecker STANDARD_CHECKER;
    @NotNull
    private static final Lazy STRICT_CHECKER$delegate;
    @NotNull
    private static final Lazy DOUBLE_CHECKER$delegate;
    public static final PermissionHelper INSTANCE;

    static {
        PermissionHelper permissionHelper;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PermissionHelper.class), "MAIN_HANDLER", "getMAIN_HANDLER()Landroid/os/Handler;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PermissionHelper.class), "STRICT_CHECKER", "getSTRICT_CHECKER()Ltv/athena/util/permissions/checker/StrictChecker;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PermissionHelper.class), "DOUBLE_CHECKER", "getDOUBLE_CHECKER()Ltv/athena/util/permissions/checker/DoubleChecker;"))};
        INSTANCE = permissionHelper = new PermissionHelper();
        MAIN_HANDLER$delegate = LazyKt.lazy((Function0)MAIN_HANDLER.2.INSTANCE);
        STANDARD_CHECKER = new StandardChecker();
        STRICT_CHECKER$delegate = LazyKt.lazy((Function0)STRICT_CHECKER.2.INSTANCE);
        DOUBLE_CHECKER$delegate = LazyKt.lazy((Function0)DOUBLE_CHECKER.2.INSTANCE);
    }

    @NotNull
    public final Handler getMAIN_HANDLER() {
        Lazy lazy = MAIN_HANDLER$delegate;
        PermissionHelper permissionHelper = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    @NotNull
    public final PermissionsFragment getPermissionsFragment(@NotNull FragmentManager fragmentManager) {
        PermissionsFragment permissionsFragment;
        Intrinsics.checkParameterIsNotNull((Object)fragmentManager, (String)"fragmentManager");
        Fragment fragment = fragmentManager.findFragmentByTag(PERMISSION_FRAGMENT_TAG);
        if (!(fragment instanceof PermissionsFragment)) {
            fragment = null;
        }
        if ((permissionsFragment = (PermissionsFragment)fragment) == null) {
            permissionsFragment = new PermissionsFragment();
            fragmentManager.beginTransaction().add((Fragment)permissionsFragment, PERMISSION_FRAGMENT_TAG).commitNow();
        }
        return permissionsFragment;
    }

    @NotNull
    public final StandardChecker getSTANDARD_CHECKER() {
        return STANDARD_CHECKER;
    }

    @NotNull
    public final StrictChecker getSTRICT_CHECKER() {
        Lazy lazy = STRICT_CHECKER$delegate;
        PermissionHelper permissionHelper = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (StrictChecker)lazy.getValue();
    }

    @NotNull
    public final DoubleChecker getDOUBLE_CHECKER() {
        Lazy lazy = DOUBLE_CHECKER$delegate;
        PermissionHelper permissionHelper = this;
        KProperty kProperty = $$delegatedProperties[2];
        boolean bl = false;
        return (DoubleChecker)lazy.getValue();
    }

    @NotNull
    public final List<String> getDeniedPermissions(@NotNull Context context, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        PermissionChecker checker = Build.VERSION.SDK_INT >= 23 ? (PermissionChecker)STANDARD_CHECKER : (PermissionChecker)this.getSTRICT_CHECKER();
        ArrayList<String> deniedList = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (checker.hasPermission(context, permission2)) continue;
            deniedList.add(permission2);
        }
        return deniedList;
    }

    @TargetApi(value=23)
    @NotNull
    public final List<String> getRationalePermissions(@NotNull Activity activity, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        ArrayList<String> rationaleList = new ArrayList<String>(1);
        for (String permission2 : permissions) {
            if (!activity.shouldShowRequestPermissionRationale(permission2)) continue;
            rationaleList.add(permission2);
        }
        return rationaleList;
    }

    @TargetApi(value=23)
    public final boolean hasAlwaysDeniedPermission(@NotNull Activity activity, String ... deniedPermissions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)deniedPermissions, (String)"deniedPermissions");
        for (String permission2 : deniedPermissions) {
            if (activity.shouldShowRequestPermissionRationale(permission2)) continue;
            return true;
        }
        return false;
    }

    @TargetApi(value=23)
    @NotNull
    public final List<String> getAlwaysDeniedPermissions(@NotNull Activity activity, String ... deniedPermissions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)deniedPermissions, (String)"deniedPermissions");
        ArrayList<String> deniedList = new ArrayList<String>(1);
        for (String permission2 : deniedPermissions) {
            if (activity.shouldShowRequestPermissionRationale(permission2)) continue;
            deniedList.add(permission2);
        }
        return deniedList;
    }

    private PermissionHelper() {
    }
}

