/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.checker;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.log.ULog;
import tv.athena.util.permissions.Permission;
import tv.athena.util.permissions.checker.AddVoicemailTest;
import tv.athena.util.permissions.checker.CalendarReadTest;
import tv.athena.util.permissions.checker.CalendarWriteTest;
import tv.athena.util.permissions.checker.CallLogReadTest;
import tv.athena.util.permissions.checker.CallLogWriteTest;
import tv.athena.util.permissions.checker.CameraTest;
import tv.athena.util.permissions.checker.ContactsReadTest;
import tv.athena.util.permissions.checker.ContactsWriteTest;
import tv.athena.util.permissions.checker.LocationCoarseTest;
import tv.athena.util.permissions.checker.LocationFineTest;
import tv.athena.util.permissions.checker.PermissionChecker;
import tv.athena.util.permissions.checker.RecordAudioTest;
import tv.athena.util.permissions.checker.SensorsTest;
import tv.athena.util.permissions.checker.SipTest;
import tv.athena.util.permissions.checker.SmsReadTest;
import tv.athena.util.permissions.checker.StorageReadTest;
import tv.athena.util.permissions.checker.StorageWriteTest;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0002J)\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u001e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltv/athena/util/permissions/checker/StrictChecker;", "Ltv/athena/util/permissions/checker/PermissionChecker;", "()V", "TAG", "", "checkAddVoicemail", "", "context", "Landroid/content/Context;", "checkCamera", "checkCoarseLocation", "checkFineLocation", "checkReadCalendar", "checkReadCallLog", "checkReadContacts", "checkReadSms", "checkReadStorage", "checkRecordAudio", "checkSensors", "checkSip", "checkWriteCalendar", "checkWriteCallLog", "checkWriteContacts", "checkWriteStorage", "hasPermission", "permissions", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "permission", "", "utils_release"})
public final class StrictChecker
implements PermissionChecker {
    private final String TAG = "permissions_AddVoicemailTest";

    @Override
    public boolean hasPermission(@NotNull Context context, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        if (Build.VERSION.SDK_INT < 21) {
            return true;
        }
        for (String permission2 : permissions) {
            if (this.hasPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(@NotNull Context context, @NotNull List<String> permissions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(permissions, (String)"permissions");
        if (Build.VERSION.SDK_INT < 21) {
            return true;
        }
        for (String permission2 : permissions) {
            if (this.hasPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasPermission(Context context, String permission2) {
        try {
            String string2 = permission2;
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getREAD_CALENDAR())) {
                return this.checkReadCalendar(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getWRITE_CALENDAR())) {
                return this.checkWriteCalendar(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getCAMERA())) {
                return this.checkCamera(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getREAD_CONTACTS())) {
                return this.checkReadContacts(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getWRITE_CONTACTS())) {
                return this.checkWriteContacts(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getGET_ACCOUNTS())) {
                return true;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getACCESS_COARSE_LOCATION())) {
                return this.checkCoarseLocation(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getACCESS_FINE_LOCATION())) {
                return this.checkFineLocation(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getRECORD_AUDIO())) {
                return this.checkRecordAudio(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getCALL_PHONE())) {
                return true;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getREAD_CALL_LOG())) {
                return this.checkReadCallLog(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getWRITE_CALL_LOG())) {
                return this.checkWriteCallLog(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getADD_VOICEMAIL())) {
                return this.checkAddVoicemail(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getUSE_SIP())) {
                return this.checkSip(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getPROCESS_OUTGOING_CALLS())) {
                return true;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getBODY_SENSORS())) {
                return this.checkSensors(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getSEND_SMS()) || Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getRECEIVE_MMS())) {
                return true;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getREAD_SMS())) {
                return this.checkReadSms(context);
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getRECEIVE_WAP_PUSH()) || Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getRECEIVE_SMS())) {
                return true;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getREAD_EXTERNAL_STORAGE())) {
                return this.checkReadStorage();
            }
            if (Intrinsics.areEqual((Object)string2, (Object)Permission.INSTANCE.getWRITE_EXTERNAL_STORAGE())) {
                return this.checkWriteStorage();
            }
        }
        catch (Throwable e) {
            ULog.e(this.TAG, "hasPermission ", e, new Object[0]);
            return false;
        }
        return true;
    }

    private final boolean checkReadCalendar(Context context) throws Throwable {
        CalendarReadTest test = new CalendarReadTest(context);
        return test.test();
    }

    private final boolean checkWriteCalendar(Context context) throws Throwable {
        CalendarWriteTest test = new CalendarWriteTest(context);
        return test.test();
    }

    private final boolean checkCamera(Context context) throws Throwable {
        CameraTest test = new CameraTest(context);
        return test.test();
    }

    private final boolean checkReadContacts(Context context) throws Throwable {
        ContactsReadTest test = new ContactsReadTest(context);
        return test.test();
    }

    private final boolean checkWriteContacts(Context context) throws Throwable {
        ContentResolver resolver;
        ContentResolver contentResolver = resolver = context.getContentResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentResolver, (String)"resolver");
        ContactsWriteTest test = new ContactsWriteTest(contentResolver);
        return test.test();
    }

    private final boolean checkCoarseLocation(Context context) throws Throwable {
        LocationCoarseTest test = new LocationCoarseTest(context);
        return test.test();
    }

    private final boolean checkFineLocation(Context context) throws Throwable {
        LocationFineTest test = new LocationFineTest(context);
        return test.test();
    }

    private final boolean checkRecordAudio(Context context) throws Throwable {
        RecordAudioTest test = new RecordAudioTest(context);
        return test.test();
    }

    private final boolean checkReadCallLog(Context context) throws Throwable {
        CallLogReadTest test = new CallLogReadTest(context);
        return test.test();
    }

    private final boolean checkWriteCallLog(Context context) throws Throwable {
        CallLogWriteTest test = new CallLogWriteTest(context);
        return test.test();
    }

    private final boolean checkAddVoicemail(Context context) throws Throwable {
        AddVoicemailTest test = new AddVoicemailTest(context);
        return test.test();
    }

    private final boolean checkSip(Context context) throws Throwable {
        SipTest test = new SipTest(context);
        return test.test();
    }

    private final boolean checkSensors(Context context) throws Throwable {
        SensorsTest test = new SensorsTest(context);
        return test.test();
    }

    private final boolean checkReadSms(Context context) throws Throwable {
        SmsReadTest test = new SmsReadTest(context);
        return test.test();
    }

    private final boolean checkReadStorage() throws Throwable {
        StorageReadTest test = new StorageReadTest();
        return test.test();
    }

    private final boolean checkWriteStorage() throws Throwable {
        StorageWriteTest test = new StorageWriteTest();
        return test.test();
    }
}

