/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.checker;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.permissions.checker.PermissionChecker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016\u00a8\u0006\f"}, d2={"Ltv/athena/util/permissions/checker/StandardChecker;", "Ltv/athena/util/permissions/checker/PermissionChecker;", "()V", "hasPermission", "", "context", "Landroid/content/Context;", "permissions", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "", "utils_release"})
public final class StandardChecker
implements PermissionChecker {
    @Override
    public boolean hasPermission(@NotNull Context context, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        List<String> list = Arrays.asList(Arrays.copyOf(permissions, permissions.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*permissions)");
        return this.hasPermission(context, list);
    }

    @Override
    public boolean hasPermission(@NotNull Context context, @NotNull List<String> permissions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(permissions, (String)"permissions");
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        AppOpsManager opsManager = null;
        for (String permission2 : permissions) {
            int result = context.checkPermission(permission2, Process.myPid(), Process.myUid());
            if (result == -1) {
                return false;
            }
            String op = AppOpsManager.permissionToOp((String)permission2);
            if (TextUtils.isEmpty((CharSequence)op)) continue;
            if (opsManager == null) {
                Object object = context.getSystemService("appops");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.AppOpsManager");
                }
                opsManager = (AppOpsManager)object;
            }
            if ((result = opsManager.checkOpNoThrow(op, Process.myUid(), context.getPackageName())) == 0 || result == 4) continue;
            return false;
        }
        return true;
    }
}

