/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.checker;

import android.content.Context;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.permissions.checker.PermissionTest;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ltv/athena/util/permissions/checker/LocationFineTest;", "Ltv/athena/util/permissions/checker/PermissionTest;", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "test", "", "utils_release"})
public final class LocationFineTest
implements PermissionTest {
    private final Context mContext;

    @Override
    public boolean test() throws Throwable {
        Object object = this.mContext.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager locationManager = (LocationManager)object;
        List providers = locationManager.getProviders(true);
        boolean gpsProvider = providers.contains("gps");
        boolean passiveProvider = providers.contains("passive");
        if (gpsProvider || passiveProvider) {
            return true;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        boolean gpsHardware = packageManager.hasSystemFeature("android.hardware.location.gps");
        return !gpsHardware ? true : !locationManager.isProviderEnabled("gps");
    }

    public LocationFineTest(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
    }
}

