/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.checker;

import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.log.ULog;
import tv.athena.util.permissions.checker.CameraTest;
import tv.athena.util.permissions.checker.PermissionTest;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000+\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltv/athena/util/permissions/checker/CameraTest;", "Ltv/athena/util/permissions/checker/PermissionTest;", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "CALLBACK", "tv/athena/util/permissions/checker/CameraTest$CALLBACK$1", "Ltv/athena/util/permissions/checker/CameraTest$CALLBACK$1;", "PREVIEW_CALLBACK", "Landroid/hardware/Camera$PreviewCallback;", "TAG", "", "test", "", "utils_release"})
public final class CameraTest
implements PermissionTest {
    private final String TAG = "permissions_CameraTest";
    private final Camera.PreviewCallback PREVIEW_CALLBACK;
    private final CALLBACK.1 CALLBACK;
    private final Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test() throws Throwable {
        boolean bl;
        SurfaceView surfaceView = new SurfaceView(this.mContext);
        SurfaceHolder holder = surfaceView.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this.CALLBACK);
        Camera camera = null;
        try {
            Camera camera2 = camera = Camera.open();
            if (camera2 == null) {
                Intrinsics.throwNpe();
            }
            Camera.Parameters parameters = camera2.getParameters();
            camera.setParameters(parameters);
            camera.setPreviewDisplay(holder);
            camera.setPreviewCallback(this.PREVIEW_CALLBACK);
            camera.startPreview();
            bl = true;
        }
        catch (Throwable e) {
            try {
                ULog.e(this.TAG, "", e, new Object[0]);
                PackageManager packageManager = this.mContext.getPackageManager();
                boolean bl2 = !packageManager.hasSystemFeature("android.hardware.camera");
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (camera != null) {
                    camera.stopPreview();
                    camera.setPreviewDisplay(null);
                    camera.setPreviewCallback(null);
                    camera.release();
                }
            }
        }
        camera.stopPreview();
        camera.setPreviewDisplay(null);
        camera.setPreviewCallback(null);
        camera.release();
        return bl;
    }

    public CameraTest(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.TAG = "permissions_CameraTest";
        this.PREVIEW_CALLBACK = PREVIEW_CALLBACK.1.INSTANCE;
        this.CALLBACK = new SurfaceHolder.Callback(){

            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            }

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
            }
        };
    }
}

