/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.image;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.util.Log;
import android.view.View;
import java.io.File;
import java.io.InputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.util.FP;
import tv.athena.util.RuntimeInfo;
import tv.athena.util.file.YYFileUtils;
import tv.athena.util.image.ImageConfig;
import tv.athena.util.image.YYImageUtils;
import tv.athena.util.log.ULog;

@Deprecated(message="old stuff")
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001yB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J(\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0007J\u0012\u0010$\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010\u000eH\u0007J\u001c\u0010&\u001a\u0004\u0018\u00010\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\fH\u0007J\"\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u001a\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u001a\u0010.\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u001a\u0010/\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u00100\u001a\u00020\u0004H\u0007J\u001a\u00101\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u001a\u00102\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u001e\u00103\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0015H\u0007J\"\u00103\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J,\u00105\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u001a\u00106\u001a\u0004\u0018\u00010\u000e2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0007J2\u0010:\u001a\u0004\u0018\u00010\u000e2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u001a\u0010>\u001a\u0004\u0018\u00010\u000e2\u0006\u0010;\u001a\u00020<2\u0006\u0010?\u001a\u00020\u0004H\u0007J\"\u0010>\u001a\u0004\u0018\u00010\u000e2\u0006\u0010;\u001a\u00020<2\u0006\u0010?\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0015H\u0007J*\u0010>\u001a\u0004\u0018\u00010\u000e2\u0006\u0010;\u001a\u00020<2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J$\u0010@\u001a\u0004\u0018\u00010\u000e2\b\u0010A\u001a\u0004\u0018\u00010\f2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u001cH\u0007J*\u0010E\u001a\u0004\u0018\u00010\u000e2\u0006\u0010A\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020C2\u0006\u0010H\u001a\u00020\u0004H\u0007J\u0010\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0004H\u0007J\u0010\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\fH\u0007J\u0014\u0010M\u001a\u0004\u0018\u00010\u000e2\b\u0010N\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010O\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\fH\u0007J*\u0010P\u001a\u0004\u0018\u00010\u00152\u0006\u0010Q\u001a\u00020R2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J*\u0010P\u001a\u0004\u0018\u00010\u00152\u0006\u0010+\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010S\u001a\u00020\u00042\u0006\u0010T\u001a\u00020\fH\u0007J\u0018\u0010U\u001a\u00020\u000e2\u0006\u0010V\u001a\u00020\u000e2\u0006\u0010W\u001a\u00020XH\u0007J \u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u0004H\u0007J\u0012\u0010]\u001a\u00020\u001c2\b\u0010^\u001a\u0004\u0018\u00010_H\u0007J\u0010\u0010]\u001a\u00020\u001c2\u0006\u00107\u001a\u000208H\u0007J\u0010\u0010]\u001a\u00020\u001c2\u0006\u0010`\u001a\u00020\fH\u0007J\u0010\u0010a\u001a\u00020\u001c2\u0006\u0010N\u001a\u00020\u000eH\u0007J\u0018\u0010b\u001a\u00020\u001c2\u0006\u0010c\u001a\u00020\f2\u0006\u0010d\u001a\u00020\fH\u0007J\u001c\u0010e\u001a\u0004\u0018\u00010\u000e2\b\u0010f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010g\u001a\u00020XH\u0007J$\u0010e\u001a\u0004\u0018\u00010\u000e2\b\u0010f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010h\u001a\u00020\u00042\u0006\u0010i\u001a\u00020\u0004H\u0007J<\u0010j\u001a\u00020\u001c2\u0006\u0010`\u001a\u00020\f2\u0006\u0010k\u001a\u00020\f2\u0006\u0010l\u001a\u00020\u00042\u0006\u0010m\u001a\u00020\u00042\b\u0010n\u001a\u0004\u0018\u00010o2\b\b\u0002\u0010H\u001a\u00020\u0004H\u0007J$\u0010p\u001a\u0004\u0018\u00010\u000e2\b\u0010V\u001a\u0004\u0018\u00010\u000e2\u0006\u0010q\u001a\u00020\u00042\u0006\u0010r\u001a\u00020\u001cH\u0007J:\u0010s\u001a\u00020\u001c2\u0006\u0010`\u001a\u00020\f2\u0006\u0010k\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010n\u001a\u0004\u0018\u00010o2\u0006\u0010H\u001a\u00020\u0004H\u0007J\u001c\u0010t\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\f2\b\u0010V\u001a\u0004\u0018\u00010\u000eH\u0007J(\u0010u\u001a\u00020\u000e2\u0006\u0010v\u001a\u00020\u000e2\u0006\u0010l\u001a\u00020\u00042\u0006\u0010m\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0004H\u0007J\u001c\u0010w\u001a\u00020\u001c2\b\u0010V\u001a\u0004\u0018\u00010\u000e2\b\u0010x\u001a\u0004\u0018\u00010\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Ltv/athena/util/image/YYImageUtils;", "", "()V", "IMAGE_COMPRESS_RATE", "", "getIMAGE_COMPRESS_RATE", "()I", "IMAGE_SCALE_HEIGHT", "getIMAGE_SCALE_HEIGHT", "IMAGE_SCALE_WIDTH", "getIMAGE_SCALE_WIDTH", "TAG", "", "sDefaultFemalePhotoBitmap", "Landroid/graphics/Bitmap;", "sDefaultFemalePhotoOffline", "sDefaultMalePhoto", "sDefaultMalePhotoBitmap", "sDefaultMalePhotoOffline", "calInSampleSize", "options", "Landroid/graphics/BitmapFactory$Options;", "destWidth", "destHeight", "calSampleSize", "desiredWidth", "desiredHeight", "isMemoryPrior", "", "opts", "calculateInSampleSize", "reqWidth", "reqHeight", "convertViewToBitmap", "v", "Landroid/view/View;", "createBlended", "src", "createClipBitmap", "bmp", "photoRect", "Landroid/graphics/Rect;", "decodeBmpSize", "filePath", "decodeBmpSizeBy", "decodeByHeight", "decodeByHeightOrThrow", "decodeBySize", "size", "decodeByWidth", "decodeByWidthOrThrow", "decodeFile", "opt", "decodeFileOrThrow", "decodeImageFromStream", "queryStream", "Ljava/io/InputStream;", "decodeStream", "decodeResOrThrow", "context", "Landroid/content/Context;", "drawableId", "decodeResource", "resId", "decodeSampledBitmapFile", "path", "config", "Ltv/athena/util/image/ImageConfig;", "rorate", "fixPictureOrientation", "replaceSrcFile", "imageConfig", "quality", "getAngleFromRotateEnum", "rotate", "getCameraPhotoOrientation", "imagePath", "getGrayBmp", "image", "getPictureDegree", "getProperOptions", "data", "", "getRotate", "filepath", "getRoundedCornerBitmap", "bitmap", "roundPx", "", "isBitmapOverSize", "sampleSize", "width", "height", "isImage", "file", "Ljava/io/File;", "imageFile", "isNotDefaultPortrait", "renameFile", "oriPath", "newPath", "resize", "oriBitmap", "scale", "targetWidth", "targetHeight", "resizeAndRotateImage", "newFileName", "maxWidth", "maxHeight", "matrix", "Landroid/graphics/Matrix;", "resizeBitmap", "maxBorderLength", "recycle", "resizeImage", "rorateBitmap", "rotateAndResizeImage", "inBitmap", "saveBitmapToFile", "filename", "PORTRAIT_OPS", "utils_release"})
public final class YYImageUtils {
    private static final String TAG = "YYImageUtils";
    private static final int IMAGE_COMPRESS_RATE = 75;
    private static final int IMAGE_SCALE_WIDTH = 800;
    private static final int IMAGE_SCALE_HEIGHT = 800;
    private static final Bitmap sDefaultMalePhoto;
    private static final Bitmap sDefaultMalePhotoOffline;
    private static final Bitmap sDefaultFemalePhotoOffline;
    private static final Bitmap sDefaultMalePhotoBitmap;
    private static final Bitmap sDefaultFemalePhotoBitmap;
    public static final YYImageUtils INSTANCE;

    public final int getIMAGE_COMPRESS_RATE() {
        return IMAGE_COMPRESS_RATE;
    }

    public final int getIMAGE_SCALE_WIDTH() {
        return IMAGE_SCALE_WIDTH;
    }

    public final int getIMAGE_SCALE_HEIGHT() {
        return IMAGE_SCALE_HEIGHT;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeByWidth(@NotNull String filePath, int desiredWidth) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            return YYImageUtils.decodeFileOrThrow$default(filePath, desiredWidth, 0, false, 8, null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeBySize(@NotNull String filePath, int size) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Rect rect = YYImageUtils.decodeBmpSize(filePath);
        return rect.width() > rect.height() ? YYImageUtils.decodeByWidth(filePath, size) : YYImageUtils.decodeByHeight(filePath, size);
    }

    @JvmStatic
    @NotNull
    public static final Rect decodeBmpSize(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        return new Rect(0, 0, opts.outWidth, opts.outHeight);
    }

    @JvmStatic
    @Nullable
    public static final Rect decodeBmpSizeBy(@NotNull String filePath, int desiredWidth, int desiredHeight) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        BitmapFactory.Options options = INSTANCE.getProperOptions(filePath, desiredWidth, desiredHeight, false);
        if (options == null) {
            return null;
        }
        BitmapFactory.Options opts = options;
        return new Rect(0, 0, opts.outWidth, opts.outHeight);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeByHeight(@NotNull String filePath, int desiredHeight) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            return YYImageUtils.decodeFileOrThrow$default(filePath, 0, desiredHeight, false, 8, null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeByWidthOrThrow(@NotNull String filePath, int desiredWidth) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return YYImageUtils.decodeFileOrThrow$default(filePath, desiredWidth, 0, false, 8, null);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeByHeightOrThrow(@NotNull String filePath, int desiredHeight) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return YYImageUtils.decodeFileOrThrow$default(filePath, 0, desiredHeight, false, 8, null);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeFile(@NotNull String filePath, int desiredWidth, int desiredHeight) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            return YYImageUtils.decodeFileOrThrow$default(filePath, desiredWidth, desiredHeight, false, 8, null);
        }
        catch (Throwable e) {
            ULog.w("decoeFile", "fail to decode %s, %s", filePath, e.toString());
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeResource(@NotNull Context context, int resId, int desiredWidth, int desiredHeight) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (desiredWidth <= 0 && desiredHeight <= 0) {
            return YYImageUtils.decodeResource(context, resId);
        }
        try {
            return YYImageUtils.decodeResOrThrow(context, resId, desiredWidth, desiredHeight, true);
        }
        catch (Throwable e) {
            ULog.e(TAG, (Function0<? extends Object>)((Function0)decodeResource.1.INSTANCE), e);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeResource(@NotNull Context context, int resId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        }
        catch (OutOfMemoryError e) {
            ULog.e(TAG, (Function0<? extends Object>)((Function0)decodeResource.2.INSTANCE), e);
            return null;
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap decodeFileOrThrow(@NotNull String filePath, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        BitmapFactory.Options options = INSTANCE.getProperOptions(filePath, desiredWidth, desiredHeight, isMemoryPrior);
        if (options == null) {
            return null;
        }
        BitmapFactory.Options opts = options;
        opts.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
    }

    public static /* synthetic */ Bitmap decodeFileOrThrow$default(String string2, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        return YYImageUtils.decodeFileOrThrow(string2, n, n2, bl);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Bitmap decodeFileOrThrow(@NotNull String filePath, int desiredWidth, int desiredHeight) {
        return YYImageUtils.decodeFileOrThrow$default(filePath, desiredWidth, desiredHeight, false, 8, null);
    }

    @JvmStatic
    @Nullable
    public static final BitmapFactory.Options getProperOptions(@NotNull byte[] data, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = INSTANCE.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        if (desiredHeight > 0 || desiredWidth > 0) {
            do {
                opts.inSampleSize = sampleSize++;
                BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            } while (desiredWidth > 0 && opts.outWidth > desiredWidth || desiredHeight > 0 && opts.outHeight > desiredHeight);
        }
        return opts;
    }

    private final BitmapFactory.Options getProperOptions(String filePath, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = this.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        if (desiredHeight > 0 || desiredWidth > 0) {
            do {
                opts.inSampleSize = sampleSize++;
                BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opts);
            } while (desiredWidth > 0 && opts.outWidth > desiredWidth || desiredHeight > 0 && opts.outHeight > desiredHeight);
        }
        return opts;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeResOrThrow(@NotNull Context context, int drawableId, int desiredWidth, int desiredHeight, boolean isMemoryPrior) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        Resources res = context.getResources();
        BitmapFactory.decodeResource((Resources)res, (int)drawableId, (BitmapFactory.Options)opts);
        if (opts.outWidth <= 0 || opts.outHeight <= 0) {
            return null;
        }
        int sampleSize = INSTANCE.calSampleSize(desiredWidth, desiredHeight, isMemoryPrior, opts);
        opts.inJustDecodeBounds = false;
        opts.inSampleSize = sampleSize;
        return BitmapFactory.decodeResource((Resources)res, (int)drawableId, (BitmapFactory.Options)opts);
    }

    private final int calSampleSize(int desiredWidth, int desiredHeight, boolean isMemoryPrior, BitmapFactory.Options opts) {
        int sampleSize = 1;
        if (desiredWidth == 0 && desiredHeight == 0) {
            sampleSize = 1;
        } else if (desiredHeight == 0) {
            sampleSize = (opts.outWidth + desiredWidth - 1) / desiredWidth;
        } else if (desiredWidth == 0) {
            sampleSize = (opts.outHeight + desiredHeight - 1) / desiredHeight;
        } else {
            int horRatio = (opts.outWidth + desiredWidth - 1) / desiredWidth;
            int verRatio = (opts.outHeight + desiredHeight - 1) / desiredHeight;
            sampleSize = isMemoryPrior ? Math.max(horRatio, verRatio) : Math.min(horRatio, verRatio);
        }
        return sampleSize;
    }

    @JvmOverloads
    @Nullable
    public final Bitmap decodeFile(@NotNull String filePath, @Nullable BitmapFactory.Options opt) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (FP.empty(filePath)) {
            return null;
        }
        Bitmap bmp = null;
        try {
            File file = new File(filePath);
            if (file.isFile()) {
                bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)opt);
            } else {
                ULog.e(TAG, filePath + " is not a file", null, new Object[0]);
            }
        }
        catch (OutOfMemoryError err) {
            ULog.e(TAG, "oom: " + filePath, null, new Object[0]);
            bmp = null;
        }
        return bmp;
    }

    public static /* synthetic */ Bitmap decodeFile$default(YYImageUtils yYImageUtils, String string2, BitmapFactory.Options options, int n, Object object) {
        if ((n & 2) != 0) {
            options = null;
        }
        return yYImageUtils.decodeFile(string2, options);
    }

    @JvmOverloads
    @Nullable
    public final Bitmap decodeFile(@NotNull String filePath) {
        return YYImageUtils.decodeFile$default(this, filePath, null, 2, null);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap resizeBitmap(@Nullable Bitmap bitmap, int maxBorderLength, boolean recycle) {
        float ratio;
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int newHeight = 0;
        int newWidth = 0;
        if (width > height) {
            ratio = (float)height / (float)width;
            newWidth = maxBorderLength;
            newHeight = (int)((float)newWidth * ratio);
        } else if (height > width) {
            ratio = (float)width / (float)height;
            newHeight = maxBorderLength;
            newWidth = (int)((float)newHeight * ratio);
        } else {
            newWidth = maxBorderLength;
            newHeight = maxBorderLength;
        }
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            if (recycle && !bitmap.isRecycled() && Intrinsics.areEqual((Object)bitmap, (Object)resizedBitmap) ^ true) {
                bitmap.recycle();
            }
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            ULog.e(TAG, "lcy resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    @JvmStatic
    public static final int calInSampleSize(@NotNull BitmapFactory.Options options, int destWidth, int destHeight) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > destWidth || width > destHeight) {
            int widthRatio;
            int heightRatio = (int)Math.floor((float)height / (float)destHeight);
            int n = inSampleSize = heightRatio < (widthRatio = (int)Math.floor((float)width / (float)destWidth)) ? heightRatio : widthRatio;
            if (inSampleSize <= 0) {
                inSampleSize = 1;
            }
            while (YYImageUtils.isBitmapOverSize(inSampleSize, width, height)) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    @JvmStatic
    public static final boolean isBitmapOverSize(int sampleSize, int width, int height) {
        int correctSampleSize = sampleSize;
        if (sampleSize > 2) {
            correctSampleSize = sampleSize / 2 * 2;
        }
        return width / correctSampleSize > 4096 || height / correctSampleSize > 4096;
    }

    @JvmStatic
    public static final boolean resizeImage(@NotNull String imageFile, @NotNull String newFileName, int destWidth, int destHeight, @Nullable Matrix matrix, int quality) {
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        Intrinsics.checkParameterIsNotNull((Object)newFileName, (String)"newFileName");
        Matrix matrix2 = matrix;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int originWidth = options.outWidth;
        int originHeight = options.outHeight;
        if (originWidth <= 0 || originHeight <= 0) {
            ULog.e(TAG, "bitmap width or height is zero", null, new Object[0]);
            return false;
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = YYImageUtils.calInSampleSize(options, destWidth, destHeight);
        Bitmap bitmap = null;
        try {
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            int decodedWidth = bitmap2.getWidth();
            int decodedHeight = bitmap.getHeight();
            if (matrix2 == null) {
                matrix2 = new Matrix();
            }
            matrix2.setScale((float)destWidth / (float)decodedWidth, (float)destHeight / (float)decodedHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)decodedWidth, (int)decodedHeight, (Matrix)matrix2, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"Empty Catch on resizeImage", (Throwable)e);
        }
        if (bitmap != null) {
            try {
                YYFileUtils out = YYFileUtils.Companion.openFile(newFileName);
                out.write(bitmap, quality);
                out.close();
                return true;
            }
            catch (Exception e) {
                ULog.e(TAG, (Function0<? extends Object>)((Function0)resizeImage.1.INSTANCE), e);
            }
        }
        return false;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean resizeAndRotateImage(@NotNull String imageFile, @NotNull String newFileName, int maxWidth, int maxHeight, @Nullable Matrix matrix, int quality) {
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        Intrinsics.checkParameterIsNotNull((Object)newFileName, (String)"newFileName");
        Matrix matrix2 = matrix;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
        int originWidth = options.outWidth;
        int originHeight = options.outHeight;
        if (originWidth <= 0 || originHeight <= 0) {
            ULog.e(TAG, "bitmap width or height is zero", null, new Object[0]);
            return false;
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = YYImageUtils.calculateInSampleSize(options, maxWidth, maxHeight);
        float factor = 0.0f;
        factor = options.inSampleSize;
        Bitmap bitmap = null;
        try {
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            int decodedWidth = bitmap2.getWidth();
            int decodedHeight = bitmap.getHeight();
            int actualWidth = (int)((float)originWidth / factor);
            int actualHeight = (int)((float)originHeight / factor);
            if (matrix2 == null) {
                matrix2 = new Matrix();
            }
            matrix2.setScale((float)actualWidth / (float)decodedWidth, (float)actualHeight / (float)decodedHeight);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)decodedWidth, (int)decodedHeight, (Matrix)matrix2, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"Empty Catch on resizeAndRotateImage", (Throwable)e);
        }
        if (bitmap != null) {
            try {
                YYFileUtils out = YYFileUtils.Companion.openFile(newFileName);
                out.write(bitmap, quality);
                out.close();
                return true;
            }
            catch (Exception e) {
                ULog.e(TAG, (Function0<? extends Object>)((Function0)resizeAndRotateImage.1.INSTANCE), e);
            }
        }
        return false;
    }

    public static /* synthetic */ boolean resizeAndRotateImage$default(String string2, String string3, int n, int n2, Matrix matrix, int n3, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            n3 = IMAGE_COMPRESS_RATE;
        }
        return YYImageUtils.resizeAndRotateImage(string2, string3, n, n2, matrix, n3);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean resizeAndRotateImage(@NotNull String imageFile, @NotNull String newFileName, int maxWidth, int maxHeight, @Nullable Matrix matrix) {
        return YYImageUtils.resizeAndRotateImage$default(imageFile, newFileName, maxWidth, maxHeight, matrix, 0, 32, null);
    }

    @JvmStatic
    public static final int calculateInSampleSize(@NotNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            int n = inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
            if (inSampleSize <= 0) {
                inSampleSize = 1;
            }
            float totalPixels = width * height;
            float totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap || YYImageUtils.isBitmapOverSize(inSampleSize, width, height)) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    @JvmStatic
    public static final int getRotate(@NotNull String filepath) {
        Intrinsics.checkParameterIsNotNull((Object)filepath, (String)"filepath");
        try {
            ExifInterface exif = new ExifInterface(filepath);
            return exif.getAttributeInt("Orientation", 1);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @JvmStatic
    public static final int getAngleFromRotateEnum(int rotate) {
        switch (rotate) {
            case 3: {
                return 180;
            }
            case 6: {
                return 90;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap rotateAndResizeImage(@NotNull Bitmap inBitmap, int maxWidth, int maxHeight, int rotate) {
        boolean needRotate;
        Intrinsics.checkParameterIsNotNull((Object)inBitmap, (String)"inBitmap");
        int imgWidth = inBitmap.getWidth();
        int imgHeight = inBitmap.getHeight();
        boolean needResize = imgWidth > maxWidth || imgHeight > maxHeight;
        boolean bl = needRotate = YYImageUtils.getAngleFromRotateEnum(rotate) != 0;
        if (needResize || needRotate) {
            Matrix matrix = new Matrix();
            if (needResize) {
                float scale = Math.min((float)maxWidth / (float)imgWidth, (float)maxHeight / (float)imgHeight);
                matrix.postScale(scale, scale);
            }
            if (needRotate) {
                matrix.postRotate((float)YYImageUtils.getAngleFromRotateEnum(rotate));
            }
            try {
                Bitmap bitmap = Bitmap.createBitmap((Bitmap)inBitmap, (int)0, (int)0, (int)imgWidth, (int)imgHeight, (Matrix)matrix, (boolean)true);
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(inBi\u2026 imgHeight, matrix, true)");
                return bitmap;
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TAG, (String)"Empty Catch on rotateAndResizeImage", (Throwable)e);
            }
        }
        return inBitmap;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeImageFromStream(@NotNull InputStream queryStream, @NotNull InputStream decodeStream) {
        Intrinsics.checkParameterIsNotNull((Object)queryStream, (String)"queryStream");
        Intrinsics.checkParameterIsNotNull((Object)decodeStream, (String)"decodeStream");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)queryStream, null, (BitmapFactory.Options)options);
        if (options.outWidth <= 0 || options.outHeight <= 0) {
            ULog.e(TAG, "bitmap width or height is zero", null, new Object[0]);
            return null;
        }
        options.inJustDecodeBounds = false;
        int widthScale = options.outWidth / IMAGE_SCALE_WIDTH;
        int heightScale = options.outHeight / IMAGE_SCALE_HEIGHT;
        options.inSampleSize = widthScale > heightScale ? widthScale : heightScale;
        options.inScaled = false;
        try {
            return BitmapFactory.decodeStream((InputStream)decodeStream, null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            ULog.e(TAG, "decodeImageFromStream error, OOM", null, new Object[0]);
            return null;
        }
    }

    @JvmStatic
    public static final boolean saveBitmapToFile(@Nullable Bitmap bitmap, @Nullable String filename) throws Exception {
        boolean isSuccess = false;
        if (bitmap != null && filename != null) {
            YYFileUtils out = YYFileUtils.Companion.openFile(filename);
            isSuccess = out.write(bitmap, IMAGE_COMPRESS_RATE);
            out.close();
        }
        return isSuccess;
    }

    @JvmStatic
    public static final boolean isImage(@NotNull InputStream queryStream) {
        Intrinsics.checkParameterIsNotNull((Object)queryStream, (String)"queryStream");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeStream((InputStream)queryStream, null, (BitmapFactory.Options)options);
            return options.outWidth > 0 && options.outHeight > 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @JvmStatic
    public static final boolean isImage(@Nullable File file) {
        boolean bl;
        if (file == null) {
            bl = false;
        } else {
            String string2 = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
            bl = YYImageUtils.isImage(string2);
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isImage(@NotNull String imageFile) {
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        if (FP.empty(imageFile)) {
            return false;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.outHeight = 0;
        options.inJustDecodeBounds = true;
        try {
            BitmapFactory.decodeFile((String)imageFile, (BitmapFactory.Options)options);
            return options.outWidth > 0 && options.outHeight > 0;
        }
        catch (Throwable e) {
            ULog.v(TAG, "%d isn't image file", imageFile);
            return false;
        }
    }

    @JvmStatic
    @NotNull
    public static final Bitmap getRoundedCornerBitmap(@NotNull Bitmap bitmap, float roundPx) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -1;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        Bitmap bitmap2 = output;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"output");
        return bitmap2;
    }

    @JvmStatic
    public static final boolean isNotDefaultPortrait(@NotNull Bitmap image) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        return Intrinsics.areEqual((Object)image, (Object)sDefaultFemalePhotoBitmap) ^ true && Intrinsics.areEqual((Object)image, (Object)sDefaultMalePhotoBitmap) ^ true && Intrinsics.areEqual((Object)image, (Object)sDefaultMalePhotoOffline) ^ true && Intrinsics.areEqual((Object)image, (Object)sDefaultFemalePhotoOffline) ^ true && Intrinsics.areEqual((Object)image, (Object)sDefaultMalePhoto) ^ true && Intrinsics.areEqual((Object)image, (Object)sDefaultMalePhotoOffline) ^ true;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap getGrayBmp(@Nullable Bitmap image) {
        if (image != null) {
            try {
                Bitmap grayscalBitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
                Canvas canvas = new Canvas(grayscalBitmap);
                Paint paint = new Paint();
                ColorMatrix matrix = new ColorMatrix();
                matrix.setSaturation(0.0f);
                ColorMatrixColorFilter filter2 = new ColorMatrixColorFilter(matrix);
                paint.setColorFilter((ColorFilter)filter2);
                canvas.drawBitmap(image, 0.0f, 0.0f, paint);
                return grayscalBitmap;
            }
            catch (Exception e) {
                ULog.e("Utils.getGrayBmp", (Function0<? extends Object>)((Function0)getGrayBmp.1.INSTANCE), e);
            }
            catch (OutOfMemoryError e) {
                ULog.e("Utils.getGrayBmp", (Function0<? extends Object>)((Function0)getGrayBmp.2.INSTANCE), e);
            }
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap createClipBitmap(@Nullable Bitmap bmp, @NotNull Rect photoRect) {
        Bitmap portrait;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)photoRect, (String)"photoRect");
            portrait = null;
            try {
                if (bmp != null) {
                    int bmpWidth = bmp.getWidth();
                    int bmpHeight = bmp.getHeight();
                    if (bmpWidth > 0 && bmpHeight > 0) {
                        photoRect.right = photoRect.right > bmpWidth ? bmpWidth : photoRect.right;
                        photoRect.bottom = photoRect.bottom > bmpHeight ? bmpHeight : photoRect.bottom;
                        portrait = Bitmap.createBitmap((Bitmap)bmp, (int)photoRect.left, (int)photoRect.top, (int)photoRect.width(), (int)photoRect.height());
                        if (Intrinsics.areEqual((Object)bmp, (Object)portrait) ^ true && !bmp.isRecycled()) {
                            bmp.recycle();
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (RuntimeInfo.sIsDebuggable) break block5;
                ULog.d("hjinw", "e = " + e, new Object[0]);
            }
        }
        return portrait;
    }

    @JvmStatic
    public static final boolean renameFile(@NotNull String oriPath, @NotNull String newPath) {
        Intrinsics.checkParameterIsNotNull((Object)oriPath, (String)"oriPath");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        File file = new File(oriPath);
        File newFile = new File(newPath);
        return file.renameTo(newFile);
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeResource(@NotNull Context context, int resId, @NotNull BitmapFactory.Options opt) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)opt, (String)"opt");
        try {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId, (BitmapFactory.Options)opt);
        }
        catch (OutOfMemoryError e) {
            ULog.e("lcy", (Function0<? extends Object>)((Function0)decodeResource.3.INSTANCE), e);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final Bitmap createBlended(@Nullable Bitmap src) {
        if (src == null) {
            throw (Throwable)new IllegalArgumentException("Given src is null.");
        }
        Bitmap target = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c2 = new Canvas(target);
        c2.drawBitmap(src, 0.0f, 0.0f, null);
        c2.drawColor(-1895825408);
        Bitmap bitmap = target;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"target");
        return bitmap;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap resize(@Nullable Bitmap oriBitmap, int targetWidth, int targetHeight) {
        int height;
        float scaleHeight;
        if (oriBitmap == null) {
            return null;
        }
        int width = oriBitmap.getWidth();
        float scaleWidth = (float)targetWidth / (float)width;
        float scale = scaleWidth > (scaleHeight = (float)targetHeight / (float)(height = oriBitmap.getHeight())) ? scaleHeight : scaleWidth;
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        try {
            return Bitmap.createBitmap((Bitmap)oriBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            ULog.e(TAG, "resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Bitmap resize(@Nullable Bitmap oriBitmap, float scale) {
        if (oriBitmap == null) {
            return null;
        }
        int width = oriBitmap.getWidth();
        int height = oriBitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        try {
            Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)oriBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            oriBitmap.recycle();
            return resizedBitmap;
        }
        catch (OutOfMemoryError e) {
            oriBitmap.recycle();
            ULog.e(TAG, "resizeBitmap OOM %s", e, new Object[0]);
            return null;
        }
    }

    @JvmStatic
    public static final int getCameraPhotoOrientation(@NotNull String imagePath) {
        Intrinsics.checkParameterIsNotNull((Object)imagePath, (String)"imagePath");
        int rotate = 0;
        try {
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"printStackTrace", (Throwable)e);
        }
        return rotate;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap fixPictureOrientation(@NotNull String path, boolean replaceSrcFile, @NotNull ImageConfig imageConfig, int quality) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)imageConfig, (String)"imageConfig");
        Bitmap bitmap = YYImageUtils.decodeSampledBitmapFile(path, imageConfig, true);
        if (replaceSrcFile) {
            try {
                String extension = YYFileUtils.Companion.getFileExtension(path);
                Bitmap.CompressFormat format = Bitmap.CompressFormat.JPEG;
                if (extension != null && StringsKt.equals((String)extension, (String)".png", (boolean)true)) {
                    format = Bitmap.CompressFormat.PNG;
                }
                YYFileUtils.Companion.saveBitmap(bitmap, path, format, quality);
            }
            catch (Throwable throwable) {
                ULog.e(TAG, "fixPictureOrientation saveBitmap error! ", throwable, new Object[0]);
            }
        }
        return bitmap;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap decodeSampledBitmapFile(@Nullable String path, @NotNull ImageConfig config, boolean rorate) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        if (path == null || path.length() == 0) {
            ULog.e(TAG, "DecodeSampledBitmapFile path is empty", null, new Object[0]);
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            ULog.e(TAG, "DecodeSampledBitmapFile file not exists", null, new Object[0]);
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = config.getImageTransparency().getBitmapConfig();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        options.inSampleSize = YYImageUtils.calculateInSampleSize(options, config.getImagePrecision().getWidth(), config.getImagePrecision().getHeight());
        options.inJustDecodeBounds = false;
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            ULog.e(TAG, "Decode file oom.", e, new Object[0]);
            System.gc();
        }
        if (rorate) {
            bitmap = YYImageUtils.rorateBitmap(path, bitmap);
        }
        return bitmap;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap rorateBitmap(@NotNull String filePath, @Nullable Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Bitmap resizedBitmap = null;
        try {
            ExifInterface exif = new ExifInterface(filePath);
            int orientation = exif.getAttributeInt("Orientation", 1);
            Matrix matrix = new Matrix();
            int rotate = 0;
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
                case 5: {
                    rotate = 45;
                }
            }
            matrix.postRotate((float)rotate);
            Bitmap bitmap2 = bitmap;
            if (bitmap2 == null) {
                Intrinsics.throwNpe();
            }
            resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        catch (Exception e) {
            ULog.e(TAG, "RotateBitmap error", e, new Object[0]);
            return bitmap;
        }
        return resizedBitmap;
    }

    @JvmStatic
    public static final int getPictureDegree(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (Throwable throwable) {
            ULog.e(TAG, "getPictureDegree error!", throwable, new Object[0]);
        }
        ULog.d(TAG, "getPictureDegree path:" + path + ", degree = " + degree, new Object[0]);
        return degree;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap convertViewToBitmap(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        int w = v.getWidth();
        int h = v.getHeight();
        Bitmap bmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c2 = new Canvas(bmp);
        c2.drawColor(-1);
        v.layout(0, 0, w, h);
        v.draw(c2);
        Bitmap bitmap = bmp;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"bmp");
        return bitmap;
    }

    private YYImageUtils() {
    }

    static {
        YYImageUtils yYImageUtils;
        INSTANCE = yYImageUtils = new YYImageUtils();
        TAG = TAG;
        IMAGE_COMPRESS_RATE = 75;
        IMAGE_SCALE_WIDTH = 800;
        IMAGE_SCALE_HEIGHT = 800;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002\u00a8\u0006\u0003"}, d2={"Ltv/athena/util/image/YYImageUtils$PORTRAIT_OPS;", "", "Companion", "utils_release"})
    public static interface PORTRAIT_OPS {
        public static final Companion Companion = Companion.$$INSTANCE;

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/image/YYImageUtils$PORTRAIT_OPS$Companion;", "", "()V", "BIG", "", "getBIG", "()I", "ORIGINAL", "getORIGINAL", "SMALL", "getSMALL", "utils_release"})
        public static final class Companion {
            private static final int SMALL = 0;
            private static final int BIG = 1;
            private static final int ORIGINAL = 2;
            static final /* synthetic */ Companion $$INSTANCE;

            public final int getSMALL() {
                return SMALL;
            }

            public final int getBIG() {
                return BIG;
            }

            public final int getORIGINAL() {
                return ORIGINAL;
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
                BIG = 1;
                ORIGINAL = 2;
            }
        }
    }
}

