/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.file;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import android.util.Pair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.util.FP;
import tv.athena.util.encode.MD5Utils;
import tv.athena.util.file.BasicFileUtils;
import tv.athena.util.file.YYFileUtils;
import tv.athena.util.log.ULog;
import tv.athena.util.valid.BlankUtil;

@Deprecated(message="old stuff")
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000  2\u00020\u0001:\u0002 !B\u001b\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltv/athena/util/file/YYFileUtils;", "Ltv/athena/util/file/BasicFileUtils;", "file", "Ljava/io/File;", "fileos", "Ljava/io/FileOutputStream;", "(Ljava/io/File;Ljava/io/FileOutputStream;)V", "getFile", "()Ljava/io/File;", "mBufferedOutputStream", "Ljava/io/BufferedOutputStream;", "mFileOutputStream", "close", "", "write", "", "bitmap", "Landroid/graphics/Bitmap;", "compressRate", "", "is", "Ljava/io/InputStream;", "buffer", "", "offset", "length", "fileName", "", "writeYCbCr420SP", "data", "width", "height", "Companion", "IO", "utils_release"})
public final class YYFileUtils
extends BasicFileUtils {
    private FileOutputStream mFileOutputStream;
    private BufferedOutputStream mBufferedOutputStream;
    @Nullable
    private final File file;
    @NotNull
    private static final String TEMP_DIR = "temp";
    private static final String IMAGE_DIR = "/image";
    private static final String ACT_RECOMMAND_FILE = "temp_act_recomm.txt";
    private static final String RECORD_EXT_HIGH_CPU = ".aac";
    private static final String RECORD_EXT_LOW_CPU = ".wav";
    private static final String RECORD_PUBLISH_EXT = ".m4a";
    private static final int MIN_LEN_OF_VALID_WAV = 131072;
    private static final int MIN_LEN_OF_VALID_AAC = 8192;
    @NotNull
    private static final String[] AUDIO_EXTS;
    private static final String BARCODE_FILE_EXT = ".png";
    private static final String YY_BARCODE_DIR = "YYBarcode";
    private static final String TAG = "YYFileUtils";
    private static final int MAX_FILENAME_LENGTH = 24;
    private static final Pattern NOT_ALPHANUMERIC;
    private static final int MAX_BUFF_SIZE = 0x100000;
    private static final int MIN_BUFF_SIZE = 4096;
    public static final Companion Companion;

    @JvmOverloads
    public final boolean write(@NotNull Bitmap bitmap, int compressRate) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return bitmap.compress(Bitmap.CompressFormat.JPEG, compressRate, (OutputStream)this.mBufferedOutputStream);
    }

    public static /* synthetic */ boolean write$default(YYFileUtils yYFileUtils, Bitmap bitmap, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 80;
        }
        return yYFileUtils.write(bitmap, n);
    }

    @JvmOverloads
    public final boolean write(@NotNull Bitmap bitmap) {
        return YYFileUtils.write$default(this, bitmap, 0, 2, null);
    }

    public final void writeYCbCr420SP(@NotNull byte[] data, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        YuvImage image = new YuvImage(data, 17, width, height, null);
        image.compressToJpeg(new Rect(0, 0, width, height - 1), 100, (OutputStream)this.mBufferedOutputStream);
    }

    public final void write(@NotNull InputStream is) {
        Intrinsics.checkParameterIsNotNull((Object)is, (String)"is");
        int bytes = 0;
        byte[] buffer = new byte[4096];
        try {
            while (true) {
                int n = is.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                bytes = it;
                if (n != -1) {
                    BufferedOutputStream bufferedOutputStream = this.mBufferedOutputStream;
                    if (bufferedOutputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    bufferedOutputStream.write(buffer, 0, bytes);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            ULog.e(TAG, "", e, new Object[0]);
        }
    }

    public final void write(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        try {
            FileInputStream fis = new FileInputStream(fileName);
            this.write(fis);
            fis.close();
        }
        catch (Exception e) {
            ULog.e(TAG, "", e, new Object[0]);
        }
    }

    public final void write(@NotNull byte[] buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        try {
            BufferedOutputStream bufferedOutputStream = this.mBufferedOutputStream;
            if (bufferedOutputStream == null) {
                Intrinsics.throwNpe();
            }
            bufferedOutputStream.write(buffer);
        }
        catch (IOException e) {
            ULog.e(TAG, "", e, new Object[0]);
        }
    }

    public final void write(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        try {
            BufferedOutputStream bufferedOutputStream = this.mBufferedOutputStream;
            if (bufferedOutputStream == null) {
                Intrinsics.throwNpe();
            }
            bufferedOutputStream.write(buffer, offset, length);
        }
        catch (IOException e) {
            ULog.e(TAG, "", e, new Object[0]);
        }
    }

    public final void close() {
        try {
            if (this.mBufferedOutputStream != null) {
                BufferedOutputStream bufferedOutputStream = this.mBufferedOutputStream;
                if (bufferedOutputStream == null) {
                    Intrinsics.throwNpe();
                }
                bufferedOutputStream.flush();
                BufferedOutputStream bufferedOutputStream2 = this.mBufferedOutputStream;
                if (bufferedOutputStream2 == null) {
                    Intrinsics.throwNpe();
                }
                bufferedOutputStream2.close();
            }
            if (this.mFileOutputStream != null) {
                FileOutputStream fileOutputStream = this.mFileOutputStream;
                if (fileOutputStream == null) {
                    Intrinsics.throwNpe();
                }
                fileOutputStream.close();
            }
        }
        catch (IOException e) {
            ULog.e(TAG, "", e, new Object[0]);
        }
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    private YYFileUtils(File file, FileOutputStream fileos) throws Exception {
        FileOutputStream fileOutputStream;
        this.file = file;
        this.mFileOutputStream = fileos;
        if (this.file != null) {
            if (this.mFileOutputStream == null) {
                this.mFileOutputStream = new FileOutputStream(this.file);
            }
            fileOutputStream = this.mFileOutputStream;
            if (fileOutputStream == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new Exception("YYFileOutput, can not create file output stream");
        }
        this.mBufferedOutputStream = new BufferedOutputStream(fileOutputStream);
    }

    static {
        Companion = new Companion(null);
        TEMP_DIR = TEMP_DIR;
        IMAGE_DIR = IMAGE_DIR;
        ACT_RECOMMAND_FILE = ACT_RECOMMAND_FILE;
        RECORD_EXT_HIGH_CPU = RECORD_EXT_HIGH_CPU;
        RECORD_EXT_LOW_CPU = RECORD_EXT_LOW_CPU;
        RECORD_PUBLISH_EXT = RECORD_PUBLISH_EXT;
        MIN_LEN_OF_VALID_WAV = 131072;
        MIN_LEN_OF_VALID_AAC = 8192;
        AUDIO_EXTS = new String[]{RECORD_EXT_HIGH_CPU, RECORD_EXT_LOW_CPU, RECORD_PUBLISH_EXT, ".rec", ".mp4", ".rec2"};
        BARCODE_FILE_EXT = BARCODE_FILE_EXT;
        YY_BARCODE_DIR = YY_BARCODE_DIR;
        TAG = TAG;
        MAX_FILENAME_LENGTH = 24;
        NOT_ALPHANUMERIC = Pattern.compile("[^A-Za-z0-9]");
        MAX_BUFF_SIZE = 0x100000;
        MIN_BUFF_SIZE = 4096;
    }

    public /* synthetic */ YYFileUtils(File file, FileOutputStream fileos, DefaultConstructorMarker $constructor_marker) {
        this(file, fileos);
    }

    @JvmStatic
    public static final boolean isValidAudioFile(@NotNull String path) {
        return Companion.isValidAudioFile(path);
    }

    @JvmStatic
    @NotNull
    public static final String getPkgDir(@NotNull Context context) {
        return Companion.getPkgDir(context);
    }

    @JvmStatic
    @NotNull
    public static final String getTxtFileContent(@NotNull Context context, @NotNull String fileName) {
        return Companion.getTxtFileContent(context, fileName);
    }

    @JvmStatic
    @Nullable
    public static final String getFileExtension(@NotNull String filePath) {
        return Companion.getFileExtension(filePath);
    }

    @JvmStatic
    @Nullable
    public static final String getFileName(@Nullable String filePath) {
        return Companion.getFileName(filePath);
    }

    @JvmStatic
    @Nullable
    public static final String dropExt(@NotNull String fname) {
        return Companion.dropExt(fname);
    }

    @JvmStatic
    public static final boolean isFileExisted(@NotNull String filePath) {
        return Companion.isFileExisted(filePath);
    }

    @JvmStatic
    private static final boolean isFolderExists(String strFolder) {
        return YYFileUtils.Companion.isFolderExists(strFolder);
    }

    @JvmStatic
    public static final boolean isFileCanWrite(@NotNull String strFolder) {
        return Companion.isFileCanWrite(strFolder);
    }

    @JvmStatic
    public static final void renameFile(@NotNull String oldFile, @NotNull String newFile) {
        Companion.renameFile(oldFile, newFile);
    }

    @JvmStatic
    public static final void removeFiles(@NotNull List<? extends Pair<Integer, String>> fileNames) {
        Companion.removeFiles(fileNames);
    }

    @JvmStatic
    public static final void removeFile(@NotNull String filename) {
        Companion.removeFile(filename);
    }

    @JvmStatic
    public static final void removeDir(@NotNull String dirPath) {
        Companion.removeDir(dirPath);
    }

    @JvmStatic
    public static final void rm(@NotNull String fname) {
        Companion.rm(fname);
    }

    @JvmStatic
    public static final void rm(@NotNull File f) {
        Companion.rm(f);
    }

    @JvmStatic
    @Nullable
    public static final File getFileFromURL(@NotNull String base, @NotNull String url) {
        return Companion.getFileFromURL(base, url);
    }

    @JvmStatic
    @Nullable
    public static final String getImageFilePathFromUri(@NotNull Context context, @Nullable Uri uri) {
        return Companion.getImageFilePathFromUri(context, uri);
    }

    @JvmStatic
    @Nullable
    public static final String decodeUri(@Nullable String uri) {
        return Companion.decodeUri(uri);
    }

    public static final boolean isSDCardMounted() {
        return Companion.isSDCardMounted();
    }

    @JvmStatic
    public static final boolean externalStorageExist() {
        return Companion.externalStorageExist();
    }

    @JvmStatic
    public static final boolean checkFileValidation(@NotNull String filepath, @NotNull String md5) throws IOException {
        return Companion.checkFileValidation(filepath, md5);
    }

    @JvmStatic
    @NotNull
    public static final File getTempFile(@NotNull Context context, @Nullable String uniqueName) {
        return Companion.getTempFile(context, uniqueName);
    }

    @Deprecated(message="")
    @JvmStatic
    public static final void saveBitmapToJPG(@NotNull Bitmap bitmap, @NotNull String filePath) throws Exception {
        Companion.saveBitmapToJPG(bitmap, filePath);
    }

    @Deprecated(message="")
    @JvmStatic
    public static final void saveBitmap(@NotNull Bitmap bitmap, @NotNull String filePath, @NotNull Bitmap.CompressFormat format) throws Exception {
        Companion.saveBitmap(bitmap, filePath, format);
    }

    @Deprecated(message="\u5df2\u505c\u7528\uff0c\u8bf7\u4f7f\u7528FileRequestManager\u91cc\u7684\u65b9\u6cd5")
    @JvmStatic
    public static final void saveBitmap(@Nullable Bitmap bitmap, @NotNull String filePath, @Nullable Bitmap.CompressFormat format, int quality) throws Exception {
        Companion.saveBitmap(bitmap, filePath, format, quality);
    }

    @JvmStatic
    @NotNull
    public static final String dropPrefix(@NotNull String s, @NotNull String prefix) {
        return Companion.dropPrefix(s, prefix);
    }

    @JvmStatic
    @NotNull
    public static final String concatPath(@NotNull String p1, @NotNull String p2) {
        return Companion.concatPath(p1, p2);
    }

    @JvmStatic
    @NotNull
    public static final String concatPaths(String ... ss) {
        return Companion.concatPaths(ss);
    }

    @JvmStatic
    @NotNull
    public static final String getYYActRecommFilename(@NotNull Context context) {
        return Companion.getYYActRecommFilename(context);
    }

    @JvmStatic
    @Nullable
    public static final String getPropsConfigNotifyFilePath(@NotNull Context context, @NotNull String url) {
        return Companion.getPropsConfigNotifyFilePath(context, url);
    }

    @JvmStatic
    @NotNull
    public static final YYFileUtils createFile(@NotNull String path) throws Exception {
        return Companion.createFile(path);
    }

    @JvmStatic
    @NotNull
    public static final YYFileUtils openFile(@NotNull String filePath) throws Exception {
        return Companion.openFile(filePath);
    }

    @JvmStatic
    public static final boolean ensureFileDirExists(@NotNull String filePath) {
        return Companion.ensureFileDirExists(filePath);
    }

    @JvmStatic
    @Nullable
    public static final String getDirOfFilePath(@NotNull String filePath) {
        return Companion.getDirOfFilePath(filePath);
    }

    @JvmStatic
    public static final long getFileLength(@NotNull String file) {
        return Companion.getFileLength(file);
    }

    @JvmStatic
    @NotNull
    public static final String fallbackFile(@NotNull String file) {
        return Companion.fallbackFile(file);
    }

    @JvmStatic
    public static final boolean isValidRecordFile(@NotNull String filePath) {
        return Companion.isValidRecordFile(filePath);
    }

    @JvmStatic
    public static final long getFileSize(@NotNull File file) throws Exception {
        return Companion.getFileSize(file);
    }

    @JvmStatic
    @NotNull
    public static final String getHumanReadableFileSize(long bytes) {
        return Companion.getHumanReadableFileSize(bytes);
    }

    @JvmStatic
    @NotNull
    public static final String getFileSizeInBytes(long bytes) {
        return Companion.getFileSizeInBytes(bytes);
    }

    @JvmStatic
    @NotNull
    public static final String getFileSizeInKBytes(long bytes) {
        return Companion.getFileSizeInKBytes(bytes);
    }

    @JvmStatic
    @NotNull
    public static final String getFileSizeInMBytes(long bytes) {
        return Companion.getFileSizeInMBytes(bytes);
    }

    @JvmStatic
    public static final void saveBitmapToPublicDir(@Nullable Bitmap bitmap, @NotNull String fileName) {
        Companion.saveBitmapToPublicDir(bitmap, fileName);
    }

    @JvmStatic
    @Nullable
    public static final byte[] fileToByteArray(@NotNull File file) {
        return Companion.fileToByteArray(file);
    }

    @JvmStatic
    @Nullable
    public static final byte[] streamToBytes(@NotNull InputStream inputStream) {
        return Companion.streamToBytes(inputStream);
    }

    @JvmStatic
    public static final void copyFile(@NotNull File src, @NotNull File des) throws IOException {
        Companion.copyFile(src, des);
    }

    @JvmStatic
    public static final boolean copyFile(@NotNull String inFileName, @NotNull String outFileName) {
        return Companion.copyFile(inFileName, outFileName);
    }

    @JvmStatic
    @Nullable
    public static final String getImagePathFromURL(@NotNull String basePath, @NotNull String url) {
        return Companion.getImagePathFromURL(basePath, url);
    }

    @JvmStatic
    public static final void deleteOldFiles(@NotNull String dirPath, @NotNull String postfix, long downloadTime) {
        Companion.deleteOldFiles(dirPath, postfix, downloadTime);
    }

    @JvmStatic
    public static final boolean isSameFile(@Nullable String path1, @Nullable String path2) {
        return Companion.isSameFile(path1, path2);
    }

    @JvmStatic
    public static final boolean isTempFile(@NotNull Context c2, @Nullable String path) {
        return Companion.isTempFile(c2, path);
    }

    @JvmStatic
    @Nullable
    public static final byte[] getBytes(@NotNull String filePath) {
        return Companion.getBytes(filePath);
    }

    @JvmStatic
    public static final void saveToFile(@NotNull byte[] bfile, @NotNull String filePath, @NotNull String fileName) {
        Companion.saveToFile(bfile, filePath, fileName);
    }

    @JvmStatic
    public static final boolean saveToFile(@NotNull String str, @NotNull String path) {
        return Companion.saveToFile(str, path);
    }

    @JvmStatic
    public static final void saveJsonData(@NotNull String jsonString, @NotNull String fileName) {
        Companion.saveJsonData(jsonString, fileName);
    }

    @JvmStatic
    @Nullable
    public static final String readJsonData(@NotNull String fileName) {
        return Companion.readJsonData(fileName);
    }

    @JvmStatic
    @Nullable
    public static final List<File> getSuffixFile(@NotNull String filePath, @NotNull String suffere) {
        return Companion.getSuffixFile(filePath, suffere);
    }

    @JvmStatic
    @Nullable
    public static final List<File> getSuffixFile(@NotNull List<File> files, @NotNull String filePath, @NotNull String suffere) {
        return Companion.getSuffixFile(files, filePath, suffere);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u001f\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\t\"\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u0012"}, d2={"Ltv/athena/util/file/YYFileUtils$IO;", "", "()V", "concat", "", "p1", "p2", "concats", "ps", "", "([Ljava/lang/String;)Ljava/lang/String;", "exist", "", "f", "mkdir", "", "path", "touch", "utils_release"})
    public static final class IO {
        public static final IO INSTANCE;

        public final void mkdir(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            BasicFileUtils.Companion.ensureDirExists(path);
        }

        @NotNull
        public final String concat(@NotNull String p1, @NotNull String p2) {
            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
            return Companion.concatPath(p1, p2);
        }

        @NotNull
        public final String concats(String ... ps) {
            Intrinsics.checkParameterIsNotNull((Object)ps, (String)"ps");
            return Companion.concatPaths(Arrays.copyOf(ps, ps.length));
        }

        public final boolean exist(@NotNull String f) {
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            if (!FP.empty(f)) {
                try {
                    return new File(f).exists();
                }
                catch (Exception e) {
                    Log.e((String)YYFileUtils.TAG, (String)"Empty Catch on exist", (Throwable)e);
                }
            }
            return false;
        }

        public final boolean touch(@NotNull String f) {
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            if (this.exist(f)) {
                return false;
            }
            if (Companion.ensureFileDirExists(f)) {
                try {
                    new File(f).createNewFile();
                }
                catch (Exception e) {
                    Log.e((String)YYFileUtils.TAG, (String)"Empty Catch on touch", (Throwable)e);
                }
            }
            return true;
        }

        private IO() {
        }

        static {
            IO iO;
            INSTANCE = iO = new IO();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0012\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0007J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0007J!\u0010'\u001a\u00020\u00042\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0007J\u0018\u0010*\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H\u0007J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0004H\u0007J\u0014\u00104\u001a\u0004\u0018\u00010\u00042\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0007J \u00106\u001a\u00020+2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020:H\u0007J\u0012\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010<\u001a\u00020\u0004H\u0007J\u0018\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u0004H\u0007J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u0004H\u0007J\b\u0010B\u001a\u00020\u001eH\u0007J\u0010\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u0004H\u0007J\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010D\u001a\u00020-H\u0007J\u0012\u0010G\u001a\u0004\u0018\u00010F2\u0006\u0010A\u001a\u00020\u0004H\u0007J\u0012\u0010H\u001a\u0004\u0018\u00010\u00042\u0006\u0010A\u001a\u00020\u0004H\u0007J\u0012\u0010I\u001a\u0004\u0018\u00010\u00042\u0006\u0010A\u001a\u00020\u0004H\u0007J\u001a\u0010J\u001a\u0004\u0018\u00010-2\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0007J\u0010\u0010M\u001a\u00020:2\u0006\u0010D\u001a\u00020\u0004H\u0007J\u0014\u0010N\u001a\u0004\u0018\u00010\u00042\b\u0010A\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010O\u001a\u00020:2\u0006\u0010D\u001a\u00020-H\u0007J\u0010\u0010P\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020:H\u0007J\u0010\u0010R\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020:H\u0007J\u0010\u0010S\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020:H\u0007J\u0010\u0010T\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020:H\u0007J\u001c\u0010U\u001a\u0004\u0018\u00010\u00042\u0006\u0010V\u001a\u00020W2\b\u00105\u001a\u0004\u0018\u00010XH\u0007J\u001a\u0010Y\u001a\u0004\u0018\u00010\u00042\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0007J\u0010\u0010[\u001a\u00020\u00042\u0006\u0010V\u001a\u00020WH\u0007J\u001a\u0010\\\u001a\u0004\u0018\u00010\u00042\u0006\u0010V\u001a\u00020W2\u0006\u0010L\u001a\u00020\u0004H\u0007J \u0010]\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010^2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004H\u0007J.\u0010]\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010^2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020-0a2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010_\u001a\u00020\u0004H\u0007J\u001a\u0010b\u001a\u00020-2\u0006\u0010V\u001a\u00020W2\b\u0010c\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010d\u001a\u00020\u00042\u0006\u0010V\u001a\u00020W2\u0006\u0010e\u001a\u00020\u0004H\u0007J\u0010\u0010f\u001a\u00020\u00042\u0006\u0010V\u001a\u00020WH\u0007J\u0010\u0010g\u001a\u00020\u001e2\u0006\u0010h\u001a\u00020\u0004H\u0007J\u0010\u0010i\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u0004H\u0007J\u0010\u0010j\u001a\u00020\u001e2\u0006\u0010h\u001a\u00020\u0004H\u0003J\u001c\u0010k\u001a\u00020\u001e2\b\u0010l\u001a\u0004\u0018\u00010\u00042\b\u0010m\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010n\u001a\u00020\u001e2\u0006\u0010o\u001a\u00020W2\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010p\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u0004H\u0007J\u0010\u0010q\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u0004H\u0007J\u0010\u0010r\u001a\u00020\u00042\u0006\u0010s\u001a\u00020tH\u0002J\u0010\u0010u\u001a\u0002022\u0006\u0010A\u001a\u00020\u0004H\u0007J\u0012\u0010v\u001a\u0004\u0018\u00010\u00042\u0006\u0010e\u001a\u00020\u0004H\u0007J\u0010\u0010w\u001a\u00020+2\u0006\u00107\u001a\u00020\u0004H\u0007J\u0010\u0010x\u001a\u00020+2\u0006\u0010y\u001a\u00020\u0004H\u0007J\"\u0010z\u001a\u00020+2\u0018\u0010{\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040|0^H\u0007J\u0018\u0010}\u001a\u00020+2\u0006\u0010~\u001a\u00020\u00042\u0006\u0010\u007f\u001a\u00020\u0004H\u0007J\u0012\u0010\u0080\u0001\u001a\u00020+2\u0007\u0010\u0081\u0001\u001a\u00020-H\u0007J\u0011\u0010\u0080\u0001\u001a\u00020+2\u0006\u0010<\u001a\u00020\u0004H\u0007J%\u0010\u0082\u0001\u001a\u00020+2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010A\u001a\u00020\u00042\b\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0007J2\u0010\u0082\u0001\u001a\u00020+2\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u00012\u0006\u0010A\u001a\u00020\u00042\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020\rH\u0007J\u001b\u0010\u0088\u0001\u001a\u00020+2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010A\u001a\u00020\u0004H\u0007J\u001d\u0010\u0089\u0001\u001a\u00020+2\n\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u00012\u0006\u0010e\u001a\u00020\u0004H\u0007J\u001a\u0010\u008a\u0001\u001a\u00020+2\u0007\u0010\u008b\u0001\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u0004H\u0007J\"\u0010\u008c\u0001\u001a\u00020+2\u0007\u0010\u008d\u0001\u001a\u00020F2\u0006\u0010A\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u0004H\u0007J\u001a\u0010\u008c\u0001\u001a\u00020\u001e2\u0007\u0010\u008e\u0001\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004H\u0007J\u0015\u0010\u008f\u0001\u001a\u0004\u0018\u00010F2\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b\u001d\u0010 \u00a8\u0006\u0092\u0001"}, d2={"Ltv/athena/util/file/YYFileUtils$Companion;", "", "()V", "ACT_RECOMMAND_FILE", "", "AUDIO_EXTS", "", "getAUDIO_EXTS$utils_release", "()[Ljava/lang/String;", "[Ljava/lang/String;", "BARCODE_FILE_EXT", "IMAGE_DIR", "MAX_BUFF_SIZE", "", "MAX_FILENAME_LENGTH", "MIN_BUFF_SIZE", "MIN_LEN_OF_VALID_AAC", "MIN_LEN_OF_VALID_WAV", "NOT_ALPHANUMERIC", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "RECORD_EXT_HIGH_CPU", "RECORD_EXT_LOW_CPU", "RECORD_PUBLISH_EXT", "TAG", "TEMP_DIR", "getTEMP_DIR", "()Ljava/lang/String;", "YY_BARCODE_DIR", "isSDCardMounted", "", "isSDCardMounted$annotations", "()Z", "checkFileValidation", "filepath", "md5", "concatPath", "p1", "p2", "concatPaths", "ss", "([Ljava/lang/String;)Ljava/lang/String;", "copyFile", "", "src", "Ljava/io/File;", "des", "inFileName", "outFileName", "createFile", "Ltv/athena/util/file/YYFileUtils;", "path", "decodeUri", "uri", "deleteOldFiles", "dirPath", "postfix", "downloadTime", "", "dropExt", "fname", "dropPrefix", "s", "prefix", "ensureFileDirExists", "filePath", "externalStorageExist", "fallbackFile", "file", "fileToByteArray", "", "getBytes", "getDirOfFilePath", "getFileExtension", "getFileFromURL", "base", "url", "getFileLength", "getFileName", "getFileSize", "getFileSizeInBytes", "bytes", "getFileSizeInKBytes", "getFileSizeInMBytes", "getHumanReadableFileSize", "getImageFilePathFromUri", "context", "Landroid/content/Context;", "Landroid/net/Uri;", "getImagePathFromURL", "basePath", "getPkgDir", "getPropsConfigNotifyFilePath", "getSuffixFile", "", "suffere", "files", "", "getTempFile", "uniqueName", "getTxtFileContent", "fileName", "getYYActRecommFilename", "isFileCanWrite", "strFolder", "isFileExisted", "isFolderExists", "isSameFile", "path1", "path2", "isTempFile", "c", "isValidAudioFile", "isValidRecordFile", "makeFileName", "contents", "", "openFile", "readJsonData", "removeDir", "removeFile", "filename", "removeFiles", "fileNames", "Landroid/util/Pair;", "renameFile", "oldFile", "newFile", "rm", "f", "saveBitmap", "bitmap", "Landroid/graphics/Bitmap;", "format", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "saveBitmapToJPG", "saveBitmapToPublicDir", "saveJsonData", "jsonString", "saveToFile", "bfile", "str", "streamToBytes", "inputStream", "Ljava/io/InputStream;", "utils_release"})
    public static final class Companion {
        @NotNull
        public final String getTEMP_DIR() {
            return TEMP_DIR;
        }

        @NotNull
        public final String[] getAUDIO_EXTS$utils_release() {
            return AUDIO_EXTS;
        }

        @JvmStatic
        public final boolean isValidAudioFile(@NotNull String path) {
            String ext;
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            if (!BlankUtil.isBlank(path) && !BlankUtil.isBlank(ext = Companion.getFileExtension(path))) {
                for (String extItem : this.getAUDIO_EXTS$utils_release()) {
                    String string2 = ext;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringsKt.equals((String)string2, (String)extItem, (boolean)true)) continue;
                    return true;
                }
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public final String getPkgDir(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            File file = context.getFilesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
            String string2 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.filesDir.absolutePath");
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final String getTxtFileContent(@NotNull Context context, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            String content = "";
            if (BlankUtil.isBlank(fileName)) {
                return content;
            }
            File file = new File(fileName);
            if (file.isFile()) {
                InputStream instream = null;
                try {
                    File file2 = context.getFilesDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"context.filesDir");
                    String string2 = file2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.filesDir.path");
                    instream = StringsKt.startsWith$default((String)fileName, (String)string2, (boolean)false, (int)2, null) ? (InputStream)context.openFileInput(Companion.getFileName(fileName)) : (InputStream)new FileInputStream(file);
                    if (instream != null) {
                        InputStreamReader inputreader = new InputStreamReader(instream);
                        BufferedReader buffreader = new BufferedReader(inputreader);
                        String line = null;
                        StringBuffer contentBuffer = new StringBuffer();
                        while (true) {
                            String string3 = buffreader.readLine();
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string3;
                            boolean bl3 = false;
                            line = it;
                            if (string3 == null) break;
                            contentBuffer.append(line).append("\n");
                        }
                        String string4 = contentBuffer.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"contentBuffer.toString()");
                        content = string4;
                        buffreader.close();
                    }
                }
                catch (Throwable e) {
                    ULog.e(YYFileUtils.TAG, "getTxtFileContent error! ", e, new Object[0]);
                }
                finally {
                    if (instream != null) {
                        try {
                            instream.close();
                        }
                        catch (Exception e) {
                            ULog.e(YYFileUtils.TAG, "Empty Catch on getTxtFileContent", e, new Object[0]);
                        }
                    }
                }
            }
            return content;
        }

        @JvmStatic
        @Nullable
        public final String getFileExtension(@NotNull String filePath) {
            String string2;
            int index;
            String fileName;
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            String string3 = fileName = this.getFileName(filePath);
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            if ((index = StringsKt.lastIndexOf$default((CharSequence)string3, (String)".", (int)0, (boolean)false, (int)6, null)) != -1) {
                String string4 = fileName;
                boolean bl = false;
                String string5 = string4.substring(index);
                string2 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = null;
            }
            return string2;
        }

        @JvmStatic
        @Nullable
        public final String getFileName(@Nullable String filePath) {
            if (filePath != null) {
                String slash = File.separator;
                CharSequence charSequence = filePath;
                String string2 = slash;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"slash");
                int pos = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null) + 1;
                String string3 = filePath;
                boolean bl = false;
                String string4 = string3.substring(pos);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                return string4;
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final String dropExt(@NotNull String fname) {
            int pos;
            Intrinsics.checkParameterIsNotNull((Object)fname, (String)"fname");
            if (!FP.empty(fname) && (pos = StringsKt.lastIndexOf$default((CharSequence)fname, (String)".", (int)0, (boolean)false, (int)6, null)) != -1) {
                return FP.take(pos, fname);
            }
            return fname;
        }

        @JvmStatic
        public final boolean isFileExisted(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            if (BlankUtil.isBlank(filePath)) {
                return false;
            }
            try {
                File file = new File(filePath);
                return file.exists() && file.length() > 0L;
            }
            catch (Exception e) {
                return false;
            }
        }

        @JvmStatic
        private final boolean isFolderExists(String strFolder) {
            File file = new File(strFolder);
            return !file.exists() ? file.mkdirs() : true;
        }

        @JvmStatic
        public final boolean isFileCanWrite(@NotNull String strFolder) {
            Intrinsics.checkParameterIsNotNull((Object)strFolder, (String)"strFolder");
            return !this.isFolderExists(strFolder) ? false : new File(strFolder).canWrite();
        }

        @JvmStatic
        public final void renameFile(@NotNull String oldFile, @NotNull String newFile) {
            Intrinsics.checkParameterIsNotNull((Object)oldFile, (String)"oldFile");
            Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
            try {
                File file = new File(oldFile);
                file.renameTo(new File(newFile));
            }
            catch (Exception e) {
                ULog.e(YYFileUtils.TAG, (Function0<? extends Object>)((Function0)renameFile.1.INSTANCE), e);
            }
        }

        @JvmStatic
        public final void removeFiles(@NotNull List<? extends Pair<Integer, String>> fileNames) {
            Intrinsics.checkParameterIsNotNull(fileNames, (String)"fileNames");
            for (Pair<Integer, String> pair : fileNames) {
                if (pair.second == null) continue;
                Object object = pair.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"p.second");
                this.removeFile((String)object);
            }
        }

        @JvmStatic
        public final void removeFile(@NotNull String filename) {
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            if (!BlankUtil.isBlank(filename)) {
                try {
                    File file = new File(filename);
                    file.delete();
                }
                catch (Exception e) {
                    ULog.e(YYFileUtils.TAG, "Empty Catch on removeFile", e, new Object[0]);
                }
            }
        }

        @JvmStatic
        public final void removeDir(@NotNull String dirPath) {
            File[] fileList;
            Intrinsics.checkParameterIsNotNull((Object)dirPath, (String)"dirPath");
            File dir = new File(dirPath);
            if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
                for (File file : fileList) {
                    file.delete();
                }
            }
            dir.delete();
        }

        @JvmStatic
        public final void rm(@NotNull String fname) {
            Intrinsics.checkParameterIsNotNull((Object)fname, (String)"fname");
            this.rm(new File(fname));
        }

        @JvmStatic
        public final void rm(@NotNull File f) {
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            if (f.exists()) {
                if (f.isDirectory()) {
                    File[] fileArray = FP.ref(f.listFiles());
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File i2;
                        File file = i2 = fileArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"i");
                        this.rm(file);
                    }
                } else {
                    f.delete();
                }
            }
        }

        @JvmStatic
        @Nullable
        public final File getFileFromURL(@NotNull String base, @NotNull String url) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            if (BlankUtil.isBlank(url)) {
                return null;
            }
            int idx = StringsKt.lastIndexOf$default((CharSequence)url, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null);
            String string3 = url;
            int n = idx + 1;
            String string4 = base;
            boolean bl = false;
            String string5 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string2 = string5;
            String string7 = string4;
            return new File(string7, string6);
        }

        @JvmStatic
        @Nullable
        public final String getImageFilePathFromUri(@NotNull Context context, @Nullable Uri uri) {
            ContentResolver cr;
            Cursor cursor;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (uri == null) {
                ULog.d(TAG, "getFilePathFromUri param uri == NULL", new Object[0]);
                return null;
            }
            File file = new File(uri.getPath());
            if (file.isFile()) {
                return file.getPath();
            }
            if (Intrinsics.areEqual((Object)"file", (Object)uri.getScheme())) {
                String string2 = uri.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri.toString()");
                String string3 = string2;
                int n = 7;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                String ret = string5;
                return this.decodeUri(ret);
            }
            if (Intrinsics.areEqual((Object)"content", (Object)uri.getScheme()) && (cursor = (cr = context.getContentResolver()).query(uri, new String[]{"_data"}, null, null, null)) != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_data");
                String ret = cursor.getString(index);
                ULog.v(TAG, "getFilePathFromUri ret = " + ret + ", index = " + index + " , cursor = " + cursor, new Object[0]);
                ret = this.decodeUri(ret);
                cursor.close();
                return ret;
            }
            return null;
        }

        @JvmStatic
        @Nullable
        public final String decodeUri(@Nullable String uri) {
            if (BlankUtil.isBlank(uri)) {
                return uri;
            }
            String string2 = uri;
            return string2 == null || StringsKt.indexOf$default((CharSequence)string2, (char)'%', (int)0, (boolean)false, (int)6, null) != -1 ? Uri.decode((String)uri) : uri;
        }

        @JvmStatic
        public static /* synthetic */ void isSDCardMounted$annotations() {
        }

        public final boolean isSDCardMounted() {
            return BasicFileUtils.Companion.availableMemInSDcard();
        }

        @JvmStatic
        public final boolean externalStorageExist() {
            boolean ret = false;
            ret = StringsKt.equals((String)Environment.getExternalStorageState(), (String)"mounted", (boolean)true);
            return ret;
        }

        @JvmStatic
        public final boolean checkFileValidation(@NotNull String filepath, @NotNull String md5) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)filepath, (String)"filepath");
            Intrinsics.checkParameterIsNotNull((Object)md5, (String)"md5");
            String string2 = MD5Utils.getFileMd5String(filepath);
            if (string2 == null) {
                return false;
            }
            String fileMd5 = string2;
            return Intrinsics.areEqual((Object)fileMd5, (Object)md5);
        }

        @JvmStatic
        @NotNull
        public final File getTempFile(@NotNull Context context, @Nullable String uniqueName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            String tempPath = context.getCacheDir().toString() + File.separator + this.getTEMP_DIR();
            File tmpFile = new File(tempPath);
            if (!tmpFile.exists()) {
                tmpFile.mkdirs();
            }
            return new File(tmpFile.getAbsolutePath() + File.separator + uniqueName);
        }

        @Deprecated(message="")
        @JvmStatic
        public final void saveBitmapToJPG(@NotNull Bitmap bitmap, @NotNull String filePath) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            this.saveBitmap(bitmap, filePath, Bitmap.CompressFormat.JPEG);
        }

        @Deprecated(message="")
        @JvmStatic
        public final void saveBitmap(@NotNull Bitmap bitmap, @NotNull String filePath, @NotNull Bitmap.CompressFormat format) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
            this.saveBitmap(bitmap, filePath, format, 50);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated(message="\u5df2\u505c\u7528\uff0c\u8bf7\u4f7f\u7528FileRequestManager\u91cc\u7684\u65b9\u6cd5")
        @JvmStatic
        public final void saveBitmap(@Nullable Bitmap bitmap, @NotNull String filePath, @Nullable Bitmap.CompressFormat format, int quality) throws Exception {
            File barcodeFile;
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Bitmap.CompressFormat format2 = format;
            if (bitmap == null) {
                return;
            }
            if (format2 == null) {
                format2 = Bitmap.CompressFormat.PNG;
            }
            if (!(barcodeFile = new File(filePath)).exists()) {
                barcodeFile.createNewFile();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(barcodeFile);
                bitmap.compress(format2, quality, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        ULog.e(YYFileUtils.TAG, (Function0<? extends Object>)((Function0)saveBitmap.1.INSTANCE), ioe);
                    }
                }
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (IOException ioe) {
                ULog.e(YYFileUtils.TAG, (Function0<? extends Object>)((Function0)saveBitmap.1.INSTANCE), ioe);
            }
        }

        @JvmStatic
        @NotNull
        public final String dropPrefix(@NotNull String s, @NotNull String prefix) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
            if (StringsKt.startsWith$default((String)s, (String)prefix, (boolean)false, (int)2, null)) {
                String string3 = FP.drop(FP.length(prefix), s);
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FP.drop(FP.length(prefix), s)");
            } else {
                string2 = s;
            }
            return string2;
        }

        @JvmStatic
        @NotNull
        public final String concatPath(@NotNull String p1, @NotNull String p2) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
            String string3 = File.separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.separator");
            if (StringsKt.endsWith$default((String)p1, (String)string3, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append(p1);
                String string4 = File.separator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"File.separator");
                string2 = stringBuilder.append(this.dropPrefix(p2, string4)).toString();
            } else {
                StringBuilder stringBuilder = new StringBuilder().append(p1).append(File.separator);
                String string5 = File.separator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"File.separator");
                string2 = stringBuilder.append(this.dropPrefix(p2, string5)).toString();
            }
            return string2;
        }

        @JvmStatic
        @NotNull
        public final String concatPaths(String ... ss) {
            Intrinsics.checkParameterIsNotNull((Object)ss, (String)"ss");
            String path = "";
            for (String s : ss) {
                path = this.concatPath(path, s);
            }
            return path;
        }

        @JvmStatic
        @NotNull
        public final String getYYActRecommFilename(@NotNull Context context) {
            File file;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            File file2 = file = context.getFileStreamPath(ACT_RECOMMAND_FILE);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            String string2 = file2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
            return string2;
        }

        @JvmStatic
        @Nullable
        public final String getPropsConfigNotifyFilePath(@NotNull Context context, @NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            return null;
        }

        @JvmStatic
        @NotNull
        public final YYFileUtils createFile(@NotNull String path) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            String dir = Companion.getDirOfFilePath(path);
            String name = Companion.getFileName(path);
            String string2 = dir;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = name;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            File f = BasicFileUtils.Companion.createFileOnSD(string2, string3);
            return new YYFileUtils(f, null, null);
        }

        @JvmStatic
        @NotNull
        public final YYFileUtils openFile(@NotNull String filePath) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            String string2 = filePath;
            int n = 0;
            CharSequence charSequence = filePath;
            String string3 = File.separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.separator");
            int n2 = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string3, (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string4 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String dirPath = string4;
            BasicFileUtils.Companion.createDir(dirPath, true);
            File file = new File(filePath);
            if (!file.exists() && !file.createNewFile()) {
                file = null;
            }
            return new YYFileUtils(file, null, null);
        }

        @JvmStatic
        public final boolean ensureFileDirExists(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            String dir = this.getDirOfFilePath(filePath);
            if (BlankUtil.isBlank(dir)) {
                return false;
            }
            String string2 = dir;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            BasicFileUtils.Companion.ensureDirExists(string2);
            return true;
        }

        @JvmStatic
        @Nullable
        public final String getDirOfFilePath(@NotNull String filePath) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            if (BlankUtil.isBlank(filePath)) {
                return null;
            }
            int sepPos = StringsKt.lastIndexOf$default((CharSequence)filePath, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null);
            if (sepPos == -1) {
                string2 = null;
            } else {
                String string3 = filePath;
                int n = 0;
                boolean bl = false;
                String string4 = string3.substring(n, sepPos);
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string2;
        }

        @JvmStatic
        public final long getFileLength(@NotNull String file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            File tmp = new File(file);
            return tmp.length();
        }

        @JvmStatic
        @NotNull
        public final String fallbackFile(@NotNull String file) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            String ext = BasicFileUtils.Companion.getFileExt(file);
            int i = StringsKt.lastIndexOf$default((CharSequence)file, (String)".", (int)0, (boolean)false, (int)6, null);
            if (i == -1) {
                string2 = "";
            } else {
                String string3 = file;
                int n = 0;
                int n2 = i + 1;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = string4;
                string2 = stringBuilder.append(string5).append("bak").append(ext).toString();
            }
            return string2;
        }

        @JvmStatic
        public final boolean isValidRecordFile(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            if (!this.isFileExisted(filePath)) {
                return false;
            }
            String string2 = this.getFileExtension(filePath);
            if (string2 == null) {
                return false;
            }
            String ext = string2;
            boolean aac = false;
            boolean bl = StringsKt.equals((String)ext, (String)RECORD_EXT_HIGH_CPU, (boolean)true);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean it = bl;
            boolean bl4 = false;
            aac = it;
            if (!bl && !StringsKt.equals((String)ext, (String)RECORD_EXT_LOW_CPU, (boolean)true)) {
                return false;
            }
            long len = Companion.getFileLength(filePath);
            long minLen = aac ? MIN_LEN_OF_VALID_AAC : MIN_LEN_OF_VALID_WAV;
            return len >= minLen;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final long getFileSize(@NotNull File file) throws Exception {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            long size = 0L;
            File[] fileList = file.listFiles();
            if (fileList != null) {
                int n = 0;
                int n2 = fileList.length;
                while (n < n2) {
                    void i;
                    File file2 = fileList[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"fileList[i]");
                    if (file2.isDirectory()) {
                        File file3 = fileList[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"fileList[i]");
                        size += this.getFileSize(file3);
                    } else {
                        size += fileList[i].length();
                    }
                    ++i;
                }
            }
            return size;
        }

        @JvmStatic
        @NotNull
        public final String getHumanReadableFileSize(long bytes) {
            if (bytes < (long)1024) {
                return this.getFileSizeInBytes(bytes);
            }
            return bytes >> 20 == 0L ? this.getFileSizeInKBytes(bytes) : this.getFileSizeInMBytes(bytes);
        }

        @JvmStatic
        @NotNull
        public final String getFileSizeInBytes(long bytes) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%dB";
            Object[] objectArray = new Object[]{bytes};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }

        @JvmStatic
        @NotNull
        public final String getFileSizeInKBytes(long bytes) {
            long kbs = bytes >> 10;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%dK";
            Object[] objectArray = new Object[]{kbs};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }

        @JvmStatic
        @NotNull
        public final String getFileSizeInMBytes(long bytes) {
            float kbs = (float)bytes / 1024.0f;
            float mbs = kbs / (float)1024;
            DecimalFormat df = new DecimalFormat("0.00M");
            String string2 = df.format(mbs);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"df.format(mbs.toDouble())");
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @JvmStatic
        public final void saveBitmapToPublicDir(@Nullable Bitmap bitmap, @NotNull String fileName) {
            block14: {
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                if (bitmap == null) {
                    return;
                }
                File barcodesRoot = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES), YY_BARCODE_DIR);
                if (!barcodesRoot.exists() && !barcodesRoot.mkdirs()) {
                    return;
                }
                File barcodeFile = new File(barcodesRoot, this.makeFileName(fileName) + BARCODE_FILE_EXT);
                barcodeFile.delete();
                FileOutputStream fos = null;
                fos = new FileOutputStream(barcodeFile);
                bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fos);
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
                break block14;
                catch (FileNotFoundException fnfe) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return;
                    catch (Throwable throwable) {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }

        private final String makeFileName(CharSequence contents) {
            String fileName = NOT_ALPHANUMERIC.matcher(contents).replaceAll("_");
            if (fileName.length() > MAX_FILENAME_LENGTH) {
                String string2 = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileName");
                String string3 = string2;
                int n = 0;
                int n2 = MAX_FILENAME_LENGTH;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                fileName = string5;
            }
            String string6 = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"fileName");
            return string6;
        }

        @JvmStatic
        @Nullable
        public final byte[] fileToByteArray(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            if (!file.exists() || !file.canRead()) {
                return null;
            }
            try {
                return this.streamToBytes(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final byte[] streamToBytes(@NotNull InputStream inputStream) {
            Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
            byte[] content = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            try {
                byte[] buffer = new byte[1024];
                int length = 0;
                while (true) {
                    int n = bis.read(buffer);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n;
                    boolean bl3 = false;
                    length = it;
                    if (n == -1) break;
                    baos.write(buffer, 0, length);
                }
                content = baos.toByteArray();
                if (content == null) {
                    Intrinsics.throwNpe();
                }
                if (content.length == 0) {
                    content = null;
                }
                baos.close();
                bis.close();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            return content;
        }

        @JvmStatic
        public final void copyFile(@NotNull File src, @NotNull File des) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            Intrinsics.checkParameterIsNotNull((Object)des, (String)"des");
            if (des.exists()) {
                des.delete();
            }
            des.createNewFile();
            FileInputStream in = new FileInputStream(src);
            int length = in.available();
            if (length == 0) {
                length = MIN_BUFF_SIZE;
            } else if (length >= MAX_BUFF_SIZE) {
                length = MAX_BUFF_SIZE;
            }
            FileOutputStream out = new FileOutputStream(des);
            byte[] buffer = new byte[length];
            while (true) {
                int ins;
                if ((ins = in.read(buffer)) == -1) {
                    in.close();
                    out.flush();
                    out.close();
                    return;
                }
                out.write(buffer, 0, ins);
            }
        }

        @JvmStatic
        public final boolean copyFile(@NotNull String inFileName, @NotNull String outFileName) {
            Intrinsics.checkParameterIsNotNull((Object)inFileName, (String)"inFileName");
            Intrinsics.checkParameterIsNotNull((Object)outFileName, (String)"outFileName");
            try {
                this.copyFile(new File(inFileName), new File(outFileName));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @JvmStatic
        @Nullable
        public final String getImagePathFromURL(@NotNull String basePath, @NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            if (BlankUtil.isBlank(url)) {
                return null;
            }
            int idx = StringsKt.lastIndexOf$default((CharSequence)url, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null);
            String string2 = url;
            int n = idx + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String path = string3;
            return basePath + File.separator + path;
        }

        @JvmStatic
        public final void deleteOldFiles(@NotNull String dirPath, @NotNull String postfix, long downloadTime) {
            Intrinsics.checkParameterIsNotNull((Object)dirPath, (String)"dirPath");
            Intrinsics.checkParameterIsNotNull((Object)postfix, (String)"postfix");
            File dir = new File(dirPath);
            if (dir.isDirectory()) {
                FilenameFilter filter2 = new FilenameFilter(postfix){
                    final /* synthetic */ String $postfix;

                    public final boolean accept(File dir, String filename) {
                        String string2 = filename;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"filename");
                        String string3 = string2;
                        boolean bl = false;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                        return StringsKt.indexOf$default((CharSequence)string5, (String)this.$postfix, (int)0, (boolean)false, (int)6, null) != -1;
                    }
                    {
                        this.$postfix = string2;
                    }
                };
                ArrayList portraitList = new ArrayList();
                File[] fileList = dir.listFiles(filter2);
                if (fileList != null && fileList.length > 0) {
                    long current = System.currentTimeMillis();
                    File[] fileArray = fileList;
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File file;
                        File file2 = file = fileArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        if (portraitList.contains(file2.getPath()) || current - file.lastModified() <= downloadTime) continue;
                        file.delete();
                    }
                }
            }
        }

        @JvmStatic
        public final boolean isSameFile(@Nullable String path1, @Nullable String path2) {
            boolean bl;
            if (path1 == null || path2 == null) {
                ULog.e$default(TAG, "lcy input illegal for comparsion " + path1 + ' ' + path2 + '.', null, new Object[0], 4, null);
                bl = false;
            } else {
                bl = Intrinsics.areEqual((Object)new File(path1), (Object)new File(path2));
            }
            return bl;
        }

        @JvmStatic
        public final boolean isTempFile(@NotNull Context c2, @Nullable String path) {
            Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
            File temp = this.getTempFile(c2, this.getFileName(path));
            return path == null ? false : Intrinsics.areEqual((Object)path, (Object)temp.getPath());
        }

        @JvmStatic
        @Nullable
        public final byte[] getBytes(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            byte[] buffer = null;
            try {
                File file = new File(filePath);
                FileInputStream fis = new FileInputStream(file);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
                byte[] b = new byte[1000];
                int n = -1;
                while (true) {
                    int n2 = fis.read(b);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n2;
                    boolean bl3 = false;
                    n = it;
                    if (n2 == -1) break;
                    bos.write(b, 0, n);
                }
                fis.close();
                bos.close();
                buffer = bos.toByteArray();
            }
            catch (Exception e) {
                ULog.e(YYFileUtils.TAG, "getBytes error!", e, new Object[0]);
            }
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @JvmStatic
        public final void saveToFile(@NotNull byte[] bfile, @NotNull String filePath, @NotNull String fileName) {
            block20: {
                Intrinsics.checkParameterIsNotNull((Object)bfile, (String)"bfile");
                Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                bos = null;
                fos = null;
                file = null;
                dir = new File(filePath);
                if (!dir.exists() && dir.isDirectory()) {
                    dir.mkdirs();
                }
                file = new File(filePath + File.separator + fileName);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bos.write(bfile);
                ** try [egrp 1[TRYBLOCK] [0 : 134->143)] { 
lbl-1000:
                // 1 sources

                {
                    bos.close();
                }
lbl21:
                // 1 sources

                catch (Exception e) {
                    ULog.e("YYFileUtils", "saveFile error!", e, new Object[0]);
                }
                try {
                    fos.close();
                }
                catch (Exception e) {
                    ULog.e("YYFileUtils", "saveFile error!", e, new Object[0]);
                }
                break block20;
                catch (Exception e) {
                    ULog.e("YYFileUtils", "saveFile error!", e, new Object[0]);
                    break block20;
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (Exception e) {
                            ULog.e("YYFileUtils", "saveFile error!", e, new Object[0]);
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {
                            ULog.e("YYFileUtils", "saveFile error!", e, new Object[0]);
                        }
                    }
                }
            }
        }

        @JvmStatic
        public final boolean saveToFile(@NotNull String str, @NotNull String path) {
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            String string2 = str;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray2 = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray3 = byArray = byArray2;
            ByteArrayInputStream stream = new ByteArrayInputStream(byArray3);
            try {
                FileOutputStream os = new FileOutputStream(path);
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while (true) {
                    int n = stream.read(buffer, 0, 8192);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int it = n;
                    boolean bl4 = false;
                    bytesRead = it;
                    if (n == -1) break;
                    os.write(buffer, 0, bytesRead);
                }
                os.close();
                stream.close();
            }
            catch (Exception e) {
                ULog.e(TAG, "saveToPath error!", e, new Object[0]);
                return false;
            }
            return true;
        }

        @JvmStatic
        public final void saveJsonData(@NotNull String jsonString, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)jsonString, (String)"jsonString");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            try {
                FileWriter file = new FileWriter(fileName);
                file.write(jsonString);
                file.close();
            }
            catch (IOException e) {
                ULog.e(YYFileUtils.TAG, "printStackTrace", e, new Object[0]);
            }
        }

        @JvmStatic
        @Nullable
        public final String readJsonData(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            try {
                FileInputStream is = new FileInputStream(fileName);
                int size = is.available();
                byte[] buffer = new byte[size];
                is.read(buffer);
                is.close();
                boolean bl = false;
                return new String(buffer, Charsets.UTF_8);
            }
            catch (IOException e) {
                ULog.e(YYFileUtils.TAG, "printStackTrace", e, new Object[0]);
                return null;
            }
        }

        @JvmStatic
        @Nullable
        public final List<File> getSuffixFile(@NotNull String filePath, @NotNull String suffere) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Intrinsics.checkParameterIsNotNull((Object)suffere, (String)"suffere");
            ArrayList files = new ArrayList();
            return this.getSuffixFile(files, filePath, suffere);
        }

        @JvmStatic
        @Nullable
        public final List<File> getSuffixFile(@NotNull List<File> files, @NotNull String filePath, @NotNull String suffere) {
            File[] subFiles;
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            Intrinsics.checkParameterIsNotNull((Object)suffere, (String)"suffere");
            File f = new File(filePath);
            if (!f.exists()) {
                return null;
            }
            File[] fileArray = subFiles = f.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File subFile;
                File file = subFile = fileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"subFile");
                if (file.isFile()) {
                    String string2 = subFile.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"subFile.name");
                    if (StringsKt.endsWith$default((String)string2, (String)suffere, (boolean)false, (int)2, null)) {
                        files.add(subFile);
                        continue;
                    }
                }
                if (!subFile.isDirectory()) continue;
                String string3 = subFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"subFile.absolutePath");
                this.getSuffixFile(files, string3, suffere);
            }
            return files;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

