/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.RequiresPermission;
import android.telephony.TelephonyManager;
import android.util.Log;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.util.FP;
import tv.athena.util.NetworkUtils;
import tv.athena.util.RuntimeInfo;
import tv.athena.util.log.ULog;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0003J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0003J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001aH\u0003J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001aH\u0007J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001aH\u0007J\u0012\u0010$\u001a\u00020#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u0012\u0010%\u001a\u00020#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u0012\u0010&\u001a\u00020#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001aH\u0003J\u0010\u0010)\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0012\u0010*\u001a\u00020(2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ltv/athena/util/NetworkUtils;", "", "()V", "NET_2G", "", "NET_3G", "NET_4G", "NET_INVALID", "NET_NAME_2G", "", "NET_NAME_3G", "NET_NAME_4G", "NET_NAME_UNKNOWN", "NET_NAME_WIFI", "NET_WIFI", "TAG", "UNKNOW_NETWORK_TYPE", "retryJob", "Lkotlinx/coroutines/Job;", "sNetWorkBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "sNetworkInfo", "Landroid/net/NetworkInfo;", "sSimOperator", "getActiveNetwork", "c", "Landroid/content/Context;", "getActiveNetworkFromService", "getActiveNetworkInfo", "context", "getNetworkName", "getNetworkType", "getOperator", "getSimOperator", "isConnected", "", "isNetworkAvailable", "isNetworkStrictlyAvailable", "isWifiActive", "onNetConnectChanged", "", "registerNetWorkReceiver", "updateActiveNetwork", "ChinaOperator", "utils_release"})
public final class NetworkUtils {
    private static final String TAG = "NetworkUtils";
    public static final int NET_INVALID = 0;
    public static final int NET_WIFI = 1;
    public static final int NET_2G = 2;
    public static final int NET_3G = 3;
    public static final int NET_4G = 4;
    public static final int UNKNOW_NETWORK_TYPE = 5;
    @NotNull
    public static final String NET_NAME_WIFI = "wifi";
    @NotNull
    public static final String NET_NAME_2G = "2g";
    @NotNull
    public static final String NET_NAME_3G = "3g";
    @NotNull
    public static final String NET_NAME_4G = "4g";
    @NotNull
    public static final String NET_NAME_UNKNOWN = "unknown";
    private static volatile String sSimOperator;
    private static BroadcastReceiver sNetWorkBroadcastReceiver;
    private static volatile NetworkInfo sNetworkInfo;
    private static Job retryJob;
    public static final NetworkUtils INSTANCE;

    private final void registerNetWorkReceiver(Context context) {
        if (sNetWorkBroadcastReceiver == null) {
            sNetWorkBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                    NetworkUtils.access$onNetConnectChanged(NetworkUtils.INSTANCE, context);
                }
            };
            IntentFilter filter2 = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            context.registerReceiver(sNetWorkBroadcastReceiver, filter2);
        }
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE"})
    private final void onNetConnectChanged(Context context) {
        this.updateActiveNetwork(context);
        Job job = retryJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (this.isNetworkAvailable(context)) {
            ULog.i(TAG, "Network connected changed, updated NetworkInfo", new Object[0]);
        } else {
            retryJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                long J$0;
                int I$0;
                int I$1;
                int I$2;
                int label;
                final /* synthetic */ Context $context;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$launch = this.p$;
                            initialDelay = 5000L;
                            var5_5 = new Ref.LongRef();
                            var5_5.element = initialDelay;
                            var6_6 = 4;
                            var7_7 = false;
                            var8_8 = 0;
                            var8_8 = 0;
                            var9_9 = var6_6;
lbl14:
                            // 2 sources

                            while (var8_8 < var9_9) {
                                it = ((Number)Boxing.boxInt((int)var8_8)).intValue();
                                $i$a$-repeat-NetworkUtils$onNetConnectChanged$1$1 = false;
                                if (!CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) ** GOTO lbl46
                                if (!NetworkUtils.INSTANCE.isNetworkAvailable(this.$context)) ** GOTO lbl21
                                NetworkUtils.access$updateActiveNetwork(NetworkUtils.INSTANCE, this.$context);
                                ** GOTO lbl46
lbl21:
                                // 1 sources

                                if (it < 3) {
                                    ULog.i("NetworkUtils", "retry after " + currentDelay.element + " ms", new Object[0]);
                                }
                                this.L$0 = $this$launch;
                                this.J$0 = initialDelay;
                                this.L$1 = currentDelay;
                                this.I$0 = var8_8;
                                this.I$1 = var9_9;
                                this.I$2 = it;
                                this.label = 1;
                                v0 = DelayKt.delay((long)currentDelay.element, (Continuation)this);
                                if (v0 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl44
                            }
                            break;
                        }
                        case 1: {
                            it = this.I$2;
                            var9_9 = this.I$1;
                            var8_8 = this.I$0;
                            currentDelay = (Ref.LongRef)this.L$1;
                            initialDelay = this.J$0;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl44:
                            // 2 sources

                            currentDelay.element = RangesKt.coerceAtMost((long)(currentDelay.element * (long)(it + 1) + initialDelay), (long)15000L);
lbl46:
                            // 3 sources

                            ++var8_8;
                            ** GOTO lbl14
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$context = context;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @JvmStatic
    public static final boolean isConnected(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        NetworkInfo info = INSTANCE.getActiveNetworkInfo(context);
        return info != null && info.isConnected();
    }

    @SuppressLint(value={"MissingPermission"})
    private final NetworkInfo getActiveNetworkInfo(Context context) {
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm = (ConnectivityManager)object;
        return cm.getActiveNetworkInfo();
    }

    @JvmStatic
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static final boolean isWifiActive(@Nullable Context c2) {
        if (c2 == null) {
            ULog.e("xuwakao", "isWifiActive is NULL", null, new Object[0]);
            return false;
        }
        NetworkInfo networkInfo = INSTANCE.getActiveNetwork(c2);
        return networkInfo != null && networkInfo.getType() == 1;
    }

    @JvmStatic
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static final boolean isNetworkStrictlyAvailable(@Nullable Context c2) {
        try {
            if (c2 == null) {
                ULog.e("xuwakao", "isNetworkStrictlyAvailable context is NULL", null, new Object[0]);
                return false;
            }
            NetworkInfo ni = INSTANCE.getActiveNetwork(c2);
            if (ni != null && ni.isAvailable() && ni.isConnected()) {
                return true;
            }
            String info = null;
            info = ni != null ? "network type = " + ni.getType() + ", " + (ni.isAvailable() ? "available" : "inavailable") + ", " + (ni.isConnected() ? "" : "not") + " connected" + ", " + (ni.isConnectedOrConnecting() ? "" : "not") + " isConnectedOrConnecting" : "no active network";
            ULog.e(TAG, "isNetworkStrictlyAvailable network info" + info, null, new Object[0]);
            return false;
        }
        catch (Throwable throwable) {
            ULog.e(TAG, (Function0<? extends Object>)((Function0)isNetworkStrictlyAvailable.1.INSTANCE), throwable);
            return false;
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public final boolean isNetworkAvailable(@Nullable Context c2) {
        if (c2 == null) {
            return false;
        }
        NetworkInfo ni = this.getActiveNetwork(c2);
        if (ni != null && (ni.isConnected() || ni.isAvailable() && ni.isConnectedOrConnecting())) {
            return true;
        }
        String info = null;
        info = ni != null ? "network type = " + ni.getType() + ", " + (ni.isAvailable() ? "available" : "inavailable") + ", " + (ni.isConnected() ? "" : "not") + " connected" + ", " + (ni.isConnectedOrConnecting() ? "" : "not") + " isConnectedOrConnecting" : "no active network";
        ULog.e(TAG, "isNetworkAvailable network info" + info, null, new Object[0]);
        return false;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private final NetworkInfo getActiveNetworkFromService(Context c2) {
        try {
            if (c2 != null) {
                Object object = c2.getApplicationContext().getSystemService("connectivity");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
                }
                ConnectivityManager cm = (ConnectivityManager)object;
                return cm.getActiveNetworkInfo();
            }
        }
        catch (Throwable e) {
            ULog.e(TAG, "error on getActiveNetworkInfo ", e, new Object[0]);
        }
        return null;
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private final NetworkInfo getActiveNetwork(Context c2) {
        if (sNetworkInfo == null) {
            sNetworkInfo = this.getActiveNetworkFromService(c2);
        } else {
            NetworkInfo networkInfo = sNetworkInfo;
            if (networkInfo == null) {
                Intrinsics.throwNpe();
            }
            if (networkInfo.isAvailable()) {
                NetworkInfo networkInfo2 = sNetworkInfo;
                if (networkInfo2 == null) {
                    Intrinsics.throwNpe();
                }
                if (networkInfo2.isConnectedOrConnecting()) {
                    return sNetworkInfo;
                }
            }
            sNetworkInfo = this.getActiveNetworkFromService(c2);
        }
        return sNetworkInfo;
    }

    @JvmStatic
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @NotNull
    public static final String getNetworkName(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String networkName = NET_NAME_UNKNOWN;
        switch (NetworkUtils.getNetworkType(context)) {
            case 1: {
                networkName = NET_NAME_WIFI;
                break;
            }
            case 2: {
                networkName = NET_NAME_2G;
                break;
            }
            case 3: {
                networkName = NET_NAME_3G;
                break;
            }
            case 4: {
                networkName = NET_NAME_4G;
                break;
            }
            case 5: {
                networkName = NET_NAME_UNKNOWN;
            }
        }
        return networkName;
    }

    @JvmStatic
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static final int getNetworkType(@NotNull Context c2) {
        Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
        int networkType = 5;
        NetworkInfo netInfo = INSTANCE.getActiveNetwork(c2);
        if (netInfo != null) {
            int type = netInfo.getType();
            if (type == 1 || type == 6) {
                networkType = 1;
            } else if (type == 0) {
                int subType = netInfo.getSubtype();
                if (subType == 7 || subType == 3 || subType == 14 || subType == 5 || subType == 6 || subType == 12 || subType == 8 || subType == 10 || subType == 15 || subType == 9) {
                    networkType = 3;
                } else if (subType == 1 || subType == 4 || subType == 2 || subType == 11) {
                    networkType = 2;
                } else if (subType == 13) {
                    networkType = 4;
                }
            }
        }
        return networkType;
    }

    private final String getSimOperator(Context c2) {
        try {
            Object object = c2.getSystemService("phone");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            TelephonyManager tm = (TelephonyManager)object;
            String string = tm.getSimOperator();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tm.simOperator");
            return string;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("getSimOperator error = " + ex));
            return "";
        }
    }

    @JvmStatic
    @NotNull
    public static final String getOperator(@NotNull Context c2) {
        String sim;
        Intrinsics.checkParameterIsNotNull((Object)c2, (String)"c");
        if (sSimOperator == null || Intrinsics.areEqual((Object)sSimOperator, (Object)"")) {
            sSimOperator = INSTANCE.getSimOperator(c2);
        }
        if (FP.empty(sim = sSimOperator)) {
            return ChinaOperator.INSTANCE.getUNKNOWN();
        }
        String string = sim;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return StringsKt.startsWith$default((String)string, (String)"46003", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sim, (String)"46005", (boolean)false, (int)2, null) ? ChinaOperator.INSTANCE.getCTL() : (StringsKt.startsWith$default((String)sim, (String)"46001", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sim, (String)"46006", (boolean)false, (int)2, null) ? ChinaOperator.INSTANCE.getUNICOM() : (StringsKt.startsWith$default((String)sim, (String)"46000", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sim, (String)"46002", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sim, (String)"46007", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sim, (String)"46020", (boolean)false, (int)2, null) ? ChinaOperator.INSTANCE.getCMCC() : ChinaOperator.INSTANCE.getUNKNOWN()));
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private final void updateActiveNetwork(Context context) {
        if (context == null) {
            return;
        }
        sNetworkInfo = this.getActiveNetworkFromService(context);
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
        Context context = RuntimeInfo.getSAppContext();
        boolean bl = false;
        boolean bl2 = false;
        Context it = context;
        boolean bl3 = false;
        INSTANCE.registerNetWorkReceiver(it);
    }

    public static final /* synthetic */ void access$onNetConnectChanged(NetworkUtils $this, Context context) {
        $this.onNetConnectChanged(context);
    }

    public static final /* synthetic */ void access$updateActiveNetwork(NetworkUtils $this, Context context) {
        $this.updateActiveNetwork(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Ltv/athena/util/NetworkUtils$ChinaOperator;", "", "()V", "CMCC", "", "getCMCC", "()Ljava/lang/String;", "CTL", "getCTL", "UNICOM", "getUNICOM", "UNKNOWN", "getUNKNOWN", "utils_release"})
    public static final class ChinaOperator {
        @NotNull
        private static final String CMCC = "CMCC";
        @NotNull
        private static final String CTL = "CTL";
        @NotNull
        private static final String UNICOM = "UNICOM";
        @NotNull
        private static final String UNKNOWN = "Unknown";
        public static final ChinaOperator INSTANCE;

        @NotNull
        public final String getCMCC() {
            return CMCC;
        }

        @NotNull
        public final String getCTL() {
            return CTL;
        }

        @NotNull
        public final String getUNICOM() {
            return UNICOM;
        }

        @NotNull
        public final String getUNKNOWN() {
            return UNKNOWN;
        }

        private ChinaOperator() {
        }

        static {
            ChinaOperator chinaOperator;
            INSTANCE = chinaOperator = new ChinaOperator();
            CMCC = CMCC;
            CTL = CTL;
            UNICOM = UNICOM;
            UNKNOWN = UNKNOWN;
        }
    }
}

