/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.RuntimeInfo;
import tv.athena.util.common.ShellUtils;
import tv.athena.util.log.ULog;
import tv.athena.util.pref.CommonPref;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\b\u0010 \u001a\u00020\u0004H\u0007J!\u0010 \u001a\u00020\u00042\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\"\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0004H\u0002J\b\u0010%\u001a\u00020\u0004H\u0002J\b\u0010&\u001a\u00020\u0004H\u0002J\b\u0010'\u001a\u00020\u0004H\u0003J\u0006\u0010(\u001a\u00020\u0004J\u0006\u0010)\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020\u0004J\b\u0010-\u001a\u00020.H\u0007J)\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00042\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\"\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u00020.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\b\u00a8\u00063"}, d2={"Ltv/athena/util/DeviceUtils;", "", "()V", "TAG", "", "deviceBrand", "deviceBrand$annotations", "getDeviceBrand", "()Ljava/lang/String;", "deviceSerial", "deviceSerial$annotations", "getDeviceSerial", "localeStringForWeb", "localeStringForWeb$annotations", "getLocaleStringForWeb", "systemCountry", "systemCountry$annotations", "getSystemCountry", "systemLanguage", "systemLanguage$annotations", "getSystemLanguage", "systemModel", "systemModel$annotations", "getSystemModel", "systemVersion", "systemVersion$annotations", "getSystemVersion", "getAndroidID", "ctx", "Landroid/content/Context;", "getInetAddress", "Ljava/net/InetAddress;", "getMacAddress", "excepts", "", "([Ljava/lang/String;)Ljava/lang/String;", "getMacAddressByFile", "getMacAddressByInetAddress", "getMacAddressByNetworkInterface", "getMacAddressByWifiInfo", "getManufacturer", "getModel", "getSDKVersionCode", "", "getSDKVersionName", "isAdbEnabled", "", "isAddressNotInExcepts", "address", "(Ljava/lang/String;[Ljava/lang/String;)Z", "isDeviceRooted", "utils_release"})
public final class DeviceUtils {
    private static final String TAG = "DeviceUtils";
    public static final DeviceUtils INSTANCE;

    @JvmStatic
    public static /* synthetic */ void systemCountry$annotations() {
    }

    @NotNull
    public static final String getSystemCountry() {
        String country = "";
        CommonPref commonPref = CommonPref.Companion.instance();
        String choice = commonPref != null ? commonPref.getString("COUNTRY_CHOSE") : null;
        CharSequence charSequence = choice;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0) && !TextUtils.equals((CharSequence)"SYSTEM", (CharSequence)choice)) {
            String string = choice;
            if (string == null) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
                String string2 = locale.getCountry();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().country");
            }
            country = string;
        } else {
            Locale locale = Locale.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
            String string = locale.getCountry();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Locale.getDefault().country");
            country = string;
        }
        ULog.i(TAG, "getSystemCountry country=" + country, new Object[0]);
        return country;
    }

    @JvmStatic
    public static /* synthetic */ void systemLanguage$annotations() {
    }

    @NotNull
    public static final String getSystemLanguage() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        String string = locale.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Locale.getDefault().language");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void systemVersion$annotations() {
    }

    @NotNull
    public static final String getSystemVersion() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.VERSION.RELEASE");
        return string;
    }

    @JvmStatic
    @Deprecated(message="Old stuff", replaceWith=@ReplaceWith(imports={}, expression="getModel()"))
    public static /* synthetic */ void systemModel$annotations() {
    }

    @NotNull
    public static final String getSystemModel() {
        String string = Build.MODEL;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.MODEL");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void deviceBrand$annotations() {
    }

    @NotNull
    public static final String getDeviceBrand() {
        String string = Build.BRAND;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.BRAND");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void deviceSerial$annotations() {
    }

    @NotNull
    public static final String getDeviceSerial() {
        String string = Build.SERIAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.SERIAL");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void localeStringForWeb$annotations() {
    }

    @NotNull
    public static final String getLocaleStringForWeb() {
        List list;
        String string;
        if (TextUtils.isEmpty((CharSequence)Locale.getDefault().toString())) {
            string = "";
        } else {
            String string2 = Locale.getDefault().toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().toString()");
        }
        String s = string;
        CharSequence charSequence = s;
        String string3 = "_";
        int n = 0;
        string3 = new Regex(string3);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string3.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] groups = stringArray;
        if (groups.length > 2) {
            s = groups[0] + "_" + groups[1];
        }
        charSequence = s;
        String string4 = "_";
        boolean bl4 = false;
        string4 = new Regex(string4);
        String string5 = "-";
        boolean bl5 = false;
        s = string4.replace(charSequence, string5);
        return s;
    }

    @JvmStatic
    @Deprecated(message="Old stuff", replaceWith=@ReplaceWith(imports={}, expression="getAndroidID()"))
    @NotNull
    public static final String getAndroidID(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        try {
            ContentResolver cr = ctx.getContentResolver();
            String string = Settings.System.getString((ContentResolver)cr, (String)"android_id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Settings.System.getStrin\u2026ttings.Secure.ANDROID_ID)");
            return string;
        }
        catch (Throwable e) {
            return "";
        }
    }

    public final boolean isDeviceRooted() {
        String[] locations;
        String su = "su";
        for (String location : locations = new String[]{"/system/bin/", "/system/xbin/", "/sbin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/xbin/", "/data/local/bin/", "/data/local/"}) {
            if (!new File(location + su).exists()) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(api=17)
    public final boolean isAdbEnabled() {
        return Settings.Secure.getInt((ContentResolver)RuntimeInfo.getSAppContext().getContentResolver(), (String)"adb_enabled", (int)0) > 0;
    }

    @NotNull
    public final String getSDKVersionName() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"android.os.Build.VERSION.RELEASE");
        return string;
    }

    public final int getSDKVersionCode() {
        return Build.VERSION.SDK_INT;
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final String getAndroidID() {
        String id2 = Settings.Secure.getString((ContentResolver)RuntimeInfo.getSAppContext().getContentResolver(), (String)"android_id");
        String string = id2;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    @NotNull
    public final String getMacAddress() {
        return this.getMacAddress("");
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.INTERNET"})
    @NotNull
    public final String getMacAddress(String ... excepts) {
        Intrinsics.checkParameterIsNotNull((Object)excepts, (String)"excepts");
        String macAddress = this.getMacAddressByWifiInfo();
        if (this.isAddressNotInExcepts(macAddress, Arrays.copyOf(excepts, excepts.length))) {
            return macAddress;
        }
        macAddress = this.getMacAddressByNetworkInterface();
        if (this.isAddressNotInExcepts(macAddress, Arrays.copyOf(excepts, excepts.length))) {
            return macAddress;
        }
        macAddress = this.getMacAddressByInetAddress();
        if (this.isAddressNotInExcepts(macAddress, Arrays.copyOf(excepts, excepts.length))) {
            return macAddress;
        }
        macAddress = this.getMacAddressByFile();
        return this.isAddressNotInExcepts(macAddress, Arrays.copyOf(excepts, excepts.length)) ? macAddress : "";
    }

    private final boolean isAddressNotInExcepts(String address, String ... excepts) {
        String[] stringArray = excepts;
        int n = 0;
        if (stringArray.length == 0) {
            return Intrinsics.areEqual((Object)"02:00:00:00:00:00", (Object)address) ^ true;
        }
        for (String filter2 : excepts) {
            if (!Intrinsics.areEqual((Object)address, (Object)filter2)) continue;
            return false;
        }
        return true;
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission", "WifiManagerLeak"})
    private final String getMacAddressByWifiInfo() {
        try {
            Object wifi;
            Object object = wifi = RuntimeInfo.getSAppContext().getSystemService("wifi");
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                Object object3 = it;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
                }
                WifiInfo wifiInfo = ((WifiManager)object3).getConnectionInfo();
                if (wifiInfo != null) {
                    WifiInfo wifiInfo2 = wifiInfo;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    WifiInfo it2 = wifiInfo2;
                    boolean bl6 = false;
                    String string = it2.getMacAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.macAddress");
                    return string;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private final String getMacAddressByNetworkInterface() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                byte[] macBytes;
                NetworkInterface ni = nis.nextElement();
                if (ni == null || !StringsKt.equals((String)ni.getName(), (String)"wlan0", (boolean)true) || (macBytes = ni.getHardwareAddress()) == null || macBytes.length <= 0) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    String string;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "%02x:";
                    Object[] objectArray = new Object[]{b};
                    StringBuilder stringBuilder = sb;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    stringBuilder.append(string);
                }
                String string = sb.substring(0, sb.length() - 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.substring(0, sb.length - 1)");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private final String getMacAddressByInetAddress() {
        try {
            byte[] macBytes;
            NetworkInterface ni;
            InetAddress inetAddress = this.getInetAddress();
            if (inetAddress != null && (ni = NetworkInterface.getByInetAddress(inetAddress)) != null && (macBytes = ni.getHardwareAddress()) != null && macBytes.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    String string;
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "%02x:";
                    Object[] objectArray = new Object[]{b};
                    StringBuilder stringBuilder = sb;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                    stringBuilder.append(string);
                }
                String string = sb.substring(0, sb.length() - 1);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.substring(0, sb.length - 1)");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "02:00:00:00:00:00";
    }

    private final InetAddress getInetAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni;
                NetworkInterface networkInterface = ni = nis.nextElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)networkInterface, (String)"ni");
                if (!networkInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String hostAddress;
                    InetAddress inetAddress;
                    InetAddress inetAddress2 = inetAddress = addresses.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"inetAddress");
                    if (inetAddress2.isLoopbackAddress()) continue;
                    String string = hostAddress = inetAddress.getHostAddress();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hostAddress");
                    if (StringsKt.indexOf$default((CharSequence)string, (char)':', (int)0, (boolean)false, (int)6, null) >= 0) continue;
                    return inetAddress;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    private final String getMacAddressByFile() {
        String name;
        ShellUtils.CommandResult result = ShellUtils.execCmd("getprop wifi.interface", false);
        if (result.result == 0 && (name = result.successMsg) != null) {
            result = ShellUtils.execCmd("cat /sys/class/net/" + name + "/address", false);
            if (result.result == 0) {
                String address;
                String string = address = result.successMsg;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"address");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    return address;
                }
            }
        }
        return "02:00:00:00:00:00";
    }

    @NotNull
    public final String getManufacturer() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Build.MANUFACTURER");
        return string;
    }

    @NotNull
    public final String getModel() {
        String model = Build.MODEL;
        if (model != null) {
            String $this$trim$iv = model;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string = "\\s*";
            boolean bl = false;
            string = new Regex(string);
            String string2 = "";
            boolean bl3 = false;
            model = string.replace(charSequence, string2);
        } else {
            model = "";
        }
        return model;
    }

    private DeviceUtils() {
    }

    static {
        DeviceUtils deviceUtils;
        INSTANCE = deviceUtils = new DeviceUtils();
    }
}

