/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.image;

import android.graphics.Bitmap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.ResolutionUtils;
import tv.athena.util.RuntimeInfo;
import tv.athena.util.log.ULog;

@Deprecated(message="old stuff")
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Ltv/athena/util/image/ImageConfig;", "", "imagePrecision", "Ltv/athena/util/image/ImageConfig$ImagePrecision;", "imageTransparency", "Ltv/athena/util/image/ImageConfig$ImageTransparency;", "(Ltv/athena/util/image/ImageConfig$ImagePrecision;Ltv/athena/util/image/ImageConfig$ImageTransparency;)V", "imageWidth", "", "imageHeight", "(II)V", "<set-?>", "getImagePrecision", "()Ltv/athena/util/image/ImageConfig$ImagePrecision;", "setImagePrecision", "(Ltv/athena/util/image/ImageConfig$ImagePrecision;)V", "getImageTransparency", "()Ltv/athena/util/image/ImageConfig$ImageTransparency;", "setImageTransparency", "(Ltv/athena/util/image/ImageConfig$ImageTransparency;)V", "Companion", "ImagePrecision", "ImageTransparency", "utils_release"})
public final class ImageConfig {
    @NotNull
    private ImagePrecision imagePrecision;
    @NotNull
    private ImageTransparency imageTransparency;
    private static ImageConfig mDefaultImageConfig;
    private static ImageConfig mBigImageConfig;
    private static ImageConfig mSmallImageConfig;
    private static ImageConfig mFullImageConfig;
    private static ImageConfig mDefaultARGBImageConfig;
    private static ImageConfig mBigARGBImageConfig;
    private static ImageConfig mSmallARGBImageConfig;
    private static ImageConfig mFullARGBImageConfig;
    public static final Companion Companion;

    @NotNull
    public final ImagePrecision getImagePrecision() {
        return this.imagePrecision;
    }

    private final void setImagePrecision(ImagePrecision imagePrecision) {
        this.imagePrecision = imagePrecision;
    }

    @NotNull
    public final ImageTransparency getImageTransparency() {
        return this.imageTransparency;
    }

    private final void setImageTransparency(ImageTransparency imageTransparency) {
        this.imageTransparency = imageTransparency;
    }

    public ImageConfig(@NotNull ImagePrecision imagePrecision, @NotNull ImageTransparency imageTransparency) {
        Intrinsics.checkParameterIsNotNull((Object)imagePrecision, (String)"imagePrecision");
        Intrinsics.checkParameterIsNotNull((Object)imageTransparency, (String)"imageTransparency");
        this.imagePrecision = ImagePrecision.Middle;
        this.imageTransparency = ImageTransparency.RGB_565;
        this.imagePrecision = imagePrecision;
        this.imageTransparency = imageTransparency;
    }

    public ImageConfig(int imageWidth, int imageHeight) {
        this.imagePrecision = ImagePrecision.Middle;
        this.imageTransparency = ImageTransparency.RGB_565;
        this.imagePrecision = new ImagePrecision(imageWidth, imageHeight);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0007\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Ltv/athena/util/image/ImageConfig$ImagePrecision;", "", "presisionRatio", "", "(F)V", "width", "", "height", "(II)V", "getHeight", "()I", "mHeight", "mPresisionRatio", "mWidth", "getWidth", "Companion", "utils_release"})
    public static final class ImagePrecision {
        private final float mPresisionRatio;
        private int mWidth;
        private int mHeight;
        @JvmField
        @NotNull
        public static final ImagePrecision Full;
        @JvmField
        @NotNull
        public static final ImagePrecision Big;
        @JvmField
        @NotNull
        public static final ImagePrecision Middle;
        @JvmField
        @NotNull
        public static final ImagePrecision Small;
        public static final Companion Companion;

        public final int getWidth() {
            if (this.mWidth > 0) {
                return this.mWidth;
            }
            try {
                this.mWidth = ResolutionUtils.getScreenWidth(RuntimeInfo.getSAppContext());
                this.mWidth = (int)((float)this.mWidth * this.mPresisionRatio);
                ULog.i("ImageConfig", "Screen width %d" + this.mWidth, new Object[0]);
            }
            catch (Exception e) {
                this.mWidth = 300;
                ULog.i("ImageConfig", "Screen width error, use default", new Object[0]);
            }
            return this.mWidth;
        }

        public final int getHeight() {
            if (this.mHeight > 0) {
                return this.mHeight;
            }
            try {
                this.mHeight = ResolutionUtils.getScreenHeight(RuntimeInfo.getSAppContext());
                ULog.i("ImageConfig", "Screen height %d" + this.mHeight, new Object[0]);
                this.mHeight = (int)((float)this.mHeight * this.mPresisionRatio);
            }
            catch (Exception e) {
                this.mHeight = 300;
                ULog.i("ImageConfig", "Screen height error, use default", new Object[0]);
            }
            return this.mHeight;
        }

        public ImagePrecision(float presisionRatio) {
            this.mPresisionRatio = presisionRatio;
        }

        public ImagePrecision(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            this.mPresisionRatio = 0.1f;
        }

        static {
            Companion = new Companion(null);
            Full = new ImagePrecision(1.0f);
            Big = new ImagePrecision(0.5f);
            Middle = new ImagePrecision(0.3f);
            Small = new ImagePrecision(0.1f);
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ltv/athena/util/image/ImageConfig$ImagePrecision$Companion;", "", "()V", "Big", "Ltv/athena/util/image/ImageConfig$ImagePrecision;", "Full", "Middle", "Small", "utils_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Ltv/athena/util/image/ImageConfig$ImageTransparency;", "", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "(Landroid/graphics/Bitmap$Config;)V", "getBitmapConfig", "()Landroid/graphics/Bitmap$Config;", "Companion", "utils_release"})
    public static final class ImageTransparency {
        @NotNull
        private final Bitmap.Config bitmapConfig;
        @JvmField
        @NotNull
        public static final ImageTransparency RGB_565;
        @JvmField
        @NotNull
        public static final ImageTransparency ARGB_8888;
        public static final Companion Companion;

        @NotNull
        public final Bitmap.Config getBitmapConfig() {
            return this.bitmapConfig;
        }

        public ImageTransparency(@NotNull Bitmap.Config bitmapConfig) {
            Intrinsics.checkParameterIsNotNull((Object)bitmapConfig, (String)"bitmapConfig");
            this.bitmapConfig = bitmapConfig;
        }

        static {
            Companion = new Companion(null);
            RGB_565 = new ImageTransparency(Bitmap.Config.RGB_565);
            ARGB_8888 = new ImageTransparency(Bitmap.Config.ARGB_8888);
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltv/athena/util/image/ImageConfig$ImageTransparency$Companion;", "", "()V", "ARGB_8888", "Ltv/athena/util/image/ImageConfig$ImageTransparency;", "RGB_565", "utils_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltv/athena/util/image/ImageConfig$Companion;", "", "()V", "mBigARGBImageConfig", "Ltv/athena/util/image/ImageConfig;", "mBigImageConfig", "mDefaultARGBImageConfig", "mDefaultImageConfig", "mFullARGBImageConfig", "mFullImageConfig", "mSmallARGBImageConfig", "mSmallImageConfig", "bigARGBImageConfig", "bigImageConfig", "defaultARGBImageConfig", "defaultImageConfig", "fullARGBImageConfig", "fullImageConfig", "smallARGBImageConfig", "smallImageConfig", "utils_release"})
    public static final class Companion {
        @NotNull
        public final synchronized ImageConfig defaultImageConfig() {
            ImageConfig imageConfig = mDefaultImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Middle, ImageTransparency.RGB_565);
                mDefaultImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        @NotNull
        public final synchronized ImageConfig bigImageConfig() {
            ImageConfig imageConfig = mBigImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Big, ImageTransparency.RGB_565);
                mBigImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        @NotNull
        public final synchronized ImageConfig smallImageConfig() {
            ImageConfig imageConfig = mSmallImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Small, ImageTransparency.RGB_565);
                mSmallImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        @NotNull
        public final synchronized ImageConfig fullImageConfig() {
            ImageConfig imageConfig = mFullImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Full, ImageTransparency.RGB_565);
                mFullImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        @NotNull
        public final synchronized ImageConfig defaultARGBImageConfig() {
            ImageConfig imageConfig = mDefaultARGBImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Middle, ImageTransparency.ARGB_8888);
                mDefaultARGBImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        @NotNull
        public final synchronized ImageConfig bigARGBImageConfig() {
            ImageConfig imageConfig = mBigARGBImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Big, ImageTransparency.ARGB_8888);
                mBigARGBImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        @NotNull
        public final synchronized ImageConfig smallARGBImageConfig() {
            ImageConfig imageConfig = mSmallARGBImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Small, ImageTransparency.ARGB_8888);
                mSmallARGBImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        @NotNull
        public final synchronized ImageConfig fullARGBImageConfig() {
            ImageConfig imageConfig = mFullARGBImageConfig;
            if (imageConfig == null) {
                ImageConfig imageConfig2;
                ImageConfig it = imageConfig2 = new ImageConfig(ImagePrecision.Full, ImageTransparency.ARGB_8888);
                mFullARGBImageConfig = it;
                imageConfig = imageConfig2;
            }
            return imageConfig;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

