/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util;

import android.support.v4.util.SimpleArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\u0010\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J \u0010\u0012\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltv/athena/util/RegexUtils;", "", "()V", "CITY_MAP", "Landroid/support/v4/util/SimpleArrayMap;", "", "REGEX_EMAIL", "REGEX_ID_CARD18", "REGEX_IP", "REGEX_URL", "REGEX_ZH", "getMatches", "", "regex", "input", "", "getReplaceAll", "replacement", "getReplaceFirst", "getSplits", "", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "isEmail", "", "isIDCard18", "isIDCard18Exact", "isIP", "isMatch", "isURL", "isZh", "utils_release"})
public final class RegexUtils {
    private static final String REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";
    private static final SimpleArrayMap<String, String> CITY_MAP;
    private static final String REGEX_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    private static final String REGEX_URL = "[a-zA-z]+://[^\\s]*";
    private static final String REGEX_ZH = "^[\\u4e00-\\u9fa5]+$";
    private static final String REGEX_IP = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
    public static final RegexUtils INSTANCE;

    @JvmStatic
    public static final boolean isMatch(@NotNull String regex, @Nullable CharSequence input) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        return input != null && (charSequence = input).length() > 0 && Pattern.matches(regex, input);
    }

    @JvmStatic
    public static final boolean isIDCard18(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return RegexUtils.isMatch(REGEX_ID_CARD18, input);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isIDCard18Exact(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (RegexUtils.isIDCard18(input)) {
            int[] factor = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
            char[] suffix = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
            if (CITY_MAP.isEmpty()) {
                CITY_MAP.put((Object)"11", (Object)"\u5317\u4eac");
                CITY_MAP.put((Object)"12", (Object)"\u5929\u6d25");
                CITY_MAP.put((Object)"13", (Object)"\u6cb3\u5317");
                CITY_MAP.put((Object)"14", (Object)"\u5c71\u897f");
                CITY_MAP.put((Object)"15", (Object)"\u5185\u8499\u53e4");
                CITY_MAP.put((Object)"21", (Object)"\u8fbd\u5b81");
                CITY_MAP.put((Object)"22", (Object)"\u5409\u6797");
                CITY_MAP.put((Object)"23", (Object)"\u9ed1\u9f99\u6c5f");
                CITY_MAP.put((Object)"31", (Object)"\u4e0a\u6d77");
                CITY_MAP.put((Object)"32", (Object)"\u6c5f\u82cf");
                CITY_MAP.put((Object)"33", (Object)"\u6d59\u6c5f");
                CITY_MAP.put((Object)"34", (Object)"\u5b89\u5fbd");
                CITY_MAP.put((Object)"35", (Object)"\u798f\u5efa");
                CITY_MAP.put((Object)"36", (Object)"\u6c5f\u897f");
                CITY_MAP.put((Object)"37", (Object)"\u5c71\u4e1c");
                CITY_MAP.put((Object)"41", (Object)"\u6cb3\u5357");
                CITY_MAP.put((Object)"42", (Object)"\u6e56\u5317");
                CITY_MAP.put((Object)"43", (Object)"\u6e56\u5357");
                CITY_MAP.put((Object)"44", (Object)"\u5e7f\u4e1c");
                CITY_MAP.put((Object)"45", (Object)"\u5e7f\u897f");
                CITY_MAP.put((Object)"46", (Object)"\u6d77\u5357");
                CITY_MAP.put((Object)"50", (Object)"\u91cd\u5e86");
                CITY_MAP.put((Object)"51", (Object)"\u56db\u5ddd");
                CITY_MAP.put((Object)"52", (Object)"\u8d35\u5dde");
                CITY_MAP.put((Object)"53", (Object)"\u4e91\u5357");
                CITY_MAP.put((Object)"54", (Object)"\u897f\u85cf");
                CITY_MAP.put((Object)"61", (Object)"\u9655\u897f");
                CITY_MAP.put((Object)"62", (Object)"\u7518\u8083");
                CITY_MAP.put((Object)"63", (Object)"\u9752\u6d77");
                CITY_MAP.put((Object)"64", (Object)"\u5b81\u590f");
                CITY_MAP.put((Object)"65", (Object)"\u65b0\u7586");
                CITY_MAP.put((Object)"71", (Object)"\u53f0\u6e7e");
                CITY_MAP.put((Object)"81", (Object)"\u9999\u6e2f");
                CITY_MAP.put((Object)"82", (Object)"\u6fb3\u95e8");
                CITY_MAP.put((Object)"91", (Object)"\u56fd\u5916");
            }
            if (CITY_MAP.get((Object)((Object)input.subSequence(0, 2)).toString()) != null) {
                int weightSum = 0;
                int n = 0;
                int n2 = 16;
                while (n <= n2) {
                    void i;
                    weightSum += (input.charAt((int)i) - 48) * factor[i];
                    ++i;
                }
                int idCardMod = weightSum % 11;
                char idCardLast = input.charAt(17);
                return idCardLast == suffix[idCardMod];
            }
        }
        return false;
    }

    public final boolean isEmail(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return RegexUtils.isMatch(REGEX_EMAIL, input);
    }

    public final boolean isURL(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return RegexUtils.isMatch(REGEX_URL, input);
    }

    public final boolean isZh(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return RegexUtils.isMatch(REGEX_ZH, input);
    }

    public final boolean isIP(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return RegexUtils.isMatch(REGEX_IP, input);
    }

    @NotNull
    public final List<String> getMatches(@NotNull String regex, @Nullable CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        if (input == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<String> matches = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        return matches;
    }

    @NotNull
    public final String[] getSplits(@Nullable String input, @NotNull String regex) {
        Object object;
        block9: {
            block8: {
                Object object2;
                Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
                object = input;
                if (input == null) break block8;
                CharSequence charSequence = (CharSequence)object;
                String string = regex;
                int n = 0;
                object = (string = new Regex(string)).split(charSequence, n);
                if (object == null) break block8;
                Object $receiver$iv = object;
                if (!$receiver$iv.isEmpty()) {
                    ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        CharSequence charSequence2 = it;
                        if (charSequence2.length() == 0) continue;
                        object2 = CollectionsKt.take((Iterable)((Iterable)$receiver$iv), (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    object2 = object = CollectionsKt.emptyList();
                }
                if (object2 == null) break block8;
                $receiver$iv = (Collection)object;
                Object object3 = $receiver$iv;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Object thisCollection$iv = object3;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                object = stringArray;
                if (stringArray != null) break block9;
            }
            object = new String[]{};
        }
        return object;
    }

    @NotNull
    public final String getReplaceFirst(@Nullable String input, @NotNull String regex, @NotNull String replacement) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        if (input == null) {
            string = "";
        } else {
            String string2 = Pattern.compile(regex).matcher(input).replaceFirst(replacement);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Pattern.compile(regex).m\u2026replaceFirst(replacement)");
        }
        return string;
    }

    @NotNull
    public final String getReplaceAll(@Nullable String input, @NotNull String regex, @NotNull String replacement) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        if (input == null) {
            string = "";
        } else {
            String string2 = Pattern.compile(regex).matcher(input).replaceAll(replacement);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Pattern.compile(regex).m\u2026).replaceAll(replacement)");
        }
        return string;
    }

    private RegexUtils() {
    }

    static {
        RegexUtils regexUtils;
        INSTANCE = regexUtils = new RegexUtils();
        CITY_MAP = new SimpleArrayMap();
    }
}

