/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.setting;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.log.ULog;
import tv.athena.util.permissions.helper.PhoneManufacturer;
import tv.athena.util.permissions.setting.ISettingPage;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ltv/athena/util/permissions/setting/SettingPage;", "Ltv/athena/util/permissions/setting/ISettingPage;", "permissionFragment", "Landroid/support/v4/app/Fragment;", "(Landroid/support/v4/app/Fragment;)V", "TAG", "", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "getPermissionFragment", "()Landroid/support/v4/app/Fragment;", "createIntent", "Landroid/content/Intent;", "defaultIntent", "getSystemProperty", "propName", "hasActivity", "", "intent", "huaweiIntent", "meizuIntent", "oppoIntent", "start", "requestCode", "", "vivoIntent", "xiaomiIntent", "utils_release"})
public final class SettingPage
implements ISettingPage {
    @NotNull
    private final Context context;
    private final String TAG = "permissions_SettingPage";
    @NotNull
    private final Fragment permissionFragment;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final Intent createIntent(Context context) {
        String string2 = PhoneManufacturer.INSTANCE.getMANUFACTURER();
        if (Intrinsics.areEqual((Object)string2, (Object)PhoneManufacturer.INSTANCE.getHUAWEI())) {
            return this.huaweiIntent(context);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)PhoneManufacturer.INSTANCE.getXIAOMI())) {
            return this.xiaomiIntent(context);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)PhoneManufacturer.INSTANCE.getOPPO())) {
            return this.oppoIntent(context);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)PhoneManufacturer.INSTANCE.getVIVO())) {
            return this.vivoIntent(context);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)PhoneManufacturer.INSTANCE.getMEIZU())) {
            return this.meizuIntent(context);
        }
        return null;
    }

    @Override
    public boolean start(int requestCode) {
        Intent intent = this.createIntent(this.context);
        if (intent != null) {
            try {
                this.permissionFragment.startActivityForResult(intent, requestCode);
                return true;
            }
            catch (Exception exception) {
                ULog.e(this.TAG, "start11", exception, new Object[0]);
            }
        }
        try {
            this.permissionFragment.startActivityForResult(this.defaultIntent(this.context), requestCode);
            return true;
        }
        catch (Exception exception) {
            ULog.e(this.TAG, "start22", exception, new Object[0]);
            return false;
        }
    }

    private final Intent defaultIntent(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return intent;
    }

    private final Intent huaweiIntent(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.defaultIntent(context);
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity"));
        return intent;
    }

    private final Intent xiaomiIntent(Context context) {
        String version = this.getSystemProperty(PhoneManufacturer.INSTANCE.getMIUI_VERSION_NAME());
        if (TextUtils.isEmpty((CharSequence)version) || StringsKt.contains$default((CharSequence)version, (CharSequence)"7", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)version, (CharSequence)"8", (boolean)false, (int)2, null)) {
            Intent intent = new Intent("miui.intent.action.APP_PERM_EDITOR");
            intent.putExtra("extra_pkgname", context.getPackageName());
            return intent;
        }
        return this.defaultIntent(context);
    }

    private final Intent vivoIntent(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packagename", context.getPackageName());
        intent.setComponent(new ComponentName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.SoftPermissionDetailActivity"));
        if (this.hasActivity(context, intent)) {
            return intent;
        }
        intent.setComponent(new ComponentName("com.iqoo.secure", "com.iqoo.secure.safeguard.SoftPermissionDetailActivity"));
        return intent;
    }

    private final Intent oppoIntent(Context context) {
        Intent intent = new Intent();
        intent.putExtra("packageName", context.getPackageName());
        intent.setComponent(new ComponentName("com.color.safecenter", "com.color.safecenter.permission.PermissionManagerActivity"));
        return intent;
    }

    private final Intent meizuIntent(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.defaultIntent(context);
        }
        Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
        intent.putExtra("packageName", context.getPackageName());
        intent.setComponent(new ComponentName("com.meizu.safe", "com.meizu.safe.security.AppSecActivity"));
        return intent;
    }

    private final boolean hasActivity(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.queryIntentActivities(intent, 65536).size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public final String getSystemProperty(@NotNull String propName) {
        Intrinsics.checkParameterIsNotNull((Object)propName, (String)"propName");
        input = null;
        try {
            v0 = p = Runtime.getRuntime().exec("getprop " + propName);
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"p");
            input = new BufferedReader(new InputStreamReader(v0.getInputStream()), 1024);
            v1 = input.readLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"input.readLine()");
            var4_6 = v1;
            ** try [egrp 1[TRYBLOCK] [0 : 83->91)] { 
        }
        catch (IOException ex) {
            ULog.e(this.TAG, "getSystemProperty", ex, new Object[0]);
            var4_7 = "";
            return var4_7;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignored) {
                    ULog.e(this.TAG, "getSystemProperty", ignored, new Object[0]);
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            input.close();
        }
lbl15:
        // 1 sources

        catch (IOException ignored) {
            ULog.e(this.TAG, "getSystemProperty", ignored, new Object[0]);
        }
        return var4_6;
    }

    @NotNull
    public final Fragment getPermissionFragment() {
        return this.permissionFragment;
    }

    public SettingPage(@NotNull Fragment permissionFragment) {
        Intrinsics.checkParameterIsNotNull((Object)permissionFragment, (String)"permissionFragment");
        this.permissionFragment = permissionFragment;
        Context context = this.permissionFragment.getContext();
        if (context == null) {
            Intrinsics.throwNpe();
        }
        this.context = context;
        this.TAG = "permissions_SettingPage";
    }
}

