/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.checker;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.permissions.checker.PermissionTest;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ltv/athena/util/permissions/checker/ContactsWriteTest;", "Ltv/athena/util/permissions/checker/PermissionTest;", "mResolver", "Landroid/content/ContentResolver;", "(Landroid/content/ContentResolver;)V", "DISPLAY_NAME", "", "delete", "", "contactId", "", "dataId", "insert", "", "test", "update", "rawContactId", "utils_release"})
public final class ContactsWriteTest
implements PermissionTest {
    private final String DISPLAY_NAME = "PERMISSION";
    private final ContentResolver mResolver;

    @Override
    public boolean test() throws Throwable {
        Cursor cursor = this.mResolver.query(ContactsContract.Data.CONTENT_URI, new String[]{"raw_contact_id"}, "mimetype=? and data1=?", new String[]{"vnd.android.cursor.item/name", this.DISPLAY_NAME}, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                long rawContactId = cursor.getLong(0);
                cursor.close();
                return this.update(rawContactId);
            }
            cursor.close();
            return this.insert();
        }
        return false;
    }

    private final boolean insert() {
        ContentValues values = new ContentValues();
        Uri rawContractUri = this.mResolver.insert(ContactsContract.RawContacts.CONTENT_URI, values);
        long rawContactId = ContentUris.parseId((Uri)rawContractUri);
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("data1", this.DISPLAY_NAME);
        values.put("data2", this.DISPLAY_NAME);
        values.put("mimetype", "vnd.android.cursor.item/name");
        Uri dataUri = this.mResolver.insert(ContactsContract.Data.CONTENT_URI, values);
        return ContentUris.parseId((Uri)dataUri) > 0L;
    }

    private final void delete(long contactId, long dataId) {
        this.mResolver.delete(ContactsContract.RawContacts.CONTENT_URI, "_id=?", new String[]{Long.toString(contactId)});
        this.mResolver.delete(ContactsContract.Data.CONTENT_URI, "_id=?", new String[]{Long.toString(dataId)});
    }

    private final boolean update(long rawContactId) {
        ContentValues values = new ContentValues();
        values.put("raw_contact_id", Long.valueOf(rawContactId));
        values.put("data1", this.DISPLAY_NAME);
        values.put("data2", this.DISPLAY_NAME);
        values.put("mimetype", "vnd.android.cursor.item/name");
        Uri dataUri = this.mResolver.insert(ContactsContract.Data.CONTENT_URI, values);
        return ContentUris.parseId((Uri)dataUri) > 0L;
    }

    public ContactsWriteTest(@NotNull ContentResolver mResolver) {
        Intrinsics.checkParameterIsNotNull((Object)mResolver, (String)"mResolver");
        this.mResolver = mResolver;
        this.DISPLAY_NAME = "PERMISSION";
    }
}

