/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.file;

import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.util.FP;
import tv.athena.util.file.BasicFileUtils;
import tv.athena.util.log.ULog;

@Deprecated(message="old stuff")
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ltv/athena/util/file/BasicFileUtils;", "", "()V", "Companion", "utils_release"})
public class BasicFileUtils {
    @NotNull
    private static final String ZIP_EXT = ".zip";
    @NotNull
    private static final String JPG_EXT = ".jpg";
    @NotNull
    private static final String SPEEX_EXT = ".aud";
    private static final HashMap<String, String> FILE_MIMES;
    private static final int MAX_BUFF_SIZE = 0x100000;
    private static final int MIN_BUFF_SIZE = 4096;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        ZIP_EXT = ZIP_EXT;
        JPG_EXT = JPG_EXT;
        SPEEX_EXT = SPEEX_EXT;
        FILE_MIMES = new HashMap();
        Map map2 = FILE_MIMES;
        String string2 = ZIP_EXT;
        String string3 = "application/zip";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = ".bmp";
        string3 = "image/bmp";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = ".gif";
        string3 = "image/gif";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = ".jpe";
        string3 = "image/jpeg";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = ".jpeg";
        string3 = "image/jpeg";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = JPG_EXT;
        string3 = "image/jpeg";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = ".png";
        string3 = "image/png";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = ".speex";
        string3 = "audio/speex";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = ".spx";
        string3 = "audio/speex";
        map2.put(string2, string3);
        map2 = FILE_MIMES;
        string2 = SPEEX_EXT;
        string3 = "audio/speex";
        map2.put(string2, string3);
        MAX_BUFF_SIZE = 0x100000;
        MIN_BUFF_SIZE = 4096;
    }

    public static final boolean isSDCardMounted() {
        return Companion.isSDCardMounted();
    }

    @JvmStatic
    public static final boolean availableMemInSDcard() {
        return Companion.availableMemInSDcard();
    }

    @JvmStatic
    public static final boolean externalStorageExist() {
        return Companion.externalStorageExist();
    }

    @JvmStatic
    @NotNull
    public static final String getFileExt(@NotNull String fileName) {
        return Companion.getFileExt(fileName);
    }

    @JvmStatic
    @Nullable
    public static final String getFileName(@Nullable String filePath) {
        return Companion.getFileName(filePath);
    }

    @JvmStatic
    @NotNull
    public static final String getFileMime(@NotNull String fileName) {
        return Companion.getFileMime(fileName);
    }

    @JvmStatic
    public static final void ensureDirExists(@NotNull String dirPath) {
        Companion.ensureDirExists(dirPath);
    }

    @JvmStatic
    public static final void createDir(@NotNull String dirPath, boolean nomedia) {
        Companion.createDir(dirPath, nomedia);
    }

    @JvmStatic
    @Nullable
    public static final File createFileOnSD(@NotNull String dir, @NotNull String name) {
        return Companion.createFileOnSD(dir, name);
    }

    @JvmStatic
    public static final boolean isFileExisted(@NotNull String filePath) {
        return Companion.isFileExisted(filePath);
    }

    @JvmStatic
    @Nullable
    public static final String getDirOfFilePath(@NotNull String filePath) {
        return Companion.getDirOfFilePath(filePath);
    }

    @JvmStatic
    public static final void renameFile(@NotNull String oldFile, @NotNull String newFile) {
        Companion.renameFile(oldFile, newFile);
    }

    @JvmStatic
    public static final void removeFile(@NotNull String filename) {
        Companion.removeFile(filename);
    }

    @JvmStatic
    public static final void removeDir(@NotNull String dirPath) {
        Companion.removeDir(dirPath);
    }

    @JvmStatic
    public static final void rm(@NotNull String fname) {
        Companion.rm(fname);
    }

    @JvmStatic
    public static final void rm(@NotNull File f) {
        Companion.rm(f);
    }

    @JvmStatic
    public static final void copyFile(@NotNull File src, @NotNull File des) throws IOException {
        Companion.copyFile(src, des);
    }

    @JvmStatic
    public static final boolean copyFile(@NotNull String inFileName, @NotNull String outFileName) {
        return Companion.copyFile(inFileName, outFileName);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0007J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0011H\u0007J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0007J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0005H\u0007J\b\u0010#\u001a\u00020\u0011H\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020\u0005H\u0007J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0007J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0007J\u0014\u0010)\u001a\u0004\u0018\u00010\u00052\b\u0010%\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0005H\u0007J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0005H\u0007J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u0005H\u0007J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005H\u0007J\u0010\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u0018H\u0007J\u0010\u00101\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0005H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u001a\u0010\u0010\u001a\u00020\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0010\u0010\u0013\u00a8\u00064"}, d2={"Ltv/athena/util/file/BasicFileUtils$Companion;", "", "()V", "FILE_MIMES", "Ljava/util/HashMap;", "", "JPG_EXT", "getJPG_EXT", "()Ljava/lang/String;", "MAX_BUFF_SIZE", "", "MIN_BUFF_SIZE", "SPEEX_EXT", "getSPEEX_EXT", "ZIP_EXT", "getZIP_EXT", "isSDCardMounted", "", "isSDCardMounted$annotations", "()Z", "availableMemInSDcard", "copyFile", "", "src", "Ljava/io/File;", "des", "inFileName", "outFileName", "createDir", "dirPath", "nomedia", "createFileOnSD", "dir", "name", "ensureDirExists", "externalStorageExist", "getDirOfFilePath", "filePath", "getFileExt", "fileName", "getFileMime", "getFileName", "isFileExisted", "removeDir", "removeFile", "filename", "renameFile", "oldFile", "newFile", "rm", "f", "fname", "utils_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void isSDCardMounted$annotations() {
        }

        public final boolean isSDCardMounted() {
            return Companion.availableMemInSDcard();
        }

        @JvmStatic
        public final boolean availableMemInSDcard() {
            File sdcard;
            if (!this.externalStorageExist()) {
                return false;
            }
            File file = sdcard = Environment.getExternalStorageDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sdcard");
            StatFs statFs = new StatFs(file.getPath());
            long blockSize = statFs.getBlockSize();
            long avaliableBlocks = statFs.getAvailableBlocks();
            long total = avaliableBlocks * blockSize / (long)1024;
            return total >= (long)10;
        }

        @JvmStatic
        public final boolean externalStorageExist() {
            boolean ret = false;
            ret = StringsKt.equals((String)Environment.getExternalStorageState(), (String)"mounted", (boolean)true);
            return ret;
        }

        @JvmStatic
        @NotNull
        public final String getFileExt(@NotNull String fileName) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            int pos = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null);
            if (pos == -1) {
                string2 = "";
            } else {
                String string3 = fileName;
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                String string5 = string3 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(pos);
                string2 = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            }
            return string2;
        }

        @JvmStatic
        @Nullable
        public final String getFileName(@Nullable String filePath) {
            String slash;
            int pos;
            if (filePath != null && (pos = StringsKt.lastIndexOf$default((CharSequence)filePath, (String)(slash = "/"), (int)0, (boolean)false, (int)6, null) + 1) > 0) {
                String string2 = filePath;
                String string3 = string2.substring(pos);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                return string3;
            }
            return null;
        }

        @NotNull
        public final String getZIP_EXT() {
            return ZIP_EXT;
        }

        @NotNull
        public final String getJPG_EXT() {
            return JPG_EXT;
        }

        @NotNull
        public final String getSPEEX_EXT() {
            return SPEEX_EXT;
        }

        @JvmStatic
        @NotNull
        public final String getFileMime(@NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            String mime = (String)FILE_MIMES.get(this.getFileExt(fileName));
            String string2 = mime;
            if (string2 == null) {
                string2 = "*/*";
            }
            return string2;
        }

        @JvmStatic
        public final void ensureDirExists(@NotNull String dirPath) {
            Intrinsics.checkParameterIsNotNull((Object)dirPath, (String)"dirPath");
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
        }

        @JvmStatic
        public final void createDir(@NotNull String dirPath, boolean nomedia) {
            Intrinsics.checkParameterIsNotNull((Object)dirPath, (String)"dirPath");
            this.ensureDirExists(dirPath);
            if (nomedia) {
                File nomediafile = new File(dirPath + "/.nomedia");
                try {
                    nomediafile.createNewFile();
                }
                catch (IOException e) {
                    Log.e((String)"BasicFileUtils", (String)"Empty Catch on createDir", (Throwable)e);
                }
            }
        }

        @JvmStatic
        @Nullable
        public final File createFileOnSD(@NotNull String dir, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            File file = null;
            if (this.isSDCardMounted()) {
                this.createDir(dir, true);
                String path = dir + File.separator + name;
                file = new File(path);
                try {
                    if (!file.exists() && !file.createNewFile()) {
                        file = null;
                    }
                }
                catch (IOException e) {
                    file = null;
                }
            }
            return file;
        }

        @JvmStatic
        public final boolean isFileExisted(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            if (FP.empty(filePath)) {
                return false;
            }
            try {
                File file = new File(filePath);
                return file.exists() && file.length() > 0L;
            }
            catch (Exception e) {
                return false;
            }
        }

        @JvmStatic
        @Nullable
        public final String getDirOfFilePath(@NotNull String filePath) {
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            if (FP.empty(filePath)) {
                return null;
            }
            int sepPos = StringsKt.lastIndexOf$default((CharSequence)filePath, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null);
            if (sepPos == -1) {
                string2 = null;
            } else {
                String string3 = filePath;
                int n = 0;
                String string4 = string3.substring(n, sepPos);
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string2;
        }

        @JvmStatic
        public final void renameFile(@NotNull String oldFile, @NotNull String newFile) {
            Intrinsics.checkParameterIsNotNull((Object)oldFile, (String)"oldFile");
            Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
            try {
                File file = new File(oldFile);
                file.renameTo(new File(newFile));
            }
            catch (Exception e) {
                ULog.e("BasicFileUtils", (Function0<? extends Object>)((Function0)renameFile.1.INSTANCE), e);
            }
        }

        @JvmStatic
        public final void removeFile(@NotNull String filename) {
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            if (!FP.empty(filename)) {
                try {
                    File file = new File(filename);
                    file.delete();
                }
                catch (Exception e) {
                    Log.e((String)"BasicFileUtils", (String)"Empty Catch on removeFile", (Throwable)e);
                }
            }
        }

        @JvmStatic
        public final void removeDir(@NotNull String dirPath) {
            File[] fileList;
            Intrinsics.checkParameterIsNotNull((Object)dirPath, (String)"dirPath");
            File dir = new File(dirPath);
            if (dir.isDirectory() && (fileList = dir.listFiles()) != null && fileList.length > 0) {
                for (File file : fileList) {
                    file.delete();
                }
            }
            dir.delete();
        }

        @JvmStatic
        public final void rm(@NotNull String fname) {
            Intrinsics.checkParameterIsNotNull((Object)fname, (String)"fname");
            this.rm(new File(fname));
        }

        @JvmStatic
        public final void rm(@NotNull File f) {
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            if (f.exists()) {
                if (f.isDirectory()) {
                    File[] fileArray = FP.ref(f.listFiles());
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File i2;
                        File file = i2 = fileArray[i];
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"i");
                        this.rm(file);
                    }
                } else {
                    f.delete();
                }
            }
        }

        @JvmStatic
        public final void copyFile(@NotNull File src, @NotNull File des) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            Intrinsics.checkParameterIsNotNull((Object)des, (String)"des");
            if (des.exists()) {
                des.delete();
            }
            des.createNewFile();
            FileInputStream in = new FileInputStream(src);
            int length = in.available();
            if (length == 0) {
                length = MIN_BUFF_SIZE;
            } else if (length >= MAX_BUFF_SIZE) {
                length = MAX_BUFF_SIZE;
            }
            FileOutputStream out = new FileOutputStream(des);
            byte[] buffer = new byte[length];
            while (true) {
                int ins;
                if ((ins = in.read(buffer)) == -1) {
                    in.close();
                    out.flush();
                    out.close();
                    return;
                }
                out.write(buffer, 0, ins);
            }
        }

        @JvmStatic
        public final boolean copyFile(@NotNull String inFileName, @NotNull String outFileName) {
            Intrinsics.checkParameterIsNotNull((Object)inFileName, (String)"inFileName");
            Intrinsics.checkParameterIsNotNull((Object)outFileName, (String)"outFileName");
            try {
                this.copyFile(new File(inFileName), new File(outFileName));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

