/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.encode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;

public class SHAUtils {
    private static final String TAG = "SHAUtils";

    private static String digest(String s, String algorithm) {
        if (s == null || s.length() == 0 || algorithm == null || algorithm.length() == 0) {
            return null;
        }
        String sha = null;
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(s.getBytes("UTF-8"));
            sha = SHAUtils.bytesToHexString(digest.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sha;
    }

    public static String getFileSHAString(String path) throws IOException {
        if (path == null || path.length() == 0) {
            return null;
        }
        File big = new File(path);
        return SHAUtils.getFileSHAString(big);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSHAString(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        String md5 = null;
        FileInputStream in = new FileInputStream(file);
        FileChannel ch = in.getChannel();
        MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(byteBuffer);
            md5 = SHAUtils.bufferToHex(digest.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return md5;
    }

    private static String bufferToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return SHAUtils.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int start, int len) {
        if (bytes == null || start < 0 || len < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * len);
        int max = start + len;
        for (int i = start; i < max; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            stringBuilder.append(hex);
        }
        return stringBuilder.toString();
    }

    public static String getSHA1(String s) {
        return SHAUtils.digest(s, "SHA-1");
    }

    public static String getSHA256(String s) {
        return SHAUtils.digest(s, "SHA-256");
    }

    public static String getSHA384(String s) {
        return SHAUtils.digest(s, "SHA-384");
    }

    public static String getSHA512(String s) {
        return SHAUtils.digest(s, "SHA-512");
    }

    public static String getSHA(String s, String algorithm) {
        return SHAUtils.digest(s, algorithm);
    }

    private static String bytesToHexString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static boolean checksumSHA1(String path, String sha1) {
        try {
            String fileMd5 = SHAUtils.getSHA1Checksum(path);
            return fileMd5.equals(sha1);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getSHA1Checksum(String filename) throws Exception {
        byte[] b = SHAUtils.createChecksum(filename, "SHA1");
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static byte[] createChecksum(String filename, String algorithm) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance(algorithm);
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }
}

