/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.encode;

import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static final String TAG = "MD5Utils";

    public static String fileMd5(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        try {
            return MD5Utils.getFileMd5String(filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String fileMd5(File file) {
        if (file == null) {
            return "";
        }
        try {
            return MD5Utils.getFileMD5String(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getFileMd5String(String path) throws IOException {
        if (path == null || path.length() == 0) {
            return null;
        }
        File big = new File(path);
        return MD5Utils.getFileMD5String(big);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5String(File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        String md5 = null;
        FileInputStream fileInputStream = null;
        FilterInputStream digestInputStream = null;
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            fileInputStream = new FileInputStream(file);
            digestInputStream = new DigestInputStream(fileInputStream, messagedigest);
            byte[] buffer = new byte[4096];
            while (digestInputStream.read(buffer) > 0) {
            }
            md5 = MD5Utils.bufferToHex(((DigestInputStream)digestInputStream).getMessageDigest().digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        finally {
            if (null != fileInputStream) {
                fileInputStream.close();
            }
            if (null != digestInputStream) {
                digestInputStream.close();
            }
        }
        return md5;
    }

    public static String getMD5String(String s) {
        if (s == null) {
            return null;
        }
        return MD5Utils.getMD5String(s.getBytes());
    }

    public static String getMD5String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String md5 = null;
        try {
            MessageDigest messagedigest = MessageDigest.getInstance("MD5");
            messagedigest.update(bytes);
            md5 = MD5Utils.bufferToHex(messagedigest.digest());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return md5;
    }

    private static String bufferToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return MD5Utils.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int start, int len) {
        if (bytes == null || start < 0 || len < 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * len);
        int max = start + len;
        for (int i = start; i < max; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            stringBuilder.append(hex);
        }
        return stringBuilder.toString();
    }
}

