/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.diskcache;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0010"}, d2={"Ltv/athena/util/diskcache/DiskCacheUtils;", "", "()V", "isExternalStorageAvailable", "", "()Z", "checkExternalStorageAvailable", "getCacheDir", "Ljava/io/File;", "context", "Landroid/content/Context;", "internal", "uniqueName", "", "getExternalCacheDir", "isExternalStorageRemovable", "utils_release"})
public final class DiskCacheUtils {
    public static final DiskCacheUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final File getCacheDir(@NotNull Context context, @NotNull String uniqueName) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uniqueName, (String)"uniqueName");
        return DiskCacheUtils.getCacheDir(context, false, uniqueName);
    }

    @JvmStatic
    @NotNull
    public static final File getCacheDir(@NotNull Context context, boolean internal, @NotNull String uniqueName) {
        String cachePath;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uniqueName, (String)"uniqueName");
        if (internal) {
            File file = context.getCacheDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.cacheDir");
            String string2 = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.cacheDir.path");
            cachePath = string2;
        } else {
            String string3;
            if (INSTANCE.isExternalStorageAvailable() || !INSTANCE.isExternalStorageRemovable()) {
                String string4 = INSTANCE.getExternalCacheDir(context).getPath();
                string3 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"getExternalCacheDir(context).path");
            } else {
                File file = context.getCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.cacheDir");
                String string5 = file.getPath();
                string3 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"context.cacheDir.path");
            }
            cachePath = string3;
        }
        return new File(cachePath + File.separator + uniqueName);
    }

    private final boolean isExternalStorageRemovable() {
        return Build.VERSION.SDK_INT >= 9 ? Environment.isExternalStorageRemovable() : true;
    }

    private final File getExternalCacheDir(Context context) {
        File file = Environment.getExternalStorageDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
        return new File(file.getPath());
    }

    public final boolean isExternalStorageAvailable() {
        return this.checkExternalStorageAvailable();
    }

    private final boolean checkExternalStorageAvailable() {
        boolean mExternalStorageAvailable = false;
        boolean mExternalStorageWriteable = false;
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            mExternalStorageAvailable = mExternalStorageWriteable = true;
        } else if ("mounted_ro".equals(state)) {
            mExternalStorageAvailable = true;
            mExternalStorageWriteable = false;
        } else {
            mExternalStorageAvailable = mExternalStorageWriteable = false;
        }
        return mExternalStorageAvailable;
    }

    private DiskCacheUtils() {
    }

    static {
        DiskCacheUtils diskCacheUtils;
        INSTANCE = diskCacheUtils = new DiskCacheUtils();
    }
}

