/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.log.ULog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nJ \u0010\f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J$\u0010\f\u001a\u00020\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001c\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltv/athena/util/compress/UtilZip;", "", "()V", "TAG", "", "addFileToZipOutStream", "", "zos", "Ljava/util/zip/ZipOutputStream;", "file", "Ljava/io/File;", "zipEntryName", "compress", "srcFile", "sourceFile", "name", "zipOutputStream", "destPath", "compressFilesIgnoreSubSub", "files", "", "zipPath", "decompress", "destFile", "zis", "Ljava/util/zip/ZipInputStream;", "decompressFile", "fileProber", "dirFile", "renameZip", "tmpFile", "zipFile", "utils_release"})
public final class UtilZip {
    private static final String TAG = "UtilZip";
    public static final UtilZip INSTANCE;

    public final void compress(@NotNull File srcFile) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        String name = srcFile.getName();
        String basePath = srcFile.getParent();
        StringBuilder stringBuilder = new StringBuilder().append(basePath).append(File.separator);
        String string2 = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        String string3 = string2;
        int n = 0;
        int n2 = StringsKt.indexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
        Object object = stringBuilder;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        Object object2 = string5;
        String destPath = ((StringBuilder)object).append((String)object2).append(".tmp").toString();
        this.compress(null, srcFile, destPath);
        string3 = name;
        n = 0;
        n2 = StringsKt.indexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
        StringBuilder stringBuilder2 = new StringBuilder().append(basePath).append(File.separator);
        File file2 = file;
        File file3 = file;
        object2 = new File(destPath);
        object = this;
        String string6 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string7 = string6;
        file2(stringBuilder2.append(string7).append(".zip").toString());
        super.renameZip((File)object2, file3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void compress(ZipOutputStream zipOutputStream, File srcFile, String destPath) {
        File destFile = new File(destPath);
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        if (zipOutputStream2 == null) {
            zipOutputStream2 = new ZipOutputStream(new FileOutputStream(destFile));
        }
        ZipOutputStream zos = zipOutputStream2;
        try {
            String string2 = srcFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"srcFile.name");
            this.compress(srcFile, zos, string2);
        }
        catch (Exception e) {
            ULog.e(TAG, "compressFile", e, new Object[0]);
        }
        finally {
            zos.flush();
            zos.close();
        }
    }

    static /* bridge */ /* synthetic */ void compress$default(UtilZip utilZip, ZipOutputStream zipOutputStream, File file, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            zipOutputStream = null;
        }
        utilZip.compress(zipOutputStream, file, string2);
    }

    private final void compress(File sourceFile, ZipOutputStream zos, String name) throws Exception {
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
            int count = 0;
            byte[] data = new byte[1024];
            while (true) {
                int n;
                int $receiver;
                count = $receiver = (n = bis.read(data, 0, 1024));
                if (n == -1) break;
                zos.write(data, 0, count);
            }
            bis.close();
            zos.closeEntry();
        } else {
            File[] count;
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || (count = listFiles).length == 0) {
                zos.putNextEntry(new ZipEntry(name + File.separator));
                zos.closeEntry();
            } else {
                File[] $receiver$iv = listFiles;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it;
                    File file = it = (element$iv = $receiver$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                    INSTANCE.compress(file, zos, name + File.separator + it.getName());
                }
            }
        }
    }

    private final void renameZip(File tmpFile, File zipFile) {
        if (tmpFile.exists()) {
            if (zipFile.exists()) {
                zipFile.delete();
            }
            tmpFile.renameTo(zipFile);
        }
    }

    @NotNull
    public final String compressFilesIgnoreSubSub(@NotNull List<? extends File> files, @NotNull String zipPath) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)zipPath, (String)"zipPath");
        if (files.isEmpty()) {
            return "";
        }
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        zipFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(zipPath);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (File file : files) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                File[] subFiles = file.listFiles();
                int n = subFiles.length;
                for (int i = 0; i < n; ++i) {
                    File f;
                    File file2 = f = subFiles[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"f");
                    if (file2.isDirectory()) continue;
                    String entryName = file.getName() + File.separator + f.getName();
                    try {
                        this.addFileToZipOutStream(zos, f, entryName);
                        continue;
                    }
                    catch (Exception e) {
                        ULog.e(TAG, "printStackTrace", e, new Object[0]);
                        if (zipFile.exists()) {
                            zipFile.delete();
                        }
                        return "";
                    }
                }
                continue;
            }
            try {
                String string2 = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
                this.addFileToZipOutStream(zos, file, string2);
            }
            catch (Exception e) {
                ULog.e(TAG, "printStackTrace", e, new Object[0]);
                if (zipFile.exists()) {
                    zipFile.delete();
                }
                return "";
            }
        }
        try {
            zos.closeEntry();
            zos.close();
        }
        catch (IOException iOException) {
            ULog.e(TAG, "printStackTrace", iOException, new Object[0]);
        }
        String string3 = zipFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"zipFile.absolutePath");
        return string3;
    }

    private final void addFileToZipOutStream(ZipOutputStream zos, File file, String zipEntryName) {
        ZipEntry ze = new ZipEntry(zipEntryName);
        byte[] buffer = new byte[1024];
        zos.putNextEntry(ze);
        FileInputStream in = new FileInputStream(file);
        int len = 0;
        while (true) {
            int n;
            int it;
            len = it = (n = in.read(buffer));
            if (n <= 0) break;
            zos.write(buffer, 0, len);
        }
        in.close();
    }

    public final void decompress(@NotNull File srcFile) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        String basePath = srcFile.getParent() + File.separator;
        this.decompress(srcFile, basePath);
    }

    public final void decompress(@NotNull File srcFile, @NotNull File destFile) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)destFile, (String)"destFile");
        CheckedInputStream cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
        ZipInputStream zis = new ZipInputStream(cis);
        this.decompress(destFile, zis);
        zis.close();
    }

    public final void decompress(@NotNull File srcFile, @NotNull String destPath) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)destPath, (String)"destPath");
        this.decompress(srcFile, new File(destPath));
    }

    private final void decompress(File destFile, ZipInputStream zis) throws Exception {
        ZipEntry entry = null;
        while (true) {
            ZipEntry zipEntry;
            ZipEntry it;
            entry = it = (zipEntry = zis.getNextEntry());
            if (zipEntry == null) break;
            StringBuilder stringBuilder = new StringBuilder().append(destFile.getPath()).append(File.separator);
            ZipEntry zipEntry2 = entry;
            if (zipEntry2 == null) {
                Intrinsics.throwNpe();
            }
            String dir = stringBuilder.append(zipEntry2.getName()).toString();
            File dirFile = new File(dir);
            this.fileProber(dirFile);
            ZipEntry zipEntry3 = entry;
            if (zipEntry3 == null) {
                Intrinsics.throwNpe();
            }
            if (zipEntry3.isDirectory()) {
                dirFile.mkdirs();
            } else {
                this.decompressFile(dirFile, zis);
            }
            zis.closeEntry();
        }
    }

    private final void decompressFile(File destFile, ZipInputStream zis) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        int count = -1;
        byte[] data = new byte[1024];
        while (true) {
            int n;
            int it;
            count = it = (n = zis.read(data, 0, 1024));
            if (n == -1) break;
            bos.write(data, 0, count);
        }
        bos.write(data);
        bos.close();
    }

    private final void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            File file = parentFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parentFile");
            this.fileProber(file);
            parentFile.mkdir();
        }
    }

    private UtilZip() {
    }

    static {
        UtilZip utilZip;
        INSTANCE = utilZip = new UtilZip();
    }
}

