/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.compress;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.compress.UtilZip;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001e\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltv/athena/util/compress/CompressUtils;", "", "()V", "BUFFER", "", "TAG", "", "TEMP", "ZIP", "compress", "", "srcFile", "Ljava/io/File;", "compressFilesIgnoreSubSub", "files", "", "destPath", "decompress", "destFile", "utils_release"})
public final class CompressUtils {
    @NotNull
    public static final String ZIP = ".zip";
    private static final String TAG = "CompressUtils";
    @NotNull
    public static final String TEMP = ".tmp";
    public static final int BUFFER = 1024;
    public static final CompressUtils INSTANCE;

    @JvmStatic
    public static final void compress(@NotNull File srcFile) {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        UtilZip.INSTANCE.compress(srcFile);
    }

    @JvmStatic
    @NotNull
    public static final String compressFilesIgnoreSubSub(@NotNull List<? extends File> files, @NotNull String destPath) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)destPath, (String)"destPath");
        return UtilZip.INSTANCE.compressFilesIgnoreSubSub(files, destPath);
    }

    @JvmStatic
    public static final void decompress(@NotNull File srcFile) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        UtilZip.INSTANCE.decompress(srcFile);
    }

    @JvmStatic
    public static final void decompress(@NotNull File srcFile, @NotNull File destFile) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)destFile, (String)"destFile");
        UtilZip.INSTANCE.decompress(srcFile, destFile);
    }

    @JvmStatic
    public static final void decompress(@NotNull File srcFile, @NotNull String destPath) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)srcFile, (String)"srcFile");
        Intrinsics.checkParameterIsNotNull((Object)destPath, (String)"destPath");
        UtilZip.INSTANCE.decompress(srcFile, destPath);
    }

    private CompressUtils() {
    }

    static {
        CompressUtils compressUtils;
        INSTANCE = compressUtils = new CompressUtils();
    }
}

