/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util;

import android.content.Context;
import android.os.Looper;
import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.util.R;
import tv.athena.util.TimeUtils;
import tv.athena.util.log.ULog;
import tv.athena.util.valid.BlankUtil;

@Deprecated(message="\u4f7f\u7528\u65b0\u7684TimeUtils -- tv.athena.util.common.TimeUtils")
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0007;<=>?@AB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0003J\u001f\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\fH\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\fH\u0007J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0007J\u001c\u0010%\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J*\u0010,\u001a\u0004\u0018\u00010\f2\u0006\u0010-\u001a\u00020.2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0007J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0010\u00103\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\fH\u0007J\u0012\u00104\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020\u0004H\u0007J\u001c\u00104\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u00105\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0004H\u0007J\u0018\u00106\u001a\u0002002\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0007J\u0018\u00109\u001a\u0002002\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0007J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Ltv/athena/util/TimeUtils;", "", "()V", "DAYS_OF_MONTH", "", "DAYS_OF_YEAR", "HOURS_OF_DAY", "MILLIS_OF_SECOND", "MINUTES_OF_HOUR", "MONTHS_OF_YEAR", "SECONDS_OF_MINUTE", "currentTimeFormat", "", "currentTimeFormat$annotations", "getCurrentTimeFormat", "()Ljava/lang/String;", "mSimpleDateFormatCache", "Ljava/util/HashMap;", "Ljava/text/SimpleDateFormat;", "checkOverflow", "t", "scale", "converTimeToString", "s", "pattern", "(Ljava/lang/Long;Ljava/lang/String;)Ljava/lang/String;", "convertTimeToLong", "time", "curSec", "", "formatTimeOutPut", "dateStr", "getDayOfMonth", "millis", "getDayOfWeek", "getExpireDeadTime", "millisToExpire", "getFormatTimeString", "timeMillis", "format", "getHourOf12HClock", "getHourOf24HClock", "getMinute", "getMonth", "getPostTimeString", "context", "Landroid/content/Context;", "showToday", "", "showSecond", "getSecond", "getSimpleDateFormat", "getTimeStringFromMillis", "getYear", "isSameDay", "millis1", "millis2", "isSameWeek", "toMilliSecondTime", "DAYS", "HOURS", "MILLIS", "MINUTES", "MONTHS", "SECONDS", "YEARS", "utils_release"})
public final class TimeUtils {
    public static final long MONTHS_OF_YEAR = 12L;
    public static final long DAYS_OF_YEAR = 365L;
    public static final long DAYS_OF_MONTH = 30L;
    public static final long HOURS_OF_DAY = 24L;
    public static final long MINUTES_OF_HOUR = 60L;
    public static final long SECONDS_OF_MINUTE = 60L;
    public static final long MILLIS_OF_SECOND = 1000L;
    private static final HashMap<String, SimpleDateFormat> mSimpleDateFormatCache;
    public static final TimeUtils INSTANCE;

    @JvmStatic
    public static /* synthetic */ void currentTimeFormat$annotations() {
    }

    @NotNull
    public static final String getCurrentTimeFormat() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String string = formatter.format(currentTime);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formatter.format(currentTime)");
        return string;
    }

    @JvmStatic
    public static final boolean isSameDay(long millis1, long millis2) {
        Calendar c2;
        Calendar c1;
        Calendar calendar = c1 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c1");
        calendar.setTimeInMillis(millis1);
        Calendar calendar2 = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"c2");
        calendar2.setTimeInMillis(millis2);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    @JvmStatic
    public static final boolean isSameWeek(long millis1, long millis2) {
        Calendar c2;
        Calendar c1;
        Calendar calendar = c1 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c1");
        calendar.setTimeInMillis(millis1);
        Calendar calendar2 = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"c2");
        calendar2.setTimeInMillis(millis2);
        return c1.get(1) == c2.get(1) && c1.get(3) == c2.get(3);
    }

    @JvmStatic
    public static final int getYear(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(1);
    }

    @JvmStatic
    public static final int getMonth(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(2) + 1;
    }

    @JvmStatic
    public static final int getDayOfMonth(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(5);
    }

    @JvmStatic
    public static final int getDayOfWeek(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(7);
    }

    @JvmStatic
    public static final int getHourOf12HClock(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(10);
    }

    @JvmStatic
    public static final int getHourOf24HClock(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(11);
    }

    @JvmStatic
    public static final int getMinute(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(12);
    }

    @JvmStatic
    public static final int getSecond(long millis) {
        Calendar c2;
        Calendar calendar = c2 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTimeInMillis(millis);
        return c2.get(13);
    }

    @JvmStatic
    public static final long getExpireDeadTime(long millisToExpire) {
        return System.currentTimeMillis() + millisToExpire;
    }

    @JvmStatic
    @Nullable
    public static final String getTimeStringFromMillis(long timeMillis) {
        String format = "%04d-%02d-%02d %02d:%02d:%2d";
        return TimeUtils.getTimeStringFromMillis(timeMillis, format);
    }

    @JvmStatic
    @Nullable
    public static final String getTimeStringFromMillis(long timeMillis, @Nullable String format) {
        Calendar cal;
        if (format == null || format.length() == 0) {
            return null;
        }
        Calendar calendar = cal = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"cal");
        calendar.setTimeInMillis(timeMillis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String timeString = null;
        try {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = new Object[]{year, month, day, hour, min, sec};
            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            timeString = string;
        }
        catch (IllegalFormatException e) {
            Log.e((String)"TimeUtils", (String)"printStackTrace", (Throwable)e);
        }
        return timeString;
    }

    @JvmStatic
    @Nullable
    public static final String getFormatTimeString(long timeMillis, @Nullable String format) {
        Calendar cal;
        if (format == null || format.length() == 0) {
            return null;
        }
        Calendar calendar = cal = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"cal");
        calendar.setTimeInMillis(timeMillis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        String timeString = null;
        try {
            CharSequence charSequence = format;
            String string = "year";
            string = new Regex(string);
            String string2 = String.valueOf(year);
            charSequence = string.replace(charSequence, string2);
            string = "mon";
            string = new Regex(string);
            string2 = month < 10 ? "" + '0' + month : "" + month;
            charSequence = string.replace(charSequence, string2);
            string = "day";
            string = new Regex(string);
            string2 = day < 10 ? "" + '0' + day : "" + day;
            charSequence = string.replace(charSequence, string2);
            string = "hour";
            string = new Regex(string);
            string2 = hour < 10 ? "" + '0' + hour : "" + hour;
            charSequence = string.replace(charSequence, string2);
            string = "min";
            string = new Regex(string);
            string2 = min < 10 ? "" + '0' + min : "" + min;
            charSequence = string.replace(charSequence, string2);
            string = "sec";
            string = new Regex(string);
            string2 = sec < 10 ? "" + '0' + sec : "" + sec;
            timeString = string.replace(charSequence, string2);
        }
        catch (Exception e) {
            ULog.e("TimeUtils", "getFormatTimeString error! ", e, new Object[0]);
        }
        return timeString;
    }

    @JvmStatic
    @Nullable
    public static final String getPostTimeString(@NotNull Context context, long timeMillis, boolean showToday, boolean showSecond) {
        String string2;
        StringBuilder stringBuilder;
        Object[] objectArray;
        String string3;
        StringCompanionObject stringCompanionObject;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String sSpace = " ";
        String sToday = context.getString(R.string.str_today);
        String sYesterday = context.getString(R.string.str_yesterday);
        String sBeforeYesterday = context.getString(R.string.str_day_before_yesterday);
        String sShortDateFormat = context.getString(R.string.str_short_date_format);
        String sDateFormat = context.getString(R.string.str_date_format);
        Calendar current = Calendar.getInstance();
        Calendar post = Calendar.getInstance();
        Calendar calendar = current;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"current");
        calendar.setTimeInMillis(System.currentTimeMillis());
        Calendar calendar2 = post;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"post");
        calendar2.setTimeInMillis(timeMillis);
        int diffDays = current.get(6) - post.get(6);
        boolean isSameYear = post.get(1) == current.get(1);
        StringBuilder builder = new StringBuilder();
        if (diffDays > 0 || !isSameYear) {
            if (diffDays > 0 && diffDays <= 2) {
                builder.append(diffDays == 1 ? sYesterday : sBeforeYesterday);
                builder.append(sSpace);
            } else if (isSameYear) {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                String string4 = sShortDateFormat;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sShortDateFormat");
                string3 = string4;
                objectArray = new Object[]{post.get(2) + 1, post.get(5)};
                stringBuilder = builder;
                String string5 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                string2 = string5;
                stringBuilder.append(string2);
                builder.append(sSpace);
            } else {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                String string6 = sDateFormat;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sDateFormat");
                string3 = string6;
                objectArray = new Object[]{post.get(1), post.get(2) + 1, post.get(5)};
                stringBuilder = builder;
                String string7 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
                string2 = string7;
                stringBuilder.append(string2);
                builder.append(sSpace);
            }
        } else if (showToday) {
            builder.append(sToday);
            builder.append(sSpace);
        }
        if (showSecond) {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            String string8 = context.getString(R.string.str_time_format);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"context.getString(R.string.str_time_format)");
            string3 = string8;
            objectArray = new Object[]{post.get(11), post.get(12), post.get(13)};
            stringBuilder = builder;
            String string9 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"java.lang.String.format(format, *args)");
            string2 = string9;
            stringBuilder.append(string2);
        } else {
            stringCompanionObject = StringCompanionObject.INSTANCE;
            String string10 = context.getString(R.string.str_short_time_format);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"context.getString(R.string.str_short_time_format)");
            string3 = string10;
            objectArray = new Object[]{post.get(11), post.get(12)};
            stringBuilder = builder;
            String string11 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"java.lang.String.format(format, *args)");
            string2 = string11;
            stringBuilder.append(string2);
        }
        return builder.toString();
    }

    @JvmStatic
    private static final long checkOverflow(long t, long scale) {
        if (t > Long.MAX_VALUE / scale) {
            return Long.MAX_VALUE;
        }
        return t < Long.MIN_VALUE / scale ? Long.MIN_VALUE : t * scale;
    }

    @JvmStatic
    public static final long convertTimeToLong(@NotNull String time) {
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date2 = date = sdf.parse(time);
            if (date2 == null) {
                Intrinsics.throwNpe();
            }
            return date2.getTime();
        }
        catch (Exception e) {
            ULog.e("TimeUtils", (Function0<? extends Object>)((Function0)convertTimeToLong.1.INSTANCE), e);
            return 0L;
        }
    }

    @JvmStatic
    @NotNull
    public static final String converTimeToString(@Nullable Long s, @NotNull String pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Date date = new Date();
        Long l = s;
        if (l == null) {
            Intrinsics.throwNpe();
        }
        date.setTime(l);
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String string2 = sdf.format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sdf.format(date)");
        return string2;
    }

    @JvmStatic
    @Deprecated(message="use -- tv.athena.util.common.TimeUtils.getNowMills()")
    public static final int curSec() {
        long l = System.currentTimeMillis();
        return (int)(l / 1000L);
    }

    @JvmStatic
    public static final long formatTimeOutPut(@NotNull String dateStr) {
        List list;
        Object object;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)dateStr, (String)"dateStr");
        long startMilliSecond = 0L;
        if (BlankUtil.isBlank(dateStr)) {
            return startMilliSecond;
        }
        Object object2 = dateStr;
        String string2 = " ";
        string2 = new Regex(string2);
        int n = 0;
        object2 = string2.split((CharSequence)object2, n);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                object = it;
                if (object.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $receiver$iv = list;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] startPart = stringArray;
        String startDatePart = "";
        String startTimePart = "";
        String startHourPart = "";
        if (!BlankUtil.isBlank((Object)startPart)) {
            startDatePart = startPart[0];
            startTimePart = startPart[1];
        }
        if (!BlankUtil.isBlank(startTimePart) && StringsKt.indexOf$default((CharSequence)startTimePart, (String)":", (int)0, (boolean)false, (int)6, null) != -1) {
            List list2;
            Collection $receiver$iv2;
            object = startTimePart;
            String $i$a$1$dropLastWhile = ":";
            $i$a$1$dropLastWhile = new Regex($i$a$1$dropLastWhile);
            int $i$f$dropLastWhile = 0;
            object = $i$a$1$dropLastWhile.split((CharSequence)object, $i$f$dropLastWhile);
            if (!$receiver$iv2.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv2.listIterator($receiver$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$receiver$iv2, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $receiver$iv2 = list2;
            Collection collection2 = $receiver$iv2;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv2 = collection2;
            String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            startHourPart = stringArray2[0];
        }
        if (!BlankUtil.isBlank(startDatePart) && !BlankUtil.isBlank(startHourPart)) {
            startMilliSecond = TimeUtils.toMilliSecondTime(startDatePart + ' ' + startHourPart + ":00:00");
        }
        return startMilliSecond;
    }

    @JvmStatic
    public static final long toMilliSecondTime(@NotNull String dateStr) {
        Intrinsics.checkParameterIsNotNull((Object)dateStr, (String)"dateStr");
        SimpleDateFormat dateFormat = TimeUtils.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = dateFormat.parse(dateStr);
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"dateFormat.parse(dateStr)");
            return date.getTime();
        }
        catch (ParseException e) {
            ULog.e("ShenquUtils", "toMilliSecondTime ParseException e =", e, new Object[0]);
            return 0L;
        }
    }

    @JvmStatic
    @NotNull
    public static final SimpleDateFormat getSimpleDateFormat(@NotNull String format) {
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            SimpleDateFormat sdf = mSimpleDateFormatCache.get(format);
            if (sdf == null) {
                sdf = new SimpleDateFormat(format);
                Map map2 = mSimpleDateFormatCache;
                SimpleDateFormat simpleDateFormat = sdf;
                map2.put(format, simpleDateFormat);
            }
            return sdf;
        }
        return new SimpleDateFormat(format);
    }

    private TimeUtils() {
    }

    static {
        TimeUtils timeUtils;
        INSTANCE = timeUtils = new TimeUtils();
        mSimpleDateFormatCache = new HashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/TimeUtils$YEARS;", "", "()V", "toDays", "", "years", "toHours", "toMillis", "toMinutes", "toMonths", "toSeconds", "utils_release"})
    public static final class YEARS {
        public static final YEARS INSTANCE;

        public final long toMillis(long years) {
            return TimeUtils.checkOverflow(years, 31536000000L);
        }

        public final long toSeconds(long years) {
            return TimeUtils.checkOverflow(years, 31536000L);
        }

        public final long toMinutes(long years) {
            return TimeUtils.checkOverflow(years, 525600L);
        }

        public final long toHours(long years) {
            return TimeUtils.checkOverflow(years, 8760L);
        }

        public final long toDays(long years) {
            return TimeUtils.checkOverflow(years, 365L);
        }

        public final long toMonths(long years) {
            return TimeUtils.checkOverflow(years, 12L);
        }

        private YEARS() {
        }

        static {
            YEARS yEARS;
            INSTANCE = yEARS = new YEARS();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/TimeUtils$MONTHS;", "", "()V", "toDays", "", "months", "toHours", "toMillis", "toMinutes", "toSeconds", "toYears", "utils_release"})
    public static final class MONTHS {
        public static final MONTHS INSTANCE;

        public final long toMillis(long months) {
            return TimeUtils.checkOverflow(months, 2592000000L);
        }

        public final long toSeconds(long months) {
            return TimeUtils.checkOverflow(months, 2592000L);
        }

        public final long toMinutes(long months) {
            return TimeUtils.checkOverflow(months, 43200L);
        }

        public final long toHours(long months) {
            return TimeUtils.checkOverflow(months, 720L);
        }

        public final long toDays(long months) {
            return TimeUtils.checkOverflow(months, 30L);
        }

        public final long toYears(long months) {
            return months / 12L;
        }

        private MONTHS() {
        }

        static {
            MONTHS mONTHS;
            INSTANCE = mONTHS = new MONTHS();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/TimeUtils$DAYS;", "", "()V", "toHours", "", "days", "toMillis", "toMinutes", "toMonths", "toSeconds", "toYears", "utils_release"})
    public static final class DAYS {
        public static final DAYS INSTANCE;

        public final long toMillis(long days) {
            return TimeUtils.checkOverflow(days, 86400000L);
        }

        public final long toSeconds(long days) {
            return TimeUtils.checkOverflow(days, 86400L);
        }

        public final long toMinutes(long days) {
            return TimeUtils.checkOverflow(days, 1440L);
        }

        public final long toHours(long days) {
            return TimeUtils.checkOverflow(days, 24L);
        }

        public final long toMonths(long days) {
            return days / 30L;
        }

        public final long toYears(long days) {
            return days / 365L;
        }

        private DAYS() {
        }

        static {
            DAYS dAYS;
            INSTANCE = dAYS = new DAYS();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/TimeUtils$HOURS;", "", "()V", "toDays", "", "hours", "toMillis", "toMinutes", "toMonths", "toSeconds", "toYears", "utils_release"})
    public static final class HOURS {
        public static final HOURS INSTANCE;

        public final long toMillis(long hours) {
            return TimeUtils.checkOverflow(hours, 3600000L);
        }

        public final long toSeconds(long hours) {
            return TimeUtils.checkOverflow(hours, 3600L);
        }

        public final long toMinutes(long hours) {
            return TimeUtils.checkOverflow(hours, 60L);
        }

        public final long toDays(long hours) {
            return hours / 24L;
        }

        public final long toMonths(long hours) {
            return this.toDays(hours) / 30L;
        }

        public final long toYears(long hours) {
            return this.toDays(hours) / 365L;
        }

        private HOURS() {
        }

        static {
            HOURS hOURS;
            INSTANCE = hOURS = new HOURS();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/TimeUtils$MINUTES;", "", "()V", "toDays", "", "minutes", "toHours", "toMillis", "toMonths", "toSeconds", "toYears", "utils_release"})
    public static final class MINUTES {
        public static final MINUTES INSTANCE;

        public final long toMillis(long minutes) {
            return TimeUtils.checkOverflow(minutes, 60000L);
        }

        public final long toSeconds(long minutes) {
            return TimeUtils.checkOverflow(minutes, 60L);
        }

        public final long toHours(long minutes) {
            return minutes / 60L;
        }

        public final long toDays(long minutes) {
            return this.toHours(minutes) / 24L;
        }

        public final long toMonths(long minutes) {
            return this.toDays(minutes) / 30L;
        }

        public final long toYears(long minutes) {
            return this.toDays(minutes) / 365L;
        }

        private MINUTES() {
        }

        static {
            MINUTES mINUTES;
            INSTANCE = mINUTES = new MINUTES();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/TimeUtils$SECONDS;", "", "()V", "toDays", "", "seconds", "toHours", "toMillis", "toMinutes", "toMonths", "toYears", "utils_release"})
    public static final class SECONDS {
        public static final SECONDS INSTANCE;

        public final long toMillis(long seconds) {
            return TimeUtils.checkOverflow(seconds, 1000L);
        }

        public final long toMinutes(long seconds) {
            return seconds / 60L;
        }

        public final long toHours(long seconds) {
            return this.toMinutes(seconds) / 60L;
        }

        public final long toDays(long seconds) {
            return this.toHours(seconds) / 24L;
        }

        public final long toMonths(long seconds) {
            return this.toDays(seconds) / 30L;
        }

        public final long toYears(long seconds) {
            return this.toDays(seconds) / 365L;
        }

        private SECONDS() {
        }

        static {
            SECONDS sECONDS;
            INSTANCE = sECONDS = new SECONDS();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Ltv/athena/util/TimeUtils$MILLIS;", "", "()V", "toDays", "", "millis", "toHours", "toMinutes", "toMonths", "toSeconds", "toYears", "utils_release"})
    public static final class MILLIS {
        public static final MILLIS INSTANCE;

        public final long toSeconds(long millis) {
            return millis / 1000L;
        }

        public final long toMinutes(long millis) {
            return this.toSeconds(millis) / 60L;
        }

        public final long toHours(long millis) {
            return this.toMinutes(millis) / 60L;
        }

        public final long toDays(long millis) {
            return this.toHours(millis) / 24L;
        }

        public final long toMonths(long millis) {
            return this.toDays(millis) / 30L;
        }

        public final long toYears(long millis) {
            return this.toDays(millis) / 365L;
        }

        private MILLIS() {
        }

        static {
            MILLIS mILLIS;
            INSTANCE = mILLIS = new MILLIS();
        }
    }
}

