/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions.checker;

import android.content.Context;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.log.ULog;
import tv.athena.util.permissions.checker.PermissionTest;
import tv.athena.util.permissions.checker.SensorsTest;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ltv/athena/util/permissions/checker/SensorsTest;", "Ltv/athena/util/permissions/checker/PermissionTest;", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "SENSOR_EVENT_LISTENER", "tv/athena/util/permissions/checker/SensorsTest$SENSOR_EVENT_LISTENER$1", "Ltv/athena/util/permissions/checker/SensorsTest$SENSOR_EVENT_LISTENER$1;", "TAG", "", "test", "", "utils_release"})
public final class SensorsTest
implements PermissionTest {
    private final String TAG = "permissions_SensorsTest";
    private final SENSOR_EVENT_LISTENER.1 SENSOR_EVENT_LISTENER;
    private final Context mContext;

    @Override
    public boolean test() throws Throwable {
        Object object = this.mContext.getSystemService("sensor");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        SensorManager sensorManager = (SensorManager)object;
        try {
            Sensor heartRateSensor = sensorManager.getDefaultSensor(21);
            sensorManager.registerListener((SensorEventListener)this.SENSOR_EVENT_LISTENER, heartRateSensor, 3);
            sensorManager.unregisterListener((SensorEventListener)this.SENSOR_EVENT_LISTENER, heartRateSensor);
        }
        catch (Throwable e) {
            ULog.e(this.TAG, "", e, new Object[0]);
            PackageManager packageManager = this.mContext.getPackageManager();
            return !packageManager.hasSystemFeature("android.hardware.sensor.heartrate");
        }
        return true;
    }

    public SensorsTest(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.TAG = "permissions_SensorsTest";
        this.SENSOR_EVENT_LISTENER = new SensorEventListener(){

            public void onSensorChanged(@NotNull SensorEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            }

            public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
                Intrinsics.checkParameterIsNotNull((Object)sensor, (String)"sensor");
            }
        };
    }
}

