package tv.athena.live.player.statistics.http

import tv.athena.live.player.statistics.StatisticsReport
import tv.athena.live.utils.ALog

/**
 * create by dengqu 2020/6/3
 */
abstract class AbstractStatisticsHttp : IStatisticsHttp {
    companion object {
        @JvmStatic
        private val TAG = AbstractStatisticsHttp::class.java.simpleName
    }

    private var mRetryTime = 2
    private var mTestUrlAddr: String? = null

    private var statusCode = 0
    private var reasonPhrase: String? = null

    private fun getServerAddr(): String? {
        return if (StatisticsReport.instance.isDebug()) {
            getTestUrlAddr()
        } else {
            getUrlAddr()
        }
    }

    override fun setTestServer(testServer: String) {
        mTestUrlAddr = testServer
    }

    override fun sendSync(content: String): Boolean {
        ALog.i(TAG, "to send content = $content")
        return sendSyncByTrying(content)
    }

    protected fun sendSyncByTrying(content: String?): Boolean {
        return sendContent(getServerAddr(), content, mRetryTime)
    }

    protected operator fun get(urlAddr: String, content: String): Boolean {
        return getByUrlConn(urlAddr, content)
    }

    private fun getByUrlConn(urlAddr: String, content: String): Boolean {
        statusCode = -1
        reasonPhrase = null
        val resp = HttpUrlConnectionUtil.getByUrlConn(urlAddr, content)
        statusCode = resp.statusCode
        reasonPhrase = resp.reason
        return resp.isSucceed
    }

    override fun getLastStatusCode(): Int {
        return statusCode
    }

    protected abstract fun sendContent(var1: String?, var2: String?, var3: Int): Boolean

    protected abstract fun getUrlAddr(): String?

    open fun getTestUrlAddr(): String? {
        return mTestUrlAddr
    }

    override fun reset() {
        mRetryTime = 2
    }
}