package tv.athena.live.player.statistics.hiido.regularly

import tv.athena.live.player.statistics.hiido.AbstractHiidoContent

/**
 * 首次拉流-基本数据
 *create by dengqu 2020/6/4
 */
class RegularlyBasicDataContent private constructor() : AbstractHiidoContent() {
    private lateinit var mHiidoContent: AbstractHiidoContent

    private var mNt: Int = -1
    private var mSd: Int = -1
    private var mPt: Int = -1

    companion object {
        /**
         * 网络类型(wifi,2G,3G,4G)
         */
        private const val NT = "nt"

        /**
         * 统计时长
         * 进频道到当前时间点的时长。进频道失败也报（单位秒）
         */
        private const val SD = "sd"

        /**
         * 观看时长,从观看到当前的时间差，毫秒，play time
         *
         */
        private const val PT = "pt"
    }

    class RegularlyBasicDataContentBuilder {
        private val mBasicDataContent = RegularlyBasicDataContent()

        fun setAbstractHiidoContent(hiidoContent: AbstractHiidoContent): RegularlyBasicDataContentBuilder {
            mBasicDataContent.mHiidoContent = hiidoContent
            return this
        }

        fun setNt(nt: Int): RegularlyBasicDataContentBuilder {
            mBasicDataContent.mNt = nt
            return this
        }

        fun setSd(sd: Int): RegularlyBasicDataContentBuilder {
            mBasicDataContent.mSd = sd
            return this
        }

        fun setPt(pt: Int): RegularlyBasicDataContentBuilder {
            mBasicDataContent.mPt = pt
            return this
        }

        fun build(): RegularlyBasicDataContent {
            return mBasicDataContent
        }
    }

    override fun getContent(): String {
        return mHiidoContent.getContent() + "&" + buildContent()
    }

    private fun buildContent(): String {
        val contents = StringBuilder()
        contents.append(NT)
        contents.append("=")
        contents.append(mNt)
        contents.append("&")

        contents.append(SD)
        contents.append("=")
        contents.append(mSd)
        contents.append("&")

        contents.append(PT)
        contents.append("=")
        contents.append(mPt)

        return contents.toString()
    }
}