package tv.athena.live.player.statistics.hiido.fpflow

import tv.athena.live.player.statistics.hiido.AbstractHiidoContent

/**
 * 首次拉流-基本数据
 *create by dengqu 2020/6/4
 */
class BasicDataContent private constructor() : AbstractHiidoContent() {
    private lateinit var mHiidoContent: AbstractHiidoContent

    private var mNt: Int = -1
    private var mSd: Int = -1
    private var mCets: Int = -1
    private var mSetr: Int = -1
    private var mCode: Int = 0

    companion object {
        /**
         * 网络类型(wifi,2G,3G,4G)
         */
        private const val NT = "nt"

        /**
         * 统计时长
         * 进频道到当前时间点的时长。进频道失败也报（单位秒）
         */
        private const val SD = "sd"

        /**
         * 创建引擎到启动引擎延时
         *
         */
        private const val CETS = "cets"

        /**
         * 从启动引擎到设置URL延时
         */
        private const val SETR = "setr"

        /**
         * 错误码 0：正常首次拉流，1：进频道失败 2：用户主动离开房间
         */
        private const val CODE = "code"
    }

    class BasicDataContentBuilder {
        private val mBasicDataContent = BasicDataContent()

        fun setAbstractHiidoContent(hiidoContent: AbstractHiidoContent): BasicDataContentBuilder {
            mBasicDataContent.mHiidoContent = hiidoContent
            return this
        }

        fun setNt(nt: Int): BasicDataContentBuilder {
            mBasicDataContent.mNt = nt
            return this
        }

        fun setSd(sd: Int): BasicDataContentBuilder {
            mBasicDataContent.mSd = sd
            return this
        }

        fun setCets(cets: Int): BasicDataContentBuilder {
            mBasicDataContent.mCets = cets
            return this
        }

        fun setSetr(setr: Int): BasicDataContentBuilder {
            mBasicDataContent.mSetr = setr
            return this
        }

        fun setCode(code: Int): BasicDataContentBuilder {
            mBasicDataContent.mCode = code
            return this
        }

        fun build(): BasicDataContent {
            return mBasicDataContent
        }
    }

    override fun getContent(): String {
        return mHiidoContent.getContent() + "&" + buildContent()
    }

    private fun buildContent(): String {
        val contents = StringBuilder()
        contents.append(NT)
        contents.append("=")
        contents.append(mNt)
        contents.append("&")

        contents.append(SD)
        contents.append("=")
        contents.append(mSd)
        contents.append("&")

        contents.append(CETS)
        contents.append("=")
        contents.append(mCets)
        contents.append("&")

        contents.append(SETR)
        contents.append("=")
        contents.append(mSetr)
        contents.append("&")

        contents.append(CODE)
        contents.append("=")
        contents.append(mCode)
        return contents.toString()
    }
}