package tv.athena.live.player.statistics.hiido

import tv.athena.util.encode.MD5Utils
import java.net.URLEncoder

/**
 * 通过http直接上报到hiido必备的内容
 *create by dengqu 2020/6/4
 */
class BaseHiidoContent private constructor() : AbstractHiidoContent() {
    private var mAct: String = "-1"

    class BaseHiidoContentBuilder() {
        private var baseHiidoContent = BaseHiidoContent()

        fun setAct(act: String): BaseHiidoContentBuilder {
            baseHiidoContent.mAct = act
            return this
        }

        fun build(): BaseHiidoContent {
            return baseHiidoContent
        }
    }

    companion object {
        /**
         * 每条数据必须包含的act字段，这个需要自行申请
         * act申请链接是https://cloud.hiido.com/integration/act/create-apply
         */
        private const val ACT = "act"

        /**
         * time为时间戳，从1970年1月1日0点0分0秒开始到上报时的秒数
         */
        private const val TIME = "time"

        /**
         *key值等于参数act与time以及固定字符串(HiidoYYSystem)的md5加密字符串的小写形式
         */
        private const val KEY = "key"

        /**
         * 计算key md5有用
         */
        private const val HIIDOYYSYSTEM = "HiidoYYSystem"
    }

    override fun getContent(): String {
        val contents = StringBuilder()
        //act必须在第一位
        contents.append(ACT)
        contents.append("=")
        contents.append(URLEncoder.encode(mAct, "UTF-8"))
        contents.append("&")

        var time = (System.currentTimeMillis() / 1000).toString()
        contents.append(TIME)
        contents.append("=")
        contents.append(URLEncoder.encode(time, "UTF-8"))
        contents.append("&")

        contents.append(KEY)
        contents.append("=")
        contents.append(URLEncoder.encode(MD5Utils.getMD5String(mAct + time + HIIDOYYSYSTEM), "UTF-8"))
        return contents.toString()
    }
}