package tv.athena.live.player.statistics.threadpool

import tv.athena.live.utils.ALog
import java.util.Date

/**
 * create by dengqu 2020/6/3
 */
class SharedThreadTimer {
    private var canceled = false
    fun schedule(task: SharedTimerTask, delay: Long) {
        require(delay >= 0L) { "Negative delay." }
        sched(task, delay, 0L)
    }

    private fun sched(task: SharedTimerTask, delay: Long, period: Long) {
        val ir = InnerRun(task, period)
        synchronized(task.lock) {
            task.nextExecutionTime = System.currentTimeMillis() + delay
            task.period = period
        }
        ThreadPool.pool?.execute(ir, delay)
    }

    fun schedule(task: SharedTimerTask, time: Date) {
        var delay = time.time - System.currentTimeMillis()
        if (delay < 0L) {
            delay = 0L
        }
        sched(task, delay, 0L)
    }

    fun schedule(task: SharedTimerTask, delay: Long, period: Long) {
        require(delay >= 0L) { "Negative delay." }
        require(period > 0L) { "Non-positive period." }
    }

    fun schedule(task: SharedTimerTask, firstTime: Date, period: Long) {
        require(period > 0L) { "Non-positive period." }
        var delay = firstTime.time - System.currentTimeMillis()
        if (delay < 0L) {
            delay = 0L
        }
        sched(task, delay, period)
    }

    fun cancel() {
        canceled = true
    }

    internal inner class InnerRun(private val task: SharedTimerTask, private val period: Long) : Runnable {
        override fun run() {
            if (!canceled) {
                try {
                    synchronized(task.lock) {
                        if (task.state == 3) {
                            return
                        }
                        task.nextExecutionTime = System.currentTimeMillis() + period
                        task.run()
                        task.nextExecutionTime = System.currentTimeMillis() + period
                    }
                } catch (var4: Throwable) {
                    ALog.e(TAG, "run", var4)
                }
                if (period > 0L) {
                    ThreadPool.pool?.execute(this, period)
                }
            }
        }
    }

    companion object {
        private val TAG = SharedThreadTimer::class.java.simpleName
    }
}