package tv.athena.live.player.statistics.http

import android.text.TextUtils
import tv.athena.live.basesdk.config.BaseDataConfig
import tv.athena.live.utils.ALog

/**
 * create by dengqu 2020/6/3
 */
class HiidoStatisticsHttpUtil : AbstractStatisticsHttp() {
    override fun sendContent(url: String?, content: String?, tryTimes: Int): Boolean {
        if (url == null) {
            ALog.e(TAG, "url == null")
            return false
        }
        if (content == null) {
            ALog.e(TAG, "content == null")
            return false
        }
        ALog.i(TAG, "hiido service address is $url")
        var tryTimes = tryTimes
        val initialTimes = tryTimes
        do {
            try {
                if (initialTimes != tryTimes) {
                }
                if (this[url!!, content!!]) {
                    ALog.i(TAG, "Successfully sent $content to $url")
                    return true
                }
                ALog.i(TAG, "Failed to sent $content to $url")
            } catch (var6: Throwable) {
                ALog.e(TAG, "sendContent exception", var6)
            }
        } while (tryTimes-- > 0)
        return false
    }

    override fun getUrlAddr(): String? {
        return if (TextUtils.isEmpty(BaseDataConfig.getHiidoUrl())) {
            URL_SERVICE
        } else {
            BaseDataConfig.getHiidoUrl()
        }
    }

    override fun getTestUrlAddr(): String? {
        return testUrlAddr
    }

    companion object {
        private const val TAG = "HiidoStatisticsHttpUtil"
        private const val URL_SERVICE = "http://hlog.hiido.com/c.gif"
        private const val testUrlAddr = "http://datatest.hiido.com/c.gif"
    }
}