package tv.athena.live.player.statistics.hiido.regularly

import tv.athena.live.player.statistics.hiido.AbstractHiidoContent
import tv.athena.live.player.statistics.hiido.fpflow.FpflowCommonContent
import java.net.URLEncoder

/**
 * 定时上报-公共部分
 * @link{FpflowCommonContent}的 *create by dengqu 2020/6/24
 */
class RegularlyCommonContent private constructor() : AbstractHiidoContent() {

    /**
     * 头部部分
     */
    private var mFpflowCommonContent: FpflowCommonContent? = null
    private var mOs: String = "-1"
    private var mAnchorUid: String = "-1"

    companion object {
        /**
         * 操作系统 - string
         */
        private const val OS = "os"

        /**
         * 主播UID列表，多个用英文逗号隔开 - string
         */
        private const val ANCHOR_UID = "anchor_uid"
    }

    class RegularlyCommonContentBuilder {
        private var regularlyCommonContent = RegularlyCommonContent()

        fun setFpflowCommonContent(fpflowCommonContent: FpflowCommonContent): RegularlyCommonContentBuilder {
            regularlyCommonContent.mFpflowCommonContent = fpflowCommonContent
            return this
        }

        fun setOs(os: String): RegularlyCommonContentBuilder {
            regularlyCommonContent.mOs = os
            return this
        }

        fun setAnchorUid(anchorUid: String): RegularlyCommonContentBuilder {
            regularlyCommonContent.mAnchorUid = anchorUid
            return this
        }

        fun build(): RegularlyCommonContent {
            return regularlyCommonContent
        }
    }

    override fun getContent(): String {
        return mFpflowCommonContent?.getContent() + "&" + buildContent()
    }

    private fun buildContent(): String {
        val contents = StringBuilder()
        contents.append(OS)
        contents.append("=")
        contents.append(URLEncoder.encode(mOs, "UTF-8"))
        contents.append("&")

        contents.append(ANCHOR_UID)
        contents.append("=")
        contents.append(URLEncoder.encode(mAnchorUid, "UTF-8"))

        return contents.toString()
    }
}