package tv.athena.live.player.statistics.hiido.fpflow

import tv.athena.live.player.statistics.hiido.AbstractHiidoContent

/**
 *create by dengqu 2020/6/4
 */
class LinkCorrelationContent private constructor() : AbstractHiidoContent() {
    private lateinit var mHiidoContent: AbstractHiidoContent
    private var mCugi: Int = -1
    private var mChps: Int = -1
    private var mIsSupportQuic: Boolean = false

    companion object {
        private const val CUGI = "cugi"
        private const val CHPS = "chps"
    }

    class LinkCorrelationContentBuilder {
        private val mLinkCorrelationContent = LinkCorrelationContent()

        fun setAbstractHiidoContent(hiidoContent: AbstractHiidoContent): LinkCorrelationContentBuilder {
            mLinkCorrelationContent.mHiidoContent = hiidoContent
            return this
        }

        fun setCugi(cugi: Int): LinkCorrelationContentBuilder {
            mLinkCorrelationContent.mCugi = cugi
            return this
        }

        fun setChps(chps: Int): LinkCorrelationContentBuilder {
            mLinkCorrelationContent.mChps = chps
            return this
        }

        fun setIsSupportQuic(isSupportQuic: Boolean): LinkCorrelationContentBuilder {
            mLinkCorrelationContent.mIsSupportQuic = isSupportQuic
            return this
        }

        fun build(): LinkCorrelationContent {
            return mLinkCorrelationContent
        }
    }

    override fun getContent(): String {
        return if (mIsSupportQuic) {
            mHiidoContent.getContent()
        } else {
            mHiidoContent.getContent() + "&" + buildContent()
        }
    }

    private fun buildContent(): String {
        val contents = StringBuilder()
        contents.append(CUGI)
        contents.append("=")
        contents.append(mCugi)
        contents.append("&")

        contents.append(CHPS)
        contents.append("=")
        contents.append(mChps)
        return contents.toString()
    }
}