package tv.athena.live.player.statistics.hiido.fpflow

import tv.athena.live.player.statistics.hiido.AbstractHiidoContent
import java.net.URLEncoder

/**
 * 首次拉流-公共
 *create by dengqu 2020/6/4
 */
class FpflowCommonContent private constructor() : AbstractHiidoContent() {
    private lateinit var mHiidoContent: AbstractHiidoContent
    private var mAppid: Long = -1L
    private var mScene: Int = -1
    private var mEuid: String = "-1"
    private var mUrl: String = "-1"
    private var mCln: String = "-1"
    private var mCtype: Int = -1
    private var mVer: String = "-1"
    private var mInfo: String = "-1"
    private var mAppinfo: String = "-1"
    private var mUUid: String = "-"
    private var mHdid: String = "-1"
    private var mPkg: String = "-1"
    private var mQxd: String = "-1"
    private var mFd1: String = "-1"
    private var mFd2: String = "-1"
    private var mfbl: String = "-1"
    private var mOsv: String = "-1"
    private var mCdps: String = "-1"

    companion object {
        /**
         * 平台类型-ANDROID
         */
        const val ANDROID_YY = 2

        /**
         * 业务ID
         * bigint
         */
        private const val APPID = "appid"

        /**
         *场景ID
         * int
         * 服务端有
         * 业务设置
         */
        private const val SCENE = "scene"

        /**
         * 用户ID
         * string
         */
        private const val EUID = "euid"

        /**
         * 业务设置的url
         * string
         * 拉流URL
         */
        private const val URL = "url"

        /**
         * 频道房间号
         * string
         * 业务需要的房间
         */
        private const val CLN = "cln"

        /**
         * 平台类型 android ios pcyy
         * int
         * 熊雄：需要统一枚举表（int）ANDROID_YY, MediaUtils::GetClientType
         */
        private const val CTYPE = "ctype"

        /**
         * 播放器版本
         * string
         * 播放器的版本号播放器提供
         */
        private const val VER = "ver"

        /**
         * 手机品牌型号信息 规则 MANUFACTURER + "_" + MODEL
         * string
         * 熊雄 拿规则- UserInfo::initUserInfo, phoneInfo
         */
        private const val INFO = "info"

        /**
         * app版本信息，不能为空
         * string
         * 业务软件版本号，他们自己要规范-(YYDeviceInfo)createDeviceInfo,
         */
        private const val APPINFO = "appinfo"

        /**
         * 唯一识别id
         */
        private const val UUID = "uuid"

        /**
         * 设备id
         */
        private const val HDID = "hdid"

        /**
         * 包名
         */
        private const val PKG = "pkg"

        /**
         * 视频分辨率
         */
        private const val QXD = "qxd"

        /**
         * 自定义字段1 hago可以用这个字段上传机器性能
         */
        private const val FD1 = "fd1"

        /**
         * 自定义字段2 hago可以用这个字段上传机器性能
         */
        private const val FD2 = "fd2"

        /**
         * 手机分辨率
         */
        private const val FBL = "fbl"

        /**
         * 系统版本
         */
        private const val OSV = "osv"

        /**
         * cdn播放版本
         */
        private const val CDPS = "cdps"
    }

    class FpflowCommonContentBuilder {
        private var fpflowCommonContent: FpflowCommonContent = FpflowCommonContent()

        fun setAbstractHiidoContent(hiidoContent: AbstractHiidoContent): FpflowCommonContentBuilder {
            fpflowCommonContent.mHiidoContent = hiidoContent
            return this
        }

        fun setAppid(appid: Long): FpflowCommonContentBuilder {
            fpflowCommonContent.mAppid = appid
            return this
        }

        fun setScene(scene: Int): FpflowCommonContentBuilder {
            fpflowCommonContent.mScene = scene
            return this
        }

        fun setEuid(euid: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mEuid = euid
            return this
        }

        fun setUrl(url: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mUrl = url
            return this
        }

        fun setCln(cln: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mCln = cln
            return this
        }

        fun setCtype(ctype: Int): FpflowCommonContentBuilder {
            fpflowCommonContent.mCtype = ctype
            return this
        }

        fun setVer(ver: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mVer = ver
            return this
        }

        fun setInfo(info: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mInfo = info
            return this
        }

        fun setAppinfo(appinfo: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mAppinfo = appinfo
            return this
        }

        fun setUUid(uuid: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mUUid = uuid
            return this
        }

        fun setHdid(hdid: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mHdid = hdid
            return this
        }

        fun setPKg(pkg: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mPkg = pkg
            return this
        }

        fun setQxd(qxd: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mQxd = qxd
            return this
        }

        fun setFd1(fd1: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mFd1 = fd1
            return this
        }

        fun setFd2(fd2: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mFd2 = fd2
            return this
        }

        fun setFbl(fbl: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mfbl = fbl
            return this
        }

        fun setOsv(osv: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mOsv = osv
            return this
        }

        fun setCdps(cdps: String): FpflowCommonContentBuilder {
            fpflowCommonContent.mCdps = cdps
            return this
        }

        fun build(): FpflowCommonContent {
            return fpflowCommonContent
        }
    }

    override fun getContent(): String {
        return mHiidoContent.getContent() + "&" + buildContent()
    }

    private fun buildContent(): String {
        val contents = StringBuilder()
        contents.append(APPID)
        contents.append("=")
        contents.append(mAppid)
        contents.append("&")

        contents.append(SCENE)
        contents.append("=")
        contents.append(mScene)
        contents.append("&")

        contents.append(EUID)
        contents.append("=")
        contents.append(URLEncoder.encode(mEuid, "UTF-8"))
        contents.append("&")

        contents.append(URL)
        contents.append("=")
        contents.append(URLEncoder.encode(mUrl, "UTF-8"))
        contents.append("&")

        contents.append(CLN)
        contents.append("=")
        contents.append(URLEncoder.encode(mCln, "UTF-8"))
        contents.append("&")

        contents.append(CTYPE)
        contents.append("=")
        contents.append(mCtype)
        contents.append("&")

        contents.append(VER)
        contents.append("=")
        contents.append(URLEncoder.encode(mVer, "UTF-8"))
        contents.append("&")

        contents.append(INFO)
        contents.append("=")
        contents.append(URLEncoder.encode(mInfo, "UTF-8"))
        contents.append("&")

        contents.append(APPINFO)
        contents.append("=")
        contents.append(URLEncoder.encode(mAppinfo, "UTF-8"))
        contents.append("&")

        contents.append(UUID)
        contents.append("=")
        contents.append(URLEncoder.encode(mUUid, "UTF-8"))
        contents.append("&")

        contents.append(HDID)
        contents.append("=")
        contents.append(URLEncoder.encode(mHdid, "UTF-8"))
        contents.append("&")

        contents.append(PKG)
        contents.append("=")
        contents.append(URLEncoder.encode(mPkg, "UTF-8"))
        contents.append("&")

        contents.append(QXD)
        contents.append("=")
        contents.append(URLEncoder.encode(mQxd, "UTF-8"))
        contents.append("&")

        contents.append(FD1)
        contents.append("=")
        contents.append(URLEncoder.encode(mFd1, "UTF-8"))
        contents.append("&")

        contents.append(FD2)
        contents.append("=")
        contents.append(URLEncoder.encode(mFd2, "UTF-8"))
        contents.append("&")

        contents.append(FBL)
        contents.append("=")
        contents.append(URLEncoder.encode(mfbl, "UTF-8"))
        contents.append("&")

        contents.append(OSV)
        contents.append("=")
        contents.append(URLEncoder.encode(mOsv, "UTF-8"))
        contents.append("&")

        contents.append(CDPS)
        contents.append("=")
        contents.append(URLEncoder.encode(mCdps, "UTF-8"))

        return contents.toString()
    }
}