package tv.athena.live.player.statistics

import android.text.TextUtils
import tv.athena.live.player.statistics.http.HiidoStatisticsHttpUtil
import tv.athena.live.player.statistics.threadpool.ThreadPool
import tv.athena.live.utils.ALog

/**
 *create by dengqu 2020/6/3
 */
class StatisticsReport {
    private var mHiidoStatisticsHttpUtil: HiidoStatisticsHttpUtil? = null

    private constructor() {
        mHiidoStatisticsHttpUtil = HiidoStatisticsHttpUtil()
    }

    private var mDebug = false
    fun init(isDebug: Boolean) {
        this.mDebug = isDebug
    }

    companion object {
        @JvmStatic
        private val TAG = StatisticsReport::class.java.simpleName

        val instance: StatisticsReport by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            StatisticsReport()
        }

        /**
         *act - 新(中台)播放器进频道统计
         */
        const val LPF_PLAYER_FIRST_ACCESS = "lpfplayerfirstaccess"

        /**
         * act - 新(中台)播放器定时上报
         */
        const val LPF_PLAYER_DOWNLOAD = "lpfplayerdownload"

        /**
         * act - 业务流量定时上报
         */
        const val LPF_PLAYER_BUSINESSFLOW = "lpfplayerbusinessflow"

        /**
         * act - 主播卡顿上报
         */
        const val LPF_CATON_PROMPTFLOW = "lpfcatonpromptflow"

        /**
         * act - 主播首次推流
         */
        const val LPF_ANCHOR_FIRSTACCESS = "lpfanchorfirstaccess"

        /**
         * act - 主播定时上报
         */
        const val LPF_ANCHORDOWNLOAD = "lpfanchordownload"
    }

    fun doReport(content: String?) {
        if (TextUtils.isEmpty(content)) {
            ALog.e(TAG, "context is empty")
            return
        }
        content?.let {
            ThreadPool.pool?.execute(Runnable { mHiidoStatisticsHttpUtil?.sendSync(it) })
        }
    }

    /**
     * 同步上报
     */
    fun doReportSync(content: String?) {
        if (TextUtils.isEmpty(content)) {
            ALog.e(TAG, "context is empty")
            return
        }
        content?.let {
            mHiidoStatisticsHttpUtil?.sendSync(it)
        }
    }

    /**
     * 直接耗时操作
     */
    fun doReport(runnable: Runnable?) {
        runnable?.let {
            ThreadPool.pool?.execute(it)
            ALog.i(TAG, "doReport runnable--------------")
        }
    }

    fun isDebug(): Boolean {
        return mDebug
    }
}