/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.player.statistics.threadpool;

import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.live.player.statistics.threadpool.SharedTimerTask;
import tv.athena.live.player.statistics.threadpool.ThreadPool;
import tv.athena.live.utils.ALog;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltv/athena/live/player/statistics/threadpool/SharedThreadTimer;", "", "()V", "canceled", "", "cancel", "", "sched", "task", "Ltv/athena/live/player/statistics/threadpool/SharedTimerTask;", "delay", "", "period", "schedule", "time", "Ljava/util/Date;", "firstTime", "Companion", "InnerRun", "statistics_release"})
public final class SharedThreadTimer {
    private boolean canceled;
    private static final String TAG;
    public static final Companion Companion;

    public final void schedule(@NotNull SharedTimerTask task, long delay) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        boolean bl = delay >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Negative delay.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.sched(task, delay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sched(SharedTimerTask task, long delay, long period) {
        block3: {
            InnerRun ir = new InnerRun(task, period);
            Object object = task.getLock();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                task.setNextExecutionTime(System.currentTimeMillis() + delay);
                task.setPeriod(period);
                Unit unit = Unit.INSTANCE;
            }
            ThreadPool threadPool = ThreadPool.Companion.getPool();
            if (threadPool == null) break block3;
            threadPool.execute(ir, delay);
        }
    }

    public final void schedule(@NotNull SharedTimerTask task, @NotNull Date time) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        long delay = time.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        this.sched(task, delay, 0L);
    }

    public final void schedule(@NotNull SharedTimerTask task, long delay, long period) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        boolean bl = delay >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Negative delay.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = period > 0L;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Non-positive period.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final void schedule(@NotNull SharedTimerTask task, @NotNull Date firstTime, long period) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)firstTime, (String)"firstTime");
        boolean bl = period > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Non-positive period.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long delay = firstTime.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        this.sched(task, delay, period);
    }

    public final void cancel() {
        this.canceled = true;
    }

    static {
        Companion = new Companion(null);
        TAG = SharedThreadTimer.class.getSimpleName();
    }

    public static final /* synthetic */ void access$setCanceled$p(SharedThreadTimer $this, boolean bl) {
        $this.canceled = bl;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltv/athena/live/player/statistics/threadpool/SharedThreadTimer$InnerRun;", "Ljava/lang/Runnable;", "task", "Ltv/athena/live/player/statistics/threadpool/SharedTimerTask;", "period", "", "(Ltv/athena/live/player/statistics/threadpool/SharedThreadTimer;Ltv/athena/live/player/statistics/threadpool/SharedTimerTask;J)V", "run", "", "statistics_release"})
    public final class InnerRun
    implements Runnable {
        private final SharedTimerTask task;
        private final long period;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                if (SharedThreadTimer.this.canceled) break block9;
                try {
                    Object object = this.task.getLock();
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        if (this.task.getState() == 3) {
                            return;
                        }
                        this.task.setNextExecutionTime(System.currentTimeMillis() + this.period);
                        this.task.run();
                        this.task.setNextExecutionTime(System.currentTimeMillis() + this.period);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (Throwable var4) {
                    ALog.e((String)TAG, (String)"run", (Throwable)var4);
                }
                if (this.period > 0L) {
                    ThreadPool threadPool = ThreadPool.Companion.getPool();
                    if (threadPool != null) {
                        threadPool.execute(this, this.period);
                    }
                }
            }
        }

        public InnerRun(SharedTimerTask task, long period) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            this.task = task;
            this.period = period;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltv/athena/live/player/statistics/threadpool/SharedThreadTimer$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "statistics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

