/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.player.statistics.threadpool;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.live.player.statistics.threadpool.ExecutorProvider;
import tv.athena.live.player.statistics.threadpool.IQueueTaskExecutor;
import tv.athena.live.player.statistics.threadpool.IYYTaskExecutor;
import tv.athena.live.player.statistics.threadpool.SharedThreadTimer;
import tv.athena.live.utils.ALog;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0018\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J&\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u001e\u0018\u00010 J&\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u001e\u0018\u00010 R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Ltv/athena/live/player/statistics/threadpool/ThreadPool;", "", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "singleExecutorService", "singleTaskExecutor", "Ltv/athena/live/player/statistics/threadpool/IQueueTaskExecutor;", "spareExecutor", "taskExecutor", "Ltv/athena/live/player/statistics/threadpool/IYYTaskExecutor;", "timer", "Ltv/athena/live/player/statistics/threadpool/SharedThreadTimer;", "getTimer", "()Ltv/athena/live/player/statistics/threadpool/SharedThreadTimer;", "execute", "", "run", "Ljava/lang/Runnable;", "delayMillis", "", "runnable", "executeQueue", "getSpareExecutor", "shutdown", "shutdownNow", "submit", "Ljava/util/concurrent/Future;", "T", "callable", "Ljava/util/concurrent/Callable;", "submitQueue", "Companion", "statistics_release"})
public final class ThreadPool {
    private ExecutorService executorService;
    private ExecutorService singleExecutorService;
    private ScheduledExecutorService scheduledExecutorService;
    private IYYTaskExecutor taskExecutor;
    private IQueueTaskExecutor singleTaskExecutor;
    private ScheduledExecutorService spareExecutor;
    @NotNull
    private final SharedThreadTimer timer = new SharedThreadTimer();
    private static final String TAG;
    @Nullable
    private static ThreadPool pool;
    public static final Companion Companion;

    @NotNull
    public final SharedThreadTimer getTimer() {
        return this.timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScheduledExecutorService getSpareExecutor() {
        if (this.spareExecutor == null) {
            ThreadPool threadPool = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (threadPool) {
                boolean bl3 = false;
                ScheduledExecutorService scheduledExecutorService = this.spareExecutor != null ? this.spareExecutor : (this.spareExecutor = Executors.newScheduledThreadPool(1));
                return scheduledExecutorService;
            }
        }
        return this.spareExecutor;
    }

    public final void execute(@Nullable Runnable runnable) {
        if (this.taskExecutor != null) {
            try {
                IYYTaskExecutor iYYTaskExecutor = this.taskExecutor;
                if (iYYTaskExecutor != null) {
                    iYYTaskExecutor.execute(runnable, 0L);
                }
            }
            catch (Throwable var3) {
                ScheduledExecutorService scheduledExecutorService = this.getSpareExecutor();
                if (scheduledExecutorService == null) {
                    Intrinsics.throwNpe();
                }
                scheduledExecutorService.execute(runnable);
            }
        } else {
            ExecutorService executorService = this.executorService;
            if (executorService == null) {
                Intrinsics.throwNpe();
            }
            executorService.execute(runnable);
        }
    }

    public final void executeQueue(@Nullable Runnable runnable) {
        if (this.singleTaskExecutor != null) {
            try {
                IQueueTaskExecutor iQueueTaskExecutor = this.singleTaskExecutor;
                if (iQueueTaskExecutor != null) {
                    iQueueTaskExecutor.execute(runnable, 0L);
                }
            }
            catch (Throwable var3) {
                ScheduledExecutorService scheduledExecutorService = this.getSpareExecutor();
                if (scheduledExecutorService == null) {
                    Intrinsics.throwNpe();
                }
                scheduledExecutorService.execute(runnable);
            }
        } else {
            ExecutorService executorService = this.singleExecutorService;
            if (executorService == null) {
                Intrinsics.throwNpe();
            }
            executorService.execute(runnable);
        }
    }

    @NotNull
    public final <T> Future<T> submit(@Nullable Callable<T> callable) {
        RunnableFuture ftask = new FutureTask<T>(callable);
        this.execute(ftask);
        return ftask;
    }

    @NotNull
    public final <T> Future<T> submitQueue(@Nullable Callable<T> callable) {
        RunnableFuture ftask = new FutureTask<T>(callable);
        this.executeQueue(ftask);
        return ftask;
    }

    public final void shutdownNow() {
        if (this.executorService != null) {
            ExecutorService executorService = this.executorService;
            if (executorService != null) {
                executorService.shutdownNow();
            }
        }
        if (this.singleExecutorService != null) {
            ExecutorService executorService = this.singleExecutorService;
            if (executorService != null) {
                executorService.shutdownNow();
            }
        }
        if (this.scheduledExecutorService != null) {
            ScheduledExecutorService scheduledExecutorService = this.scheduledExecutorService;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
        }
        if (this.spareExecutor != null) {
            ScheduledExecutorService scheduledExecutorService = this.spareExecutor;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
            this.spareExecutor = null;
        }
    }

    public final void shutdown() {
        if (this.executorService != null) {
            ExecutorService executorService = this.executorService;
            if (executorService != null) {
                executorService.shutdown();
            }
        }
        if (this.singleExecutorService != null) {
            ExecutorService executorService = this.singleExecutorService;
            if (executorService != null) {
                executorService.shutdown();
            }
        }
        if (this.scheduledExecutorService != null) {
            ScheduledExecutorService scheduledExecutorService = this.scheduledExecutorService;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdown();
            }
        }
        if (this.spareExecutor != null) {
            ScheduledExecutorService scheduledExecutorService = this.spareExecutor;
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdown();
            }
            this.spareExecutor = null;
        }
    }

    public final void execute(@NotNull Runnable run, long delayMillis) {
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)run, (String)"run");
            try {
                if (this.taskExecutor != null) {
                    try {
                        IYYTaskExecutor iYYTaskExecutor = this.taskExecutor;
                        if (iYYTaskExecutor != null) {
                            iYYTaskExecutor.execute(run, delayMillis);
                        }
                        break block8;
                    }
                    catch (Throwable var5) {
                        ScheduledExecutorService scheduledExecutorService = this.getSpareExecutor();
                        if (scheduledExecutorService == null) {
                            Intrinsics.throwNpe();
                        }
                        scheduledExecutorService.schedule(run, delayMillis, TimeUnit.MILLISECONDS);
                    }
                    break block8;
                }
                ScheduledExecutorService scheduledExecutorService = this.scheduledExecutorService;
                if (scheduledExecutorService == null) {
                    Intrinsics.throwNpe();
                }
                scheduledExecutorService.schedule(run, delayMillis, TimeUnit.MILLISECONDS);
            }
            catch (Throwable var6) {
                ALog.e((String)TAG, (String)"execute", (Throwable)var6);
            }
        }
    }

    private ThreadPool() {
        if (ExecutorProvider.getIyyTaskExecutor() == null) {
            this.executorService = Executors.newFixedThreadPool(5);
            this.singleExecutorService = Executors.newSingleThreadExecutor();
            this.scheduledExecutorService = Executors.newScheduledThreadPool(1, 1.INSTANCE);
        } else {
            IYYTaskExecutor iYYTaskExecutor = this.taskExecutor = ExecutorProvider.getIyyTaskExecutor();
            if (iYYTaskExecutor == null) {
                Intrinsics.throwNpe();
            }
            this.singleTaskExecutor = iYYTaskExecutor.createAQueueExcuter();
            if (this.singleTaskExecutor == null) {
                this.singleExecutorService = Executors.newSingleThreadExecutor();
            }
        }
    }

    static {
        Companion = new Companion(null);
        TAG = ThreadPool.class.getSimpleName();
    }

    public /* synthetic */ ThreadPool(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ltv/athena/live/player/statistics/threadpool/ThreadPool$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "<set-?>", "Ltv/athena/live/player/statistics/threadpool/ThreadPool;", "pool", "getPool", "()Ltv/athena/live/player/statistics/threadpool/ThreadPool;", "setPool", "(Ltv/athena/live/player/statistics/threadpool/ThreadPool;)V", "statistics_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ThreadPool getPool() {
            if (pool == null) {
                Class<ThreadPool> var0 = ThreadPool.class;
                Class<ThreadPool> clazz = ThreadPool.class;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (clazz) {
                    boolean bl3 = false;
                    if (pool == null) {
                        pool = new ThreadPool(null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return pool;
        }

        private final void setPool(ThreadPool threadPool) {
            pool = threadPool;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

