package tv.athena.live.player.statistics.threadpool

/**
 * create by dengqu 2020/6/3
 */
abstract class SharedTimerTask : Runnable {
    val lock = Any()
    var state = 0
    var period: Long = 0
    var nextExecutionTime: Long = 0
    fun cancel(): Boolean {
        synchronized(lock) {
            val result = state == 1
            state = 3
            return result
        }
    }

    fun scheduledExecutionTime(): Long {
        synchronized(lock) { return nextExecutionTime }
    }

    companion object {
        const val VIRGIN = 0
        const val SCHEDULED = 1
        const val EXECUTED = 2
        const val CANCELLED = 3
    }
}