package tv.athena.live.player.statistics.http;

import android.os.Build;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

import javax.net.ssl.HttpsURLConnection;

import tv.athena.live.utils.ALog;

/**
 * create by dengqu 2020/6/3
 */
public class HttpUrlConnectionUtil {
    private final static String TAG = HttpUrlConnectionUtil.class.getSimpleName();

    private static final Pattern ipv4Pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");

    public HttpUrlConnectionUtil() {
    }

    public static String get(String url, Map<String, String> params) throws IOException {
        String paramsStr = null;
        if (params != null && params.size() > 0) {
            int i = 0;
            StringBuffer sb = new StringBuffer();

            Map.Entry entry;
            for (Iterator var5 = params.entrySet().iterator(); var5.hasNext();
                 sb.append((String) entry.getKey())
                     .append("=").append((String) entry.getValue())) {
                entry = (Map.Entry) var5.next();
                if (i++ > 0) {
                    sb.append("&");
                }
            }

            paramsStr = sb.toString();
            sb.setLength(0);
        }

        return getByUrlConn(url, paramsStr).result;
    }

    public static HttpUrlConnectionUtil.HttpResp getByUrlConn(String urlAddr, String content)
        throws IOException {
        HttpUrlConnectionUtil.HttpResp resp = new HttpUrlConnectionUtil.HttpResp();
        HttpURLConnection urlConn = null;
        DataOutputStream dos = null;
        InputStream is = null;

        try {
            if (content != null && content.length() > 0) {
                urlAddr = String.format("%s?%s", urlAddr, content);
            }
            urlConn = urlToUrlConnection(urlAddr);
            urlConn.setConnectTimeout(30000);
            urlConn.setReadTimeout(60000);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("GET");
            urlConn.setInstanceFollowRedirects(true);
            urlConn.connect();
            resp.isSucceed = urlConn.getResponseCode() == 200;
            resp.statusCode = urlConn.getResponseCode();
            resp.reason = urlConn.getResponseMessage();
            if (urlConn.getResponseCode() == 200) {
                ALog.i(TAG, "get url=[" + urlAddr + "] is ok");
                is = urlConn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                boolean var8 = false;

                int len;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }

                resp.result = new String(bao.toByteArray(), "UTF-8");
                ALog.i(TAG, "the result is %s" + resp.result);
                bao.close();
            } else {
                ALog.w(TAG,
                    "http get [" + urlAddr + "] error! status:" + urlConn.getResponseCode());
            }
        } catch (Throwable var17) {
            ALog.e(TAG, "getByUrlConn", var17);
        } finally {
            try {
                if (urlConn != null) {
                    urlConn.disconnect();
                    urlConn = null;
                }

                if (dos != null) {
                    ((DataOutputStream) dos).close();
                    dos = null;
                }

                if (is != null) {
                    is.close();
                    is = null;
                }
            } catch (Throwable var16) {
                ALog.e(TAG, "getByUrlConn", var16);
            }

        }

        return resp;
    }

    public static boolean isIpAddress(String host) {
        return ipv4Pattern.matcher(host).matches();
    }

    public static HttpURLConnection urlToUrlConnection(String urlAddr) throws IOException {
        URL url = new URL(urlAddr);
        if (Build.VERSION.SDK_INT <= 27 ||
            StatisticsAppInfo.INSTANCE.targetSdkVersion <= 27 &&
                StatisticsAppInfo.INSTANCE.targetSdkVersion != 0) {
            HttpURLConnection urlConn = (HttpURLConnection) url.openConnection();
            return urlConn;
        } else {
            if (!url.getProtocol().equalsIgnoreCase("https")) {
                String surl = "https" + urlAddr.substring(url.getProtocol().length());
                url = new URL(surl);
            }

            HttpsURLConnection con = (HttpsURLConnection) url.openConnection();
            boolean b = isIpAddress(url.getHost());
            if (b) {
                con.setSSLSocketFactory(StatisticsSSLSocketClient.getSSLSocketFactory());
                con.setHostnameVerifier(StatisticsSSLSocketClient.getHostnameVerifier());
            }
            return con;
        }
    }

    public static class HttpResp {
        public boolean isSucceed = false;
        public int statusCode = -1;
        public String reason = null;
        public String result = null;
        public String remoteIp = null;

        public HttpResp() {
        }
    }
}
