package tv.athena.live.player.statistics.hiido.regularly

import tv.athena.live.player.statistics.hiido.AbstractHiidoContent

/**
 *create by dengqu 2020/6/28
 */
class RegularlySystemContent private constructor() : AbstractHiidoContent() {
    private var abstractHiidoContent: AbstractHiidoContent? = null
    private var s1: Int = -1
    private var s2: Int = -1
    private var s3: Int = -1
    private var s4: Int = -1
    private var s5: Int = -1
    private var s6: Int = -1

    companion object {
        /**
         * CPU核数 int
         */
        const val S1 = "s1"

        /**
         * CPU使用率 float
         */
        const val S2 = "s2"

        /**
         * 本进程CPU使用率 float
         */
        const val S3 = "s3"

        /**
         * 内存使用率 float
         */
        const val S4 = "s4"

        /**
         * 本进程内存使用率 float
         */
        const val S5 = "s5"

        /**
         * 本机内存大小(M) float
         */
        const val S6 = "s6"
    }

    class RegularlySystemContentBuilder {
        private var hiidoContent = RegularlySystemContent()
        fun setAbstractHiidoContent(abstractHiidoContent: AbstractHiidoContent): RegularlySystemContentBuilder {
            hiidoContent.abstractHiidoContent = abstractHiidoContent
            return this
        }

        fun setS1(s1: Int): RegularlySystemContentBuilder {
            hiidoContent.s1 = s1
            return this
        }

        fun setS2(s2: Int): RegularlySystemContentBuilder {
            hiidoContent.s2 = s2
            return this
        }

        fun setS3(s3: Int): RegularlySystemContentBuilder {
            hiidoContent.s3 = s3
            return this
        }

        fun setS4(s4: Int): RegularlySystemContentBuilder {
            hiidoContent.s4 = s4
            return this
        }

        fun setS5(s5: Int): RegularlySystemContentBuilder {
            hiidoContent.s5 = s5
            return this
        }

        fun setS6(s6: Int): RegularlySystemContentBuilder {
            hiidoContent.s6 = s6
            return this
        }

        fun build(): RegularlySystemContent {
            return hiidoContent
        }
    }

    override fun getContent(): String {
        return abstractHiidoContent?.getContent() + "&" + buildContent()
    }

    private fun buildContent(): String {
        val contents = StringBuilder()
        contents.append(S1)
        contents.append("=")
        contents.append(s1)
        contents.append("&")

        contents.append(S2)
        contents.append("=")
        contents.append(s2)
        contents.append("&")

        contents.append(S3)
        contents.append("=")
        contents.append(s3)
        contents.append("&")

        contents.append(S4)
        contents.append("=")
        contents.append(s4)
        contents.append("&")

        contents.append(S5)
        contents.append("=")
        contents.append(s5)
        contents.append("&")

        contents.append(S6)
        contents.append("=")
        contents.append(s6)

        return contents.toString()
    }
}