/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.player.vodplayer.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import tv.athena.live.utils.ALog;

public class SystemUtil {
    private static final String TAG = SystemUtil.class.getSimpleName();
    private static RandomAccessFile mProcStatFile;
    private static RandomAccessFile mAppStatFile;
    private static Long mLastCpuTime;
    private static Long mLastAppCpuTime;
    private static final FileFilter CPU_FILTER;
    private static ActivityManager mActivityManager;

    public SystemUtil() {
        SystemUtil.getCpuRate();
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getOs() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String version = SystemUtil.getSystemVersion();
            int pos = version.indexOf(".") + 1;
            String subVersion = pos < version.length() ? version.substring(pos) : "0";
            stringBuilder.append("ANDROID");
            stringBuilder.append(" ");
            stringBuilder.append(version);
            stringBuilder.append(".");
            stringBuilder.append(subVersion);
            return stringBuilder.toString();
        }
        catch (Exception e) {
            ALog.e((String)TAG, (String)"getOs", (Throwable)e);
            return "-1";
        }
    }

    public static int getNumberOfCPUCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
        }
        catch (Exception e) {
            cores = -1;
            ALog.e((String)TAG, (String)"getNumberOfCPUCores", (Throwable)e);
        }
        return cores;
    }

    public static int[] getCpuRate() {
        if (Build.VERSION.SDK_INT >= 26) {
            return SystemUtil.getCurrentCpuDataForO();
        }
        return SystemUtil.getCPUDataBelowO();
    }

    private static int[] getCPUDataBelowO() {
        int value = 0;
        int[] result = new int[]{0, 0};
        int totalValue = 0;
        try {
            if (mProcStatFile == null || mAppStatFile == null) {
                mProcStatFile = new RandomAccessFile("/proc/stat", "r");
                mAppStatFile = new RandomAccessFile("/proc/" + android.os.Process.myPid() + "/stat", "r");
            } else {
                mProcStatFile.seek(0L);
                mAppStatFile.seek(0L);
            }
            String procStatString = mProcStatFile.readLine();
            String appStatString = mAppStatFile.readLine();
            String[] procStats = procStatString.split(" ");
            String[] appStats = appStatString.split(" ");
            long cpuTime = Long.parseLong(procStats[2]) + Long.parseLong(procStats[3]) + Long.parseLong(procStats[4]) + Long.parseLong(procStats[5]) + Long.parseLong(procStats[6]) + Long.parseLong(procStats[7]) + Long.parseLong(procStats[8]);
            long appTime = Long.parseLong(appStats[13]) + Long.parseLong(appStats[14]);
            if (mLastCpuTime == null && mLastAppCpuTime == null) {
                mLastCpuTime = cpuTime;
                mLastAppCpuTime = appTime;
                return result;
            }
            totalValue = (int)((cpuTime - mLastCpuTime) * 100L);
            value = (int)((float)(appTime - mLastAppCpuTime) / (float)(cpuTime - mLastCpuTime) * 100.0f);
            mLastCpuTime = cpuTime;
            mLastAppCpuTime = appTime;
            ALog.i((String)"getCPUData", (String)("mLastCpuTime =" + mLastCpuTime + ",mLastAppCpuTime =" + mLastAppCpuTime + ",value =" + value));
        }
        catch (Exception e) {
            ALog.e((String)TAG, (String)"getCurrentCPUData", (Throwable)e);
        }
        result[0] = value;
        result[1] = totalValue;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getCurrentCpuDataForO() {
        Process process = null;
        int[] result = new int[]{0, 0};
        int totalValue = 0;
        try {
            String line;
            process = Runtime.getRuntime().exec("top -n 1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int cpuIndex = -1;
            while ((line = reader.readLine()) != null) {
                int value;
                float rate;
                String cpu;
                String[] param;
                if (TextUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
                int tempIndex = SystemUtil.getCPUIndex(line);
                if (tempIndex != -1) {
                    cpuIndex = tempIndex;
                    continue;
                }
                if (line.startsWith(String.valueOf(android.os.Process.myPid()))) {
                    if (cpuIndex == -1 || (param = line.split("\\s+")).length <= cpuIndex) continue;
                    cpu = param[cpuIndex];
                    if (cpu.endsWith("%")) {
                        cpu = cpu.substring(0, cpu.lastIndexOf("%"));
                    }
                    rate = Float.parseFloat(cpu) / (float)Runtime.getRuntime().availableProcessors();
                    value = (int)rate;
                    ALog.i((String)TAG, (String)("getCurrentCpuDataForO line.startsWith(String.valueOf(Process.myPid())) value =" + value));
                    result[0] = value;
                    totalValue += value;
                    continue;
                }
                if (cpuIndex == -1 || (param = line.split("\\s+")).length <= cpuIndex) continue;
                cpu = param[cpuIndex];
                if (cpu.endsWith("%")) {
                    cpu = cpu.substring(0, cpu.lastIndexOf("%"));
                }
                rate = Float.parseFloat(cpu) / (float)Runtime.getRuntime().availableProcessors();
                value = (int)rate;
                ALog.i((String)TAG, (String)("getCurrentCpuDataForO value =" + value));
                totalValue += value;
            }
        }
        catch (Exception e) {
            ALog.e((String)TAG, (String)"getCurrentCpuDataForO", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        result[1] = totalValue;
        ALog.i((String)TAG, (String)("result result[0] =" + result[0] + ",result[1] =" + result[1]));
        return result;
    }

    private static int getCPUIndex(String line) {
        if (line.contains("CPU")) {
            String[] titles = line.split("\\s+");
            for (int i = 0; i < titles.length; ++i) {
                if (!titles[i].contains("CPU")) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getProcessCpuUsage(String pid) {
        try {
            RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
            String load = reader.readLine();
            String[] toks = load.split(" ");
            double totalCpuTime1 = 0.0;
            int len = toks.length;
            for (int i = 2; i < len; ++i) {
                totalCpuTime1 += Double.parseDouble(toks[i]);
            }
            BufferedReader readerBB = new BufferedReader(new FileReader("/proc/"));
            String processNameB = readerBB.readLine();
            RandomAccessFile reader2 = new RandomAccessFile("/proc/" + pid + "/stat", "r");
            String load2 = reader2.readLine();
            String[] toks2 = load2.split(" ");
            double processCpuTime1 = 0.0;
            double utime = Double.parseDouble(toks2[13]);
            double stime = Double.parseDouble(toks2[14]);
            double cutime = Double.parseDouble(toks2[15]);
            double cstime = Double.parseDouble(toks2[16]);
            processCpuTime1 = utime + stime + cutime + cstime;
            try {
                Thread.sleep(360L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            reader.seek(0L);
            load = reader.readLine();
            reader.close();
            toks = load.split(" ");
            double totalCpuTime2 = 0.0;
            len = toks.length;
            for (int i = 2; i < len; ++i) {
                totalCpuTime2 += Double.parseDouble(toks[i]);
            }
            reader2.seek(0L);
            load2 = reader2.readLine();
            String[] toks3 = load2.split(" ");
            double processCpuTime2 = 0.0;
            utime = Double.parseDouble(toks3[13]);
            stime = Double.parseDouble(toks3[14]);
            cutime = Double.parseDouble(toks3[15]);
            cstime = Double.parseDouble(toks3[16]);
            processCpuTime2 = utime + stime + cutime + cstime;
            int usage = (int)((processCpuTime2 - processCpuTime1) * 100.0 / (totalCpuTime2 - totalCpuTime1));
            return usage;
        }
        catch (Exception e) {
            ALog.e((String)TAG, (String)"getProcessCpuUsage", (Throwable)e);
            return -1;
        }
    }

    public static long getTotalMemorySize() {
        String dir = "/proc/meminfo";
        try {
            FileReader fr = new FileReader(dir);
            BufferedReader br = new BufferedReader(fr, 2048);
            String memoryLine = br.readLine();
            String subMemoryLine = memoryLine.substring(memoryLine.indexOf("MemTotal:"));
            br.close();
            long totalMemorySize = Integer.parseInt(subMemoryLine.replaceAll("\\D+", ""));
            return totalMemorySize;
        }
        catch (Exception e) {
            ALog.e((String)TAG, (String)"getTotalMemorySize", (Throwable)e);
            return -1L;
        }
    }

    public static int getUsedPercentValue(Context context) {
        String dir = "/proc/meminfo";
        try {
            FileReader fr = new FileReader(dir);
            BufferedReader br = new BufferedReader(fr, 2048);
            String memoryLine = br.readLine();
            String subMemoryLine = memoryLine.substring(memoryLine.indexOf("MemTotal:"));
            br.close();
            long totalMemorySize = Integer.parseInt(subMemoryLine.replaceAll("\\D+", ""));
            long availableSize = SystemUtil.getAvailableMemory(context) / 1024L;
            float percent = (float)(totalMemorySize - availableSize) / ((float)totalMemorySize * 1.0f);
            return (int)(percent * 100.0f);
        }
        catch (Exception e) {
            ALog.e((String)TAG, (String)"getUsedPercentValue", (Throwable)e);
            return -1;
        }
    }

    private static long getAvailableMemory(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = SystemUtil.getActivityManager(context);
        if (activityManager == null) {
            return 0L;
        }
        activityManager.getMemoryInfo(mi);
        if (mi == null) {
            return 0L;
        }
        return mi.availMem;
    }

    public static synchronized ActivityManager getActivityManager(Context context) {
        if (mActivityManager == null) {
            if (context == null) {
                return null;
            }
            mActivityManager = (ActivityManager)context.getSystemService("activity");
        }
        return mActivityManager;
    }

    public static int getAppMemoryUser(Context context) {
        ActivityManager activityManager = SystemUtil.getActivityManager(context);
        if (activityManager == null) {
            return 0;
        }
        int memory = activityManager.getMemoryClass();
        System.out.println("memory: " + memory);
        float totalMemory = (float)((double)Runtime.getRuntime().totalMemory() * 1.0 / 1048576.0);
        float freeMemory = (float)((double)Runtime.getRuntime().freeMemory() * 1.0 / 1048576.0);
        float percent = (totalMemory - freeMemory) / (totalMemory * 1.0f);
        return (int)(percent * 100.0f);
    }

    static {
        CPU_FILTER = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String path = pathname.getName();
                if (path.startsWith("cpu")) {
                    for (int i = 3; i < path.length(); ++i) {
                        if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

