/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.player.vodplayer;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import com.yy.transvod.downloader.MediaDownloader;
import com.yy.transvod.downloader.MediaDownloaderOptions;
import com.yy.transvod.player.DataSource;
import com.yy.transvod.preference.Preference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.annotation.ServiceRegister;
import tv.athena.core.axis.Axis;
import tv.athena.live.basesdk.liveroom.LivePlatformSdk;
import tv.athena.live.player.IAthLiveMediaPlayer;
import tv.athena.live.player.IAthLivePlayerEngine;
import tv.athena.live.player.IAthLivePlayerStatisticsService;
import tv.athena.live.player.statistics.common.CommonStatisticsConfig;
import tv.athena.live.player.vodplayer.AthLiveMediaPlayerFactory;
import tv.athena.live.player.vodplayer.VodPlayerPreference;
import tv.athena.live.utils.ALog;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 52\u00020\u0001:\u000245B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0002J<\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0002J\b\u0010(\u001a\u00020\u0018H\u0016J0\u0010)\u001a\u00020\u00182&\u0010*\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010+j\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u0001`,H\u0016J(\u0010-\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0004H\u0016J\u0018\u00102\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0016J\b\u00103\u001a\u00020\u0018H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Ltv/athena/live/player/vodplayer/VodPlayerEngineImpl;", "Ltv/athena/live/player/IAthLivePlayerEngine;", "()V", "mCacheDirectory", "", "mContext", "Landroid/content/Context;", "mDataSources", "Ljava/util/concurrent/ConcurrentHashMap;", "Ltv/athena/live/player/vodplayer/VodPlayerEngineImpl$AthDownloadDataSource;", "mMediaDownloader", "Lcom/yy/transvod/downloader/MediaDownloader;", "createPlayer", "Ltv/athena/live/player/IAthLiveMediaPlayer;", "uuid", "userUUID", "samplerFilter", "", "forceUse601ColorStandard", "", "directRenderToSurface", "isMultiInstance", "userTextureView", "deInitialize", "", "destroyPlayer", "player", "getApplicationContext", "initMediaDownloader", "initialize", "context", "appId", "sceneId", "", "logLevel", "cacheDirectory", "looper", "Landroid/os/Looper;", "isHasDownload", "url", "onAabReady", "setVodConfigs", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "startDownloadMedia", "isSupportQuic", "isDash", "startPlayerEngine", "uid", "stopDownloadMedia", "stopPlayerEngine", "AthDownloadDataSource", "Companion", "athliveplayer_release"})
@ServiceRegister(serviceInterface=IAthLivePlayerEngine.class)
public final class VodPlayerEngineImpl
implements IAthLivePlayerEngine {
    private Context mContext;
    private String mCacheDirectory;
    private MediaDownloader mMediaDownloader;
    private ConcurrentHashMap<String, AthDownloadDataSource> mDataSources = new ConcurrentHashMap();
    private static final String TAG = "VodPlayerEngineImpl";
    public static final Companion Companion = new Companion(null);

    public void initialize(@NotNull Context context, @NotNull String appId, long sceneId, int logLevel, @Nullable String cacheDirectory, @Nullable Looper looper) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        LivePlatformSdk.getInstance().tryLoadTransvodSo();
        this.mContext = context.getApplicationContext();
        this.mCacheDirectory = cacheDirectory;
        CommonStatisticsConfig.INSTANCE.setMAppid(appId);
        String string = context.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.packageName");
        CommonStatisticsConfig.INSTANCE.setPackageName(string);
        CommonStatisticsConfig.INSTANCE.setMContext(context.getApplicationContext());
        VodPlayerPreference.INSTANCE.initVodPlayerDns();
        IAthLivePlayerStatisticsService iAthLivePlayerStatisticsService = (IAthLivePlayerStatisticsService)Axis.Companion.getService(IAthLivePlayerStatisticsService.class);
        if (iAthLivePlayerStatisticsService != null) {
            iAthLivePlayerStatisticsService.init(context.getPackageName(), context);
        }
        this.initMediaDownloader();
    }

    private final void initMediaDownloader() {
        MediaDownloaderOptions downOptions = new MediaDownloaderOptions();
        downOptions.mApplicationContext = this.getApplicationContext();
        downOptions.mCacheDir = TextUtils.isEmpty((CharSequence)this.mCacheDirectory) ? "/sdcard/yy_video/" : this.mCacheDirectory;
        this.mMediaDownloader = new MediaDownloader(downOptions);
    }

    public void deInitialize() {
    }

    public void startPlayerEngine(@NotNull String uid) {
        Intrinsics.checkParameterIsNotNull((Object)uid, (String)"uid");
    }

    public void stopPlayerEngine() {
    }

    @NotNull
    public IAthLiveMediaPlayer createPlayer(@NotNull String uuid, @NotNull String userUUID, int samplerFilter, boolean forceUse601ColorStandard, boolean directRenderToSurface, boolean isMultiInstance, boolean userTextureView) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)userUUID, (String)"userUUID");
        ALog.i((String)TAG, (String)("createPlayer ---------- " + this.mContext));
        return AthLiveMediaPlayerFactory.Companion.getInstance().getAthLiveMediaPlayer(this.mContext, this.mCacheDirectory, uuid, userUUID, samplerFilter, forceUse601ColorStandard, directRenderToSurface, isMultiInstance, userTextureView);
    }

    public void destroyPlayer(@NotNull IAthLiveMediaPlayer player, @NotNull String uuid, @NotNull String userUUID, boolean isMultiInstance) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)userUUID, (String)"userUUID");
        AthLiveMediaPlayerFactory.Companion.getInstance().releasePlayer(uuid, userUUID, isMultiInstance);
    }

    public void setVodConfigs(@Nullable HashMap<String, String> map) {
        ALog.i((String)TAG, (String)("setVodConfigs map = " + map));
        VodPlayerPreference.INSTANCE.setVodConfigs(map);
    }

    @Nullable
    public Context getApplicationContext() {
        return this.mContext;
    }

    public void startDownloadMedia(@NotNull String uuid, @NotNull String url, boolean isSupportQuic, boolean isDash) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        ALog.i((String)TAG, (String)("startDownloadMedia before uuid = " + uuid + ",url = " + url + " ,isSupportQuic = " + isSupportQuic + ",mDataSources " + "size = " + this.mDataSources.size()));
        if (this.isHasDownload(uuid, url)) {
            ALog.i((String)TAG, (String)("uuid =" + uuid + " has startDownloadMedia-------- "));
            return;
        }
        ALog.i((String)TAG, (String)("uuid =" + uuid + " not startDownloadMedia-------- "));
        int srcFmt = isDash ? 3 : 2;
        int cachePolicy = isDash ? 0 : 2;
        int proto = isSupportQuic || isDash ? 100 : 0;
        DataSource mDataSource = new DataSource(url, proto, srcFmt, cachePolicy, true);
        MediaDownloader mediaDownloader = this.mMediaDownloader;
        if (mediaDownloader != null) {
            mediaDownloader.startDownloadMedia(mDataSource);
        }
        ((Map)this.mDataSources).put(uuid, new AthDownloadDataSource(uuid, url, isSupportQuic, mDataSource));
        ALog.i((String)TAG, (String)("startDownloadMedia after uuid = " + uuid + ",url = " + url + " ," + "isSupportQuic = " + isSupportQuic + ',' + "mDataSources " + "size = " + this.mDataSources.size()));
    }

    public void stopDownloadMedia(@NotNull String uuid, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        ConcurrentHashMap<String, AthDownloadDataSource> concurrentHashMap = this.mDataSources;
        ALog.i((String)TAG, (String)("stopDownloadMedia before uuid = " + uuid + ",url = " + url + ',' + "size = " + (concurrentHashMap != null ? Integer.valueOf(concurrentHashMap.size()) : null)));
        ConcurrentHashMap<String, AthDownloadDataSource> concurrentHashMap2 = this.mDataSources;
        if (concurrentHashMap2 != null) {
            ConcurrentHashMap<String, AthDownloadDataSource> concurrentHashMap3 = concurrentHashMap2;
            boolean bl = false;
            boolean bl2 = false;
            ConcurrentHashMap<String, AthDownloadDataSource> it = concurrentHashMap3;
            boolean bl3 = false;
            Map map = it;
            boolean bl4 = false;
            if (!map.isEmpty()) {
                ConcurrentHashMap tempDataSources = new ConcurrentHashMap();
                Map map2 = it;
                boolean bl5 = false;
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    boolean bl6 = false;
                    String key = (String)entry2.getKey();
                    entry2 = entry;
                    bl6 = false;
                    AthDownloadDataSource value = (AthDownloadDataSource)entry2.getValue();
                    if (TextUtils.equals((CharSequence)key, (CharSequence)uuid) || TextUtils.equals((CharSequence)value.getUrl(), (CharSequence)url)) {
                        ALog.i((String)TAG, (String)"stopDownloadMedia find --------------");
                        MediaDownloader mediaDownloader = this.mMediaDownloader;
                        if (mediaDownloader != null) {
                            mediaDownloader.stopDownloadMedia(value.getDataSource());
                        }
                        continue;
                    }
                    ((Map)tempDataSources).put(key, value);
                }
                this.mDataSources.clear();
                this.mDataSources = tempDataSources;
            }
        }
        ConcurrentHashMap<String, AthDownloadDataSource> concurrentHashMap4 = this.mDataSources;
        ALog.i((String)TAG, (String)("stopDownloadMedia after uuid = " + uuid + ",url = " + url + ',' + "size = " + (concurrentHashMap4 != null ? Integer.valueOf(concurrentHashMap4.size()) : null)));
    }

    public void onAabReady() {
        Preference.loadSoLibForAabMode();
    }

    private final boolean isHasDownload(String uuid, String url) {
        Object object = this.mDataSources;
        boolean bl = false;
        if (!object.isEmpty()) {
            Map map = this.mDataSources;
            boolean bl2 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = object = iterator.next();
                boolean bl3 = false;
                String key = (String)object2.getKey();
                object2 = object;
                bl3 = false;
                AthDownloadDataSource value = (AthDownloadDataSource)object2.getValue();
                if (!TextUtils.equals((CharSequence)key, (CharSequence)uuid) && !TextUtils.equals((CharSequence)value.getUrl(), (CharSequence)url)) continue;
                ALog.i((String)TAG, (String)"isHasDownload find-------------------");
                return true;
            }
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ltv/athena/live/player/vodplayer/VodPlayerEngineImpl$AthDownloadDataSource;", "", "uuid", "", "url", "isSupportQuic", "", "dataSource", "Lcom/yy/transvod/player/DataSource;", "(Ljava/lang/String;Ljava/lang/String;ZLcom/yy/transvod/player/DataSource;)V", "getDataSource", "()Lcom/yy/transvod/player/DataSource;", "()Z", "getUrl", "()Ljava/lang/String;", "getUuid", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "athliveplayer_release"})
    public static final class AthDownloadDataSource {
        @NotNull
        private final String uuid;
        @NotNull
        private final String url;
        private final boolean isSupportQuic;
        @NotNull
        private final DataSource dataSource;

        @NotNull
        public final String getUuid() {
            return this.uuid;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final boolean isSupportQuic() {
            return this.isSupportQuic;
        }

        @NotNull
        public final DataSource getDataSource() {
            return this.dataSource;
        }

        public AthDownloadDataSource(@NotNull String uuid, @NotNull String url, boolean isSupportQuic, @NotNull DataSource dataSource) {
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            this.uuid = uuid;
            this.url = url;
            this.isSupportQuic = isSupportQuic;
            this.dataSource = dataSource;
        }

        @NotNull
        public final String component1() {
            return this.uuid;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        public final boolean component3() {
            return this.isSupportQuic;
        }

        @NotNull
        public final DataSource component4() {
            return this.dataSource;
        }

        @NotNull
        public final AthDownloadDataSource copy(@NotNull String uuid, @NotNull String url, boolean isSupportQuic, @NotNull DataSource dataSource) {
            Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
            return new AthDownloadDataSource(uuid, url, isSupportQuic, dataSource);
        }

        public static /* synthetic */ AthDownloadDataSource copy$default(AthDownloadDataSource athDownloadDataSource, String string, String string2, boolean bl, DataSource dataSource, int n, Object object) {
            if ((n & 1) != 0) {
                string = athDownloadDataSource.uuid;
            }
            if ((n & 2) != 0) {
                string2 = athDownloadDataSource.url;
            }
            if ((n & 4) != 0) {
                bl = athDownloadDataSource.isSupportQuic;
            }
            if ((n & 8) != 0) {
                dataSource = athDownloadDataSource.dataSource;
            }
            return athDownloadDataSource.copy(string, string2, bl, dataSource);
        }

        @NotNull
        public String toString() {
            return "AthDownloadDataSource(uuid=" + this.uuid + ", url=" + this.url + ", isSupportQuic=" + this.isSupportQuic + ", dataSource=" + this.dataSource + ")";
        }

        public int hashCode() {
            String string = this.uuid;
            String string2 = this.url;
            int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.isSupportQuic ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            DataSource dataSource = this.dataSource;
            return (n + n2) * 31 + (dataSource != null ? dataSource.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AthDownloadDataSource)) break block3;
                    AthDownloadDataSource athDownloadDataSource = (AthDownloadDataSource)object;
                    if (!Intrinsics.areEqual((Object)this.uuid, (Object)athDownloadDataSource.uuid) || !Intrinsics.areEqual((Object)this.url, (Object)athDownloadDataSource.url) || !(this.isSupportQuic == athDownloadDataSource.isSupportQuic) || !Intrinsics.areEqual((Object)this.dataSource, (Object)athDownloadDataSource.dataSource)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltv/athena/live/player/vodplayer/VodPlayerEngineImpl$Companion;", "", "()V", "TAG", "", "athliveplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

