/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.player.vodplayer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.yy.transvod.preference.OnPlayerStatistics;
import com.yy.transvod.preference.Preference;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.annotation.ServiceRegister;
import tv.athena.core.axis.Axis;
import tv.athena.live.player.IAthLivePlayerEngine;
import tv.athena.live.player.IAthLivePlayerStatisticsService;
import tv.athena.live.player.bean.ATHLivePlayerStatistics;
import tv.athena.live.player.bean.PlayerStatisticsExtraInfo;
import tv.athena.live.player.bean.PlayerStatisticsInfo;
import tv.athena.live.player.statistics.StatisticsReport;
import tv.athena.live.player.statistics.common.CommonStatisticsConfig;
import tv.athena.live.player.statistics.hiido.AbstractHiidoContent;
import tv.athena.live.player.statistics.hiido.BaseHiidoContent;
import tv.athena.live.player.statistics.hiido.fpflow.BasicDataContent;
import tv.athena.live.player.statistics.hiido.fpflow.FpflowCommonContent;
import tv.athena.live.player.statistics.hiido.fpflow.LinkCorrelationContent;
import tv.athena.live.player.statistics.hiido.regularly.RegularlyBasicDataContent;
import tv.athena.live.player.statistics.hiido.regularly.RegularlyCommonContent;
import tv.athena.live.player.statistics.hiido.regularly.RegularlySystemContent;
import tv.athena.live.player.vodplayer.utils.SystemUtil;
import tv.athena.live.utils.ALog;
import tv.athena.live.utils.DeviceUtil;
import tv.athena.live.utils.GslbUtils;
import tv.athena.live.utils.NetUtils;
import tv.athena.live.utils.StatisticsUtils;
import tv.athena.live.utils.UUidUtil;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\"\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u001a\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\bH\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\bH\u0016J\u0018\u00100\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u00104\u001a\u000202H\u0016J\u0018\u00105\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u00106\u001a\u00020(H\u0016J\u0018\u00107\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\bH\u0016J&\u00109\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010:\u001a\u00020(H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Ltv/athena/live/player/vodplayer/VodAthLivePlayerStatisticsServiceImpl;", "Ltv/athena/live/player/IAthLivePlayerStatisticsService;", "()V", "mContext", "Landroid/content/Context;", "mHandler", "Landroid/os/Handler;", "mPackageName", "", "mPlayserStatisticsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ltv/athena/live/player/bean/ATHLivePlayerStatistics;", "addATHLivePlayerStatistics", "", "playerUUid", "playerStatistics", "addAnchorUid", "mUid", "doAdaptiveBitRateReport", "vodPlayerStatis", "doBusinessFlow", "uuid", "doLiveingFirstAccess", "code", "doLivingLoop", "playerStatis", "getATHLivePlayerStatistics", "init", "packageName", "context", "leave", "removePlayerUid", "setConfigResolution", "mPlayerUUid", "configResolution", "setGslbTime", "gslbTime", "setIsSupportQuic", "supportQuic", "", "setPlayerStatisticsInfo", "playerStatisticsInfo", "Ltv/athena/live/player/bean/PlayerStatisticsInfo;", "playerStatisticsExtraInfo", "Ltv/athena/live/player/bean/PlayerStatisticsExtraInfo;", "setPlayerUrl", "url", "setSceneId", "sceneId", "", "setTimeDelay", "timeDelay", "updateCannelType", "flag", "updateQxd", "qxd", "urlEncodePlayerStatis", "isFirstAccess", "Companion", "athliveplayer_release"})
@ServiceRegister(serviceInterface=IAthLivePlayerStatisticsService.class)
public final class VodAthLivePlayerStatisticsServiceImpl
implements IAthLivePlayerStatisticsService {
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private String mPackageName = "-1";
    private Context mContext;
    private ConcurrentHashMap<Integer, ATHLivePlayerStatistics> mPlayserStatisticsMap = new ConcurrentHashMap();
    private static final String TAG = "VodAthLivePlayerStatisticsServiceImpl";
    public static final Companion Companion = new Companion(null);

    public void setTimeDelay(int mPlayerUUid, long timeDelay) {
        block0: {
            ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(mPlayerUUid);
            Object object = playerStatistics;
            if (object == null || (object = object.getMTimeDelayList()) == null) break block0;
            ((ConcurrentLinkedQueue)object).add(timeDelay);
        }
    }

    public void updateQxd(int mPlayerUUid, @NotNull String qxd) {
        block0: {
            ATHLivePlayerStatistics playerStatistics;
            Intrinsics.checkParameterIsNotNull((Object)qxd, (String)"qxd");
            ATHLivePlayerStatistics aTHLivePlayerStatistics = playerStatistics = this.mPlayserStatisticsMap.get(mPlayerUUid);
            if (aTHLivePlayerStatistics == null) break block0;
            aTHLivePlayerStatistics.setConfigResolution(qxd);
        }
    }

    public void setPlayerUrl(int playerUUid, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        ALog.i((String)TAG, (String)("setPlayerUrl " + playerUUid + ' ' + url));
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)("setPlayerUrl playerStatistics == null " + playerUUid));
            return;
        }
        playerStatistics.setMUrl(url);
        String string = UUidUtil.getUUID32();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUidUtil.getUUID32()");
        playerStatistics.setMUUid(string);
    }

    public void setIsSupportQuic(int playerUUid, boolean supportQuic) {
        ALog.i((String)TAG, (String)("setIsSupportQuic " + playerUUid + ' ' + supportQuic));
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"setIsSupportQuic playerStatistics == null");
            return;
        }
        playerStatistics.setMIsSupportQuic(supportQuic);
    }

    public void setSceneId(int playerUUid, long sceneId) {
        block1: {
            ALog.i((String)TAG, (String)("setSceneId " + playerUUid + ' ' + sceneId));
            ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
            if (playerStatistics == null) {
                ALog.i((String)TAG, (String)"setSceneId playerStatistics == null");
                return;
            }
            PlayerStatisticsInfo playerStatisticsInfo = playerStatistics.getMPlayerStatisticsInfo();
            if (playerStatisticsInfo == null) break block1;
            playerStatisticsInfo.setScene((int)sceneId);
        }
    }

    public void setGslbTime(int playerUUid, int gslbTime) {
        block1: {
            ALog.i((String)TAG, (String)("setGslbTime " + playerUUid + ' ' + gslbTime));
            ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
            if (playerStatistics == null) {
                ALog.i((String)TAG, (String)"setGslbTime playerStatistics == null");
                return;
            }
            Object object = playerStatistics;
            if (object == null || (object = object.getMGslbMap()) == null) break block1;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            ((Map)it).put(playerStatistics.getMUrl(), gslbTime);
        }
    }

    public void addAnchorUid(int playerUUid, @Nullable String mUid) {
        block1: {
            ATHLivePlayerStatistics playerStatistics;
            ATHLivePlayerStatistics aTHLivePlayerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
            if (aTHLivePlayerStatistics == null) {
                return;
            }
            ATHLivePlayerStatistics aTHLivePlayerStatistics2 = playerStatistics = aTHLivePlayerStatistics;
            if (aTHLivePlayerStatistics2 == null) break block1;
            aTHLivePlayerStatistics2.addAnchorUid(mUid);
        }
    }

    public void setConfigResolution(int mPlayerUUid, @NotNull String configResolution) {
        Intrinsics.checkParameterIsNotNull((Object)configResolution, (String)"configResolution");
        ALog.i((String)TAG, (String)("setConfigResolution " + mPlayerUUid + ' ' + configResolution));
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(mPlayerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"setConfigResolution playerStatistics == null");
            return;
        }
        playerStatistics.setConfigResolution(configResolution);
    }

    public void updateCannelType(int mPlayerUUid, boolean flag) {
        ALog.i((String)TAG, (String)("updateCannelType " + mPlayerUUid + ' ' + flag));
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(mPlayerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"updateCannelType playerStatistics == null");
            return;
        }
        playerStatistics.setMultiCannel(flag);
    }

    @Nullable
    public ATHLivePlayerStatistics getATHLivePlayerStatistics(int playerUUid) {
        ConcurrentHashMap<Integer, ATHLivePlayerStatistics> concurrentHashMap = this.mPlayserStatisticsMap;
        return concurrentHashMap != null ? concurrentHashMap.get(playerUUid) : null;
    }

    /*
     * WARNING - void declaration
     */
    public void leave(int playerUUid) {
        block2: {
            void playerStatistics;
            ALog.i((String)TAG, (String)("leave " + playerUUid));
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = this.mPlayserStatisticsMap.get(playerUUid);
            if ((ATHLivePlayerStatistics)playerStatistics.element == null) {
                ALog.i((String)TAG, (String)"leave playerStatistics == null");
                return;
            }
            if (((ATHLivePlayerStatistics)playerStatistics.element).isMultiCannel()) {
                this.removePlayerUid(playerUUid);
                ALog.i((String)TAG, (String)("leave isMultiCannel == " + ((ATHLivePlayerStatistics)playerStatistics.element).isMultiCannel()));
                return;
            }
            this.doBusinessFlow(playerUUid);
            Handler handler = this.mHandler;
            if (handler == null) break block2;
            handler.postDelayed(new Runnable(this, (Ref.ObjectRef)playerStatistics, playerUUid){
                final /* synthetic */ VodAthLivePlayerStatisticsServiceImpl this$0;
                final /* synthetic */ Ref.ObjectRef $playerStatistics;
                final /* synthetic */ int $playerUUid;

                public final void run() {
                    if (!((ATHLivePlayerStatistics)this.$playerStatistics.element).getMFirstaccessReport()) {
                        this.this$0.doLiveingFirstAccess(this.$playerUUid, -2, "");
                    }
                    VodAthLivePlayerStatisticsServiceImpl.access$removePlayerUid(this.this$0, this.$playerUUid);
                }
                {
                    this.this$0 = vodAthLivePlayerStatisticsServiceImpl;
                    this.$playerStatistics = objectRef;
                    this.$playerUUid = n;
                }
            }, 5000L);
        }
    }

    private final void removePlayerUid(int playerUUid) {
        ALog.i((String)TAG, (String)("removePlayerUid " + playerUUid));
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"removePlayerUid playerStatistics == null");
            return;
        }
        if (playerStatistics.getMFirstaccessReport()) {
            ALog.i((String)TAG, (String)("leave " + playerStatistics.getMFirstaccessReport()));
            this.mPlayserStatisticsMap.remove(playerUUid);
            return;
        }
    }

    public void setPlayerStatisticsInfo(int playerUUid, @NotNull PlayerStatisticsInfo playerStatisticsInfo, @NotNull PlayerStatisticsExtraInfo playerStatisticsExtraInfo) {
        Intrinsics.checkParameterIsNotNull((Object)playerStatisticsInfo, (String)"playerStatisticsInfo");
        Intrinsics.checkParameterIsNotNull((Object)playerStatisticsExtraInfo, (String)"playerStatisticsExtraInfo");
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"doLiveingFirstAccess playerStatistics == null");
            return;
        }
        playerStatistics.setMPlayerStatisticsInfo(playerStatisticsInfo);
        playerStatistics.setMPlayerStatisticsExtraInfo(playerStatisticsExtraInfo);
    }

    public void init(@Nullable String packageName, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPackageName = packageName;
        this.mContext = context;
        Preference.setStatisticsCallback((OnPlayerStatistics)new OnPlayerStatistics(this){
            final /* synthetic */ VodAthLivePlayerStatisticsServiceImpl this$0;

            public final void onStatistics(int taskId, int type, String text) {
                ALog.i((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("onStatistics taskId=" + taskId + ",type = " + type + ",text = " + text));
                switch (type) {
                    case 1: {
                        this.this$0.doLiveingFirstAccess(taskId, 0, text);
                        break;
                    }
                    case 2: {
                        VodAthLivePlayerStatisticsServiceImpl.access$doLivingLoop(this.this$0, taskId, text);
                        VodAthLivePlayerStatisticsServiceImpl.access$doBusinessFlow(this.this$0, taskId);
                        break;
                    }
                    case 3: {
                        VodAthLivePlayerStatisticsServiceImpl.access$doAdaptiveBitRateReport(this.this$0, taskId, text);
                    }
                }
            }
            {
                this.this$0 = vodAthLivePlayerStatisticsServiceImpl;
            }
        });
    }

    private final void doAdaptiveBitRateReport(int playerUUid, String vodPlayerStatis) {
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"doAdaptiveBitRateReport playerStatistics == null");
            return;
        }
        ATHLivePlayerStatistics aTHLivePlayerStatistics = playerStatistics;
        boolean bl = false;
        boolean bl2 = false;
        ATHLivePlayerStatistics it = aTHLivePlayerStatistics;
        boolean bl3 = false;
        StatisticsReport.Companion.getInstance().doReport(new Runnable(it, this, vodPlayerStatis, playerUUid){
            final /* synthetic */ ATHLivePlayerStatistics $it;
            final /* synthetic */ VodAthLivePlayerStatisticsServiceImpl this$0;
            final /* synthetic */ String $vodPlayerStatis$inlined;
            final /* synthetic */ int $playerUUid$inlined;
            {
                this.$it = aTHLivePlayerStatistics;
                this.this$0 = vodAthLivePlayerStatisticsServiceImpl;
                this.$vodPlayerStatis$inlined = string;
                this.$playerUUid$inlined = n;
            }

            public final void run() {
                BaseHiidoContent baseHiidoContent = new BaseHiidoContent.BaseHiidoContentBuilder().setAct("lpfautoadaptiveswitch").build();
                String string = CommonStatisticsConfig.INSTANCE.getMAppid();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder = new FpflowCommonContent.FpflowCommonContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)baseHiidoContent);
                boolean bl = false;
                long l = Long.parseLong(string);
                PlayerStatisticsInfo playerStatisticsInfo = this.$it.getMPlayerStatisticsInfo();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder2 = fpflowCommonContentBuilder.setAppid(l).setScene(playerStatisticsInfo != null ? playerStatisticsInfo.getScene() : -1);
                Object object = this.$it.getMPlayerStatisticsInfo();
                if (object == null || (object = object.getEuid()) == null) {
                    object = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder3 = fpflowCommonContentBuilder2.setEuid((String)object).setUrl(this.$it.getMUrl()).setUUid(this.$it.getMUUid());
                String string2 = VodAthLivePlayerStatisticsServiceImpl.access$getMPackageName$p(this.this$0);
                if (string2 == null) {
                    string2 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder4 = fpflowCommonContentBuilder3.setPKg(string2);
                Object object2 = this.$it.getMPlayerStatisticsInfo();
                if (object2 == null || (object2 = object2.getFd1()) == null) {
                    object2 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder5 = fpflowCommonContentBuilder4.setFd1((String)object2);
                Object object3 = this.$it.getMPlayerStatisticsInfo();
                if (object3 == null || (object3 = object3.getFd2()) == null) {
                    object3 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder6 = fpflowCommonContentBuilder5.setFd2((String)object3).setFbl(DeviceUtil.Companion.getScreenFbl(VodAthLivePlayerStatisticsServiceImpl.access$getMContext$p(this.this$0))).setOsv(DeviceUtil.Companion.getOsv());
                Object object4 = this.$it.getMPlayerStatisticsInfo();
                if (object4 == null || (object4 = object4.getCdnPlaySuffix()) == null) {
                    object4 = "-1";
                }
                PlayerStatisticsExtraInfo playerStatisticsExtraInfo = this.$it.getMPlayerStatisticsExtraInfo();
                PlayerStatisticsExtraInfo playerStatisticsExtraInfo2 = this.$it.getMPlayerStatisticsExtraInfo();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder7 = fpflowCommonContentBuilder6.setCdps((String)object4).setLsq(playerStatisticsExtraInfo != null ? playerStatisticsExtraInfo.getServicePmrovider() : -1).setMprotocol(playerStatisticsExtraInfo2 != null ? playerStatisticsExtraInfo2.getMediaProtocol() : -1);
                Object object5 = this.$it.getMPlayerStatisticsInfo();
                if (object5 == null || (object5 = object5.getHdid()) == null) {
                    object5 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder8 = fpflowCommonContentBuilder7.setHdid((String)object5);
                Object object6 = this.$it.getMPlayerStatisticsInfo();
                if (object6 == null || (object6 = object6.getCln()) == null) {
                    object6 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder9 = fpflowCommonContentBuilder8.setCln((String)object6);
                Object object7 = this.$it.getMPlayerStatisticsInfo();
                if (object7 == null || (object7 = object7.getAppinfo()) == null) {
                    object7 = "-1";
                }
                FpflowCommonContent fpflowCommonContent = fpflowCommonContentBuilder9.setAppinfo((String)object7).setVer("0.0.0.181.aar-SNAPSHOT").setInfo(DeviceUtil.Companion.getPhoneInfo()).setCtype(2).build();
                int pt = (int)(System.currentTimeMillis() - this.$it.getMFirstPtTime());
                if (pt < 0) {
                    pt = 1;
                }
                int sd = 0;
                if (this.$it.getMAdaptiveBitRateLoopSd() == 0) {
                    sd = pt;
                    this.$it.setMAdaptiveBitRateLoopSd((int)System.currentTimeMillis());
                } else {
                    int currentTime = (int)System.currentTimeMillis();
                    sd = currentTime - this.$it.getMAdaptiveBitRateLoopSd();
                    this.$it.setMAdaptiveBitRateLoopSd(currentTime);
                }
                StringBuilder stringBuilder = this.$it.getMAnchorUid();
                String string3 = stringBuilder != null ? stringBuilder.toString() : null;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.mAnchorUid?.toString()");
                String anchorUidResult = string3;
                if (!TextUtils.isEmpty((CharSequence)anchorUidResult) && StringsKt.startsWith$default((String)anchorUidResult, (String)",", (boolean)false, (int)2, null)) {
                    anchorUidResult = StringsKt.replaceFirst$default((String)anchorUidResult, (String)",", (String)"", (boolean)false, (int)4, null);
                }
                IAthLivePlayerEngine iAthLivePlayerEngine = (IAthLivePlayerEngine)Axis.Companion.getService(IAthLivePlayerEngine.class);
                BasicDataContent basicDataContent = new BasicDataContent.BasicDataContentBuilder().setNt(NetUtils.getNetworkState((Context)(iAthLivePlayerEngine != null ? iAthLivePlayerEngine.getApplicationContext() : null))).setSd1(sd).setPt(pt).setAnchorUid(anchorUidResult).setAbstractHiidoContent((AbstractHiidoContent)fpflowCommonContent).build();
                String urlEncoderPlayerStatis = VodAthLivePlayerStatisticsServiceImpl.access$urlEncodePlayerStatis(this.this$0, this.$vodPlayerStatis$inlined, this.$playerUUid$inlined, false);
                ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doAdaptiveBitRateReport urlEncoderPlayerStatis = " + urlEncoderPlayerStatis));
                String result = basicDataContent.getContent() + urlEncoderPlayerStatis;
                ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doAdaptiveBitRateReport result = " + result));
                StatisticsReport.Companion.getInstance().doReportSync(result);
            }
        });
    }

    private final void doBusinessFlow(int uuid) {
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(uuid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"doBusinessFlow playerStatistics == null");
            return;
        }
        if (playerStatistics.isMultiCannel()) {
            ALog.i((String)TAG, (String)"doBusinessFlow playerStatistics isMultiCannel = true");
            return;
        }
        ATHLivePlayerStatistics aTHLivePlayerStatistics = playerStatistics;
        boolean bl = false;
        boolean bl2 = false;
        ATHLivePlayerStatistics it = aTHLivePlayerStatistics;
        boolean bl3 = false;
        StatisticsReport.Companion.getInstance().doReport(new Runnable(it, this){
            final /* synthetic */ ATHLivePlayerStatistics $it;
            final /* synthetic */ VodAthLivePlayerStatisticsServiceImpl this$0;
            {
                this.$it = aTHLivePlayerStatistics;
                this.this$0 = vodAthLivePlayerStatisticsServiceImpl;
            }

            public final void run() {
                BaseHiidoContent baseHiidoContent = new BaseHiidoContent.BaseHiidoContentBuilder().setAct("lpfplayerbusinessflow").build();
                String qxd = TextUtils.isEmpty((CharSequence)this.$it.getConfigResolution()) ? "-1" : this.$it.getConfigResolution();
                String string = CommonStatisticsConfig.INSTANCE.getMAppid();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder = new FpflowCommonContent.FpflowCommonContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)baseHiidoContent);
                boolean bl = false;
                long l = Long.parseLong(string);
                PlayerStatisticsInfo playerStatisticsInfo = this.$it.getMPlayerStatisticsInfo();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder2 = fpflowCommonContentBuilder.setAppid(l).setScene(playerStatisticsInfo != null ? playerStatisticsInfo.getScene() : -1);
                Object object = this.$it.getMPlayerStatisticsInfo();
                if (object == null || (object = object.getEuid()) == null) {
                    object = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder3 = fpflowCommonContentBuilder2.setEuid((String)object).setUrl(this.$it.getMUrl());
                Object object2 = this.$it.getMPlayerStatisticsInfo();
                if (object2 == null || (object2 = object2.getCln()) == null) {
                    object2 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder4 = fpflowCommonContentBuilder3.setCln((String)object2);
                Object object3 = this.$it.getMPlayerStatisticsInfo();
                if (object3 == null || (object3 = object3.getAppinfo()) == null) {
                    object3 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder5 = fpflowCommonContentBuilder4.setAppinfo((String)object3).setUUid(this.$it.getMUUid());
                String string2 = VodAthLivePlayerStatisticsServiceImpl.access$getMPackageName$p(this.this$0);
                if (string2 == null) {
                    string2 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder6 = fpflowCommonContentBuilder5.setPKg(string2).setQxd(qxd);
                Object object4 = this.$it.getMPlayerStatisticsInfo();
                if (object4 == null || (object4 = object4.getFd1()) == null) {
                    object4 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder7 = fpflowCommonContentBuilder6.setFd1((String)object4);
                Object object5 = this.$it.getMPlayerStatisticsInfo();
                if (object5 == null || (object5 = object5.getFd2()) == null) {
                    object5 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder8 = fpflowCommonContentBuilder7.setFd2((String)object5).setFbl(DeviceUtil.Companion.getScreenFbl(VodAthLivePlayerStatisticsServiceImpl.access$getMContext$p(this.this$0))).setOsv(DeviceUtil.Companion.getOsv());
                Object object6 = this.$it.getMPlayerStatisticsInfo();
                if (object6 == null || (object6 = object6.getHdid()) == null) {
                    object6 = "-1";
                }
                FpflowCommonContent fpflowCommonContent = fpflowCommonContentBuilder8.setHdid((String)object6).setVer("0.0.0.181.aar-SNAPSHOT").setInfo(DeviceUtil.Companion.getPhoneInfo()).setCtype(2).build();
                StringBuilder stringBuilder = this.$it.getMAnchorUid();
                String string3 = stringBuilder != null ? stringBuilder.toString() : null;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.mAnchorUid?.toString()");
                String anchorUidResult = string3;
                if (!TextUtils.isEmpty((CharSequence)anchorUidResult) && StringsKt.startsWith$default((String)anchorUidResult, (String)",", (boolean)false, (int)2, null)) {
                    anchorUidResult = StringsKt.replaceFirst$default((String)anchorUidResult, (String)",", (String)"", (boolean)false, (int)4, null);
                }
                RegularlyCommonContent.RegularlyCommonContentBuilder regularlyCommonContentBuilder = new RegularlyCommonContent.RegularlyCommonContentBuilder().setFpflowCommonContent(fpflowCommonContent);
                String string4 = SystemUtil.getOs();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"SystemUtil.getOs()");
                RegularlyCommonContent regularlyCommonContent = regularlyCommonContentBuilder.setOs(string4).setAnchorUid(anchorUidResult).build();
                int pt = (int)(System.currentTimeMillis() - this.$it.getMFirstPtTime());
                int sd = 0;
                if (this.$it.getMLastBussinessLoopSd() == 0) {
                    sd = pt;
                    this.$it.setMLastBussinessLoopSd((int)System.currentTimeMillis());
                } else {
                    int currentTime = (int)System.currentTimeMillis();
                    sd = currentTime - this.$it.getMLastBussinessLoopSd();
                    this.$it.setMLastBussinessLoopSd(currentTime);
                }
                IAthLivePlayerEngine iAthLivePlayerEngine = (IAthLivePlayerEngine)Axis.Companion.getService(IAthLivePlayerEngine.class);
                RegularlyBasicDataContent regularlyBasicDataContent = new RegularlyBasicDataContent.RegularlyBasicDataContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)regularlyCommonContent).setNt(NetUtils.getNetworkState((Context)(iAthLivePlayerEngine != null ? iAthLivePlayerEngine.getApplicationContext() : null))).setSd1(sd).setPt(pt).build();
                String result = regularlyBasicDataContent.getContent();
                ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doBusinessFlow result = " + result));
                StatisticsReport.Companion.getInstance().doReportSync(result);
            }
        });
    }

    public void addATHLivePlayerStatistics(int playerUUid, @Nullable ATHLivePlayerStatistics playerStatistics) {
        block0: {
            ConcurrentHashMap<Integer, ATHLivePlayerStatistics> concurrentHashMap = this.mPlayserStatisticsMap;
            if (concurrentHashMap == null) break block0;
            concurrentHashMap.put(playerUUid, playerStatistics);
        }
    }

    public void doLiveingFirstAccess(int playerUUid, int code, @Nullable String vodPlayerStatis) {
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(playerUUid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"doLiveingFirstAccess playerStatistics == null");
            return;
        }
        if (playerStatistics.isMultiCannel()) {
            ALog.i((String)TAG, (String)"doLiveingFirstAccess playerStatistics isMultiCannel = true");
            return;
        }
        ATHLivePlayerStatistics aTHLivePlayerStatistics = playerStatistics;
        boolean bl = false;
        boolean bl2 = false;
        ATHLivePlayerStatistics it = aTHLivePlayerStatistics;
        boolean bl3 = false;
        if (it.getMFirstaccessReport()) {
            ALog.i((String)TAG, (String)("doLiveingFirstAccess " + it.getMFirstaccessReport()));
            return;
        }
        it.setMFirstaccessReport(true);
        StatisticsReport.Companion.getInstance().doReport(new Runnable(it, this, code, vodPlayerStatis, playerUUid){
            final /* synthetic */ ATHLivePlayerStatistics $it;
            final /* synthetic */ VodAthLivePlayerStatisticsServiceImpl this$0;
            final /* synthetic */ int $code$inlined;
            final /* synthetic */ String $vodPlayerStatis$inlined;
            final /* synthetic */ int $playerUUid$inlined;
            {
                this.$it = aTHLivePlayerStatistics;
                this.this$0 = vodAthLivePlayerStatisticsServiceImpl;
                this.$code$inlined = n;
                this.$vodPlayerStatis$inlined = string;
                this.$playerUUid$inlined = n2;
            }

            public final void run() {
                BaseHiidoContent baseHiidoContent = new BaseHiidoContent.BaseHiidoContentBuilder().setAct("lpfplayerfirstaccess").build();
                String qxd = TextUtils.isEmpty((CharSequence)this.$it.getConfigResolution()) ? "-1" : this.$it.getConfigResolution();
                String string = CommonStatisticsConfig.INSTANCE.getMAppid();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder = new FpflowCommonContent.FpflowCommonContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)baseHiidoContent);
                boolean bl = false;
                long l = Long.parseLong(string);
                PlayerStatisticsInfo playerStatisticsInfo = this.$it.getMPlayerStatisticsInfo();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder2 = fpflowCommonContentBuilder.setAppid(l).setScene(playerStatisticsInfo != null ? playerStatisticsInfo.getScene() : -1);
                Object object = this.$it.getMPlayerStatisticsInfo();
                if (object == null || (object = object.getEuid()) == null) {
                    object = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder3 = fpflowCommonContentBuilder2.setEuid((String)object).setUrl(this.$it.getMUrl()).setUUid(this.$it.getMUUid());
                String string2 = VodAthLivePlayerStatisticsServiceImpl.access$getMPackageName$p(this.this$0);
                if (string2 == null) {
                    string2 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder4 = fpflowCommonContentBuilder3.setPKg(string2).setQxd(qxd);
                Object object2 = this.$it.getMPlayerStatisticsInfo();
                if (object2 == null || (object2 = object2.getFd1()) == null) {
                    object2 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder5 = fpflowCommonContentBuilder4.setFd1((String)object2);
                Object object3 = this.$it.getMPlayerStatisticsInfo();
                if (object3 == null || (object3 = object3.getFd2()) == null) {
                    object3 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder6 = fpflowCommonContentBuilder5.setFd2((String)object3).setFbl(DeviceUtil.Companion.getScreenFbl(VodAthLivePlayerStatisticsServiceImpl.access$getMContext$p(this.this$0))).setOsv(DeviceUtil.Companion.getOsv());
                Object object4 = this.$it.getMPlayerStatisticsInfo();
                if (object4 == null || (object4 = object4.getCdnPlaySuffix()) == null) {
                    object4 = "-1";
                }
                PlayerStatisticsExtraInfo playerStatisticsExtraInfo = this.$it.getMPlayerStatisticsExtraInfo();
                PlayerStatisticsExtraInfo playerStatisticsExtraInfo2 = this.$it.getMPlayerStatisticsExtraInfo();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder7 = fpflowCommonContentBuilder6.setCdps((String)object4).setLsq(playerStatisticsExtraInfo != null ? playerStatisticsExtraInfo.getServicePmrovider() : -1).setMprotocol(playerStatisticsExtraInfo2 != null ? playerStatisticsExtraInfo2.getMediaProtocol() : -1);
                Object object5 = this.$it.getMPlayerStatisticsInfo();
                if (object5 == null || (object5 = object5.getHdid()) == null) {
                    object5 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder8 = fpflowCommonContentBuilder7.setHdid((String)object5);
                Object object6 = this.$it.getMPlayerStatisticsInfo();
                if (object6 == null || (object6 = object6.getCln()) == null) {
                    object6 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder9 = fpflowCommonContentBuilder8.setCln((String)object6);
                Object object7 = this.$it.getMPlayerStatisticsInfo();
                if (object7 == null || (object7 = object7.getAppinfo()) == null) {
                    object7 = "-1";
                }
                FpflowCommonContent fpflowCommonContent = fpflowCommonContentBuilder9.setAppinfo((String)object7).setVer("0.0.0.181.aar-SNAPSHOT").setInfo(DeviceUtil.Companion.getPhoneInfo()).setCtype(2).build();
                int sd = (int)(System.currentTimeMillis() - this.$it.getMFirstPtTime());
                if (this.$code$inlined == -2) {
                    sd -= 5000;
                }
                if (sd < 0) {
                    sd = 1;
                }
                IAthLivePlayerEngine iAthLivePlayerEngine = (IAthLivePlayerEngine)Axis.Companion.getService(IAthLivePlayerEngine.class);
                BasicDataContent basicDataContent = new BasicDataContent.BasicDataContentBuilder().setNt(NetUtils.getNetworkState((Context)(iAthLivePlayerEngine != null ? iAthLivePlayerEngine.getApplicationContext() : null))).setSd1(sd).setCode(this.$code$inlined).setAbstractHiidoContent((AbstractHiidoContent)fpflowCommonContent).build();
                int cugi = GslbUtils.INSTANCE.isUseGslb() ? 1 : 0;
                int chps = -1;
                Serializable serializable = this.$it.getMGslbMap();
                if (serializable != null && (serializable = (Integer)((HashMap)serializable).get(this.$it.getMUrl())) != null) {
                    Serializable serializable2 = serializable;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Serializable it = serializable2;
                    boolean bl4 = false;
                    Serializable serializable3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)serializable3, (String)"it");
                    chps = (Integer)serializable3;
                }
                LinkCorrelationContent linkCorrelationContent = new LinkCorrelationContent.LinkCorrelationContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)basicDataContent).setCugi(cugi).setChps(chps).setIsSupportQuic(this.$it.getMIsSupportQuic()).build();
                String urlEncoderPlayerStatis = VodAthLivePlayerStatisticsServiceImpl.access$urlEncodePlayerStatis(this.this$0, this.$vodPlayerStatis$inlined, this.$playerUUid$inlined, true);
                PlayerStatisticsInfo playerStatisticsInfo2 = this.$it.getMPlayerStatisticsInfo();
                if (!TextUtils.isEmpty((CharSequence)(playerStatisticsInfo2 != null ? playerStatisticsInfo2.getFirstAccessExtend() : null))) {
                    PlayerStatisticsInfo playerStatisticsInfo3 = this.$it.getMPlayerStatisticsInfo();
                    urlEncoderPlayerStatis = urlEncoderPlayerStatis + '&' + (playerStatisticsInfo3 != null ? playerStatisticsInfo3.getFirstAccessExtend() : null);
                }
                ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doLiveingFirstAccess urlEncoderPlayerStatis = " + urlEncoderPlayerStatis));
                String result = linkCorrelationContent.getContent() + urlEncoderPlayerStatis;
                ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doLiveingFirstAccess result = " + result));
                StatisticsReport.Companion.getInstance().doReportSync(result);
            }
        });
    }

    private final void doLivingLoop(int uuid, String playerStatis) {
        ATHLivePlayerStatistics playerStatistics = this.mPlayserStatisticsMap.get(uuid);
        if (playerStatistics == null) {
            ALog.i((String)TAG, (String)"doLivingLoop playerStatistics == null");
            return;
        }
        if (playerStatistics.isMultiCannel()) {
            ALog.i((String)TAG, (String)"doLivingLoop playerStatistics isMultiCannel = true");
            return;
        }
        ATHLivePlayerStatistics aTHLivePlayerStatistics = playerStatistics;
        boolean bl = false;
        boolean bl2 = false;
        ATHLivePlayerStatistics it = aTHLivePlayerStatistics;
        boolean bl3 = false;
        StatisticsReport.Companion.getInstance().doReport(new Runnable(it, this, playerStatis, uuid){
            final /* synthetic */ ATHLivePlayerStatistics $it;
            final /* synthetic */ VodAthLivePlayerStatisticsServiceImpl this$0;
            final /* synthetic */ String $playerStatis$inlined;
            final /* synthetic */ int $uuid$inlined;
            {
                this.$it = aTHLivePlayerStatistics;
                this.this$0 = vodAthLivePlayerStatisticsServiceImpl;
                this.$playerStatis$inlined = string;
                this.$uuid$inlined = n;
            }

            public final void run() {
                boolean bl;
                String it;
                String string = this.$playerStatis$inlined;
                if (string != null) {
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    it = string2;
                    bl = false;
                    ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doLivingLoop playerStatis = " + this.$playerStatis$inlined));
                }
                BaseHiidoContent baseHiidoContent = new BaseHiidoContent.BaseHiidoContentBuilder().setAct("lpfplayerdownload").build();
                String qxd = TextUtils.isEmpty((CharSequence)this.$it.getConfigResolution()) ? "-1" : this.$it.getConfigResolution();
                it = CommonStatisticsConfig.INSTANCE.getMAppid();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder = new FpflowCommonContent.FpflowCommonContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)baseHiidoContent);
                bl = false;
                long l = Long.parseLong(it);
                PlayerStatisticsInfo playerStatisticsInfo = this.$it.getMPlayerStatisticsInfo();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder2 = fpflowCommonContentBuilder.setAppid(l).setScene(playerStatisticsInfo != null ? playerStatisticsInfo.getScene() : -1);
                Object object = this.$it.getMPlayerStatisticsInfo();
                if (object == null || (object = object.getEuid()) == null) {
                    object = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder3 = fpflowCommonContentBuilder2.setEuid((String)object).setUrl(this.$it.getMUrl());
                Object object2 = this.$it.getMPlayerStatisticsInfo();
                if (object2 == null || (object2 = object2.getCln()) == null) {
                    object2 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder4 = fpflowCommonContentBuilder3.setCln((String)object2);
                Object object3 = this.$it.getMPlayerStatisticsInfo();
                if (object3 == null || (object3 = object3.getAppinfo()) == null) {
                    object3 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder5 = fpflowCommonContentBuilder4.setAppinfo((String)object3).setUUid(this.$it.getMUUid());
                String string3 = VodAthLivePlayerStatisticsServiceImpl.access$getMPackageName$p(this.this$0);
                if (string3 == null) {
                    string3 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder6 = fpflowCommonContentBuilder5.setPKg(string3).setQxd(qxd);
                Object object4 = this.$it.getMPlayerStatisticsInfo();
                if (object4 == null || (object4 = object4.getCdnPlaySuffix()) == null) {
                    object4 = "-1";
                }
                PlayerStatisticsExtraInfo playerStatisticsExtraInfo = this.$it.getMPlayerStatisticsExtraInfo();
                PlayerStatisticsExtraInfo playerStatisticsExtraInfo2 = this.$it.getMPlayerStatisticsExtraInfo();
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder7 = fpflowCommonContentBuilder6.setCdps((String)object4).setLsq(playerStatisticsExtraInfo != null ? playerStatisticsExtraInfo.getServicePmrovider() : -1).setMprotocol(playerStatisticsExtraInfo2 != null ? playerStatisticsExtraInfo2.getMediaProtocol() : -1);
                Object object5 = this.$it.getMPlayerStatisticsInfo();
                if (object5 == null || (object5 = object5.getFd1()) == null) {
                    object5 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder8 = fpflowCommonContentBuilder7.setFd1((String)object5);
                Object object6 = this.$it.getMPlayerStatisticsInfo();
                if (object6 == null || (object6 = object6.getFd2()) == null) {
                    object6 = "-1";
                }
                FpflowCommonContent.FpflowCommonContentBuilder fpflowCommonContentBuilder9 = fpflowCommonContentBuilder8.setFd2((String)object6).setFbl(DeviceUtil.Companion.getScreenFbl(VodAthLivePlayerStatisticsServiceImpl.access$getMContext$p(this.this$0))).setOsv(DeviceUtil.Companion.getOsv());
                Object object7 = this.$it.getMPlayerStatisticsInfo();
                if (object7 == null || (object7 = object7.getHdid()) == null) {
                    object7 = "-1";
                }
                FpflowCommonContent fpflowCommonContent = fpflowCommonContentBuilder9.setHdid((String)object7).setVer("0.0.0.181.aar-SNAPSHOT").setInfo(DeviceUtil.Companion.getPhoneInfo()).setCtype(2).build();
                StringBuilder stringBuilder = this.$it.getMAnchorUid();
                String string4 = stringBuilder != null ? stringBuilder.toString() : null;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.mAnchorUid?.toString()");
                String anchorUidResult = string4;
                if (!TextUtils.isEmpty((CharSequence)anchorUidResult) && StringsKt.startsWith$default((String)anchorUidResult, (String)",", (boolean)false, (int)2, null)) {
                    anchorUidResult = StringsKt.replaceFirst$default((String)anchorUidResult, (String)",", (String)"", (boolean)false, (int)4, null);
                }
                RegularlyCommonContent.RegularlyCommonContentBuilder regularlyCommonContentBuilder = new RegularlyCommonContent.RegularlyCommonContentBuilder().setFpflowCommonContent(fpflowCommonContent);
                String string5 = SystemUtil.getOs();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"SystemUtil.getOs()");
                RegularlyCommonContent regularlyCommonContent = regularlyCommonContentBuilder.setOs(string5).setAnchorUid(anchorUidResult).build();
                int pt = (int)(System.currentTimeMillis() - this.$it.getMFirstPtTime());
                int sd = 0;
                if (this.$it.getMLastLoopSd() == 0) {
                    sd = pt;
                    this.$it.setMLastLoopSd((int)System.currentTimeMillis());
                } else {
                    int currentTime = (int)System.currentTimeMillis();
                    sd = currentTime - this.$it.getMLastLoopSd();
                    this.$it.setMLastLoopSd(currentTime);
                }
                IAthLivePlayerEngine iAthLivePlayerEngine = (IAthLivePlayerEngine)Axis.Companion.getService(IAthLivePlayerEngine.class);
                RegularlyBasicDataContent regularlyBasicDataContent = new RegularlyBasicDataContent.RegularlyBasicDataContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)regularlyCommonContent).setNt(NetUtils.getNetworkState((Context)(iAthLivePlayerEngine != null ? iAthLivePlayerEngine.getApplicationContext() : null))).setSd1(sd).setPt(pt).build();
                int a2up = -1;
                Collection collection = this.$it.getMTimeDelayList();
                boolean bl4 = false;
                if (!collection.isEmpty()) {
                    long a2upTotal = 0L;
                    Iterable $this$forEach$iv = this.$it.getMTimeDelayList();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Long it2 = (Long)element$iv;
                        boolean bl5 = false;
                        Long l2 = it2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"it");
                        a2upTotal += l2.longValue();
                    }
                    a2up = (int)(a2upTotal / (long)this.$it.getMTimeDelayList().size());
                    this.$it.getMTimeDelayList().clear();
                }
                int[] cpuResult = SystemUtil.getCpuRate();
                IAthLivePlayerEngine iAthLivePlayerEngine2 = (IAthLivePlayerEngine)Axis.Companion.getService(IAthLivePlayerEngine.class);
                IAthLivePlayerEngine iAthLivePlayerEngine3 = (IAthLivePlayerEngine)Axis.Companion.getService(IAthLivePlayerEngine.class);
                RegularlySystemContent regularlySystemContent = new RegularlySystemContent.RegularlySystemContentBuilder().setAbstractHiidoContent((AbstractHiidoContent)regularlyBasicDataContent).setS1(SystemUtil.getNumberOfCPUCores()).setS2(cpuResult[1]).setS3(cpuResult[0]).setS4(SystemUtil.getUsedPercentValue((Context)(iAthLivePlayerEngine2 != null ? iAthLivePlayerEngine2.getApplicationContext() : null))).setS5(SystemUtil.getAppMemoryUser((Context)(iAthLivePlayerEngine3 != null ? iAthLivePlayerEngine3.getApplicationContext() : null))).setS6((int)SystemUtil.getTotalMemorySize()).setA2up(a2up).build();
                String urlEncoderPlayerStatis = VodAthLivePlayerStatisticsServiceImpl.urlEncodePlayerStatis$default(this.this$0, this.$playerStatis$inlined, this.$uuid$inlined, false, 4, null);
                ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doLivingLoop urlEncoderPlayerStatis = " + urlEncoderPlayerStatis));
                String result = regularlySystemContent.getContent() + urlEncoderPlayerStatis;
                ALog.d((String)"VodAthLivePlayerStatisticsServiceImpl", (String)("doLivingLoop result = " + result));
                StatisticsReport.Companion.getInstance().doReportSync(result);
            }
        });
    }

    private final String urlEncodePlayerStatis(String playerStatis, int playerUUid, boolean isFirstAccess) {
        ALog.d((String)TAG, (String)("urlEncodePlayerStatis playerStatis =" + playerStatis));
        if (TextUtils.isEmpty((CharSequence)playerStatis)) {
            return playerStatis;
        }
        try {
            StringBuilder result;
            block16: {
                String[] contents;
                block18: {
                    block17: {
                        String[] stringArray;
                        boolean $i$f$toTypedArray;
                        Collection $this$toTypedArray$iv;
                        result = new StringBuilder();
                        String string = playerStatis;
                        if (string == null) break block16;
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        List list = StringsKt.split$default((CharSequence)it, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
                        if (list != null) {
                            $this$toTypedArray$iv = list;
                            $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                            if (stringArray2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                            }
                            stringArray = stringArray2;
                        } else {
                            stringArray = contents = null;
                        }
                        if (contents == null) break block17;
                        $this$toTypedArray$iv = contents;
                        $i$f$toTypedArray = false;
                        if (!(((Collection)$this$toTypedArray$iv).length == 0)) break block18;
                    }
                    return playerStatis;
                }
                boolean hasChpiVaule = false;
                String cdnIp = "-1";
                for (String value : contents) {
                    String[] kv;
                    if (TextUtils.isEmpty((CharSequence)value)) continue;
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)value, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new String[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    if (kv.length != 2) continue;
                    result.append("&");
                    result.append(kv[0]);
                    result.append("=");
                    result.append(URLEncoder.encode(kv[1], "UTF-8"));
                    if (isFirstAccess) {
                        if (TextUtils.equals((CharSequence)kv[0], (CharSequence)"httpcode")) {
                            StatisticsUtils.updateCdnHttpCode((int)playerUUid, (String)kv[1]);
                        }
                        if (TextUtils.equals((CharSequence)kv[0], (CharSequence)"dspeed")) {
                            StatisticsUtils.updateCdnDdspeed((int)playerUUid, (String)kv[1]);
                        }
                        if (!TextUtils.equals((CharSequence)kv[0], (CharSequence)"dlsize")) continue;
                        StatisticsUtils.updateCdnDlsize((int)playerUUid, (String)kv[1]);
                        continue;
                    }
                    if (TextUtils.equals((CharSequence)kv[0], (CharSequence)"chpi") && !TextUtils.isEmpty((CharSequence)kv[1])) {
                        hasChpiVaule = true;
                    }
                    if (!TextUtils.equals((CharSequence)kv[0], (CharSequence)"cdn_ip") || TextUtils.isEmpty((CharSequence)kv[1])) continue;
                    cdnIp = kv[1];
                }
                if (!(isFirstAccess || hasChpiVaule || TextUtils.isEmpty((CharSequence)cdnIp))) {
                    result.append("&");
                    result.append("chpi");
                    result.append("=");
                    result.append(URLEncoder.encode(cdnIp, "UTF-8"));
                }
            }
            return result.toString();
        }
        catch (Exception e) {
            ALog.e((String)TAG, (String)"urlEncodePlayerStatis", (Throwable)e);
            return playerStatis;
        }
    }

    static /* synthetic */ String urlEncodePlayerStatis$default(VodAthLivePlayerStatisticsServiceImpl vodAthLivePlayerStatisticsServiceImpl, String string, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return vodAthLivePlayerStatisticsServiceImpl.urlEncodePlayerStatis(string, n, bl);
    }

    public static final /* synthetic */ void access$removePlayerUid(VodAthLivePlayerStatisticsServiceImpl $this, int playerUUid) {
        $this.removePlayerUid(playerUUid);
    }

    public static final /* synthetic */ void access$doLivingLoop(VodAthLivePlayerStatisticsServiceImpl $this, int uuid, String playerStatis) {
        $this.doLivingLoop(uuid, playerStatis);
    }

    public static final /* synthetic */ void access$doBusinessFlow(VodAthLivePlayerStatisticsServiceImpl $this, int uuid) {
        $this.doBusinessFlow(uuid);
    }

    public static final /* synthetic */ void access$doAdaptiveBitRateReport(VodAthLivePlayerStatisticsServiceImpl $this, int playerUUid, String vodPlayerStatis) {
        $this.doAdaptiveBitRateReport(playerUUid, vodPlayerStatis);
    }

    public static final /* synthetic */ String access$getMPackageName$p(VodAthLivePlayerStatisticsServiceImpl $this) {
        return $this.mPackageName;
    }

    public static final /* synthetic */ void access$setMPackageName$p(VodAthLivePlayerStatisticsServiceImpl $this, String string) {
        $this.mPackageName = string;
    }

    public static final /* synthetic */ Context access$getMContext$p(VodAthLivePlayerStatisticsServiceImpl $this) {
        return $this.mContext;
    }

    public static final /* synthetic */ void access$setMContext$p(VodAthLivePlayerStatisticsServiceImpl $this, Context context) {
        $this.mContext = context;
    }

    public static final /* synthetic */ String access$urlEncodePlayerStatis(VodAthLivePlayerStatisticsServiceImpl $this, String playerStatis, int playerUUid, boolean isFirstAccess) {
        return $this.urlEncodePlayerStatis(playerStatis, playerUUid, isFirstAccess);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltv/athena/live/player/vodplayer/VodAthLivePlayerStatisticsServiceImpl$Companion;", "", "()V", "TAG", "", "athliveplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

