package tv.athena.live.player.vodplayer

import android.content.Context
import android.os.Handler
import android.os.Looper
import android.text.TextUtils
import com.yy.transvod.player.OnPlayerStatisticsListener
import com.yy.transvod.preference.Preference
import tv.athena.annotation.ServiceRegister
import tv.athena.core.axis.Axis
import tv.athena.live.player.BuildConfig
import tv.athena.live.player.IAthLivePlayerEngine
import tv.athena.live.player.IAthLivePlayerStatisticsService
import tv.athena.live.player.bean.ATHLivePlayerStatistics
import tv.athena.live.player.bean.PlayerStatisticsExtraInfo
import tv.athena.live.player.bean.PlayerStatisticsInfo
import tv.athena.live.player.statistics.StatisticsReport
import tv.athena.live.player.statistics.common.CommonStatisticsConfig
import tv.athena.live.player.statistics.hiido.BaseHiidoContent
import tv.athena.live.player.statistics.hiido.fpflow.BasicDataContent
import tv.athena.live.player.statistics.hiido.fpflow.FpflowCommonContent
import tv.athena.live.player.statistics.hiido.fpflow.LinkCorrelationContent
import tv.athena.live.player.statistics.hiido.regularly.RegularlyBasicDataContent
import tv.athena.live.player.statistics.hiido.regularly.RegularlyCommonContent
import tv.athena.live.player.statistics.hiido.regularly.RegularlySystemContent
import tv.athena.live.utils.DeviceUtil
import tv.athena.live.utils.NetUtils
import tv.athena.live.player.vodplayer.utils.SystemUtil
import tv.athena.live.utils.ALog
import tv.athena.live.utils.GslbUtils
import tv.athena.live.utils.StatisticsUtils
import tv.athena.live.utils.UUidUtil
import java.lang.Exception
import java.lang.StringBuilder
import java.net.URLEncoder
import java.util.concurrent.ConcurrentHashMap

/**
 *
 * @Description: 作用描述
 * @Author: dengqu
 * @CreateDate: 2020-08-07 15:56
 *
 */
@ServiceRegister(serviceInterface = IAthLivePlayerStatisticsService::class)
class VodAthLivePlayerStatisticsServiceImpl : IAthLivePlayerStatisticsService {

    override fun setTimeDelay(mPlayerUUid: Int, timeDelay: Long) {
        var playerStatistics = mPlayserStatisticsMap[mPlayerUUid]
        playerStatistics?.mTimeDelayList?.add(timeDelay)
    }

    override fun updateQxd(mPlayerUUid: Int, qxd: String) {
        var playerStatistics = mPlayserStatisticsMap[mPlayerUUid]
        playerStatistics?.configResolution = qxd
    }

    private var mHandler = Handler(Looper.getMainLooper())
    private var mPackageName: String? = "-1"
    private var mContext: Context? = null
    override fun setPlayerUrl(playerUUid: Int, url: String) {
        ALog.i(TAG, "setPlayerUrl $playerUUid $url")
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "setPlayerUrl playerStatistics == null $playerUUid")
            return
        }
        playerStatistics.mUrl = url
        playerStatistics.mUUid = UUidUtil.getUUID32()
    }

    override fun setIsSupportQuic(playerUUid: Int, supportQuic: Boolean) {
        ALog.i(TAG, "setIsSupportQuic $playerUUid $supportQuic")
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "setIsSupportQuic playerStatistics == null")
            return
        }
        playerStatistics.mIsSupportQuic = supportQuic
    }

    override fun setSceneId(playerUUid: Int, sceneId: Long) {
        ALog.i(TAG, "setSceneId $playerUUid $sceneId")
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "setSceneId playerStatistics == null")
            return
        }
        playerStatistics.mPlayerStatisticsInfo?.scene = sceneId.toInt()
    }

    override fun setGslbTime(playerUUid: Int, gslbTime: Int) {
        ALog.i(TAG, "setGslbTime $playerUUid $gslbTime")
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "setGslbTime playerStatistics == null")
            return
        }
        playerStatistics?.mGslbMap?.let {
            it[playerStatistics.mUrl] = gslbTime
        }
    }

    override fun addAnchorUid(playerUUid: Int, mUid: String?) {
        var playerStatistics: ATHLivePlayerStatistics? = mPlayserStatisticsMap[playerUUid] ?: return
        playerStatistics?.addAnchorUid(mUid)
    }

    override fun setConfigResolution(mPlayerUUid: Int, configResolution: String) {
        ALog.i(TAG, "setConfigResolution $mPlayerUUid $configResolution")
        var playerStatistics = mPlayserStatisticsMap[mPlayerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "setConfigResolution playerStatistics == null")
            return
        }
        playerStatistics?.configResolution = configResolution
    }

    override fun updateCannelType(mPlayerUUid: Int, flag: Boolean) {
        ALog.i(TAG, "updateCannelType $mPlayerUUid $flag")
        var playerStatistics = mPlayserStatisticsMap[mPlayerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "updateCannelType playerStatistics == null")
            return
        }
        playerStatistics?.isMultiCannel = flag
    }

    override fun getATHLivePlayerStatistics(playerUUid: Int): ATHLivePlayerStatistics? {
        return mPlayserStatisticsMap?.get(playerUUid)
    }

    override fun leave(playerUUid: Int) {
        ALog.i(TAG, "leave $playerUUid")
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "leave playerStatistics == null")
            return
        }
        if (playerStatistics.isMultiCannel) {
            removePlayerUid(playerUUid)
            ALog.i(TAG, "leave isMultiCannel == ${playerStatistics.isMultiCannel}")
            return
        }
        doBusinessFlow(playerUUid)
        mHandler?.postDelayed({
            if (!playerStatistics.mFirstaccessReport) {
                doLiveingFirstAccess(playerUUid,
                    IAthLivePlayerStatisticsService.IATHPlayerFirstAccessCode.CODE_LEAVE_ROOM,
                    "")
            }
            removePlayerUid(playerUUid)
        }, 5000)
    }

    private fun removePlayerUid(playerUUid: Int) {
        ALog.i(TAG, "removePlayerUid $playerUUid")
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "removePlayerUid playerStatistics == null")
            return
        }
        if (playerStatistics.mFirstaccessReport) {
            ALog.i(TAG, "leave ${playerStatistics.mFirstaccessReport}")
            mPlayserStatisticsMap.remove(playerUUid)
            return
        }
    }

    override fun setPlayerStatisticsInfo(
        playerUUid: Int, playerStatisticsInfo: PlayerStatisticsInfo,
        playerStatisticsExtraInfo: PlayerStatisticsExtraInfo
    ) {
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "doLiveingFirstAccess playerStatistics == null")
            return
        }
        playerStatistics.mPlayerStatisticsInfo = playerStatisticsInfo
        playerStatistics.mPlayerStatisticsExtraInfo = playerStatisticsExtraInfo
    }

    companion object {
        private const val TAG = "VodAthLivePlayerStatisticsServiceImpl"
    }

    /**
     * 播放器统计集合
     */
    private var mPlayserStatisticsMap = ConcurrentHashMap<Int, ATHLivePlayerStatistics?>()

    override fun init(packageName: String?, context: Context) {
        mPackageName = packageName
        mContext = context
        Preference.setStatisticsCallback { taskId, type, text ->
            /**
             * 任务id   /  类型 /   统计字符串
             */
            ALog.i(TAG, "onStatistics taskId=$taskId,type = $type,text = $text")
            when (type) {
                OnPlayerStatisticsListener.STATISTICS_TYPE_LIVEING_FIRST_ACCESS -> {
                    doLiveingFirstAccess(taskId,
                        IAthLivePlayerStatisticsService.IATHPlayerFirstAccessCode.CODE_NORMAL,
                        text)
                }
                OnPlayerStatisticsListener.STATISTICS_TYPE_LIVING_LOOP -> {
                    doLivingLoop(taskId, text)
                    doBusinessFlow(taskId)
                }
                OnPlayerStatisticsListener.STATISTICS_TYPE_LIVNG_DASH_SWITCH -> {
                    doAdaptiveBitRateReport(taskId, text)
                }
            }
        }
    }

    private fun doAdaptiveBitRateReport(playerUUid: Int, vodPlayerStatis: String?) {
        var playerStatistics = mPlayserStatisticsMap[playerUUid]
        if (playerStatistics == null) {
            ALog.i(TAG, "doAdaptiveBitRateReport playerStatistics == null")
            return
        }
        playerStatistics?.let {
            StatisticsReport.instance.doReport(Runnable {
                var baseHiidoContent = BaseHiidoContent.BaseHiidoContentBuilder().setAct(
                    StatisticsReport.LPF_AUTO_ADAPTIVE_SWITCH).build()
                var fpflowCommonContent =
                    FpflowCommonContent.FpflowCommonContentBuilder()
                        .setAbstractHiidoContent(baseHiidoContent)
                        .setAppid(CommonStatisticsConfig.mAppid.toLong())
                        .setScene(it.mPlayerStatisticsInfo?.scene ?: -1)
                        .setEuid(it.mPlayerStatisticsInfo?.euid ?: "-1")
                        .setUrl(it.mUrl)
                        .setUUid(it.mUUid)
                        .setPKg(mPackageName ?: "-1")
                        .setFd1(it.mPlayerStatisticsInfo?.fd1 ?: "-1")
                        .setFd2(it.mPlayerStatisticsInfo?.fd2 ?: "-1")
                        .setFbl(DeviceUtil.getScreenFbl(mContext))
                        .setOsv(DeviceUtil.getOsv())
                        .setCdps(it.mPlayerStatisticsInfo?.cdnPlaySuffix ?: "-1")
                        .setLsq(it.mPlayerStatisticsExtraInfo?.servicePmrovider ?: -1)
                        .setMprotocol(it.mPlayerStatisticsExtraInfo?.mediaProtocol ?: -1)
                        .setHdid(it.mPlayerStatisticsInfo?.hdid ?: "-1")
                        .setCln(it.mPlayerStatisticsInfo?.cln ?: "-1")
                        .setAppinfo(it.mPlayerStatisticsInfo?.appinfo ?: "-1")
                        .setVer(BuildConfig.blitzplayer_version)
                        .setInfo(DeviceUtil.getPhoneInfo())
                        .setCtype(FpflowCommonContent.ANDROID_YY)
                        .build()
                var pt = (System.currentTimeMillis() - it.mFirstPtTime).toInt()
                //存在秒开的话，it.mFirstPtTime初始化比这个回调还晚
                if (pt < 0) {
                    pt = 1
                }
                var sd = 0
                if (it.mAdaptiveBitRateLoopSd == 0) {
                    sd = pt
                    it.mAdaptiveBitRateLoopSd = System.currentTimeMillis().toInt()
                } else {
                    var currentTime: Int = System.currentTimeMillis().toInt()
                    sd = currentTime - it.mAdaptiveBitRateLoopSd
                    it.mAdaptiveBitRateLoopSd = currentTime
                }

                var anchorUidResult = it.mAnchorUid?.toString()
                if (!TextUtils.isEmpty(anchorUidResult) && anchorUidResult.startsWith(",")) {
                    anchorUidResult = anchorUidResult.replaceFirst(",", "")
                }

                var basicDataContent =
                    BasicDataContent.BasicDataContentBuilder()
                        .setNt(NetUtils.getNetworkState(
                            Axis.getService(
                                IAthLivePlayerEngine::class.java)?.getApplicationContext()))
                        .setSd1(sd)
                        .setPt(pt)
                        .setAnchorUid(anchorUidResult)
                        .setAbstractHiidoContent(fpflowCommonContent)
                        .build()
                var urlEncoderPlayerStatis =
                    urlEncodePlayerStatis(vodPlayerStatis, playerUUid, false)
                ALog.d(TAG, "doAdaptiveBitRateReport urlEncoderPlayerStatis = $urlEncoderPlayerStatis")
                var result = basicDataContent.getContent() + urlEncoderPlayerStatis
                ALog.d(TAG, "doAdaptiveBitRateReport result = $result")
                StatisticsReport.instance.doReportSync(result)
            })
        }
    }

    private fun doBusinessFlow(uuid: Int) {
        var playerStatistics = mPlayserStatisticsMap[uuid]

        if (playerStatistics == null) {
            ALog.i(TAG, "doBusinessFlow playerStatistics == null")
            return
        }
        if (playerStatistics.isMultiCannel) {
            ALog.i(TAG, "doBusinessFlow playerStatistics isMultiCannel = true")
            return
        }
        playerStatistics?.let {
            StatisticsReport.instance.doReport(Runnable {
                var baseHiidoContent = BaseHiidoContent.BaseHiidoContentBuilder().setAct(
                    StatisticsReport.LPF_PLAYER_BUSINESSFLOW).build()
                var qxd = if (TextUtils.isEmpty(it.configResolution)) {
                    "-1"
                } else {
                    it.configResolution
                }
                var fpflowCommonContent =
                    FpflowCommonContent.FpflowCommonContentBuilder()
                        .setAbstractHiidoContent(baseHiidoContent)
                        .setAppid(CommonStatisticsConfig.mAppid.toLong())
                        .setScene(it.mPlayerStatisticsInfo?.scene ?: -1)
                        .setEuid(it.mPlayerStatisticsInfo?.euid ?: "-1")
                        .setUrl(it.mUrl)
                        .setCln(it.mPlayerStatisticsInfo?.cln ?: "-1")
                        .setAppinfo(it.mPlayerStatisticsInfo?.appinfo ?: "-1")
                        .setUUid(it.mUUid)
                        .setPKg(mPackageName ?: "-1")
                        .setQxd(qxd)
                        .setFd1(it.mPlayerStatisticsInfo?.fd1 ?: "-1")
                        .setFd2(it.mPlayerStatisticsInfo?.fd2 ?: "-1")
                        .setFbl(DeviceUtil.getScreenFbl(mContext))
                        .setOsv(DeviceUtil.getOsv())
                        .setHdid(it.mPlayerStatisticsInfo?.hdid ?: "-1")
                        .setVer(BuildConfig.blitzplayer_version)
                        .setInfo(DeviceUtil.getPhoneInfo())
                        .setCtype(FpflowCommonContent.ANDROID_YY)
                        .build()
                var anchorUidResult = it.mAnchorUid?.toString()
                if (!TextUtils.isEmpty(anchorUidResult) && anchorUidResult.startsWith(",")) {
                    anchorUidResult = anchorUidResult.replaceFirst(",", "")
                }
                var regularlyCommonContent = RegularlyCommonContent.RegularlyCommonContentBuilder()
                    .setFpflowCommonContent(fpflowCommonContent)
                    .setOs(SystemUtil.getOs())
                    .setAnchorUid(anchorUidResult)
                    .build()

                var pt = (System.currentTimeMillis() - it.mFirstPtTime).toInt()
                var sd = 0
                if (it.mLastBussinessLoopSd == 0) {
                    sd = pt
                    it.mLastBussinessLoopSd = System.currentTimeMillis().toInt()
                } else {
                    var currentTime: Int = System.currentTimeMillis().toInt()
                    sd = currentTime - it.mLastBussinessLoopSd
                    it.mLastBussinessLoopSd = currentTime
                }
                var regularlyBasicDataContent =
                    RegularlyBasicDataContent.RegularlyBasicDataContentBuilder()
                        .setAbstractHiidoContent(regularlyCommonContent)
                        .setNt(NetUtils.getNetworkState(
                            Axis.getService(
                                IAthLivePlayerEngine::class.java)?.getApplicationContext()))
                        .setSd1(sd)
                        .setPt(pt)
                        .build()
                var result = regularlyBasicDataContent.getContent()
                ALog.d(TAG, "doBusinessFlow result = $result")
                StatisticsReport.instance.doReportSync(result)
            })
        }
    }

    override fun addATHLivePlayerStatistics(
        playerUUid: Int, playerStatistics: ATHLivePlayerStatistics?
    ) {
        mPlayserStatisticsMap?.put(playerUUid, playerStatistics)
    }

    override fun doLiveingFirstAccess(playerUUid: Int, code: Int, vodPlayerStatis: String?) {
        var playerStatistics = mPlayserStatisticsMap[playerUUid]

        if (playerStatistics == null) {
            ALog.i(TAG, "doLiveingFirstAccess playerStatistics == null")
            return
        }
        if (playerStatistics.isMultiCannel) {
            ALog.i(TAG, "doLiveingFirstAccess playerStatistics isMultiCannel = true")
            return
        }
        playerStatistics?.let {
            if (it.mFirstaccessReport) {
                ALog.i(TAG, "doLiveingFirstAccess ${it.mFirstaccessReport}")
                return
            }
            it.mFirstaccessReport = true
            StatisticsReport.instance.doReport(Runnable {
                var baseHiidoContent = BaseHiidoContent.BaseHiidoContentBuilder().setAct(
                    StatisticsReport.LPF_PLAYER_FIRST_ACCESS).build()
                var qxd = if (TextUtils.isEmpty(it.configResolution)) {
                    "-1"
                } else {
                    it.configResolution
                }
                var fpflowCommonContent =
                    FpflowCommonContent.FpflowCommonContentBuilder()
                        .setAbstractHiidoContent(baseHiidoContent)
                        .setAppid(CommonStatisticsConfig.mAppid.toLong())
                        .setScene(it.mPlayerStatisticsInfo?.scene ?: -1)
                        .setEuid(it.mPlayerStatisticsInfo?.euid ?: "-1")
                        .setUrl(it.mUrl)
                        .setUUid(it.mUUid)
                        .setPKg(mPackageName ?: "-1")
                        .setQxd(qxd)
                        .setFd1(it.mPlayerStatisticsInfo?.fd1 ?: "-1")
                        .setFd2(it.mPlayerStatisticsInfo?.fd2 ?: "-1")
                        .setFbl(DeviceUtil.getScreenFbl(mContext))
                        .setOsv(DeviceUtil.getOsv())
                        .setCdps(it.mPlayerStatisticsInfo?.cdnPlaySuffix ?: "-1")
                        .setLsq(it.mPlayerStatisticsExtraInfo?.servicePmrovider ?: -1)
                        .setMprotocol(it.mPlayerStatisticsExtraInfo?.mediaProtocol ?: -1)
                        .setHdid(it.mPlayerStatisticsInfo?.hdid ?: "-1")
                        .setCln(it.mPlayerStatisticsInfo?.cln ?: "-1")
                        .setAppinfo(it.mPlayerStatisticsInfo?.appinfo ?: "-1")
                        .setVer(BuildConfig.blitzplayer_version)
                        .setInfo(DeviceUtil.getPhoneInfo())
                        .setCtype(FpflowCommonContent.ANDROID_YY)
                        .build()
                var sd = (System.currentTimeMillis() - it.mFirstPtTime).toInt()
                if (code == IAthLivePlayerStatisticsService.IATHPlayerFirstAccessCode.CODE_LEAVE_ROOM) {
                    sd -= 5000
                }
                //存在秒开的话，it.mFirstPtTime初始化比这个回调还晚
                if (sd < 0) {
                    sd = 1
                }
                var basicDataContent =
                    BasicDataContent.BasicDataContentBuilder()
                        .setNt(NetUtils.getNetworkState(
                            Axis.getService(
                                IAthLivePlayerEngine::class.java)?.getApplicationContext()))
                        .setSd1(sd)
                        .setCode(code)
                        .setAbstractHiidoContent(fpflowCommonContent)
                        .build()
                var cugi = if (GslbUtils.isUseGslb()) {
                    1
                } else {
                    0
                }
                var chps: Int = -1
                it.mGslbMap?.get(it.mUrl)?.let {
                    chps = it
                }
                var linkCorrelationContent =
                    LinkCorrelationContent.LinkCorrelationContentBuilder()
                        .setAbstractHiidoContent(basicDataContent)
                        .setCugi(cugi)
                        .setChps(chps)
                        .setIsSupportQuic(it.mIsSupportQuic)
                        .build()
                var urlEncoderPlayerStatis =
                    urlEncodePlayerStatis(vodPlayerStatis, playerUUid, true)
                if (!TextUtils.isEmpty(it.mPlayerStatisticsInfo?.firstAccessExtend)) {
                    urlEncoderPlayerStatis = "$urlEncoderPlayerStatis&${it.mPlayerStatisticsInfo?.firstAccessExtend}"
                }
                ALog.d(TAG, "doLiveingFirstAccess urlEncoderPlayerStatis = $urlEncoderPlayerStatis")
                var result = linkCorrelationContent.getContent() + urlEncoderPlayerStatis
                ALog.d(TAG, "doLiveingFirstAccess result = $result")
                StatisticsReport.instance.doReportSync(result)
            })
        }
    }

    /**
     * 数据上报-定时上报
     */
    private fun doLivingLoop(uuid: Int, playerStatis: String?) {
        var playerStatistics = mPlayserStatisticsMap[uuid]

        if (playerStatistics == null) {
            ALog.i(TAG, "doLivingLoop playerStatistics == null")
            return
        }
        if (playerStatistics.isMultiCannel) {
            ALog.i(TAG, "doLivingLoop playerStatistics isMultiCannel = true")
            return
        }
        playerStatistics?.let {
            StatisticsReport.instance.doReport(Runnable {
                playerStatis?.let {
                    ALog.d(TAG, "doLivingLoop playerStatis = $playerStatis")
                }
                var baseHiidoContent = BaseHiidoContent.BaseHiidoContentBuilder().setAct(
                    StatisticsReport.LPF_PLAYER_DOWNLOAD).build()
                var qxd = if (TextUtils.isEmpty(it.configResolution)) {
                    "-1"
                } else {
                    it.configResolution
                }
                var fpflowCommonContent =
                    FpflowCommonContent.FpflowCommonContentBuilder()
                        .setAbstractHiidoContent(baseHiidoContent)
                        .setAppid(CommonStatisticsConfig.mAppid.toLong())
                        .setScene(it.mPlayerStatisticsInfo?.scene ?: -1)
                        .setEuid(it.mPlayerStatisticsInfo?.euid ?: "-1")
                        .setUrl(it.mUrl)
                        .setCln(it.mPlayerStatisticsInfo?.cln ?: "-1")
                        .setAppinfo(it.mPlayerStatisticsInfo?.appinfo ?: "-1")
                        .setUUid(it.mUUid)
                        .setPKg(mPackageName ?: "-1")
                        .setQxd(qxd)
                        .setCdps(it.mPlayerStatisticsInfo?.cdnPlaySuffix ?: "-1")
                        .setLsq(it.mPlayerStatisticsExtraInfo?.servicePmrovider ?: -1)
                        .setMprotocol(it.mPlayerStatisticsExtraInfo?.mediaProtocol ?: -1)
                        .setFd1(it.mPlayerStatisticsInfo?.fd1 ?: "-1")
                        .setFd2(it.mPlayerStatisticsInfo?.fd2 ?: "-1")
                        .setFbl(DeviceUtil.getScreenFbl(mContext))
                        .setOsv(DeviceUtil.getOsv())
                        .setHdid(it.mPlayerStatisticsInfo?.hdid ?: "-1")
                        .setVer(BuildConfig.blitzplayer_version)
                        .setInfo(DeviceUtil.getPhoneInfo())
                        .setCtype(FpflowCommonContent.ANDROID_YY)
                        .build()
                var anchorUidResult = it.mAnchorUid?.toString()
                if (!TextUtils.isEmpty(anchorUidResult) && anchorUidResult.startsWith(",")) {
                    anchorUidResult = anchorUidResult.replaceFirst(",", "")
                }
                var regularlyCommonContent = RegularlyCommonContent.RegularlyCommonContentBuilder()
                    .setFpflowCommonContent(fpflowCommonContent)
                    .setOs(SystemUtil.getOs())
                    .setAnchorUid(anchorUidResult)
                    .build()

                var pt = (System.currentTimeMillis() - it.mFirstPtTime).toInt()
                var sd = 0
                if (it.mLastLoopSd == 0) {
                    sd = pt
                    it.mLastLoopSd = System.currentTimeMillis().toInt()
                } else {
                    var currentTime: Int = System.currentTimeMillis().toInt()
                    sd = currentTime - it.mLastLoopSd
                    it.mLastLoopSd = currentTime
                }
                var regularlyBasicDataContent =
                    RegularlyBasicDataContent.RegularlyBasicDataContentBuilder()
                        .setAbstractHiidoContent(regularlyCommonContent)
                        .setNt(NetUtils.getNetworkState(
                            Axis.getService(
                                IAthLivePlayerEngine::class.java)?.getApplicationContext()))
                        .setSd1(sd)
                        .setPt(pt)
                        .build()

                var a2up = -1
                if (it.mTimeDelayList.isNotEmpty()) {
                    var a2upTotal = 0L
                    it.mTimeDelayList.forEach {
                        a2upTotal += it
                    }
                    a2up = (a2upTotal / it.mTimeDelayList.size).toInt()
                    it.mTimeDelayList.clear()
                }
                val cpuResult = SystemUtil.getCpuRate()
                var regularlySystemContent = RegularlySystemContent.RegularlySystemContentBuilder()
                    .setAbstractHiidoContent(regularlyBasicDataContent)
                    .setS1(SystemUtil.getNumberOfCPUCores())
                    .setS2(cpuResult[1])
                    .setS3(cpuResult[0])
                    .setS4(SystemUtil.getUsedPercentValue(
                        Axis.getService(
                            IAthLivePlayerEngine::class.java)?.getApplicationContext()))
                    .setS5(SystemUtil.getAppMemoryUser(
                        Axis.getService(
                            IAthLivePlayerEngine::class.java)?.getApplicationContext()))
                    .setS6(SystemUtil.getTotalMemorySize().toInt())
                    .setA2up(a2up)
                    .build()

                var urlEncoderPlayerStatis = urlEncodePlayerStatis(playerStatis, uuid)
                ALog.d(TAG, "doLivingLoop urlEncoderPlayerStatis = $urlEncoderPlayerStatis")
                var result = regularlySystemContent.getContent() + urlEncoderPlayerStatis
                ALog.d(TAG, "doLivingLoop result = $result")
                StatisticsReport.instance.doReportSync(result)
            })
        }
    }

    private fun urlEncodePlayerStatis(
        playerStatis: String?, playerUUid: Int, isFirstAccess: Boolean = false
    ): String? {
        ALog.d(TAG, "urlEncodePlayerStatis playerStatis =$playerStatis")
        if (TextUtils.isEmpty(playerStatis)) {
            return playerStatis
        }
        try {
            var result = StringBuilder()
            playerStatis?.let {
                val contents: Array<String>? = it.split("&")?.toTypedArray()
                if (contents == null || contents.isEmpty()) {
                    return playerStatis
                }
                var hasChpiVaule = false
                var cdnIp = "-1"
                for (value in contents!!) {
                    if (!TextUtils.isEmpty(value)) {
                        val kv = value.split("=").toTypedArray()
                        if (kv.size == 2) {
                            result.append("&")
                            result.append(kv[0])
                            result.append("=")
                            result.append(URLEncoder.encode(kv[1], "UTF-8"))
                            if (isFirstAccess) {
                                if (TextUtils.equals(kv[0], "httpcode")) {
                                    StatisticsUtils.updateCdnHttpCode(playerUUid, kv[1])
                                }
                                if (TextUtils.equals(kv[0], "dspeed")) {
                                    StatisticsUtils.updateCdnDdspeed(playerUUid, kv[1])
                                }
                                if (TextUtils.equals(kv[0], "dlsize")) {
                                    StatisticsUtils.updateCdnDlsize(playerUUid, kv[1])
                                }
                            } else {
                                if (TextUtils.equals(kv[0], "chpi") && !TextUtils.isEmpty(kv[1])) {
                                    hasChpiVaule = true
                                }
                                if (TextUtils.equals(kv[0], "cdn_ip")) {
                                    if (!TextUtils.isEmpty(kv[1])) {
                                        cdnIp = kv[1]
                                    }
                                }
                            }
                        }
                    }
                }
                //定时上报数据中没有chpi，并且cdn_ip有值，主动赋值
                if (!isFirstAccess && !hasChpiVaule && !TextUtils.isEmpty(cdnIp)) {
                    result.append("&")
                    result.append("chpi")
                    result.append("=")
                    result.append(URLEncoder.encode(cdnIp, "UTF-8"))
                }
            }
            return result.toString()
        } catch (e: Exception) {
            ALog.e(TAG, "urlEncodePlayerStatis", e)
        }
        return playerStatis
    }
}