package tv.athena.live.player.vodplayer.utils

import com.yy.transvod.player.VodPlayer
import com.yy.transvod.player.common.MixVideoExtraInfo
import com.yy.transvod.player.common.VideoExtraInfo
import tv.athena.live.ntp.SntpClient
import tv.athena.live.utils.ALog
import java.util.ArrayList

/**
 *
 * @Description: 作用描述
 * @Author: dengqu
 * @CreateDate: 2020/11/30 3:06 PM
 *
 */
object SeiParseUtil {
    const val TAG = "SeiParseUtil"

    //协议头部大小
    private const val SEI_PAYLOAD_HEAD_SIZE = 3

    fun decodeSEIPayload(p0: VodPlayer?, url: String, sei: ByteArray?, listener: ATHCdnPlayerSeiListener?) {
        try {
            sei?.let {
                //ALog.i(TAG, "decodeSEIPayload size =${it.size}")
                var start = 0
                var totalLength = it.size
                val appDataList = ArrayList<VideoExtraInfo>()
                val layoutList = ArrayList<MixVideoExtraInfo>()
                while (start <= (totalLength - SEI_PAYLOAD_HEAD_SIZE)) {
                    var curPayloadLength = SntpClient.read(sei[start], sei[start + 1]).toInt()
                    if (start + curPayloadLength > totalLength) {
                        break
                    }
                    var payloadType: Int = SntpClient.ui(sei[start + 2])
                    //ALog.i(TAG, "payloadType = " + payloadType)
                    when (payloadType) {
                        2 -> {
                            if (curPayloadLength > 2) {
                                var startPoint = start + SEI_PAYLOAD_HEAD_SIZE
                                var length: Int = SntpClient.read(sei[startPoint], sei[startPoint + 1]).toInt()
                                if (length > 0 && length <= curPayloadLength - SEI_PAYLOAD_HEAD_SIZE - 2) {
                                    var info = VideoExtraInfo()
                                    info.mUrl = url
                                    info.mStrExtraInfo = ByteArray(length)
                                    System.arraycopy(sei, startPoint + 2, info.mStrExtraInfo, 0, length)
                                    appDataList.add(info)
                                }
                            }
                        }

                        4 -> {
                            var length = curPayloadLength
                            var layoutCnt = SntpClient.ui(sei[start + 3])
                            var layoutDataPtr = start + SEI_PAYLOAD_HEAD_SIZE + 1
                            length -= (SEI_PAYLOAD_HEAD_SIZE + 1)
                            for (i in 0 until layoutCnt) {
                                if (layoutDataPtr > start + curPayloadLength) {
                                    break
                                }
                                var dataLenth = SntpClient.read(sei[layoutDataPtr], sei[layoutDataPtr + 1]).toInt()
                                layoutDataPtr += 2 // skip len (2Byte)
                                dataLenth -= 2 // skip len
                                length -= 2

                                if (dataLenth in 1..length) {
                                    var layout = layoutDataPtr
                                    layoutDataPtr += dataLenth
                                    length -= dataLenth

                                    // |uidlen(1byte)|uid(nbyte)|appdatalen(2byte)|appdata(nbyte)|***|
                                    // uid
                                    var uidLen = SntpClient.ui(sei[layout])
                                    layout++
                                    dataLenth--
                                    if (uidLen > dataLenth) {
                                        continue
                                    }
                                    var data = ByteArray(uidLen)
                                    System.arraycopy(sei, layout, data, 0, uidLen)
                                    var strUid = String(data)
                                    //ALog.i(TAG, "strUid=$strUid")
                                    layout += uidLen
                                    dataLenth -= uidLen
                                    // appdata
                                    if (dataLenth < 2) {
                                        continue
                                    }
                                    var appdataLen = SntpClient.read(sei[layout], sei[layout + 1]).toInt()
                                    layout += 2
                                    dataLenth -= 2
                                    if (appdataLen > dataLenth) {
                                        continue
                                    }
                                    if (appdataLen > 0) {
                                        var info = VideoExtraInfo()
                                        info.mUrl = url
                                        info.mUid = strUid
                                        info.mStrExtraInfo = ByteArray(appdataLen)
                                        System.arraycopy(sei, layout, info.mStrExtraInfo, 0, appdataLen)
                                        appDataList.add(info)
                                        layout += appdataLen
                                        dataLenth -= appdataLen
                                    }

                                    // layout
                                    //|flag(1byte)|alpha(1byte)|zorder(1byte)|srcwidth(2byte)|srcheight(2byte)|cropX(2byte)|cropY(2byte)|cropW(2byte)|cropH(2byte)|layoutX(2)|layoutY(2)|layoutW(2)|layoutH(2)|
                                    if (dataLenth < 1) {
                                        continue
                                    }
                                    var flag = SntpClient.ui(sei[layout])
                                    var extraInfo = MixVideoExtraInfo()
                                    var content = 0
                                    var delayIndex = layout + 1
                                    dataLenth--
                                    // 先判断是否有布局信息
                                    if ((flag and 0x01) == 1) {
                                        if (dataLenth < 23) {
                                            continue
                                        }
                                        delayIndex = layout + 23
                                        var alpha = SntpClient.ui(sei[layout + 1])
                                        var zorder = SntpClient.ui(sei[layout + 2])
                                        var srcW = SntpClient.read(sei[layout + 3], sei[layout + 4]).toInt()
                                        var srcH = SntpClient.read(sei[layout + 5], sei[layout + 6]).toInt()
                                        var cropX = SntpClient.read(sei[layout + 7], sei[layout + 8]).toInt()
                                        var cropY = SntpClient.read(sei[layout + 9], sei[layout + 10]).toInt()
                                        var cropW = SntpClient.read(sei[layout + 11], sei[layout + 12]).toInt()
                                        var cropH = SntpClient.read(sei[layout + 13], sei[layout + 14]).toInt()
                                        var layoutX = SntpClient.read(sei[layout + 15], sei[layout + 16]).toInt()
                                        var layoutY = SntpClient.read(sei[layout + 17], sei[layout + 18]).toInt()
                                        var layoutW = SntpClient.read(sei[layout + 19], sei[layout + 20]).toInt()
                                        var layoutH = SntpClient.read(sei[layout + 21], sei[layout + 22]).toInt()

                                        extraInfo.url = url
                                        extraInfo.uid = strUid
                                        extraInfo.alpha = (alpha / 255.0).toFloat()
                                        extraInfo.zOrder = zorder
                                        extraInfo.width = srcW
                                        extraInfo.height = srcH
                                        extraInfo.cropX = cropX
                                        extraInfo.cropY = cropY
                                        extraInfo.cropW = cropW
                                        extraInfo.cropH = cropH
                                        extraInfo.layoutX = layoutX
                                        extraInfo.layoutY = layoutY
                                        extraInfo.layoutW = layoutW
                                        extraInfo.layoutH = layoutH
                                        extraInfo.content = content
                                        dataLenth -= 22
                                    }
                                    // 判断帧内容
                                    if ((flag and 0x2) == 0x2) {
                                        content = 1
                                        extraInfo.content = content
                                    }
                                    if ((flag and 0x4) == 0x4) {
                                        content = 2
                                        extraInfo.content = content
                                    }
                                    layoutList.add(extraInfo)

                                    if (dataLenth < 2) {
                                        continue
                                    }
                                    if (sei.size > delayIndex) {
                                        var privateInfoLength =
                                            SntpClient.read(sei[delayIndex], sei[delayIndex + 1]).toInt()
                                        dataLenth -= 2
                                        if (privateInfoLength > dataLenth) {
                                            continue
                                        }
                                        if (privateInfoLength <= 0 && sei.size < delayIndex + 1 + privateInfoLength) {
                                            continue
                                        }
                                        var delayData = ByteArray(privateInfoLength)
                                        System.arraycopy(sei, delayIndex + 2, delayData, 0, privateInfoLength)
                                        listener?.onATHPrivateData(url, strUid, delayData)
                                    }
                                } else {
                                    break
                                }
                            }
                            // 解完布局信息之后，需要解画布信息
                            var canvasDataPtr = layoutDataPtr
                            if (canvasDataPtr + 4 <= start + curPayloadLength && layoutList.isNotEmpty()) {
                                var canvasW = SntpClient.read(sei[canvasDataPtr], sei[canvasDataPtr + 1]).toInt()
                                var canvasH = SntpClient.read(sei[canvasDataPtr + 2], sei[canvasDataPtr + 3]).toInt()
                                for (list in layoutList) {
                                    list.canvasW = canvasW
                                    list.canvasH = canvasH
                                }
                            }
                        }
                    }
                    start += curPayloadLength
                }
                listener?.let {
                    if (appDataList != null && appDataList.isNotEmpty()) {
                        listener.onATHSEIVideoExtraInfo(appDataList)
                    }
                    if (layoutList != null && layoutList.isNotEmpty()) {
                        listener.onATHSEIMixVideoExtraInfo(p0, layoutList)
                    }
                }
            }
        } catch (e: Exception) {
            ALog.e(TAG, "onSEIOriginalData", e)
        }
    }

    interface ATHCdnPlayerSeiListener {
        /**
         * 主播端到观众端画面的时间延迟
         */
        fun onATHPrivateData(url: String, uid: String, privateInfo: ByteArray)

        /**
         * 视频sei相关信息
         */
        fun onATHSEIVideoExtraInfo(videoExtraInfo: ArrayList<VideoExtraInfo>?)

        /**
         *布局sei相关回调
         */
        fun onATHSEIMixVideoExtraInfo(p0: VodPlayer?, infos: ArrayList<MixVideoExtraInfo>?)
    }
}