package tv.athena.live.player.vodplayer

import com.yy.gslbsdk.DnsResultInfo
import com.yy.transvod.preference.DnsHostInfo
import com.yy.transvod.preference.OnDnsHostResolveCallback
import com.yy.transvod.preference.Preference
import tv.athena.core.sly.Sly
import tv.athena.live.utils.ALog
import tv.athena.live.utils.GslbUtils

/**
 *create by dengqu 2020/6/24
 */
object VodPlayerPreference {
    private const val TAG = "VodPlayerPreference"

    fun initVodPlayerDns() {
        ALog.i(TAG, "initVodPlayerDns ----------------------")
        Preference.setDnsHostResolveCallback(dnsHostResolveCallback)
    }

    fun setVodConfigs(map: HashMap<String, String>?) {
        map?.let {
            if (it.isNotEmpty()) {
                Preference.setMediaConfig(map)
            }
        }
    }

    private var dnsHostResolveCallback: OnDnsHostResolveCallback =
        OnDnsHostResolveCallback { host ->
            ALog.i(TAG, "OnDnsHostResolveCallback ----------------------")
            if (GslbUtils.isUseGslb()) {
                ALog.i(TAG, "use gslb host = $host")
                val hostInfo = DnsHostInfo()
                var gslbStartTime = System.currentTimeMillis()
                val res: DnsResultInfo? = GslbUtils.getIpsByHost(host)
                var gslbEndTime = System.currentTimeMillis()
                Sly.postMessage(GslbStatusEvent(host, (gslbEndTime - gslbStartTime).toInt()))
                hostInfo.ipsV4 = res?.mIps
                hostInfo.success = res?.mErrorCode == 0
                hostInfo.dnsResolveType = 1
                hostInfo.errMsg = null
                hostInfo
            } else {
                ALog.i(TAG, "not use gslb")
                null
            }
        }
}