package tv.athena.live.player.vodplayer

import android.content.Context
import android.os.Handler
import android.os.Looper
import android.text.TextUtils
import com.yy.transvod.player.PlayerOptions
import com.yy.transvod.player.VodPlayer
import tv.athena.live.basesdk.config.BaseDataConfig
import tv.athena.live.player.IAthLiveMediaPlayer
import tv.athena.live.utils.ALog
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.ConcurrentLinkedQueue

/**
 *create by dengqu 2020/6/16
 */
class AthLiveMediaPlayerFactory private constructor() {
    private var mPlayers = ConcurrentHashMap<String, IAthLiveMediaPlayer?>()
    private var mRunnables = ConcurrentHashMap<String, Runnable?>()
    private var mPlayerUsers = ConcurrentLinkedQueue<String>()

    private var mHandler: Handler = Handler(Looper.getMainLooper())

    companion object {
        private const val TAG = "AthLiveMediaPlayerFactory"
        const val RELEASE_DELY = 3000L

        /**
         * 默认的缓存目录
         */
        const val DEFAULT_CACHE_DIRECTORY = "/sdcard/yy_video/"
        val instance: AthLiveMediaPlayerFactory by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            AthLiveMediaPlayerFactory()
        }
    }

    fun getAthLiveMediaPlayer(
            context: Context?, cacheDirectory:
            String?, uuid: String, userUUID: String,
            samplerFilter: Int = 0,
            forceUse601ColorStandard: Boolean = false,
            directRenderToSurface: Boolean = false,
            isMultiInstance: Boolean,
            userTextureView: Boolean = false
    ): IAthLiveMediaPlayer {
        ALog.i(TAG,
                "getAthLiveMediaPlayer cacheDirectory =$cacheDirectory ,uuid =$uuid,userUUID =$userUUID ," +
                        "forceUse601ColorStandard = $forceUse601ColorStandard,directRenderToSurface = " +
                        "$directRenderToSurface,samplerFilter " +
                        "=$samplerFilter,isMultiInstance=$isMultiInstance,size=${mPlayers?.size}")
        mPlayerUsers?.add(userUUID)
        var finalUUID = if (isMultiInstance) {
            userUUID
        } else {
            uuid
        }
        mPlayers?.get(finalUUID)?.let {
            ALog.i(TAG, "player is not null")
            mHandler?.removeCallbacks(mRunnables?.remove(finalUUID))
            return it
        }
        val vodPlayerEventHandler = VodPlayerEventHandler()
        //播放器options
        var options = PlayerOptions()
        options.cacheDirectory = if (TextUtils.isEmpty(cacheDirectory)) {
            DEFAULT_CACHE_DIRECTORY
        } else {
            cacheDirectory
        }
        if (BaseDataConfig.isHardCodecBlack()) {
            ALog.i(TAG, "getAthLiveMediaPlayer isHardCodecBlack -------------")
            options.videoCodec = PlayerOptions.MEDIA_SW_CODEC
            options.directRenderToSurface = false
        } else {
            ALog.i(TAG, "getAthLiveMediaPlayer isNotHardCodecBlack -------------")
            options.videoCodec = PlayerOptions.MEDIA_HW_CODEC
            options.forceUse601ColorStandard = forceUse601ColorStandard
            options.samplerFilter = samplerFilter
            options.directRenderToSurface = directRenderToSurface
        }
        options.audioCodec = PlayerOptions.MEDIA_SW_CODEC
        options.videoSeekMode = PlayerOptions.VIDEO_SEEK_MODE_ACCURATE
        options.playerMode = PlayerOptions.PLAYER_FOR_LIVE
        options.usingSurfaceView = !userTextureView
        //创建播放器实例
        var mVodPlayer = VodPlayer(context, options)
        vodPlayerEventHandler.setupPlayListener(mVodPlayer)
        var proxyPlayer = VodPlayerProxy(mVodPlayer)
        vodPlayerEventHandler.setVodPlayerProxy(proxyPlayer)
        mPlayers?.put(finalUUID, proxyPlayer)
        proxyPlayer.setVodPlayerEventHandler(vodPlayerEventHandler)
        ALog.i(TAG, "mPlayers size = ${mPlayers?.size}")
        return proxyPlayer
    }

    fun releasePlayer(uuid: String, userUUID: String, isMultiInstance: Boolean) {
        ALog.i(TAG, "releasePlayer before uuid =$uuid，userUUID=$userUUID,size = ${mPlayers?.size}")
        if (mPlayerUsers?.contains(userUUID)) {
            mPlayers?.get(userUUID)?.unregister()
            mPlayerUsers?.remove(userUUID)
            if (isMultiInstance) {
                mPlayers?.remove(userUUID)?.releasePlayer()
            } else {
                if (mPlayerUsers?.isEmpty()) {
                    ALog.i(TAG, "releasePlayer -----------")
                    var runable = ReleasePlayerRunnable(uuid)
                    mRunnables?.put(uuid, runable)
                    mHandler?.postDelayed(runable, RELEASE_DELY)
                }
            }
        } else {
            ALog.i(TAG, "releasePlayer !mPlayerUsers?.contains(userUUID)")
        }
        ALog.i(TAG, "releasePlayer after uuid =$uuid，userUUID=$userUUID,size = ${mPlayers?.size}")
    }

    inner class ReleasePlayerRunnable(uuid: String) : Runnable {
        private var mUUid = uuid
        override fun run() {
            ALog.i(TAG, "releasePlayerRunnable run before size = ${mPlayers?.size} ")
            if (mPlayerUsers?.isEmpty()) {
                mPlayers?.remove(mUUid)?.releasePlayer()
            }
            ALog.i(TAG, "releasePlayerRunnable run after size = ${mPlayers?.size} ")
        }
    }
}