package tv.athena.live.player.vodplayer

import android.view.View
import android.view.ViewGroup
import com.yy.transvod.player.DataSource
import com.yy.transvod.player.VodPlayer
import tv.athena.live.player.AbsMediaPlayerEventHandler
import tv.athena.live.player.AthLiveMediaPlayerContants
import tv.athena.live.player.IAthLiveMediaPlayer
import tv.athena.live.player.bean.PlayerStatisticsExtraInfo
import tv.athena.live.player.bean.PlayerStatisticsInfo
import tv.athena.live.utils.ALog

/**
 *create by dengqu 2020/6/1
 */
class VodPlayerProxy(private val player: VodPlayer?) : IAthLiveMediaPlayer {
    private var mVodPlayerEventHandler: VodPlayerEventHandler? = null

    fun setVodPlayerEventHandler(handler: VodPlayerEventHandler) {
        this.mVodPlayerEventHandler = handler
    }

    companion object {
        private const val TAG = "VodPlayerProxy"
    }

    override fun getPlayerView(renderMode: Int): View {
        return player?.playerView as View
    }

    override fun setContainer(viewGroup: ViewGroup, player: IAthLiveMediaPlayer?) {
        mVodPlayerEventHandler?.setContainer(viewGroup)
        mVodPlayerEventHandler?.setScaleType(AthLiveMediaPlayerContants.RenderMode.RENDER_MODE_CLIP_TO_BOUNDS)
        ALog.i(TAG, "setContainer $viewGroup")
    }

    override fun setATHPlayerPlayerStatistics(
            playerStatisticsInfo: PlayerStatisticsInfo, playerStatisticsExtraInfo: PlayerStatisticsExtraInfo
    ) {
        mVodPlayerEventHandler?.setATHPlayerPlayerStatistics(playerStatisticsInfo, playerStatisticsExtraInfo)
    }

    override fun setCallback(callback: AbsMediaPlayerEventHandler?) {
        mVodPlayerEventHandler?.setCallback(callback)
    }

    override fun startPlayStream(): Int {
        return player?.start() ?: -1
    }

    override fun stopPlayStream() {
        player?.stop()
    }

    override fun setDataSource(url: String) {
        setDataSource(url, false, false)
    }

    override fun setDataSource(url: String, isSupportQuic: Boolean, isDash: Boolean) {
        ALog.i(TAG, "setDataSource url = $url,isSupportQuic =$isSupportQuic,isDash =$isDash")
        val srcFmt = if (isDash) {
            DataSource.SOURCE_FMT_DASH
        } else {
            DataSource.SOURCE_FMT_FLV
        }
        val cachePolicy = DataSource.CACHE_POLICY_STREAM_LATEST_GOP

        val proto = if (isSupportQuic || isDash) {
            DataSource.URL_PROTO_USER
        } else {
            DataSource.URL_PROTO_HTTP
        }
        //设置数据源
        player?.setDataSource(DataSource(url, proto, srcFmt, cachePolicy, true))
        player?.setDisplayMode(VodPlayer.VIDEO_DISPLAY_MODE_CROP)
        ALog.i(TAG, "setDataSource [url : $url],[isSupportQuic : $isSupportQuic]")
    }

    override fun setParameters(params: String) {
    }

    override fun setUserData(key: String, value: Any) {
    }

    override fun setAudioStreamsVolume(volume: Int) {
        ALog.i(TAG, "setAudioStreamsVolume volume = $volume")
        player?.setVolume(volume)
    }

    override fun enableAudioDataIndication(viewGroup: ViewGroup, enablePlay: Boolean): Int? {
        return 0
    }

    override fun enableAudioPlaySpectrum(viewGroup: ViewGroup, enable: Boolean): Int? {
        return 0
    }

    override fun enableRenderPcmDataCallBack(
            viewGroup: ViewGroup,
            enable: Boolean, sampleRate: Int, channel: Int
    ): Int? {
        return 0
    }

    override fun setAudioPlaySpectrumInfo(viewGroup: ViewGroup, spectrumLen: Int, notifyIntervalMS: Int): Int? {
        return 0
    }

    override fun setAudioVolumeIndication(
            viewGroup: ViewGroup, interval: Int,
            moreThanThd: Int, lessThanThd: Int, smooth: Int
    ): Int? {
        return 0
    }

    override fun releasePlayer() {
        ALog.i(TAG, "releasePlayer start ---------------------")
        mVodPlayerEventHandler?.release()
        try {
            stopPlayStream()
        } catch (e: java.lang.Exception) {
            ALog.e(TAG, "releasePlayer")
        }
        try {
            player?.release()
        } catch (e: java.lang.Exception) {
            ALog.e(TAG, "releasePlayer")
        }
    }

    override fun unregister() {
        mVodPlayerEventHandler?.unregister()
    }

    /**
     * 具体定义值查看{@link com.yy.transvod.player.DataSource}
     */
    override fun switchDefinition(definition: Int) {
        ALog.i(TAG, "switchDefinition $definition $player")
        player?.setQuality(definition)
    }

    /**
     * 具体定义值查看{@link com.yy.transvod.player.DataSource}
     */
    override fun setDashLiveMode(dashLiveMode: Int) {
        ALog.i(TAG, "setDashLiveMode $dashLiveMode $player")
        player?.setDashLiveMode(dashLiveMode)
    }

    override fun setAvSyncStrategy(avSyncStrategy: Int) {
        ALog.i(TAG, "setAvSyncStrategy $avSyncStrategy $player")
        player?.setAvSyncStrategy(avSyncStrategy)
    }

    override fun setAvAlignEnable(avalignEnable: Boolean) {
        ALog.i(TAG, "setAvAlignEnable $avalignEnable $player")
        player?.setAvAlignEnable(avalignEnable)
    }

    override fun leave(playerUUid: Int) {
        mVodPlayerEventHandler?.leave(playerUUid)
    }

    override fun setSceneId(sceneId: Long) {
        mVodPlayerEventHandler?.setSceneId(sceneId)
    }

    override fun updateCannelType(playerUUid: Int, flag: Boolean) {
        mVodPlayerEventHandler?.updateCannelType(playerUUid, flag)
    }

    override fun enableMediaExtraInfoCallBack(enableMediaExtraInfoCallBack: Boolean): Int {
        player?.setVideoExtrasInfoEnable(enableMediaExtraInfoCallBack)
        return 0
    }
}