package tv.athena.live.player.vodplayer

import android.text.TextUtils
import android.view.ViewGroup
import com.yy.transvod.player.OnPlayerAVExtraInfoListener
import com.yy.transvod.player.OnPlayerCachePositionUpdateListener
import com.yy.transvod.player.OnPlayerErrorListener
import com.yy.transvod.player.OnPlayerFirstVideoFrameShowListener
import com.yy.transvod.player.OnPlayerInfoListener
import com.yy.transvod.player.OnPlayerLoadingUpdateListener
import com.yy.transvod.player.OnPlayerNetRequestStatusListener
import com.yy.transvod.player.OnPlayerPlayCompletionListener
import com.yy.transvod.player.OnPlayerPlayPositionUpdateListener
import com.yy.transvod.player.OnPlayerStateUpdateListener
import com.yy.transvod.player.VodPlayer
import com.yy.transvod.player.common.MixAudioExtraInfo
import com.yy.transvod.player.common.MixVideoExtraInfo
import com.yy.transvod.player.common.VideoExtraInfo
import org.json.JSONObject
import tv.athena.annotation.MessageBinding
import tv.athena.core.axis.Axis
import tv.athena.core.sly.Sly
import tv.athena.live.basesdk.config.BaseDataConfig
import tv.athena.live.channel.ChannelStatusEvent
import tv.athena.live.constants.HiidoConstants
import tv.athena.live.ntp.TrueTime
import tv.athena.live.player.AbsMediaPlayerEventHandler
import tv.athena.live.player.AthLiveMediaPlayerContants.BlitzVideoViewScaleMode
import tv.athena.live.player.IAthLivePlayerStatisticsService
import tv.athena.live.player.bean.ATHLiveMixVideoInfo
import tv.athena.live.player.bean.ATHLivePlayerStatistics
import tv.athena.live.player.bean.ATHMixLayoutVideoInfo
import tv.athena.live.player.bean.PlayerStatisticsExtraInfo
import tv.athena.live.player.bean.PlayerStatisticsInfo
import tv.athena.live.player.bean.ProxyAudioVolumeInfo
import tv.athena.live.player.bean.ProxyBlitzMixVideoInfo
import tv.athena.live.player.vodplayer.utils.SeiParseUtil
import tv.athena.live.utils.ALog
import tv.athena.live.utils.ServiceRetryUtil
import tv.athena.live.utils.StatisticsUtils
import tv.athena.live.utils.TimeConsumingUtil
import tv.athena.util.encode.Base64Utils
import java.nio.ByteBuffer
import java.util.ArrayList
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.ConcurrentLinkedQueue

/**
 *create by dengqu 2020/6/1
 */
class VodPlayerEventHandler {
    private var mCallback: AbsMediaPlayerEventHandler? = null
    private var playerContainWidth = -1
    private var playerContainHeight = -1
    private var mScaleType: Int = BlitzVideoViewScaleMode.BLITZVIDEOVIEW_SCALE_MODE_CLIP_TO_BOUNDS
    private var mCacheATHMixLayoutVideoInfo = ConcurrentHashMap<String, ATHMixLayoutVideoInfo>()
    private val athMixLayoutVideoInfos = ConcurrentLinkedQueue<ATHMixLayoutVideoInfo>()
    private val athMixVideoInfos = ConcurrentLinkedQueue<ATHLiveMixVideoInfo>()
    private var mPlayerProxy: VodPlayerProxy? = null
    private var mPlayerUUid: Int = -1
    private var mJoinUids: List<Long> = arrayListOf() //当前流 uid 组合
    private var mLastPrintLogTime = 0L

    //当前播放url
    private var mUrl = ""

    constructor() {
        Sly.subscribe(this)
        mLastPrintLogTime = 0L
    }

    companion object {
        private const val TAG = "VodPlayerEventHandler"
        private const val MAX_LOG_PRINT_TIME = 3000L
        private const val KEY_CURRENT_TIME = "current_time"
    }

    @MessageBinding
    fun onChannelStatusEvent(event: ChannelStatusEvent) {
        ALog.i(TAG,
            "onChannelStatusEvent status =${event.status} " +
                ",sid =${event.sid}, enterTime =${event.enterTime}")
        if (event.status == ChannelStatusEvent.ENTER_FAIL) {
            //进入平道失败也报
            var playerStatistics = Axis.getService(IAthLivePlayerStatisticsService::class.java)
                ?.getATHLivePlayerStatistics(mPlayerUUid)
            if (TextUtils.equals(playerStatistics?.mPlayerStatisticsInfo?.cln, event.sid)) {
                Axis.getService(IAthLivePlayerStatisticsService::class.java)
                    ?.doLiveingFirstAccess(mPlayerUUid,
                        IAthLivePlayerStatisticsService.IATHPlayerFirstAccessCode
                            .CODE_ENTER_FAIL, "")
            }
        }
    }

    @MessageBinding
    fun onGslbStatusEvent(event: GslbStatusEvent) {
        ALog.i(TAG,
            "onGslbStatusEvent host =${event.host} " +
                ",gslbTime =${event.gslbTime}")

        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.setGslbTime(mPlayerUUid, event.gslbTime)
    }

    fun setVodPlayerProxy(playerProxy: VodPlayerProxy?) {
        mPlayerProxy = playerProxy
    }

    fun setupPlayListener(player: VodPlayer?) {
        player?.let {
            //设置 listener
            it.setOnPlayerLoadingUpdateListener(mOnPlayerLoadingUpdateListener)
            it.setOnPlayerPlayPositionUpdateListener(mPlayerPlayPositionUpdateListener)
            it.setOnPlayerCachePositionUpdateListener(mOnPlayerCachePositionUpdateListener)
            it.setOnPlayerStateUpdateListener(mOnPlayerStateUpdateListener)
            it.setOnPlayerInfoListener(mOnPlayerInfoListener)
            it.setOnPlayerPlayCompletionListener(mOnPlayerPlayCompletionListener)
            it.setOnPlayerAVExtraInfoListener(mOnPlayerAVExtraInfoListener)
            it.setOnPlayerErrorListener(mOnPlayerErrorListener)
            it.setOnPlayerFirstVideoFrameShowListener(mOnPlayerFirstVideoFrameShowListener)
            it.setOnPlayerNetRequestStatusListener(mOnPlayerNetRequestStatusListener)
        }
    }

    fun setCallback(callback: AbsMediaPlayerEventHandler?) {
        ALog.i(TAG, "setCallback $callback")
        this.mCallback = callback
    }

    fun setContainer(viewGroup: ViewGroup) {
        playerContainHeight = viewGroup.height
        playerContainWidth = viewGroup.width
        mCacheATHMixLayoutVideoInfo.clear()
        ALog.i(TAG, "setContainer $playerContainWidth, $playerContainHeight")
    }

    fun setScaleType(scaleType: Int) {
        this.mScaleType = scaleType
    }

    /*
     1, 播放完成回调, 每一次播放结束时,都会回调onPlayerPlayCompletionOneLoop.
     2, 达到所设置都的循环播放次数时,会回调 onPlayerPlayCompletion 方法.
     */
    private val mOnPlayerPlayCompletionListener: OnPlayerPlayCompletionListener =
        object : OnPlayerPlayCompletionListener {
            override fun onPlayerPlayCompletion(player: VodPlayer) {
                ALog.i(TAG, "wws play completion")
            }

            override fun onPlayerPlayCompletionOneLoop(player: VodPlayer) {
                ALog.i(TAG, "wws play completionOneLoop")
            }
        }

    /*
     "加载中"状态回调, 0 ~ 100
     */
    private val mOnPlayerLoadingUpdateListener = OnPlayerLoadingUpdateListener { player, percent ->
        ALog.i(TAG, "wws loading percent = $percent")
    }

    /*
    缓存进度回调, 可以用来实现 第二进度条(缓存进度条)
     */
    private val mOnPlayerCachePositionUpdateListener =
        object : OnPlayerCachePositionUpdateListener {
            override fun onPlayerCachePositionUpdate(p0: VodPlayer?, percent: Long) {
                ALog.i(TAG, "wws loading percent = $percent")
            }

            override fun onPlayerCacheWriteToDiskCompleted(p0: VodPlayer?, percent: String?) {
                ALog.i(TAG, "wws loading percent = $percent")
            }
        }


    /*
    播放错误回调
    */
    private val mOnPlayerErrorListener = OnPlayerErrorListener { player, what, extra ->
        ALog.i(TAG, "OnPlayerErrorListener what= $what , extra = $extra")
        StatisticsUtils.notifyCdnPlayError(what, mPlayerUUid)
        mCallback?.onPlayerError(mPlayerProxy, what, extra)
    }

    /*
  播放信息回调
  */
    private val mOnPlayerInfoListener = object : OnPlayerInfoListener {
        override fun onPlayerVideoSizeUpdate(p0: VodPlayer?, p1: Int, p2: Int) {
            mCallback?.onVideoSizeChanged(mPlayerProxy, p1, p2)
            Axis.getService(IAthLivePlayerStatisticsService::class.java)?.updateQxd(mPlayerUUid, "$p1*$p2")
        }

        override fun onPlayerVideoQualityChange(p0: String?) {
            ALog.i(TAG, "onPlayerVideoQualityChange $p0")
        }

        override fun onPlayerInfo(p0: VodPlayer?, what: Int, extra: Long) {
            if (what == OnPlayerInfoListener.PLAYER_INFO_RESOURCE_DURATION) {
            }
        }
    }


    /*
    首帧渲染回调, 可以在收到此回调时 去掉封面
    */
    private val mOnPlayerFirstVideoFrameShowListener =
        OnPlayerFirstVideoFrameShowListener { var1, var2, var3, var4 ->
            ALog.i(TAG, "wws first frame show")
            StatisticsUtils.notifyCdnPlay(HiidoConstants.RESULT_SUCCESS, mPlayerUUid)
            StatisticsUtils.resetCdnPlayerTime()
            TimeConsumingUtil.end(TimeConsumingUtil.START_FROM_SET_CDN_PLAYER,
                TimeConsumingUtil.END_BY_CDN_PLAYER_VIDEO_PLAY)
            mCallback?.onVideoPlay(mPlayerProxy, var2, var3, var4)
        }

    /*
    播放进度回调, 用来实现第一进度条/播放进度条
    */
    private val mPlayerPlayPositionUpdateListener =
        OnPlayerPlayPositionUpdateListener { player, position ->
        }

    /*
    播放器状态回调
    */
    private val mOnPlayerStateUpdateListener =
        OnPlayerStateUpdateListener { player, newState, var3 ->
            ALog.e(TAG, "newState = $newState")
            mCallback?.onPlayStatus(mPlayerProxy, newState, var3)
        }

    /*
   播放行为的统计信息回调(埋点), 每一次播放行为结束时, 都会返回统计字符串,可以用来上报海度.
    */
    private val mOnPlayerNetRequestStatusListener =
        OnPlayerNetRequestStatusListener { p0, p1, p2 ->
            mCallback?.onPlayerNetRequestStatus(mPlayerProxy, p1)
        }

    private fun canPrintSEIMixVideoExtraInfo(): Boolean {
        var currentTimeMillis = System.currentTimeMillis()
        return if (currentTimeMillis - mLastPrintLogTime > MAX_LOG_PRINT_TIME) {
            mLastPrintLogTime = currentTimeMillis
            true
        } else {
            false
        }
    }

    private val mOnPlayerAVExtraInfoListener: OnPlayerAVExtraInfoListener =
        object : OnPlayerAVExtraInfoListener {
            override fun onSEIOriginalData(p0: VodPlayer?, sei: ByteArray?) {
                SeiParseUtil.decodeSEIPayload(p0, mUrl, sei, object : SeiParseUtil.ATHCdnPlayerSeiListener {
                    override fun onATHPrivateData(url: String, uid: String, privateInfo: ByteArray) {
                        try {
                            var canPrintSEIMixVideoExtraInfo = canPrintSEIMixVideoExtraInfo()
                            if (canPrintSEIMixVideoExtraInfo) {
                                ALog.i(TAG, "onATHTimeDelay mJoinUids is empty, url=$url,uid=$uid," +
                                    "timeDelay=$privateInfo,enable=${BaseDataConfig.playTimeDelayEnable()}")
                            }
                            if (!BaseDataConfig.playTimeDelayEnable()) {
                                return
                            }
                            if (mJoinUids?.isEmpty()) {
                                if (canPrintSEIMixVideoExtraInfo) {
                                    ALog.i(TAG, "mJoinUids is empty")
                                }
                                return
                            }
                            if (!TextUtils.equals(mJoinUids[0].toString(), uid)) {
                                if (canPrintSEIMixVideoExtraInfo) {
                                    ALog.i(TAG, "!TextUtils.equals(mJoinUids[0].toString(), uid)")
                                }
                                return
                            }
                            if (TrueTime.isInitialized() && TrueTime.now() != -1L) {
                                var result =
                                    String(Base64Utils.decode(privateInfo,
                                        Base64Utils.DEFAULT))
                                var jsonObject = JSONObject(result)
                                var currentTime = jsonObject.getLong(KEY_CURRENT_TIME)
                                var timeDelay = TrueTime.now() - currentTime
                                if (canPrintSEIMixVideoExtraInfo) {
                                    ALog.i(TAG, "setTimeDelay timeDelay $timeDelay")
                                }
                                Axis.getService(
                                    IAthLivePlayerStatisticsService::class.java)
                                    ?.setTimeDelay(mPlayerUUid, timeDelay)
                            } else {
                                if (canPrintSEIMixVideoExtraInfo) {
                                    ALog.i(TAG, "TrueTime.isInitialized() && TrueTime.now() != -1L")
                                }
                                ServiceRetryUtil.getNtpTime()
                            }
                        } catch (e: Exception) {
                            ALog.e(TAG, "onATHTimeDelay", e)
                        }
                    }

                    override fun onATHSEIVideoExtraInfo(p1: ArrayList<VideoExtraInfo>?) {
                        synchronized(this@VodPlayerEventHandler) {
                            try {
                                p1?.let { it ->
                                    it.forEach { it1 ->
                                        it1.mStrExtraInfo?.let {
                                            val byteBuffer: ByteBuffer = ByteBuffer.wrap(it)
                                            if (canPrintSEIMixVideoExtraInfo()) {
                                                ALog.i(TAG, "onATHSEIVideoExtraInfo $it1")
                                            }
                                            mCallback?.onRecvMediaExtraInfo(mPlayerProxy, it1.mUid, byteBuffer,
                                                it.size)
                                        }
                                    }
                                }
                                getUidBySEIVideoExtraInfo(p1)
                                if (canPrintSEIMixVideoExtraInfo()) {
                                    ALog.i(TAG, "onATHSEIVideoExtraInfo ---------")
                                }
                            } catch (e: Exception) {
                                ALog.e(TAG, "onATHSEIVideoExtraInfo", e)
                            }
                        }
                    }

                    override fun onATHSEIMixVideoExtraInfo(p0: VodPlayer?, infos: ArrayList<MixVideoExtraInfo>?) {
                        synchronized(this@VodPlayerEventHandler) {
                            try {
                                var canPrintSEIMixVideoExtraInfo = canPrintSEIMixVideoExtraInfo()
                                if (canPrintSEIMixVideoExtraInfo) {
                                    ALog.i(TAG, "onSEIMixVideoExtraInfo ---------")
                                }
                                val proxyInfos = ArrayList<ProxyBlitzMixVideoInfo>()
                                infos?.forEachIndexed { index, blitzMixVideoInfo ->
                                    if (canPrintSEIMixVideoExtraInfo) {
                                        ALog.i(TAG, "onRecvMixVideoInfo [position : $index,  " +
                                            " frameContentType : ${blitzMixVideoInfo.content}" +
                                            " uid :  ${blitzMixVideoInfo.uid}]")
                                    }
                                    blitzMixVideoInfo.apply {
                                        val proxyInfo = ProxyBlitzMixVideoInfo(uid,
                                            width,
                                            height,
                                            cropX,
                                            cropY,
                                            cropW,
                                            cropH,
                                            layoutX,
                                            layoutY,
                                            layoutW,
                                            layoutH,
                                            canvasW,
                                            canvasH,
                                            zOrder,
                                            alpha,
                                            content)
                                        proxyInfos.add(proxyInfo)
                                    }
                                }
                                handleBlitzMixVideoInfos(infos, p0, canPrintSEIMixVideoExtraInfo)
                            } catch (e: Exception) {
                                ALog.e(TAG, "onATHSEIMixVideoExtraInfo", e)
                            }
                        }
                    }
                })
            }

            override fun onSEIMixVideoExtraInfo(
                player: VodPlayer?, infos: ArrayList<MixVideoExtraInfo>?
            ) {
            }

            override fun onSEIVideoExtraInfo(p0: VodPlayer?, p1: ArrayList<VideoExtraInfo>?) {
            }

            override fun onDSEMixAudioExtraInfo(
                p0: VodPlayer?, p1: Int, p2: ArrayList<MixAudioExtraInfo>?
            ) {
                synchronized(this@VodPlayerEventHandler) {
                    try {
                        ALog.i(TAG, "onDSEMixAudioExtraInfo ---------")
                        var speakers: ArrayList<ProxyAudioVolumeInfo> = ArrayList()
                        p2?.forEach {
                            speakers.add(ProxyAudioVolumeInfo(it.uid, it.volume))
                        }
                        mCallback?.onPlayVolumeIndication(mPlayerProxy, speakers, p1)
                    } catch (e: Exception) {
                        ALog.e(TAG, "onDSEMixAudioExtraInfo", e)
                    }
                }
            }
        }

    private fun getUidBySEIVideoExtraInfo(p1: ArrayList<VideoExtraInfo>?) {
        p1?.let { it ->
            it.forEachIndexed { index, videoExtraInfo ->
                videoExtraInfo?.let { it1 ->
                    Axis.getService(IAthLivePlayerStatisticsService::class.java)
                        ?.addAnchorUid(mPlayerUUid, it1.mUid)
                }
            }
        }
    }

    private fun handleBlitzMixVideoInfos(
        infos: ArrayList<MixVideoExtraInfo>?, player: VodPlayer?,
        canPrintSEIMixVideoExtraInfo: Boolean
    ) {
        if (playerContainHeight == -1 || playerContainWidth == -1) {
            if (canPrintSEIMixVideoExtraInfo) {
                ALog.i(TAG,
                    "handleBlitzMixVideoInfos [playerContainHeight : $playerContainHeight]" +
                        "[playerContainWidth : $playerContainWidth]")
            }
            return
        }
        athMixLayoutVideoInfos.clear()
        athMixVideoInfos.clear()
        infos?.forEach { blitzMixVideoInfo ->
            val uid = blitzMixVideoInfo.uid
            val zOrder = blitzMixVideoInfo.zOrder
            val alpha = blitzMixVideoInfo.alpha
            val canvasHeight = blitzMixVideoInfo.canvasH.toFloat()
            val canvasWidth = blitzMixVideoInfo.canvasW.toFloat()
            val canvasRate = canvasWidth / canvasHeight
            val containerRate = playerContainWidth.toFloat() / playerContainHeight.toFloat()
            var videoLayoutX = 0
            var videoLayoutY = 0
            var videoLayoutW = 0
            var videoLayoutH = 0
            // 左右扩充，裁剪
            if (canvasRate > containerRate) {
                val expandRate = canvasHeight / playerContainHeight.toFloat()
                val expandWidth = canvasWidth / expandRate
                //左右两边裁剪距离
                val lrSpace = (expandWidth - playerContainWidth) / 2
                blitzMixVideoInfo.layoutY = (blitzMixVideoInfo.layoutY / expandRate).toInt()
                blitzMixVideoInfo.layoutW = ((blitzMixVideoInfo.layoutW / expandRate)).toInt()
                blitzMixVideoInfo.layoutH = (blitzMixVideoInfo.layoutH / expandRate).toInt()
                blitzMixVideoInfo.layoutX = (blitzMixVideoInfo.layoutX / expandRate).toInt()

                if (blitzMixVideoInfo.layoutX == 0 &&
                    blitzMixVideoInfo.layoutW <= playerContainWidth) {
                    videoLayoutX = 0
                    videoLayoutY = blitzMixVideoInfo.layoutY
                    videoLayoutW = (blitzMixVideoInfo.layoutW - lrSpace).toInt()
                    videoLayoutH = blitzMixVideoInfo.layoutH
                } else if (blitzMixVideoInfo.layoutX == 0 &&
                    blitzMixVideoInfo.layoutW > playerContainWidth) {
                    videoLayoutX = 0
                    videoLayoutY = blitzMixVideoInfo.layoutY
                    videoLayoutW = (blitzMixVideoInfo.layoutW - lrSpace * 2).toInt()
                    videoLayoutH = blitzMixVideoInfo.layoutH
                } else if (blitzMixVideoInfo.layoutX != 0 &&
                    blitzMixVideoInfo.layoutX - lrSpace + blitzMixVideoInfo.layoutW <= playerContainWidth) {
                    videoLayoutX = (blitzMixVideoInfo.layoutX - lrSpace).toInt()
                    videoLayoutY = blitzMixVideoInfo.layoutY
                    videoLayoutW = blitzMixVideoInfo.layoutW
                    videoLayoutH = blitzMixVideoInfo.layoutH
                } else {
                    videoLayoutX = (blitzMixVideoInfo.layoutX - lrSpace).toInt()
                    videoLayoutY = blitzMixVideoInfo.layoutY
                    videoLayoutW = (blitzMixVideoInfo.layoutW - lrSpace).toInt()
                    videoLayoutH = blitzMixVideoInfo.layoutH
                }
            }
            //上下扩充，裁剪
            if (canvasRate < containerRate) {
                val expandRate = canvasWidth / playerContainWidth.toFloat()
                val expandHeight = canvasHeight / expandRate
                val udspace = (expandHeight - playerContainHeight) / 2

                blitzMixVideoInfo.layoutW = (blitzMixVideoInfo.layoutW / expandRate).toInt()
                blitzMixVideoInfo.layoutH = ((blitzMixVideoInfo.layoutH / expandRate).toInt())
                blitzMixVideoInfo.layoutX = (blitzMixVideoInfo.layoutX / expandRate).toInt()
                blitzMixVideoInfo.layoutY = ((blitzMixVideoInfo.layoutY / expandRate).toInt())

                if (blitzMixVideoInfo.layoutY == 0 &&
                    blitzMixVideoInfo.layoutH <= playerContainHeight) {
                    videoLayoutX = blitzMixVideoInfo.layoutX
                    videoLayoutY = 0
                    videoLayoutW = blitzMixVideoInfo.layoutW
                    videoLayoutH = (blitzMixVideoInfo.layoutH - udspace).toInt()
                } else if (blitzMixVideoInfo.layoutY == 0 &&
                    blitzMixVideoInfo.layoutH > playerContainHeight) {
                    videoLayoutX = blitzMixVideoInfo.layoutX
                    videoLayoutY = 0
                    videoLayoutW = blitzMixVideoInfo.layoutW
                    videoLayoutH = (blitzMixVideoInfo.layoutH - udspace * 2).toInt()
                } else if (blitzMixVideoInfo.layoutY != 0 &&
                    blitzMixVideoInfo.layoutY - udspace + blitzMixVideoInfo.layoutH <= playerContainHeight) {
                    videoLayoutX = blitzMixVideoInfo.layoutX
                    videoLayoutY = (blitzMixVideoInfo.layoutY - udspace).toInt()
                    videoLayoutW = blitzMixVideoInfo.layoutW
                    videoLayoutH = blitzMixVideoInfo.layoutH
                } else {
                    videoLayoutX = blitzMixVideoInfo.layoutX
                    videoLayoutY = (blitzMixVideoInfo.layoutY - udspace).toInt()
                    videoLayoutW = blitzMixVideoInfo.layoutW
                    videoLayoutH = (blitzMixVideoInfo.layoutH - udspace).toInt()
                }
            }
            val athMixLayoutVideoInfo = ATHMixLayoutVideoInfo(uid,
                videoLayoutX,
                videoLayoutY,
                videoLayoutW,
                videoLayoutH,
                zOrder,
                alpha)
            athMixLayoutVideoInfos.add(athMixLayoutVideoInfo)
            val frameContentType = blitzMixVideoInfo.content
            val athLiveMixVideoInfo =
                ATHLiveMixVideoInfo(uid, athMixLayoutVideoInfo, frameContentType)
            athMixVideoInfos.add(athLiveMixVideoInfo)
        }
        onATHRecMixVideoInfo(player,
            playerContainWidth,
            playerContainHeight,
            mScaleType,
            athMixLayoutVideoInfos, canPrintSEIMixVideoExtraInfo)
        onATHRecMixFrameContentType(player,
            playerContainWidth,
            playerContainHeight,
            mScaleType,
            athMixVideoInfos)
    }

    /**
     *  @param player 播放器
     *  @param width 业务设置容器宽
     *  @param height 业务设置容器高
     *  @param scaleType 当前播放器设置的裁剪模式
     *  @param infos 混画后各个对应uid 相对应在 业务设置容器的位置信息 方便业务用作 ui
     *  展示
     */
    fun onATHRecMixVideoInfo(
        player: VodPlayer?,
        width: Int,
        height: Int,
        scaleType: Int,
        infos: ConcurrentLinkedQueue<ATHMixLayoutVideoInfo>,
        canPrintSEIMixVideoExtraInfo: Boolean
    ) {
        if (canPrintSEIMixVideoExtraInfo) {
            ALog.i(TAG, "onATHRecMixVideoInfo [player : $player ;" +
                "width:  $width ; " +
                "height: $height ; " +
                "scaleType : $scaleType, " +
                "size : ${infos.size}")
        }
        mCallback?.onATHRecMixVideoInfo(mPlayerProxy, width, height, scaleType, ArrayList(infos))
        mCacheATHMixLayoutVideoInfo.clear()
        infos.forEach {
            if (canPrintSEIMixVideoExtraInfo) {
                ALog.i(TAG, "onATHRecMixVideoInfo bean $it")
            }
            mCacheATHMixLayoutVideoInfo[it.uid] = it
        }
    }

    /**
     *   *
     *   @param player 播放器
     *  @param width 业务设置容器宽
     *  @param height 业务设置容器高
     *  @param scaleType 当前播放器设置的裁剪模式
     *  @param infos  补帧回调
     */
    fun onATHRecMixFrameContentType(
        player: VodPlayer?,
        width: Int,
        height: Int,
        scaleType: Int,
        infos: ConcurrentLinkedQueue<ATHLiveMixVideoInfo>
    ) {
        mCallback?.onATHRecMixFrameContentType(mPlayerProxy, width, height, scaleType, ArrayList(infos))
    }

    fun leave(playerUUid: Int) {
        Axis.getService(IAthLivePlayerStatisticsService::class.java)?.leave(playerUUid)
    }

    fun release() {
        unregister()
    }

    fun setATHPlayerPlayerStatistics(
        playerStatisticsInfo: PlayerStatisticsInfo,
        playerStatisticsExtraInfo: PlayerStatisticsExtraInfo
    ) {
        mJoinUids = playerStatisticsExtraInfo.joinUids
        resetUUid(playerStatisticsExtraInfo.playerUUid)
        setPlayerStatisticsInfo(playerStatisticsInfo, playerStatisticsExtraInfo)
        setPlayerUrl(playerStatisticsExtraInfo.url)
        setIsSupportQuic(playerStatisticsExtraInfo.supportQuic)
        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.setConfigResolution(mPlayerUUid, playerStatisticsExtraInfo.configResolution)
    }

    private fun resetUUid(playerUUid: Int) {
        mPlayerUUid = playerUUid
        val playerStatistics = ATHLivePlayerStatistics()
        if (mJoinUids.isNotEmpty()) {
            playerStatistics.addAnchorUid(mJoinUids)
        }
        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.addATHLivePlayerStatistics(mPlayerUUid, playerStatistics)
    }

    private fun setPlayerStatisticsInfo(
        playerStatisticsInfo: PlayerStatisticsInfo, playerStatisticsExtraInfo: PlayerStatisticsExtraInfo
    ) {
        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.setPlayerStatisticsInfo(mPlayerUUid, playerStatisticsInfo, playerStatisticsExtraInfo)
        playerStatisticsInfo?.let {
            ALog.i(TAG,
                "setPlayerStatisticsInfo scene =${it.scene},euid =${it.appinfo}" +
                    ",euid =${it.cln},euid =${it.euid},firstAccessExtend=${it.firstAccessExtend}")
        }
    }

    private fun setPlayerUrl(url: String) {
        mLastPrintLogTime = 0L
        mUrl = url
        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.setPlayerUrl(mPlayerUUid, url)
        StatisticsUtils.setCdnPlayInfo(mPlayerUUid, url)
    }

    private fun setIsSupportQuic(supportQuic: Boolean) {
        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.setIsSupportQuic(mPlayerUUid, supportQuic)
    }

    fun setSceneId(sceneId: Long) {
        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.setSceneId(mPlayerUUid, sceneId)
    }

    fun updateCannelType(playerUUid: Int, flag: Boolean) {
        Axis.getService(IAthLivePlayerStatisticsService::class.java)
            ?.updateCannelType(mPlayerUUid, flag)
    }

    fun unregister() {
        Sly.unSubscribe(this)
    }
}