/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.fragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import tv.athena.live.api.activitybar.bean.ActivityBarConfig;
import tv.athena.live.api.activitybar.bean.WebViewFeature;
import tv.athena.live.api.activitybar.service.IJsApiModule;
import tv.athena.live.api.activitybar.service.IJsSupportWebApi;
import tv.athena.live.api.activitybar.service.IWebViewFragment;
import tv.athena.live.api.activitybar.service.IWebViewUIClient;
import tv.athena.live.component.business.activitybar.webview.GlobalConfig;
import tv.athena.live.component.business.activitybar.webview.jsapi.JavaScriptInterface;
import tv.athena.live.component.business.activitybar.webview.util.HttpsParser;
import tv.athena.live.component.business.activitybar.webview.util.ScheduledTask;
import tv.athena.live.component.business.activitybar.webview.util.WebViewUtils;
import tv.athena.live.utils.ALog;
import tv.athena.util.FP;

public class WebViewFragment
extends Fragment
implements IWebViewFragment {
    private static final String TAG = "WebViewFragment";
    public static final String LOAD_URL = "load_url";
    public static final String LOAD_DATA = "load_data";
    public static final String REQUEST_HEADER = "request_header";
    public static final String WEB_VIEW_FEATURE = "web_view_feature";
    private static final String WEB_VIEW_PULL = "WEB_VIEW_PULL";
    private static final String CURRENT_URL = "current_url";
    private static final String JS_OPERATION_YY_CLIENT = "YYClient";
    private static final String ANDROID_JS_INTERFACE_V_2 = "AndroidJSInterfaceV2";
    private static final String RESULT_TO_WEB = "javascript:try{window.unifiedResultToWeb('%s',JSON.parse('%s'));}catch(e){if(console)console.log(e)}";
    private static final String RESULT_TO_WEB_STRING = "javascript:try{window.unifiedResultToWeb('%s','{\"code\":%s,\"message\":\"%s\",\"data\":%s}');}catch(e){if(console)console.log(e)}";
    private WebView mWebView;
    private final WebViewFeature mWebViewFeature;
    private String localData;
    private String mCurrentUrl;
    private View mProgressView;
    private View mContainer;
    private Bundle mBundle;
    private boolean mEnablePullRefresh = false;
    private boolean ignoreSslError = false;
    private boolean mIsShowLoading = true;
    private WebViewClient mWebViewClient;
    private WebChromeClient mChromeClient;
    private DownloadListener mDownloadListener;
    private IWebViewUIClient mIWebViewUIClient;
    private JavaScriptInterface mJsInterfaceV2;
    private IJsSupportWebApi mJsSupportWebbApi;
    private ValueCallback<Uri> mUploadFile;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ActivityBarConfig config;
    private FrameLayout title;
    private String jsRegisterName = "AndroidJSInterfaceV2";
    private String setUrl;

    public static WebViewFragment newInstance(Context context, String url) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(String url) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance() {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(Context context, String url, WebViewFeature feature) {
        return WebViewFragment.newInstance(context, url, "", feature);
    }

    public static WebViewFragment newInstance(Context context, String url, String data, WebViewFeature feature) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        bundle.putString(LOAD_DATA, data);
        bundle.putInt(WEB_VIEW_FEATURE, feature.getFeatureValue());
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(Context context, String url, WebViewFeature feature, HashMap<String, String> header) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        bundle.putInt(WEB_VIEW_FEATURE, feature.getFeatureValue());
        if (header != null && !header.isEmpty()) {
            bundle.putSerializable(REQUEST_HEADER, header);
        }
        fragment.setArguments(bundle);
        return fragment;
    }

    public static WebViewFragment newInstance(Context context, String url, int feature) {
        WebViewFragment fragment = new WebViewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(LOAD_URL, HttpsParser.convertToHttps(url));
        bundle.putInt(WEB_VIEW_FEATURE, feature);
        fragment.setArguments(bundle);
        return fragment;
    }

    public WebViewFragment() {
        this.mWebViewFeature = new WebViewFeature();
    }

    public void setActivityBarConfig(ActivityBarConfig config) {
        this.config = config;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mBundle = this.getArguments();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int feature;
        View view = new View(container.getContext());
        if (this.mWebView != null) {
            this.mWebView.destroy();
        }
        if ((feature = this.mBundle.getInt(WEB_VIEW_FEATURE)) != 0) {
            this.mWebViewFeature.setFeatureValue(feature);
        }
        this.mContainer = view;
        return view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            String url = savedInstanceState.getString(CURRENT_URL);
            this.mCurrentUrl = HttpsParser.convertToHttps(url);
        }
        this.applyWebViewFeature();
        this.setJsModuleApi();
        this.setWebViewClient();
        this.setWebChromeClient();
        this.showLoading();
    }

    public FrameLayout getTitleContainer() {
        return this.title;
    }

    public void onResume() {
        String url;
        this.mWebView.onResume();
        super.onResume();
        String data = this.mBundle.getString(LOAD_DATA);
        if (!FP.empty((CharSequence)data)) {
            this.loadDataInner(data);
            return;
        }
        if (!FP.empty((CharSequence)this.localData)) {
            this.loadDataInner(data);
            return;
        }
        if (this.getCurrentUrl() != null) {
            url = this.getCurrentUrl();
        } else {
            url = this.mBundle.getString(LOAD_URL);
            if (TextUtils.isEmpty((CharSequence)url)) {
                url = this.setUrl;
            }
        }
        if (TextUtils.isEmpty((CharSequence)url) || url.equals(this.mCurrentUrl)) {
            return;
        }
        if (this.mBundle.containsKey(REQUEST_HEADER)) {
            HashMap headers = (HashMap)this.mBundle.getSerializable(REQUEST_HEADER);
            if (headers != null && !headers.isEmpty()) {
                this.loadUrl(url, headers);
            }
        } else {
            this.loadUrl(url);
        }
    }

    public void onPause() {
        if (this.mWebView == null) {
            return;
        }
        super.onPause();
        if (Build.VERSION.SDK_INT >= 11) {
            this.mWebView.onPause();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(CURRENT_URL, this.mWebView.getUrl());
        outState.putBoolean(WEB_VIEW_PULL, this.mEnablePullRefresh);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 7100) {
            this.loadUrl(this.mCurrentUrl);
            return;
        }
        if (requestCode == 7200) {
            if (null != this.mWebView) {
                if (Build.VERSION.SDK_INT <= 18) {
                    this.mWebView.loadUrl("javascript:reshPart()");
                } else {
                    try {
                        this.mWebView.evaluateJavascript("javascript:reshPart()", null);
                    }
                    catch (Exception e) {
                        ALog.e((String)TAG, (String)"", (Throwable)e);
                        this.mWebView.loadUrl("javascript:reshPart()");
                    }
                }
            }
            return;
        }
        if (requestCode == 2001) {
            Uri result;
            Uri uri = result = data == null || resultCode != -1 ? null : data.getData();
            if (this.mUploadFile != null) {
                this.mUploadFile.onReceiveValue((Object)result);
            }
        }
        if (requestCode > 6100 && requestCode < 6900) {
            this.handlePictureTaker(requestCode, resultCode, data);
        } else {
            this.handleWebActResult(requestCode, resultCode, data);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mContainer != null && this.mContainer.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.mContainer.getParent()).removeView(this.mContainer);
        }
        if (this.title != null) {
            this.title.removeAllViews();
        }
    }

    public void onDestroy() {
        if (this.mIsShowLoading) {
            this.hideLoading();
        }
        if (this.mWebView != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.removeJavascriptInterface(JS_OPERATION_YY_CLIENT);
            }
            this.mWebView.setDownloadListener(null);
            ViewGroup viewGroup = (ViewGroup)this.mWebView.getParent();
            if (viewGroup != null) {
                viewGroup.removeView((View)this.mWebView);
            }
            try {
                this.mWebView.stopLoading();
                this.mJsInterfaceV2.release();
                if (Build.VERSION.SDK_INT > 11) {
                    this.mWebView.removeJavascriptInterface(this.jsRegisterName);
                }
                this.mWebView.destroy();
            }
            catch (Throwable e) {
                ALog.e((String)TAG, (String)"webview destroy error!!!", (Throwable)e);
            }
            this.mWebView = null;
        }
        super.onDestroy();
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public Fragment getFragment() {
        return this;
    }

    public void setWebViewUIClient(IWebViewUIClient client) {
        this.mIWebViewUIClient = client;
    }

    public void setDownloadListener(DownloadListener listener) {
        this.mDownloadListener = listener;
    }

    public void setLocalUrl(String data) {
        this.localData = data;
    }

    public void setWebViewFeature(WebViewFeature mFeature) {
        if (mFeature == null || this.mWebViewFeature == null) {
            return;
        }
        int feature = mFeature.getFeatureValue();
        if (feature != 0) {
            this.mWebViewFeature.setFeatureValue(feature);
        }
    }

    public void loadUrl(String url) {
        if (this.mWebView == null) {
            this.setUrl = url;
            return;
        }
        if (FP.empty((CharSequence)url)) {
            if (this.config != null && this.config.getErrorCallback() != null) {
                this.config.getErrorCallback().onError(10);
            }
            return;
        }
        url = HttpsParser.convertToHttps(url);
        this.loadUrlInner(url);
    }

    public void loadUrl(String url, HashMap<String, String> headers) {
        if (this.mWebView == null) {
            return;
        }
        if (FP.empty((CharSequence)url)) {
            if (this.config != null && this.config.getErrorCallback() != null) {
                this.config.getErrorCallback().onError(10);
            }
            return;
        }
        url = HttpsParser.convertToHttps(url);
        this.loadUrlInner(url, headers);
    }

    public void loadJavaScript(final String javaScript, final ValueCallback<String> resultCallback) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (WebViewFragment.this.mWebView != null) {
                    try {
                        WebViewFragment.this.mWebView.evaluateJavascript(javaScript, resultCallback);
                    }
                    catch (Exception e) {
                        ALog.e((String)WebViewFragment.TAG, (String)"", (Throwable)e);
                        WebViewFragment.this.mWebView.loadUrl(javaScript);
                    }
                }
            }
        });
    }

    public void addJsApiModule(IJsApiModule module) {
        if (this.mJsInterfaceV2 != null) {
            this.mJsInterfaceV2.addApiModule(module);
        }
    }

    @SuppressLint(value={"JavascriptInterface"})
    public void addJsInterface(Object object, String name) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.addJavascriptInterface(object, name);
    }

    public void showLoading() {
        boolean isSet = false;
        if (this.config != null && this.config.getIActivityBarUI() != null) {
            isSet = this.config.getIActivityBarUI().showLoadingDialog();
        }
        if (!isSet && this.mIsShowLoading) {
            this.mProgressView.setVisibility(0);
        }
    }

    public void hideLoading() {
        boolean isSet = false;
        if (this.config != null && this.config.getIActivityBarUI() != null) {
            isSet = this.config.getIActivityBarUI().hideDialog();
        }
        if (!isSet && this.mIsShowLoading) {
            this.mProgressView.setVisibility(8);
        }
    }

    public void setIJsSupportWebApi(IJsSupportWebApi iJsSupportWebApi) {
        this.mJsSupportWebbApi = iJsSupportWebApi;
    }

    private void setJsModuleApi() {
        if (this.mWebView == null) {
            return;
        }
        this.mJsInterfaceV2 = new JavaScriptInterface(this.mWebView, this.mJsSupportWebbApi);
        if (this.config != null && this.config.getIJsApiModules() != null && this.config.getIJsApiModules().size() > 0) {
            for (IJsApiModule module : this.config.getIJsApiModules()) {
                if (module == null) continue;
                this.mJsInterfaceV2.addApiModule(module);
            }
        }
        if (this.config != null && !TextUtils.isEmpty((CharSequence)this.config.getJsRegisterName())) {
            this.jsRegisterName = this.config.getJsRegisterName();
        }
        this.mWebView.addJavascriptInterface((Object)this.mJsInterfaceV2, this.jsRegisterName);
    }

    protected void setWebChromeClient() {
        if (this.mWebView == null) {
            return;
        }
        if (this.mChromeClient == null) {
            this.mChromeClient = new WebChromeClient(){

                public void onReceivedTitle(WebView view, String title) {
                    if (WebViewFragment.this.config != null && WebViewFragment.this.config.getIActivityBarUI() != null) {
                        WebViewFragment.this.config.getIActivityBarUI().onReceivedTitle(view, title);
                    }
                    if (WebViewFragment.this.mIWebViewUIClient != null) {
                        WebViewFragment.this.mIWebViewUIClient.onReceivedTitle(view, title);
                    }
                    super.onReceivedTitle(view, title);
                }

                public void openFileChooser(ValueCallback valueCallback, String acceptType) {
                    WebViewFragment.this.mUploadFile = valueCallback;
                }

                public void openFileChooser(ValueCallback<Uri> valueCallback, String acceptType, String capture) {
                    WebViewFragment.this.mUploadFile = valueCallback;
                }
            };
        }
        this.mWebView.setWebChromeClient(this.mChromeClient);
    }

    protected void setWebViewClient() {
        if (this.mWebView == null) {
            return;
        }
        if (this.mWebViewClient == null) {
            this.mWebViewClient = new WebViewClient(){

                public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                    ALog.w((String)WebViewFragment.TAG, (String)("onReceivedSslError error=" + error));
                    if (WebViewFragment.this.ignoreSslError) {
                        handler.proceed();
                        return;
                    }
                    if (WebViewFragment.this.config != null && WebViewFragment.this.config.getErrorCallback() != null) {
                        WebViewFragment.this.config.getErrorCallback().onReceivedSslError(view, handler, error);
                    }
                }

                public void onPageFinished(WebView view, String url) {
                    if (WebViewFragment.this.config != null && WebViewFragment.this.config.getIActivityBarUI() != null) {
                        WebViewFragment.this.config.getIActivityBarUI().onPageFinished(view, url);
                    }
                    if (WebViewFragment.this.mIWebViewUIClient != null) {
                        WebViewFragment.this.mIWebViewUIClient.onPageFinished(view, url);
                    }
                    super.onPageFinished(view, url);
                    if (WebViewFragment.this.mWebView != null) {
                        WebViewFragment.this.mWebView.getSettings().setBlockNetworkImage(false);
                    }
                    WebViewFragment.this.setDownLoadListener();
                    WebViewFragment.this.hideLoading();
                }

                public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    boolean bHandler = false;
                    if (WebViewFragment.this.config != null && WebViewFragment.this.config.getIActivityBarUI() != null) {
                        bHandler = WebViewFragment.this.config.getIActivityBarUI().shouldOverrideUrlLoading(view, url);
                    }
                    if (bHandler) {
                        return true;
                    }
                    if (WebViewFragment.this.mIWebViewUIClient != null) {
                        bHandler = WebViewFragment.this.mIWebViewUIClient.shouldOverrideUrlLoading(view, url);
                    }
                    if (bHandler) {
                        return true;
                    }
                    if (!FP.empty((CharSequence)url) && url.startsWith("http")) {
                        WebViewFragment.this.mCurrentUrl = url;
                    }
                    if (null != view && !FP.empty((CharSequence)url) && (url.startsWith("http://") || url.startsWith("https://"))) {
                        view.loadUrl(url);
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view, url);
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    WebViewFragment.this.showLoading();
                    if (WebViewFragment.this.config != null && WebViewFragment.this.config.getIActivityBarUI() != null) {
                        WebViewFragment.this.config.getIActivityBarUI().onPageStarted(view, url, favicon);
                    }
                    if (WebViewFragment.this.mIWebViewUIClient != null) {
                        WebViewFragment.this.mIWebViewUIClient.onPageStarted(view, url, favicon);
                    }
                    super.onPageStarted(view, url, favicon);
                    if (url != null && !url.contains("file://")) {
                        WebViewFragment.this.mCurrentUrl = url;
                    }
                }

                public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
                    if (event.getKeyCode() == 4) {
                        return true;
                    }
                    return super.shouldOverrideKeyEvent(view, event);
                }

                public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
                    WebViewFragment.this.applyWebViewFeature();
                    WebViewFragment.this.setJsModuleApi();
                    WebViewFragment.this.setWebViewClient();
                    WebViewFragment.this.setWebChromeClient();
                    WebViewFragment.this.mWebView.loadUrl(WebViewFragment.this.mCurrentUrl);
                    return true;
                }
            };
        }
        this.mWebView.setWebViewClient(this.mWebViewClient);
    }

    protected void setDownLoadListener() {
        if (this.mWebView == null) {
            return;
        }
        if (this.mDownloadListener == null) {
            this.mDownloadListener = new DownloadListener(){

                public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                    ALog.i((String)WebViewFragment.TAG, (String)("url=" + url));
                    ALog.i((String)WebViewFragment.TAG, (String)("userAgent=" + userAgent));
                    ALog.i((String)WebViewFragment.TAG, (String)("contentDisposition=" + contentDisposition));
                    ALog.i((String)WebViewFragment.TAG, (String)("mimetype=" + mimetype));
                    ALog.i((String)WebViewFragment.TAG, (String)("contentLength=" + contentLength));
                    Uri uri = Uri.parse((String)url);
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    if (WebViewFragment.this.getActivity() != null) {
                        if (intent.resolveActivity(WebViewFragment.this.getActivity().getPackageManager()) != null) {
                            WebViewFragment.this.startActivity(intent);
                        } else {
                            ALog.i((String)WebViewFragment.TAG, (String)("can not found activity by this intent:" + intent));
                            if (WebViewFragment.this.config != null && WebViewFragment.this.config.getErrorCallback() != null) {
                                WebViewFragment.this.config.getErrorCallback().onError(11);
                            }
                        }
                    }
                }
            };
        }
        this.mWebView.setDownloadListener(this.mDownloadListener);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void applyWebViewFeature() {
        if (null == this.mWebView) {
            ALog.w((String)TAG, (String)"warnning: fail apply webview feature, target webview is null.");
            return;
        }
        this.mIsShowLoading = this.mWebViewFeature.isSupportFeature(32);
        if (this.mWebViewFeature.isSupportFeature(16)) {
            this.mWebView.setBackgroundColor(0);
            if (this.mWebView.getBackground() != null) {
                this.mWebView.getBackground().setAlpha(0);
            }
        }
        try {
            if (this.mWebViewFeature.isSupportFeature(1)) {
                this.mWebView.addJavascriptInterface((Object)new JsOperation((Activity)this.getActivity()), JS_OPERATION_YY_CLIENT);
                this.mWebView.getSettings().setJavaScriptEnabled(true);
            } else {
                this.mWebView.getSettings().setJavaScriptEnabled(false);
            }
        }
        catch (Throwable t) {
            ALog.e((String)TAG, (String)"", (Throwable)t);
        }
        if (this.mWebViewFeature.isSupportFeature(2)) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.mWebView.getSettings().setCacheMode(-1);
            } else {
                this.mWebView.getSettings().setCacheMode(0);
            }
        } else {
            this.mWebView.getSettings().setCacheMode(2);
        }
        if (this.mWebViewFeature.isSupportFeature(4)) {
            this.mWebView.clearFormData();
        }
        if (this.mWebViewFeature.isSupportFeature(8)) {
            this.mWebView.clearHistory();
        }
        if (this.mWebViewFeature.isSupportFeature(64) && this.mWebView instanceof View) {
            this.mWebView.setOnLongClickListener(v -> true);
        }
        this.mWebView.getSettings().setBuiltInZoomControls(false);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWebView.getSettings().setMixedContentMode(0);
        }
        this.mWebView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        if (!FP.empty((CharSequence)GlobalConfig.getUserAgentSuffix())) {
            String newUA = this.mWebView.getSettings().getUserAgentString() + " " + GlobalConfig.getUserAgentSuffix();
            this.mWebView.getSettings().setUserAgentString(newUA);
        }
    }

    private void loadUrlInner(String url) {
        boolean isUrlNoChange;
        if (this.mWebView == null) {
            return;
        }
        this.mCurrentUrl = url;
        this.mWebView.getSettings().setBlockNetworkImage(true);
        boolean bl = isUrlNoChange = this.mWebView.getUrl() != null && (this.mCurrentUrl.equals(this.mWebView.getUrl()) || this.mWebView.getUrl().equals(this.mCurrentUrl + "#/"));
        if (isUrlNoChange) {
            this.mWebView.reload();
        } else {
            this.mWebView.loadUrl(url);
        }
    }

    private void loadUrlInner(String url, HashMap<String, String> headers) {
        boolean isUrlNoChange;
        if (this.mWebView == null) {
            return;
        }
        this.mCurrentUrl = url;
        this.mWebView.getSettings().setBlockNetworkImage(true);
        boolean bl = isUrlNoChange = this.mWebView.getUrl() != null && (this.mCurrentUrl.equals(this.mWebView.getUrl()) || this.mWebView.getUrl().equals(this.mCurrentUrl + "#/"));
        if (isUrlNoChange) {
            this.mWebView.reload();
        } else {
            this.mWebView.loadUrl(url, headers);
        }
    }

    private void loadDataInner(String data) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.getSettings().setBlockNetworkImage(true);
        this.mWebView.loadData(data, "text/html", "utf-8");
    }

    private String getCurrentUrl() {
        return this.mCurrentUrl;
    }

    private void handlePictureTaker(int requestCode, int resultCode, Intent data) {
        if (this.mWebView == null) {
            return;
        }
        if (resultCode == 0 || data == null) {
            String invokeStr = String.format(RESULT_TO_WEB_STRING, 0, 2, "", "[]");
            ALog.i((String)TAG, (String)"[handlePictureTaker].[cancel]");
            this.mWebView.loadUrl(invokeStr);
        } else {
            int type;
            String[] uris;
            switch (requestCode) {
                case 6101: {
                    uris = data.getStringArrayExtra("portrait_clip_key");
                    type = 1;
                    break;
                }
                case 6102: {
                    uris = new String[]{data.getStringExtra("portrait_clip_key")};
                    type = 2;
                    break;
                }
                case 6103: {
                    uris = data.getStringArrayExtra("portrait_clip_key");
                    type = 3;
                    break;
                }
                default: {
                    uris = new String[]{};
                    type = 0;
                }
            }
            ScheduledTask.getInstance().scheduledDelayed(() -> {
                int code;
                String param;
                if (FP.empty((Object[])uris)) {
                    param = "[]";
                    code = 2;
                } else {
                    param = WebViewUtils.handleImageToBase64JsonStr(uris);
                    code = 1;
                }
                if (this.mHandler != null) {
                    this.mHandler.post(() -> {
                        if (this.mWebView != null) {
                            String invokeStr = String.format(RESULT_TO_WEB_STRING, type, code, "", param);
                            ALog.i((String)TAG, (String)("[handlePictureTaker].type=" + type + ",len=" + invokeStr.length()));
                            this.mWebView.loadUrl(invokeStr);
                        }
                    });
                }
            }, 0L);
        }
    }

    private void handleWebActResult(int requestCode, int resultCode, Intent data) {
        if (data != null && resultCode == -1) {
            ScheduledTask.getInstance().scheduledDelayed(() -> {
                int type;
                String param;
                switch (requestCode) {
                    case 3011: {
                        String[] cameraImgUrls = new String[]{data.getStringExtra("portrait_clip_key")};
                        param = this.handleThumbnailRetToWeb(cameraImgUrls);
                        type = 5;
                        break;
                    }
                    case 3010: {
                        String[] imgUrls = new String[]{data.getStringExtra("portrait_clip_key")};
                        param = this.handleThumbnailRetToWeb(imgUrls);
                        type = 4;
                        break;
                    }
                    case 2010: {
                        String[] urisImg = data.getStringArrayExtra("portrait_clip_key");
                        param = this.handleThumbnailRetToWeb(urisImg);
                        type = 3;
                        break;
                    }
                    case 2011: {
                        String[] uris = data.getStringArrayExtra("portrait_clip_key");
                        param = this.handleThumbnailRetToWeb(uris);
                        type = 2;
                        break;
                    }
                    default: {
                        type = 0;
                        param = null;
                    }
                }
                if (this.mHandler != null) {
                    this.mHandler.post(() -> {
                        if (!FP.empty((CharSequence)param) && this.mWebView != null && type != 0) {
                            String invokeStr = String.format(RESULT_TO_WEB, type, param);
                            ALog.i((String)TAG, (String)("[base64ImageToWeb].type=" + type + ",len=" + invokeStr.length()));
                            this.mWebView.loadUrl(invokeStr);
                        }
                    });
                }
            }, 0L);
        }
    }

    private String handleThumbnailRetToWeb(String[] clipPaths) {
        if (clipPaths != null && clipPaths.length > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.length; ++i) {
                JSONObject jsonObject = WebViewUtils.handleImgThumbnailToBase64(clipPaths[i]);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                ALog.i((String)"handleThumbnailRetToWeb", (String)("[ReturnBase64ImgToWeb].imgSizes=" + bitmapJsonArray.length()));
                return bitmapJsonArray.toString();
            }
        }
        return null;
    }

    public void onDetach() {
        super.onDetach();
    }

    class JsOperation {
        Activity mActivity;

        JsOperation(Activity activity) {
            this.mActivity = activity;
        }

        @JavascriptInterface
        public void finishActivity() {
            this.mActivity.finish();
        }
    }
}

